/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.lightdbmysql;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="lightdb_mysql")
public class LightdbMysqlTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(LightdbMysqlTargetJdbcMeta.class);

    public static String getTargetJarPath() {
        Object targetJdbcPath = "";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            String regex = ".*ltjdbc.*\\.jar.*";
            for (URL url : urlClassLoader.getURLs()) {
                if (!url.getPath().matches(regex)) continue;
                targetJdbcPath = "jar:" + url.getPath();
                break;
            }
        } else {
            String[] paths;
            String cp = System.getProperty("java.class.path");
            if (cp == null || cp.isEmpty()) {
                String initialModuleName = System.getProperty("jdk.module.main");
                cp = initialModuleName == null ? "" : null;
            }
            String regex = ".*ltjdbc.*\\.jar";
            for (String path : paths = cp.split(File.pathSeparator)) {
                if (!path.matches(regex)) continue;
                targetJdbcPath = "jar:file:" + path + "!/";
            }
        }
        return targetJdbcPath;
    }

    @Autowired
    public LightdbMysqlTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public void createScehma() {
        while (MotionEtlGlobalCtx.getInstance().increaseSchema()) {
            String searchPath = (String)JdbcUtils.doQuery((Connection)this.openConnection(), (String)"show search_path;", resultSet -> {
                try {
                    resultSet.next();
                    return resultSet.getString(1);
                }
                catch (SQLException e) {
                    EtlGlobalCtx.INSTANCE.handleException((Throwable)e);
                    return "\"$user\", public, \"$lt_syntax_compatible_type\", lt_catalog";
                }
            });
            String sql = String.format("CREATE SCHEMA IF NOT EXISTS %s;set search_path to %s;", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema() + "," + searchPath);
            JdbcUtils.executeSql((Connection)this.openConnection(), (String)sql);
        }
        MotionEtlGlobalCtx.getInstance().resetSchemaIndex();
    }

    public void saveMessage() {
        String schema = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getErrorSaveLightdbSchema();
        String table = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getErrorSaveLightdbTable();
        String sql = String.format("CREATE SCHEMA IF NOT EXISTS %s;", schema);
        String sql2 = String.format("CREATE TABLE IF NOT EXISTS %s.%s(object_name VARCHAR,message VARCHAR);", schema, table);
        String sql3 = String.format("INSERT INTO %s.%s (object_name, message) VALUES (?, ?)", schema, table);
        JdbcUtils.executeSql((Connection)this.openConnection(), (String)sql);
        JdbcUtils.executeSql((Connection)this.openConnection(), (String)sql2);
        JdbcUtils.executeSaveMessage((Connection)this.openConnection(), (String)sql3);
    }

    public Map<String, TableInfo> tableInfo() {
        Object sql = "";
        sql = String.format("select table_name,column_name,case udt_name\n                            when 'character varying' then 'varchar'\n                            when 'character' then 'char'\n                            else udt_name\n                            end,character_maximum_length,numeric_precision,numeric_scale\n                        from information_schema.columns\n                        where table_schema = lower('%s') and is_identity = 'NO' \n                        and table_name not like 'BIN$%%$0'\n                        and (table_schema,table_name) in \n(\nSELECT  \nn.nspname,\nc.relname as tablename\nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r','p')\nAND n.nspname  = lower('%s') \nAND c.relispartition='f' \nAND c.relname not like 'BIN$%%$0'\n)", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterPgTable();
        return this.getTableInfo((String)sql);
    }

    public String createColumnDdl() {
        return String.format("select table_name,column_name,udt_name,\n                        numeric_precision, numeric_scale,character_maximum_length,datetime_precision\n                        from information_schema.columns\n                        where table_schema = lower('%s') and is_identity = 'NO' \n                        and table_name not like 'BIN$%%$0'\n                        and (table_schema,table_name) in \n(\nSELECT  \nn.nspname,\nc.relname as tablename\nFROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r','p')\nAND n.nspname  = lower('%s') \nAND c.relispartition='f' \nAND c.relname not like 'BIN$%%$0'\n)", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterPgTable();
    }

    public Map<String, String> tableNames() {
        String tableName = String.format("SELECT tablename FROM pg_tables WHERE schemaname = '%s' AND tablename NOT IN (SELECT relname FROM pg_class WHERE oid IN (SELECT inhrelid FROM pg_inherits WHERE inhparent IN (SELECT partrelid FROM pg_partitioned_table)))", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        return this.queryCountSql2(tableName);
    }

    public void getEtlMessage() {
        String sql = String.format("select DISTINCT object_name,message from  %s.%s", MotionEtlGlobalCtx.getInstance().getGlobalConfig().getErrorSaveLightdbSchema(), MotionEtlGlobalCtx.getInstance().getGlobalConfig().getErrorSaveLightdbTable());
        try {
            JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, resultSet -> {
                HashMap info = MotionEtlGlobalCtx.getInstance().getEtlMessage();
                try {
                    while (resultSet.next()) {
                        info.put(resultSet.getString(1).toLowerCase(), resultSet.getString(2));
                    }
                    return info;
                }
                catch (SQLException e) {
                    return new HashMap(8);
                }
            });
        }
        catch (Exception e) {
            return;
        }
    }

    public Map<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String tableCountSql = String.format("SELECT  \nc.relname as tablename,\n'0' as invalid_data_filling\n FROM pg_catalog.pg_class c \nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \nWHERE c.relkind IN ('r','p')\nAND n.nspname  = '%s' \nAND c.relispartition='f' \nAND pg_catalog.pg_table_is_visible(c.oid)\nAND c.relname not like 'BIN$%%$0' %s", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().filterPgTable("tablename"));
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)tableCountSql));
        String indexCountSql = String.format("select \n       i.tablename,\n       string_agg(i.indexname, ',') AS index_list\nfrom pg_indexes i  where i.schemaname = '%s'\nand (schemaname,indexname) in \n(\nSELECT n.nspname, \n  c.relname as \"index_name\"\n  FROM pg_catalog.pg_class c\n     LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\nWHERE c.relkind IN ('i')\n      AND n.nspname = '%s'\n     AND c.relispartition='f'\n) %s \nGROUP BY \n    i.tablename\nORDER BY \n    i.tablename\n", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().filterPgTable("i.tablename"));
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select relname,'0' as invalid_data_filling from pg_class where relkind = 'v' and relnamespace = (select oid from pg_namespace where nspname='%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        result.put(CompareTypeEnum.VIEW.getCompareType(), this.queryCountSql2(viewCountSql));
        String sequenceCountSql = String.format("select relname,'0' as invalid_data_filling from pg_class where relkind = 'S' and relnamespace = (select oid from pg_namespace where nspname='%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        result.put(CompareTypeEnum.SEQUENCE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)sequenceCountSql));
        String proceduresCountSql = String.format("select routine_name,'0' as invalid_data_filling FROM  information_schema.routines WHERE  routine_type = 'PROCEDURE' and specific_schema=lower('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        result.put(CompareTypeEnum.PROCEDURES.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresCountSql));
        String functionCountSql = String.format("select routine_name,'0' as invalid_data_filling FROM  information_schema.routines WHERE  routine_type = 'FUNCTION' and specific_schema=lower('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        result.put(CompareTypeEnum.FUNCTION.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)functionCountSql));
        if ("lightdb-oracle".equals(this.getDbConfig().getMode())) {
            String triggerCountSql = String.format("SELECT TRIGGER_NAME,'0' as invalid_data_filling\nFROM dba_TRIGGERS where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
            result.put(CompareTypeEnum.TRIGGER.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)triggerCountSql));
            String typeCountSql = String.format("select type_name,'0' as invalid_data_filling from  dba_types \nwhere owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
            result.put(CompareTypeEnum.TYPE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)typeCountSql));
            String packageCountSql = String.format("select pkgname,'0' as invalid_data_filling from lt_package ", new Object[0]);
            result.put(CompareTypeEnum.PACKAGE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageCountSql));
            String packageBodyCountSql = String.format("select pkgname,'0' as invalid_data_filling from lt_package where pkgbody is not null ", new Object[0]);
            result.put(CompareTypeEnum.PACKAGE_BODY.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageBodyCountSql));
        }
        return result;
    }

    public Set<String> getPartitionTable() {
        HashSet partitionTableSet = new HashSet();
        String partitionTableSql = String.format("SELECT relname FROM pg_catalog.pg_class WHERE oid IN (SELECT partrelid FROM pg_catalog.pg_partitioned_table) AND relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = '%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        return (Set)JdbcUtils.doQuery((Connection)this.openConnection(), (String)partitionTableSql, resultSet -> {
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    partitionTableSet.add(tableName);
                }
                return partitionTableSet;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(partitionTableSql, (Throwable)e);
                return partitionTableSet;
            }
        });
    }

    public Map<String, Set<String>> getPartitionIndexName() {
        String partitionTableSql = String.format("SELECT name, column_name FROM all_part_key_columns    \nWHERE owner ='%s'  GROUP BY name, column_name;\n", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toUpperCase());
        HashMap indexNamesMap = new HashMap(1000);
        return (Map)JdbcUtils.doQuery((Connection)this.openConnection(), (String)partitionTableSql, resultSet -> {
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String indexName = resultSet.getString(2);
                    if (indexNamesMap.containsKey(tableName)) {
                        Set indexNameSet = (Set)indexNamesMap.get(tableName);
                        indexNameSet.add(indexName);
                        continue;
                    }
                    HashSet<String> indexSet = new HashSet<String>();
                    indexSet.add(indexName);
                    indexNamesMap.put(tableName, indexSet);
                }
                return indexNamesMap;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(partitionTableSql, (Throwable)e);
                return indexNamesMap;
            }
        });
    }

    public String targetDataInfo(String sql, int number, String[] filter) {
        return (String)JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, resultSet -> {
            StringBuffer result = new StringBuffer();
            try {
                while (resultSet.next()) {
                    String num = "number";
                    for (int i = 1; i <= number; ++i) {
                        String str = resultSet.getString(i);
                        if (filter[i - 1].toLowerCase().equals(num)) {
                            str = this.cleanData(str);
                        }
                        result.append(str + " ");
                    }
                }
                return result.toString();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String cleanData(String date) {
        int i;
        if (date == null || date.length() == 0) {
            return date;
        }
        String[] result = date.split("\\.");
        if (result.length <= 1) {
            return date;
        }
        char[] chars = result[1].toCharArray();
        StringBuffer sb = new StringBuffer();
        int number = -1;
        for (i = chars.length - 1; i >= 0; --i) {
            if (chars[i] == '0') continue;
            number = i;
            break;
        }
        for (i = 0; i <= number; ++i) {
            sb.append(chars[i]);
        }
        if (sb.length() > 0) {
            return result[0] + "." + sb.toString();
        }
        return result[0];
    }

    public List<String> fetchPgTypes() {
        return (List)JdbcUtils.doQuery((Connection)this.openConnection(), (String)"select typname from pg_type where typtype in ('o','d')", resultSet -> {
            ArrayList<String> types = new ArrayList<String>();
            try {
                while (resultSet.next()) {
                    types.add(resultSet.getString(1));
                }
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException((Throwable)e);
            }
            return types;
        });
    }

    public HashMap<String, String> queryCountSql(String countSql) {
        return (HashMap)JdbcUtils.doQuery((Connection)this.openConnection(), (String)countSql, resultSet -> {
            HashMap<String, String> info = new HashMap<String, String>(100);
            try {
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String tableCount = null;
                    String sql = String.format("select count(*)  from %s.\"%s\"", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), tableName);
                    try {
                        tableCount = (String)JdbcUtils.doQuery((Connection)this.openConnection(), (String)sql, resultSet2 -> {
                            String result = null;
                            try {
                                while (resultSet2.next()) {
                                    result = resultSet2.getString(1);
                                }
                                return result;
                            }
                            catch (SQLException e) {
                                EtlGlobalCtx.INSTANCE.handleException("\u5217\u4e0d\u5b58\u5728", (Throwable)e);
                                return result;
                            }
                        });
                    }
                    catch (Exception e) {
                        EtlGlobalCtx.INSTANCE.handleException(countSql, (Throwable)e);
                    }
                    if (tableCount == null || tableCount.length() == 0) {
                        tableCount = "0";
                    }
                    info.put(MotionEtlGlobalCtx.getInstance().ignoreCase(tableName), tableCount);
                }
                return info;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException("\u5217\u4e0d\u5b58\u5728", (Throwable)e);
                return info;
            }
        });
    }

    public HashMap<String, String> queryCountSql1(String countSql) {
        return (HashMap)JdbcUtils.doQuery((Connection)this.openConnection(), (String)countSql, resultSet -> {
            HashMap<String, String> info = new HashMap<String, String>(100);
            try {
                while (resultSet.next()) {
                    Object str;
                    String tableName = MotionEtlGlobalCtx.getInstance().ignoreCase(resultSet.getString(1));
                    if (info.containsKey(tableName)) {
                        str = (String)info.get(tableName) + "," + resultSet.getString(2).toLowerCase();
                    } else {
                        str = resultSet.getString(2);
                        if (str == null || ((String)str).length() == 0) {
                            str = "0";
                        }
                    }
                    info.put(tableName, ((String)str).toLowerCase());
                }
                return info;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(countSql, (Throwable)e);
                return new HashMap(8);
            }
        });
    }

    public HashMap<String, String> queryCountSql2(String countSql) {
        return (HashMap)JdbcUtils.doQuery((Connection)this.openConnection(), (String)countSql, resultSet -> {
            HashMap<String, String> info = new HashMap<String, String>(100);
            try {
                while (resultSet.next()) {
                    info.put(MotionEtlGlobalCtx.getInstance().ignoreCase(resultSet.getString(1)), "0");
                }
                return info;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(countSql, (Throwable)e);
                return new HashMap(8);
            }
        });
    }

    public String createTableDataColumnInfo() {
        return String.format("with indx_t as(  \n SELECT\n    cls.relname AS table_name,\n   array_agg(a.attname) AS index_list\n--    array_agg(a.attname) AS column_names\nFROM\n    pg_catalog.pg_index idx\nJOIN\n    pg_catalog.pg_class cls ON cls.oid = idx.indrelid\nJOIN\n    pg_catalog.pg_namespace n ON n.oid = cls.relnamespace \nJOIN\n    pg_catalog.pg_attribute a ON a.attrelid = cls.oid AND a.attnum = ANY(idx.indkey)\nWHERE\n    idx.indisunique = TRUE\n    AND cls.relkind  IN ('r','p')\n    and n.nspname  = lower('%s')\n    AND cls.relispartition='f'\n    AND cls.relname not like 'BIN$%%$0'\nGROUP BY\n    cls.relname\nORDER BY\n    cls.relname\n)\nselect a.table_schema,a.table_name,a.column_name,a.udt_name,\n      CASE\n        WHEN a.column_name=any(t.index_list) THEN 1\n        ELSE 0\n    END AS is_unique\n from information_schema.columns a\n left join indx_t t on t.TABLE_NAME = a.TABLE_NAME \n where a.table_schema = lower('%s') and a.is_identity = 'NO' \n       and a.table_name not like 'BIN$%%$0'  %s", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterPgTable("a.TABLE_NAME"));
    }
}

