/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.mysql;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.utils.CommonUtils;
import java.sql.Connection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="mysql")
public class MysqlTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(MysqlTargetJdbcMeta.class);

    @Autowired
    public MysqlTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Map<String, TableInfo> tableInfo() {
        String sql = String.format("select TABLE_NAME,COLUMN_NAME,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH,NUMERIC_PRECISION,NUMERIC_SCALE from INFORMATION_SCHEMA.COLUMNS a\n where TABLE_SCHEMA = '%s' and not exists(  \n select 1 from information_schema.views b where a.table_schema=b.table_schema and a.table_name=b.table_name)", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterGoldenDBTable("a.table_name");
        return this.getTableInfo(sql);
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        String driverClassName = "com.mysql.cj.jdbc.Driver";
        String regex = "^mysql-connector-j.*\\.jar$";
        return CommonUtils.getConnectionByDbConfig((EtlConfig.DbConfig)dbConfig, (String)driverClassName, (String)regex, this.getClass());
    }
}

