/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.oceanbase;

import com.hundsun.lightdb.ImportWorker;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.AbstractTargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@EnableScheduling
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="ocean_base_oracle")
public class OceanBaseTargetImporter
extends AbstractTargetImporter {
    private static final Logger log = LoggerFactory.getLogger(OceanBaseTargetImporter.class);

    @Autowired
    public OceanBaseTargetImporter(TargetJdbcMeta targetJdbcMeta, SourceJdbcMeta sourceJdbcMeta) {
        super(targetJdbcMeta, sourceJdbcMeta);
    }

    public HashMap<String, TableInfo> tableDataColumnInfo() {
        String ddl = this.targetJdbcMeta.createTableDataColumnInfo();
        return JdbcUtils.fetchTableColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }

    public void syncCustomTableData(List<String> syncCustomSqlList) {
        List<String> sqlList = syncCustomSqlList;
        if (!CollectionUtils.isEmpty(sqlList)) {
            sqlList.stream().forEach(s -> {
                if (StringUtils.isBlank((CharSequence)s)) {
                    return;
                }
                try {
                    StringBuilder sb = new StringBuilder(" delete from ").append(s.substring(s.indexOf("from") + 4));
                    JdbcUtils.executeSql((Connection)this.targetJdbcMeta.openConnection(), (String)sb.toString());
                    String subString = s.substring(s.indexOf("from") + 4, s.indexOf("where")).trim();
                    String schema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
                    String name = "";
                    if (subString.split("\\.").length > 1) {
                        schema = subString.split("\\.")[0];
                        name = subString.split("\\.")[1];
                    } else {
                        name = subString.split("\\.")[1];
                    }
                    Map tableInfos = this.targetJdbcMeta.tableInfo(schema, name);
                    TableInfo tableInfo = (TableInfo)tableInfos.get(name);
                    ImportWorker importWorker = new ImportWorker(MotionEtlGlobalCtx.getInstance().motionParameters, MotionEtlGlobalCtx.getInstance().getGlobalConfig().getBatchCount(), tableInfo, this.sourceJdbcMeta, this.targetJdbcMeta, 0, 0, s, "");
                    this.workerGroup.addTask((Runnable)importWorker);
                }
                catch (Exception e) {
                    log.error("syncCustomTableData \u6267\u884c\u5931\u8d25\uff0c\u914d\u7f6esql {} \u9519\u8bef\u4fe1\u606f:{}", s, (Object)e);
                }
            });
            this.waitCompletion();
        }
    }

    public HashMap<String, HashMap<String, String>> columnInfo() {
        String ddl = this.targetJdbcMeta.createColumnDdl();
        return JdbcUtils.fetchColumnInfo((Connection)this.targetJdbcMeta.openConnection(), (String)ddl);
    }

    public Map<String, HashMap<String, String>> countType() {
        return this.targetJdbcMeta.countType();
    }
}

