/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.oceanbase;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="ocean_base_oracle")
public class OceanBaseTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(OceanBaseTargetJdbcMeta.class);

    @Autowired
    public OceanBaseTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        String driverClassName = "com.oceanbase.jdbc.Driver";
        String regex = "^oceanbase-client.*\\.jar$";
        return CommonUtils.getConnectionByDbConfig((EtlConfig.DbConfig)dbConfig, (String)driverClassName, (String)regex, this.getClass());
    }

    public String createTableDataColumnInfo() {
        return String.format("select a.owner,a.table_name,a.column_name,a.data_type,nvl(b.is_unique,0) from \n     (select t.owner,t.table_name,c.column_name,c.data_type from dba_tab_cols c  JOIN dba_tables t \n      ON c.owner = t.owner \n     AND c.table_name = t.table_name \n     where c.owner=upper('%s') AND c.hidden_column = 'NO' and c.table_name not like 'BIN%%' %s) a\n     left join\n     (select distinct b.table_owner,b.table_name,b.column_name, 1 is_unique \n     from dba_indexes a,dba_ind_columns b where a.table_owner=upper('%s') and \n       (a.uniqueness='UNIQUE' or exists(select 1 from dba_constraints c        where owner=upper('%s') and constraint_type='P' AND c.index_name=A.INDEX_NAME))\n     and b.table_owner=upper('%s') %s and a.index_name=b.INDEX_NAME) b\n     on a.owner=b.table_owner and a.table_name=b.table_name and a.column_name=b.column_name", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterOceanBaseOracleTable("c.table_name"), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterOceanBaseOracleTable("b.table_name"));
    }

    public Map<String, TableInfo> tableInfo() {
        String sql = String.format(" SELECT \n    table_name,\n    column_name,\n    CASE \n        WHEN data_type = 'VARCHAR2' THEN 'varchar'\n        WHEN data_type = 'CHAR' THEN 'char'\n        ELSE data_type\n    END AS udt_name,\n    CASE \n        WHEN data_type IN ('VARCHAR2', 'CHAR') THEN CHAR_LENGTH\n        ELSE NULL\n    END AS character_maximum_length,\n    CASE \n        WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_PRECISION\n        ELSE NULL\n    END AS numeric_precision,\n    CASE \n        WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_SCALE\n        ELSE NULL\n    END AS numeric_scale\nFROM \n    dba_tab_columns where owner = upper('%s')  and table_name not in (select view_name from  dba_views) and table_name not like 'RECYCLE_$_%%'", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("table_name");
        return this.getTableInfo(sql);
    }

    public Map<String, TableInfo> tableInfo(String schema, String name) {
        String selectSql = String.format(" SELECT \n    table_name,\n    column_name,\n    CASE \n        WHEN data_type = 'VARCHAR2' THEN 'varchar'\n        WHEN data_type = 'CHAR' THEN 'char'\n        ELSE data_type\n    END AS udt_name,\n    CASE \n        WHEN data_type IN ('VARCHAR2', 'CHAR') THEN CHAR_LENGTH\n        ELSE NULL\n    END AS character_maximum_length,\n    CASE \n        WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_PRECISION\n        ELSE NULL\n    END AS numeric_precision,\n    CASE \n        WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_SCALE\n        ELSE NULL\n    END AS numeric_scale\nFROM \n    dba_tab_columns where owner = upper('%s') and table_name = upper('%s')", schema, name);
        return this.getTableInfo(schema, selectSql);
    }

    public String createColumnDdl() {
        return "SELECT\n  a.TABLE_NAME, a.COLUMN_NAME, a.DATA_TYPE, a.DATA_PRECISION, a.DATA_SCALE,NULLIF(a.char_length,0),a.DATA_LENGTH \nFROM all_tab_columns a, dba_tables t \n" + String.format("WHERE  t.owner = a.owner AND a.TABLE_NAME = t.TABLE_NAME AND a.owner = upper('%s') ", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterTable("a.TABLE_NAME");
    }

    public Map<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String countTableSql = String.format("select TABLE_NAME,'0' as invalid_data_filling from dba_tables where owner = upper('%s') %s", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME"));
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)countTableSql));
        String indexCountSql = String.format("with indx_t as (SELECT \n                table_name , LISTAGG(index_name, ',') WITHIN GROUP (ORDER BY index_name) AS index_list\n                FROM \n                dba_indexes \n                WHERE \n                table_type = 'TABLE' \n    and  NOT REGEXP_LIKE(index_name, '^'||table_name||'_OB(PK|UNIQUE)_[0-9]{16}$')                 AND owner = upper('%s')  %s                GROUP BY \n                      table_name\n                ORDER BY \n                      table_name)\n                select table_name,index_list from indx_t", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterTable("TABLE_NAME"));
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select VIEW_NAME,'0' as invalid_data_filling from dba_views  where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.VIEW.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)viewCountSql));
        String sequenceCountSql = String.format("select sequence_name,'0' as invalid_data_filling from dba_sequences where sequence_owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.SEQUENCE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)sequenceCountSql));
        String proceduresCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PROCEDURE' and STATUS = 'VALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.PROCEDURES.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresCountSql));
        String proceduresInvalidCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PROCEDURE' and STATUS = 'INVALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put("proceduresInvalidCount", JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)proceduresInvalidCountSql));
        String functionCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'FUNCTION' and STATUS = 'VALID' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.FUNCTION.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)functionCountSql));
        String triggerCountSql = String.format("SELECT TRIGGER_NAME,'0' as invalid_data_filling \nFROM dba_TRIGGERS \n where owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.TRIGGER.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)triggerCountSql));
        String typeCountSql = String.format("select type_name,'0' as invalid_data_filling from  dba_types \nwhere owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.TYPE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)typeCountSql));
        String packageCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PACKAGE' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.PACKAGE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageCountSql));
        String packageBodyCountSql = String.format("select object_name,'0' as invalid_data_filling from  dba_objects \nwhere object_type = 'PACKAGE BODY' and owner = upper('%s')", MotionEtlGlobalCtx.getInstance().currentTargetSchema());
        result.put(CompareTypeEnum.PACKAGE_BODY.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)packageBodyCountSql));
        return result;
    }
}

