/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.target.oracle;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.AbstractTargetJdbcMeta;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.targetDatabase"}, havingValue="oracle")
public class OracleTargetJdbcMeta
extends AbstractTargetJdbcMeta {
    private static final Logger log = LoggerFactory.getLogger(OracleTargetJdbcMeta.class);
    static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";

    @Autowired
    public OracleTargetJdbcMeta(@Qualifier(value="target") EtlConfig.DbConfig dbConfig) {
        super(dbConfig);
    }

    public Connection getConnection(EtlConfig.DbConfig dbConfig) {
        Connection newConnection = null;
        try {
            Class.forName(JDBC_DRIVER);
            boolean pwdEncrypted = MotionEtlGlobalCtx.getInstance().getGlobalConfig().isPwdEncrypted();
            newConnection = DriverManager.getConnection(dbConfig.getUrl(), dbConfig.getUsername(), pwdEncrypted ? AesDecryptUtils.decryptStringWithInputKey((String)dbConfig.getPassword(), (String)System.getProperty("EncryptKey")) : dbConfig.getPassword());
            try {
                Statement stmt = newConnection.createStatement();
                stmt.execute("ALTER SESSION SET NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'");
                stmt.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newConnection;
    }

    public Map<String, TableInfo> tableInfo() {
        String sql = String.format(" SELECT \n                       table_name,\n                        column_name,\n                       CASE \n                           WHEN data_type = 'VARCHAR2' THEN 'varchar'\n                           WHEN data_type = 'CHAR' THEN 'char'\n                            ELSE data_type\n                        END AS udt_name,\n                        CASE \n                            WHEN data_type IN ('VARCHAR2', 'CHAR') THEN CHAR_LENGTH\n                           ELSE NULL\n                       END AS character_maximum_length,\n                        CASE \n                            WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_PRECISION\n                            ELSE NULL\n                        END AS numeric_precision,\n                       CASE \n                            WHEN data_type IN ('NUMBER', 'FLOAT', 'DECIMAL') THEN DATA_SCALE\n                           ELSE NULL\n                        END AS numeric_scale\n                    FROM \n                        dba_tab_columns \n                    where owner = upper('%s')  AND \n      table_name not like 'BIN$%%$%%' \n AND       table_name NOT IN ( select /*+NO_UNNEST*/VIEW_NAME from dba_views WHERE owner = upper('%s')) ", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterOracleTable("table_name");
        return this.getTableInfo(sql);
    }

    public String createColumnDdl() {
        return "SELECT\n  a.TABLE_NAME, a.COLUMN_NAME, a.DATA_TYPE, a.DATA_PRECISION, a.DATA_SCALE,NULLIF(a.char_length,0),a.DATA_LENGTH \nFROM all_tab_columns a, dba_tables t \n" + String.format("WHERE  t.owner = a.owner AND a.TABLE_NAME = t.TABLE_NAME AND a.owner = upper('%s') ", MotionEtlGlobalCtx.getInstance().currentTargetSchema()) + MotionEtlGlobalCtx.getInstance().filterOracleTable("a.TABLE_NAME");
    }

    public String createTableDataColumnInfo() {
        return String.format("select a.owner,a.table_name,a.column_name,a.data_type,nvl(b.is_unique,0) from \n     (select owner,table_name,column_name,data_type from dba_tab_cols \n     where owner=upper('%s') and table_name not like 'BIN%%' %s) a\n     left join\n     (select distinct b.table_owner,b.table_name,b.column_name, 1 is_unique \n     from dba_indexes a,dba_ind_columns b where a.table_owner=upper('%s') and \n       (a.uniqueness='UNIQUE' or exists(select 1 from dba_constraints c        where owner=upper('%s') and constraint_type='P' AND c.index_name=A.INDEX_NAME))\n     and b.table_owner=upper('%s') %s and a.index_name=b.INDEX_NAME) b\n     on a.owner=b.table_owner and a.table_name=b.table_name and a.column_name=b.column_name", MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterOracleTable("table_name"), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().currentTargetSchema(), MotionEtlGlobalCtx.getInstance().filterOracleTable("b.table_name"));
    }

    public Map<String, HashMap<String, String>> countType() {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>(8);
        String tableCountSql = String.format("SELECT  \n table_name,\n '0' as invalid_data_filling\n  FROM dba_tables c \n WHERE owner  = upper('%s') \n", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().filterOracleTable("table_name"));
        result.put(CompareTypeEnum.TABLE.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)tableCountSql));
        String indexCountSql = String.format("select table_name, \n LISTAGG(column_name, ', ') WITHIN GROUP (ORDER BY column_position) index_list \n from dba_ind_columns a where index_owner=upper('%s') and index_name not like 'BIN$%%' \n and not exists(select 1 from dba_constraints b where owner=upper('%s') and constraint_name not like 'BIN$%%' \n and constraint_type='P' and a.index_name=b.constraint_name)\n group by table_name order by table_name\n", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase(), MotionEtlGlobalCtx.getInstance().filterOracleTable("table_name"));
        result.put(CompareTypeEnum.INDEX.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)indexCountSql));
        String viewCountSql = String.format("select view_name,'0' as invalid_data_filling from dba_views  where owner = '%s'", MotionEtlGlobalCtx.getInstance().currentTargetSchema().toLowerCase());
        result.put(CompareTypeEnum.VIEW.getCompareType(), JdbcUtils.queryCountSql((Connection)this.openConnection(), (String)viewCountSql));
        return result;
    }
}

