/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.transformer;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.enums.DataTypeEnum;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.CommonUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Mysql2Gaussdb500OracleTransformer
implements EtlTransformer {
    private static final Logger log = LoggerFactory.getLogger(Mysql2Gaussdb500OracleTransformer.class);
    public static HashMap<String, String> type = new HashMap(16);
    public static final String ERROR = "ERROR";
    public static final String NULL_STR = "null";
    public static final String ZERO = "0";
    public static final String DATETIME_PRECISION_VAL = "6";
    public static final String NUMERIC_PRECISION_VAL = "8";
    public static final int DATETIME_PRECISION_IDX = 4;

    public String transformTableDdl(String ddl) {
        String transformDdl = ddl;
        try {
            String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
            String regex = String.format("(?i)^\\bCREATE\\b.*\\bTABLE\\b\\s+", new Object[0]);
            transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("`%s`.", targetShcema));
            transformDdl = CommonUtils.mysqlRemoveKey((String)transformDdl);
            transformDdl = this.goTransfom(transformDdl);
            regex = "(?i)\\bselect\\s+\\b.*?\\bsetval\\s*\\('";
            transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("%s.", targetShcema));
            return transformDdl;
        }
        catch (Exception e) {
            log.error("DDL[{}]\u8f6c\u6362\u5931\u8d25\uff0c\u62a5\u9519", (Object)ddl, (Object)e);
            return ddl;
        }
    }

    public String transformViewDdl(String ddl) {
        String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
        String regex = String.format("(?i)^\\bCREATE\\b.*\\bVIEW\\b\\s+", new Object[0]);
        ddl = CommonUtils.regexInsert((String)ddl, (String)regex, (String)String.format("`%s`.", targetShcema));
        ddl = ddl.replaceAll("ALGORITHM=UNDEFINED DEFINER=`[^`]+`@`[^`]+` SQL SECURITY DEFINER", "");
        return this.goTransfom(ddl);
    }

    public String transformIndexDdl(String ddl) {
        return this.goTransfom(ddl);
    }

    public String transformPrimaryKeyDdl(String ddl) {
        return this.goTransfom(ddl);
    }

    public String transformForeignKeyDdl(String ddl) {
        return this.goTransfom(ddl);
    }

    public String goParse(String sql) {
        return Transformer.parse((String)sql, (String)DbType.MYSQL.name(), (String)DbType.GAUSSDB500_ORACLE.name());
    }

    public String goTransfom(String ddl) {
        try {
            String goParsed = this.goParse(ddl);
            if (goParsed.endsWith("ERROR")) {
                SqlLogger.printSql((String)"ltsql \u89e3\u6790\u5931\u8d25: ", (String)ddl);
                return ddl;
            }
            SqlLogger.printSql((String)"ltsql-parsed: ", (String)goParsed);
            return goParsed;
        }
        catch (Exception e) {
            SqlLogger.printSql((String)"ltsql \u89e3\u6790\u5931\u8d25: ", (String)ddl);
            log.error("\u7edf\u4e00SQL\u89e3\u6790\u62a5\u9519: ", (Throwable)e);
            return ddl;
        }
    }

    public String compareColumn(String columnName, String[] source, String[] target) {
        if (source == null || target == null) {
            return "\t \u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bfb\u53d6\u5931\u8d25";
        }
        String typeScore = source[0];
        if (typeScore == null || typeScore.length() == 0) {
            return "\t \u5217\u540d\u4e3a\u7a7a";
        }
        StringBuilder sb = new StringBuilder();
        if (source[0].equals(DataTypeEnum.FLOAT.getName()) || source[0].equals(DataTypeEnum.DOUBLE.getName())) {
            source[0] = "float8";
            source[1] = "null";
        }
        if (target[0].equals(DataTypeEnum.FLOAT4.getName()) || target[0].equals(DataTypeEnum.FLOAT8.getName())) {
            target[0] = "float8";
            target[1] = "null";
        }
        Mysql2Gaussdb500OracleTransformer.typeTransform((String[])source);
        String precisionScore = source[1].toLowerCase();
        String scaleScore = source[2].toLowerCase();
        String lengthScore = source[3].toLowerCase();
        String typeTarget = target[0].toLowerCase();
        String precisionTarget = target[1].toLowerCase();
        String scaleTarget = target[2].toLowerCase();
        String lengthTarget = target[3].toLowerCase();
        String dataLengthTarget = target[4].toLowerCase();
        String dataLengthSource = source[4].toLowerCase();
        if (!typeScore.equals(typeTarget)) {
            typeScore = source[0];
        }
        if (!typeScore.equals(typeTarget)) {
            sb.append(String.format("\t  \u6570\u636e\u7c7b\u578b\u4e0d\u540c, %s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[0], MotionEtlGlobalCtx.getInstance().targetDatabase, target[0]));
        } else {
            if (!(precisionScore.equals(precisionTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)precisionScore, (String)precisionTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u7cbe\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[1], MotionEtlGlobalCtx.getInstance().targetDatabase, target[1]));
            }
            if (!(scaleScore.equals(scaleTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)scaleScore, (String)scaleTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[2]));
            }
            if (!(lengthScore.equals(lengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)lengthScore, (String)lengthTarget))) {
                sb.append(String.format("\t  \u5b57\u7b26\u7684\u957f\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[3], MotionEtlGlobalCtx.getInstance().targetDatabase, target[3]));
            }
            if (!(dataLengthSource.equals(dataLengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)dataLengthSource, (String)dataLengthTarget))) {
                sb.append(String.format("\t  \u65e5\u671f\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s, %s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[4]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            sb.insert(0, String.format("\t%s:", columnName));
            sb.append("\n");
        } else {
            sb.append("SUCCESS");
        }
        return sb.toString();
    }

    private static void typeTransform(String[] source) {
        boolean datetimePrecisionNoChangeFlag = false;
        if (source[0].equals(DataTypeEnum.FLOAT8.getName())) {
            return;
        }
        source[0] = source[0].toLowerCase();
        if (type.containsKey(source[0])) {
            if (source[0].equals(DataTypeEnum.DATE.getName())) {
                source[4] = "0";
                datetimePrecisionNoChangeFlag = true;
            }
            if (source[0].equals(DataTypeEnum.DATETIME.getName())) {
                datetimePrecisionNoChangeFlag = true;
                if ("null".equals(source[4])) {
                    source[4] = "0";
                }
            }
            if (source[0].equals(DataTypeEnum.BLOB.getName()) || source[0].equals(DataTypeEnum.TINYBLOB.getName()) || source[0].equals(DataTypeEnum.MEDIUMBLOB.getName()) || source[0].equals(DataTypeEnum.LONGBLOB.getName()) || source[0].equals(DataTypeEnum.VARBINARY.getName())) {
                source[3] = "null";
            }
            source[0] = (String)type.get(source[0]);
        }
        if (source[0].equals(DataTypeEnum.TEXT.getName()) || source[0].equals(DataTypeEnum.MEDIUMTEXT.getName()) || source[0].equals(DataTypeEnum.LONGTEXT.getName())) {
            source[3] = "null";
        }
        if (source[0].equals(DataTypeEnum.INT4.getName())) {
            source[1] = "32";
        }
        if (source[0].equals(DataTypeEnum.INT8.getName())) {
            source[1] = "64";
        }
        if (source[0].equals(DataTypeEnum.BIT.getName())) {
            source[3] = source[1];
            source[1] = "null";
        }
        if (source[0].equals(DataTypeEnum.TIME.getName()) && "0".equals(source[4])) {
            source[4] = "6";
        }
        if (source[0].equals(DataTypeEnum.TIMESTAMP.getName()) && "0".equals(source[4]) && !datetimePrecisionNoChangeFlag) {
            source[4] = "6";
        }
        if (source[0].equals(DataTypeEnum.INT1.getName())) {
            source[1] = "8";
        }
        if (source[0].equals(DataTypeEnum.NVARCHAR2.getName())) {
            source[3] = "" + Integer.parseInt(source[3]) * 3;
        }
    }

    static {
        type.put("tinyint", "int4");
        type.put("smallint", "int8");
        type.put("mediumint", "int4");
        type.put("int", "int4");
        type.put("bigint", "int8");
        type.put("decimal", "numeric");
        type.put("date", "timestamp");
        type.put("datetime", "timestamp");
        type.put("char", "bpchar");
        type.put("varchar", "nvarchar2");
        type.put("varbinary", "bytea");
        type.put("blob", "bytea");
        type.put("boolean", "int1");
        type.put("longtext", "text");
        type.put("mediumtext", "text");
        type.put("tinyblob", "bytea");
        type.put("mediumblob", "bytea");
        type.put("longblob", "bytea");
    }
}

