/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.transformer;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.goldenmysql.GoldenMysqlTargetJdbcMeta;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.enums.DataTypeEnum;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.StrategyUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class Mysql802GoldenMysqlTransformer
implements EtlTransformer {
    private static final Logger log = LoggerFactory.getLogger(Mysql802GoldenMysqlTransformer.class);
    public static HashMap<String, String> type = new HashMap(16);
    @Autowired
    GoldenMysqlTargetJdbcMeta goldenMysqlTargetJdbcMeta;
    public static final String ERROR = "ERROR";

    public String transformTableDdl(String ddl) {
        String transformDdl = ddl;
        String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
        String regex = String.format("(?i)^\\bCREATE\\b.*\\bTABLE\\b\\s+", new Object[0]);
        transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("`%s`.", targetShcema));
        transformDdl = CommonUtils.mysqlRemoveKeyExceptPK((String)transformDdl);
        return transformDdl;
    }

    public String transformIndexDdl(String ddl) {
        return ddl;
    }

    private String pgTransform(String ddl) {
        return this.druidTransform(ddl, com.alibaba.druid.DbType.postgresql);
    }

    private String oracleTransform(String ddl) {
        return this.druidTransform(ddl, com.alibaba.druid.DbType.oracle);
    }

    public String transformSequenceDdl(String ddl) {
        return this.pgTransform(ddl);
    }

    public String transformViewDdl(String ddl) {
        ddl = ddl.replaceAll("ALGORITHM=UNDEFINED DEFINER=`[^`]+`@`[^`]+` SQL SECURITY DEFINER", "");
        return ddl;
    }

    public String transformProcedureDdl(String ddl) {
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().isRemoveDoubleQuote()) {
            ddl = StrategyUtils.removeQuoteForDDL((String)ddl, (String)"PROCEDURE", (String)"(IS|AS)");
        }
        ddl = CommonUtils.preClean((String)ddl);
        return ddl;
    }

    public String transformFunctionDdl(String ddl) {
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().isRemoveDoubleQuote()) {
            ddl = StrategyUtils.removeQuoteForDDL((String)ddl, (String)"FUNCTION", (String)"(IS|AS)");
        }
        ddl = CommonUtils.preClean((String)ddl);
        ddl = CommonUtils.languageJava((String)ddl);
        return ddl;
    }

    public String transformTriggerDdl(String ddl) {
        return this.oracleTransform(ddl);
    }

    public String transformPackageDdl(String ddl) {
        ddl = CommonUtils.removeQuoteSchemaPackage((String)ddl);
        ddl = CommonUtils.preClean((String)ddl);
        return ddl;
    }

    public String transformCheckConstraintsDdl(String ddl) {
        return this.pgTransform(ddl);
    }

    public String transformPrimaryKeyDdl(String ddl) {
        Map targetIndexFromTable = this.goldenMysqlTargetJdbcMeta.getPartitionIndexName();
        return ddl;
    }

    public String transformForeignKeyDdl(String ddl) {
        return ddl;
    }

    public String transformSynonymDdl(String ddl) {
        return this.pgTransform(ddl);
    }

    public String transformTypeDdl(String ddl) {
        return this.pgTransform(ddl);
    }

    public String doubleTransfom(String sql) {
        String druidPreParse = this.pgTransform(sql);
        try {
            String goParsed = this.goParse(druidPreParse);
            if (goParsed.endsWith(ERROR)) {
                SqlLogger.printSql((String)"ltsql \u89e3\u6790\u5931\u8d25: ", (String)sql);
                return druidPreParse;
            }
            SqlLogger.printSql((String)"ltsql-parsed: ", (String)goParsed);
            return goParsed;
        }
        catch (Exception e) {
            SqlLogger.printSql((String)"ltsql \u89e3\u6790\u5931\u8d25: ", (String)sql);
            log.error("\u7edf\u4e00SQL\u89e3\u6790\u62a5\u9519: ", (Throwable)e);
            return druidPreParse;
        }
    }

    public String goParse(String sql) {
        return Transformer.parse((String)sql, (String)DbType.ORACLE.name(), (String)DbType.LIGHTDB_ORACLE.name());
    }

    public String druidTransform(String sql, com.alibaba.druid.DbType dbType) {
        try {
            sql = this.preClean(sql);
            OracleStatementParser statementParser = new OracleStatementParser(sql);
            SQLStatement sqlStatement = statementParser.parseStatement();
            SqlLogger.printSql((String)"source-sql", (String)sql);
            String result = SQLUtils.toSQLString((SQLObject)sqlStatement, (com.alibaba.druid.DbType)dbType);
            SqlLogger.printSql((String)"druid-parsed", (String)result);
            return result;
        }
        catch (Exception e) {
            SqlLogger.printSql((String)"druid \u89e3\u6790\u5931\u8d25: ", (String)sql);
            log.error("druid\u89e3\u6790\u62a5\u9519: ", (Throwable)e);
            return sql;
        }
    }

    private String preClean(String sql) {
        return sql.replaceAll("EDITIONABLE", "").replaceAll("NONEDITIONABLE", "").replaceAll("DEFAULT ''\\s*\\*\\s*''", "DEFAULT ''");
    }

    public String compareColumn(String columnName, String[] source, String[] target) {
        if (source == null || target == null) {
            String str = "\t \u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bfb\u53d6\u5931\u8d25";
            return str;
        }
        String typeScore = source[0];
        if (typeScore == null || typeScore.length() == 0) {
            String str = "\t \u5217\u540d\u4e3a\u7a7a";
            return str;
        }
        StringBuilder sb = new StringBuilder();
        String precisionScore = source[1].toLowerCase();
        String scaleScore = source[2].toLowerCase();
        String lengthScore = source[3].toLowerCase();
        String typeTarget = target[0].toLowerCase();
        String precisionTarget = target[1].toLowerCase();
        String scaleTarget = target[2].toLowerCase();
        String lengthTarget = target[3].toLowerCase();
        String dataLengthTarget = target[4].toLowerCase();
        if (!typeScore.equals(typeTarget)) {
            typeScore = source[0];
        }
        boolean token = true;
        if (typeScore.equals(DataTypeEnum.INTERVAL.getName()) || source[0].contains(DataTypeEnum.TIMESTAMP.getName())) {
            if (!(scaleScore.equals(dataLengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)scaleScore, (String)dataLengthTarget))) {
                sb.append(String.format("\t  \u65e5\u671f\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s, %s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[4]));
                token = false;
            }
        } else {
            if (!(precisionScore.equals(precisionTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)precisionScore, (String)precisionTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u7cbe\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[1], MotionEtlGlobalCtx.getInstance().targetDatabase, target[1]));
                token = false;
            }
            if (!(scaleScore.equals(scaleTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)scaleScore, (String)scaleTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[2]));
                token = false;
            }
            if (!(lengthScore.equals(lengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)lengthScore, (String)lengthTarget))) {
                sb.append(String.format("\t  \u5b57\u7b26\u7684\u957f\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[3], MotionEtlGlobalCtx.getInstance().targetDatabase, target[3]));
                token = false;
            }
        }
        if (!token) {
            sb.insert(0, String.format("\t%s:", columnName));
            sb.append("\n");
        }
        return "SUCCESS";
    }
}

