/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.transformer;

import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.target.oceanbasemysql.OceanBaseMysqlTargetJdbcMeta;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.enums.DataTypeEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class Mysql802OceanBaseMysqlTransformer
implements EtlTransformer {
    private static final Logger log = LoggerFactory.getLogger(Mysql802OceanBaseMysqlTransformer.class);
    public static HashMap<String, String> type = new HashMap(16);
    public static final String NULL = "null";
    public static final int TYPE_NAME_IDX = 0;
    public static final int NUMERIC_PRECISION_IDX = 1;
    public static final int NUMERIC_SCALE_IDX = 2;
    public static final int CHARACTER_MAXIMUM_LENGTH_IDX = 3;
    @Autowired
    OceanBaseMysqlTargetJdbcMeta oceanBaseMysqlTargetJdbcMeta;

    public String transformTableDdl(String ddl) {
        String transformDdl = ddl;
        String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
        String regex = String.format("(?i)^\\bCREATE\\b.*\\bTABLE\\b\\s+", new Object[0]);
        transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("`%s`.", targetShcema));
        transformDdl = CommonUtils.mysqlRemoveKey((String)transformDdl);
        transformDdl = transformDdl.replaceAll("DEFAULT CHARSET=utf8mb3", "");
        transformDdl = transformDdl.replaceAll("COLLATE=utf8mb4_0900_ai_ci", "");
        transformDdl = transformDdl.replaceAll("CHARACTER SET utf8mb3", "");
        transformDdl = transformDdl.replaceAll("COLLATE utf8mb3_bin", "");
        return transformDdl;
    }

    public String transformIndexDdl(String ddl) {
        return ddl;
    }

    public String transformViewDdl(String ddl) {
        ddl = ddl.replaceAll("ALGORITHM=UNDEFINED DEFINER=`[^`]+`@`[^`]+` SQL SECURITY DEFINER", "");
        return ddl;
    }

    public String transformPrimaryKeyDdl(String ddl) {
        return ddl;
    }

    public String transformForeignKeyDdl(String ddl) {
        return ddl;
    }

    public String compareColumn(String columnName, String[] source, String[] target) {
        if (source == null || target == null) {
            return "\t \u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bfb\u53d6\u5931\u8d25";
        }
        String typeScore = source[0];
        if (typeScore == null || typeScore.length() == 0) {
            return "\t \u5217\u540d\u4e3a\u7a7a";
        }
        StringBuilder sb = new StringBuilder();
        Mysql802OceanBaseMysqlTransformer.typeTransform((String[])source, (String[])target);
        String precisionScore = source[1].toLowerCase();
        String scaleScore = source[2].toLowerCase();
        String lengthScore = source[3].toLowerCase();
        String typeTarget = target[0].toLowerCase();
        String precisionTarget = target[1].toLowerCase();
        String scaleTarget = target[2].toLowerCase();
        String lengthTarget = target[3].toLowerCase();
        String dataLengthTarget = target[4].toLowerCase();
        String dataLengthSource = source[4].toLowerCase();
        if (!typeScore.equals(typeTarget)) {
            typeScore = source[0];
        }
        if (!typeScore.equals(typeTarget)) {
            sb.append(String.format("\t  \u6570\u636e\u7c7b\u578b\u4e0d\u540c, %s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[0], MotionEtlGlobalCtx.getInstance().targetDatabase, target[0]));
        } else {
            if (!(precisionScore.equals(precisionTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)precisionScore, (String)precisionTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u7cbe\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[1], MotionEtlGlobalCtx.getInstance().targetDatabase, target[1]));
            }
            if (!(scaleScore.equals(scaleTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)scaleScore, (String)scaleTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[2]));
            }
            if (!(lengthScore.equals(lengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)lengthScore, (String)lengthTarget))) {
                sb.append(String.format("\t  \u5b57\u7b26\u7684\u957f\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[3], MotionEtlGlobalCtx.getInstance().targetDatabase, target[3]));
            }
            if (!(dataLengthSource.equals(dataLengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)dataLengthSource, (String)dataLengthTarget))) {
                sb.append(String.format("\t  \u65e5\u671f\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s, %s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[4]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            sb.insert(0, String.format("\t%s:", columnName));
            sb.append("\n");
        } else {
            sb.append("SUCCESS");
        }
        return sb.toString();
    }

    private static void typeTransform(String[] source, String[] target) {
        if (source[0].equals(DataTypeEnum.INT.getName()) && target[0].equals(DataTypeEnum.INT.getName())) {
            source[1] = "null";
            target[1] = "null";
        }
        if (source[0].equals(DataTypeEnum.BIGINT.getName()) && target[0].equals(DataTypeEnum.BIGINT.getName())) {
            source[1] = "null";
            target[1] = "null";
        }
        if (source[0].equals(DataTypeEnum.LONGTEXT.getName()) && target[0].equals(DataTypeEnum.LONGTEXT.getName())) {
            source[3] = "null";
            target[3] = "null";
        }
        if (source[0].equals(DataTypeEnum.BIT.getName()) && target[0].equals(DataTypeEnum.BIT.getName())) {
            source[2] = "null";
            target[2] = "null";
        }
        if (source[0].equals(DataTypeEnum.TINYINT.getName()) && target[0].equals(DataTypeEnum.TINYINT.getName())) {
            source[1] = "null";
            target[1] = "null";
        }
        if (source[0].equals(DataTypeEnum.LONGBLOB.getName()) && target[0].equals(DataTypeEnum.LONGBLOB.getName())) {
            source[3] = "null";
            target[3] = "null";
        }
        if (source[0].equals(DataTypeEnum.JSON.getName()) && target[0].equals(DataTypeEnum.JSON.getName())) {
            source[3] = "null";
            target[3] = "null";
        }
        if (source[0].equals(DataTypeEnum.MEDIUMINT.getName()) && target[0].equals(DataTypeEnum.MEDIUMINT.getName())) {
            source[1] = "null";
            target[1] = "null";
        }
        if (source[0].equals(DataTypeEnum.SMALLINT.getName()) && target[0].equals(DataTypeEnum.SMALLINT.getName())) {
            source[1] = "null";
            target[1] = "null";
        }
    }
}

