/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.transformer;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.enums.DataTypeEnum;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.CommonUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Mysql802OracleTransformer
implements EtlTransformer {
    private static final Logger log = LoggerFactory.getLogger(Mysql802OracleTransformer.class);
    public static final String NULL = "null";
    public static final String ZERO = "0";
    public static HashMap<String, String> type = new HashMap(16);
    public static final String ERROR = "ERROR";
    public static final int KEY_IDX_0 = 0;
    public static final int KEY_IDX_4 = 4;

    public String transformTableDdl(String ddl) {
        String transformDdl = ddl;
        try {
            String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
            String regex = String.format("(?i)^\\bCREATE\\b.*\\bTABLE\\b\\s+", new Object[0]);
            transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("`%s`.", targetShcema));
            transformDdl = CommonUtils.mysqlRemoveKey((String)transformDdl);
            transformDdl = this.goTransfom(transformDdl);
            regex = "(?i)\\bselect\\s+\\b.*?\\bsetval\\s*\\('";
            transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("%s.", targetShcema));
            return transformDdl;
        }
        catch (Exception e) {
            log.error("DDL[{}]\u8f6c\u6362\u5931\u8d25", (Object)ddl, (Object)e);
            return ddl;
        }
    }

    public String transformViewDdl(String ddl) {
        String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
        String regex = "(?i)^\\bCREATE\\b.*\\bVIEW\\b\\s+";
        ddl = CommonUtils.regexInsert((String)ddl, (String)regex, (String)String.format("`%s`.", targetShcema));
        ddl = ddl.replaceAll("ALGORITHM=UNDEFINED DEFINER=`[^`]+`@`[^`]+` SQL SECURITY DEFINER", "");
        return this.goTransfom(ddl);
    }

    public String transformIndexDdl(String ddl) {
        String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
        String regex = String.format("(?i)^\\bCREATE\\b.*\\bINDEX\\b\\s+", new Object[0]);
        String transformDdl = this.goTransfom(ddl);
        transformDdl = CommonUtils.regexInsert((String)transformDdl, (String)regex, (String)String.format("%s.", targetShcema));
        return transformDdl;
    }

    public String transformPrimaryKeyDdl(String ddl) {
        return this.goTransfom(ddl);
    }

    public String transformForeignKeyDdl(String ddl) {
        return this.goTransfom(ddl);
    }

    public String goParse(String sql) {
        return Transformer.parse((String)sql, (String)DbType.MYSQL.name(), (String)DbType.ORACLE_19C.name());
    }

    public String goTransfom(String ddl) {
        try {
            String goParsed = this.goParse(ddl);
            if (goParsed.endsWith("ERROR")) {
                SqlLogger.printSql((String)"\u7edf\u4e00SQL\u89e3\u6790\u5931\u8d25: ", (String)ddl);
                return ddl;
            }
            SqlLogger.printSql((String)"\u7edf\u4e00SQL\u89e3\u6790\u7ed3\u679c: ", (String)goParsed);
            return goParsed;
        }
        catch (Exception e) {
            SqlLogger.printSql((String)"\u7edf\u4e00SQL\u89e3\u6790\u5931\u8d25: ", (String)ddl);
            log.error("\u7edf\u4e00SQL\u89e3\u6790\u62a5\u9519: ", (Throwable)e);
            return ddl;
        }
    }

    public String compareColumn(String columnName, String[] source, String[] target) {
        if (source == null || target == null) {
            String str = "\t \u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bfb\u53d6\u5931\u8d25";
            return str;
        }
        String typeScore = source[0];
        if (typeScore == null || typeScore.length() == 0) {
            String str = "\t \u5217\u540d\u4e3a\u7a7a";
            return str;
        }
        StringBuilder sb = new StringBuilder();
        Mysql802OracleTransformer.modifyColumnAttrForCompare((String[])source, (String[])target);
        Mysql802OracleTransformer.typeTransform((String[])source);
        String precisionScore = source[1].toLowerCase();
        String scaleScore = source[2].toLowerCase();
        String lengthScore = source[3].toLowerCase();
        String typeTarget = target[0].toLowerCase();
        String precisionTarget = target[1].toLowerCase();
        String scaleTarget = target[2].toLowerCase();
        String lengthTarget = target[3].toLowerCase();
        String dataLengthTarget = target[4].toLowerCase();
        String dataLengthSource = source[4].toLowerCase();
        typeScore = source[0];
        if (!source[0].equals(typeTarget)) {
            typeScore = source[0];
        }
        if (!typeScore.equals(typeTarget)) {
            sb.append(String.format("\t  \u6570\u636e\u7c7b\u578b\u4e0d\u540c, %s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[0], MotionEtlGlobalCtx.getInstance().targetDatabase, target[0]));
        } else {
            if (!(precisionScore.equals(precisionTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)precisionScore, (String)precisionTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u7cbe\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[1], MotionEtlGlobalCtx.getInstance().targetDatabase, target[1]));
            }
            if (!(scaleScore.equals(scaleTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)scaleScore, (String)scaleTarget))) {
                sb.append(String.format("\t  \u6570\u636e\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[2]));
            }
            if (!(lengthScore.equals(lengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)lengthScore, (String)lengthTarget))) {
                sb.append(String.format("\t  \u5b57\u7b26\u7684\u957f\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[3], MotionEtlGlobalCtx.getInstance().targetDatabase, target[3]));
            }
            if (!(dataLengthSource.equals(dataLengthTarget) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)dataLengthSource, (String)dataLengthTarget))) {
                sb.append(String.format("\t  \u65e5\u671f\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s, %s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, source[2], MotionEtlGlobalCtx.getInstance().targetDatabase, target[4]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb)) {
            sb.insert(0, String.format("\t%s:", columnName));
            sb.append("\n");
        } else {
            sb.append("SUCCESS");
        }
        return sb.toString();
    }

    private static void modifyColumnAttrForCompare(String[] source, String[] target) {
        if (source[0].equals(DataTypeEnum.INT.getName()) || source[0].equals(DataTypeEnum.BIGINT.getName()) || source[0].equals(DataTypeEnum.TINYINT.getName()) || source[0].equals(DataTypeEnum.MEDIUMINT.getName()) || source[0].equals(DataTypeEnum.SMALLINT.getName())) {
            source[1] = "null";
            target[4] = "null";
        }
        if (source[0].equals(DataTypeEnum.DATE.getName())) {
            target[4] = "null";
        }
        if (source[0].equals(DataTypeEnum.BLOB.getName()) || source[0].equals(DataTypeEnum.LONGBLOB.getName()) || source[0].equals(DataTypeEnum.MEDIUMBLOB.getName())) {
            source[3] = "null";
            target[4] = "null";
        }
        if (source[0].equals(DataTypeEnum.FLOAT.getName())) {
            source[1] = "null";
            target[1] = "null";
            target[4] = "null";
        }
        if (source[0].equals(DataTypeEnum.LONGTEXT.getName()) || source[0].equals(DataTypeEnum.TEXT.getName()) || source[0].equals(DataTypeEnum.MEDIUMTEXT.getName())) {
            source[3] = "null";
            target[4] = "null";
        }
        if (source[0].equals(DataTypeEnum.CHAR.getName()) || source[0].equals(DataTypeEnum.VARCHAR.getName())) {
            target[4] = "null";
            if (target[0].equals(DataTypeEnum.CLOB.getName())) {
                source[3] = target[3];
                source[0] = DataTypeEnum.CLOB.getName();
            }
        }
        if (target[0].equals(DataTypeEnum.ORACLE_TIMESTAMP_6.getName())) {
            target[0] = DataTypeEnum.TIMESTAMP.getName();
            target[2] = "null";
            source[4] = "0";
            target[4] = "0";
        }
        if (source[0].equals(DataTypeEnum.VARCHAR.getName()) && target[0].equals(DataTypeEnum.NVARCHAR2.getName())) {
            target[4] = "null";
        }
        if (target[0].equalsIgnoreCase(DataTypeEnum.NUMBER.getName())) {
            target[4] = "null";
        }
    }

    private static void typeTransform(String[] source) {
        boolean datetimePrecisionNoChangeFlag = false;
        if (source[0].equals(DataTypeEnum.FLOAT8.getName())) {
            return;
        }
        source[0] = source[0].toLowerCase();
        if (type.containsKey(source[0])) {
            source[0] = (String)type.get(source[0]);
        }
    }

    static {
        type.put("int", "number");
        type.put("bigint", "number");
        type.put("numeric", "number");
        type.put("smallint", "number");
        type.put("mediumint", "number");
        type.put("tinyint", "number");
        type.put("decimal", "number");
        type.put("datetime", "timestamp");
        type.put("varchar", "varchar2");
        type.put("text", "clob");
        type.put("longtext", "clob");
        type.put("mediumtext", "clob");
        type.put("tinyblob", "blob");
        type.put("mediumblob", "blob");
        type.put("longblob", "blob");
    }
}

