/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.transformer;

import com.google.common.base.Joiner;
import com.hundsun.lightdb.core.source.oracle.OracleSourceFetcher;
import com.hundsun.lightdb.core.transformer.Ora2LightdbOracleTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class Ora2LightdbAnalyticTransformer
extends Ora2LightdbOracleTransformer {
    @Autowired
    OracleSourceFetcher oracleSourceFetcher;

    public String transformTableDdl(String ddl) {
        Map indexMap;
        String sql = super.transformTableDdl(ddl);
        Map uniqueColumns = this.oracleSourceFetcher.uniqueIndexesOfTable();
        String tableName = sql.split("\\s+")[2];
        int index = tableName.lastIndexOf(46);
        if (index != -1) {
            tableName = tableName.substring(index + 1);
        }
        if ((indexMap = (Map)uniqueColumns.get(tableName = tableName.toLowerCase())) != null) {
            StringBuilder sb = new StringBuilder(sql);
            String partition = "";
            if (indexMap.size() > 1) {
                partition = " DISTRIBUTED REPLICATED ";
            } else {
                LinkedHashSet columns = new LinkedHashSet((Collection)new ArrayList(indexMap.values()).get(0));
                String join = Joiner.on((char)',').join(columns);
                partition = String.format(" DISTRIBUTED BY (%s) ", join);
            }
            int partitionBy = sb.indexOf("PARTITION BY");
            if (partitionBy != -1) {
                sb.insert(partitionBy, partition);
            } else {
                sb.append(partition);
            }
            sql = sb.toString();
        }
        return sql;
    }
}

