/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.core.transformer;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.enums.DataTypeEnum;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.CommonUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oracle2OceanBaseOracleTransformer
implements EtlTransformer {
    private static final Logger log = LoggerFactory.getLogger(Oracle2OceanBaseOracleTransformer.class);
    public static final String ERROR = "ERROR";
    public static Map<String, String> type = new HashMap(16);

    public String transformTableDdl(String ddl) {
        if (StringUtils.isBlank((CharSequence)ddl)) {
            return ddl;
        }
        String[] sqls = ddl.split(";\n");
        String createDdl = sqls[0];
        ddl = this.goTransfom(createDdl);
        return ddl;
    }

    public String transformViewDdl(String ddl) {
        ddl = this.cleanViewDdl(ddl);
        return this.goTransfom(ddl);
    }

    private String cleanViewDdl(String viewDefinition) {
        if (StringUtils.isBlank((CharSequence)viewDefinition)) {
            return viewDefinition;
        }
        viewDefinition = viewDefinition.trim();
        String createViewPattern = "(?si)^CREATE.*?\\bVIEW\\b";
        Pattern createViewRegex = Pattern.compile(createViewPattern);
        Matcher createViewMatcher = createViewRegex.matcher(viewDefinition);
        int endIndex = 0;
        if (!createViewMatcher.find()) {
            return viewDefinition;
        }
        endIndex = createViewMatcher.end();
        String preCreateViewPart = viewDefinition.substring(0, endIndex);
        String postCreateViewPart = viewDefinition.substring(endIndex);
        if (StringUtils.isNotBlank((CharSequence)preCreateViewPart)) {
            preCreateViewPart = preCreateViewPart.replaceAll("(?i)\\bEDITIONABLE\\b", "").replaceAll("(?i)\\bNONEDITIONABLE\\b", "");
        }
        return preCreateViewPart + postCreateViewPart;
    }

    public String goParse(String sql) {
        return Transformer.parse((String)sql, (String)DbType.ORACLE.name(), (String)DbType.OCEAN_BASE_ORACLE.name());
    }

    public String goTransfom(String ddl) {
        try {
            String goParsed = this.goParse(ddl);
            if (goParsed.endsWith(ERROR)) {
                SqlLogger.printSql((String)"\u7edf\u4e00SQL\u89e3\u6790\u5931\u8d25: ", (String)ddl);
                return ddl;
            }
            SqlLogger.printSql((String)"\u7edf\u4e00SQL\u89e3\u6790\u7ed3\u679c: ", (String)goParsed);
            return goParsed;
        }
        catch (Exception e) {
            SqlLogger.printSql((String)"\u7edf\u4e00SQL\u89e3\u6790\u5931\u8d25: ", (String)ddl);
            log.error("\u7edf\u4e00SQL\u89e3\u6790\u62a5\u9519: ", (Throwable)e);
            return ddl;
        }
    }

    public String compareColumn(String columnName, String[] source, String[] target) {
        if (source == null || target == null) {
            return "\t \u6570\u636e\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bfb\u53d6\u5931\u8d25";
        }
        if (source.length == 0 || target.length == 0) {
            return "\t \u5217\u540d\u4e3a\u7a7a";
        }
        StringBuffer sb = new StringBuffer();
        String sourceType = source[0].toLowerCase();
        String sourcePrecision = source[1].toLowerCase();
        String sourceScale = source[2].toLowerCase();
        String sourceCharLength = source[3].toLowerCase();
        String targetType = target[0].toLowerCase();
        String targetPrecision = target[1].toLowerCase();
        String targetScale = target[2].toLowerCase();
        String targetCharLength = target[3].toLowerCase();
        boolean token = true;
        List<String> numberType = Arrays.asList(DataTypeEnum.NUMBER.getName(), DataTypeEnum.FLOAT.getName());
        List<String> characterType = Arrays.asList(DataTypeEnum.CHAR.getName(), DataTypeEnum.CLOB.getName(), DataTypeEnum.NCHAR.getName(), DataTypeEnum.NVARCHAR2.getName(), DataTypeEnum.VARCHAR2.getName());
        if (sourceType.equals(targetType) || targetType.equals(type.get(sourceType))) {
            if (numberType.contains(sourceType)) {
                if (!(sourcePrecision.equals(targetPrecision) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)sourcePrecision, (String)sourcePrecision))) {
                    sb.append(String.format("\t  \u6570\u636e\u7684\u7cbe\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, sourcePrecision, MotionEtlGlobalCtx.getInstance().targetDatabase, targetPrecision));
                    token = false;
                }
                if (!(sourceScale.equals(targetScale) || !MotionEtlGlobalCtx.getInstance().needCompareAll() && CommonUtils.compareString((String)sourceScale, (String)sourceScale))) {
                    sb.append(String.format("\t  \u6570\u636e\u7684\u6807\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, sourceScale, MotionEtlGlobalCtx.getInstance().targetDatabase, targetScale));
                    token = false;
                }
            }
            if (characterType.contains(sourceType) && !sourceCharLength.equals(targetCharLength) && (MotionEtlGlobalCtx.getInstance().needCompareAll() || !CommonUtils.compareString((String)sourceCharLength, (String)targetCharLength))) {
                sb.append(String.format("\t  \u5b57\u7b26\u7684\u957f\u5ea6\u4e0d\u540c\uff0c%s\uff1a%s,%s\uff1a%s;", MotionEtlGlobalCtx.getInstance().sourceDatabase, sourceCharLength, MotionEtlGlobalCtx.getInstance().targetDatabase, targetCharLength));
                token = false;
            }
        } else {
            sb.append(String.format("  %s\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u540c, %s\uff1a%s,%s\uff1a%s;", columnName, MotionEtlGlobalCtx.getInstance().sourceDatabase, sourceType, MotionEtlGlobalCtx.getInstance().targetDatabase, targetType));
            token = false;
        }
        if (!token) {
            sb.insert(0, String.format("\t%s:", columnName));
            sb.append("\n");
            return sb.toString();
        }
        return "SUCCESS";
    }

    static {
        type.put("rowid", "urowid");
    }
}

