/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.base;

import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static int SUCCESS_CODE = 0;
    private static int INTERNAL_CODE = -1;
    private int code;
    private T data;
    private String message;

    public Result() {
    }

    private Result(int code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    private Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static <T> Result<T> success(T data) {
        return new Result(SUCCESS_CODE, data, "");
    }

    public static <T> Result<T> successWithoutData(String message) {
        return new Result(SUCCESS_CODE, null, message);
    }

    public static <T> Result<T> successWithDataAndMessage(T data, String message) {
        return new Result(SUCCESS_CODE, data, message);
    }

    public static <T> Result<T> fail(String message) {
        return new Result(INTERNAL_CODE, message);
    }

    public static <T> Result<T> fail(int code, String message) {
        return new Result(code, message);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

