/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.factory;

import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.source.goldenmysql.GoldenMysqlSourceFetcher;
import com.hundsun.lightdb.core.source.lightdb.LightdbSourceFetcher;
import com.hundsun.lightdb.core.source.mysql.MysqlSourceFetcher;
import com.hundsun.lightdb.core.source.oracle.OracleSourceFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceFetcherFacorty {
    private static final Logger log = LoggerFactory.getLogger(SourceFetcherFacorty.class);

    public static SourceFetcher getSourceFetcher(String dataBaseType, SourceJdbcMeta sourceJdbcMeta) {
        OracleSourceFetcher sourceFetcher = null;
        switch (dataBaseType) {
            case "oracle": {
                sourceFetcher = new OracleSourceFetcher(sourceJdbcMeta);
                break;
            }
            case "lightdb": {
                sourceFetcher = new LightdbSourceFetcher(sourceJdbcMeta);
                break;
            }
            case "mysql": {
                sourceFetcher = new MysqlSourceFetcher(sourceJdbcMeta);
                break;
            }
            case "golden-mysql": {
                sourceFetcher = new GoldenMysqlSourceFetcher(sourceJdbcMeta);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b{}", (Object)dataBaseType);
            }
        }
        return sourceFetcher;
    }
}

