/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.factory;

import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.source.goldenmysql.GoldenMysqlSourceJdbcMeta;
import com.hundsun.lightdb.core.source.lightdb.LightdbSourceJdbcMeta;
import com.hundsun.lightdb.core.source.mysql.MysqlSourceJdbcMeta;
import com.hundsun.lightdb.core.source.oracle.OracleSourceJdbcMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceJdbcMetaFacorty {
    private static final Logger log = LoggerFactory.getLogger(SourceJdbcMetaFacorty.class);

    public static SourceJdbcMeta getSourceJdbcMeta(String dataBaseType, EtlConfig.DbConfig dbConfig) {
        OracleSourceJdbcMeta sourceJdbcMeta = null;
        switch (dataBaseType) {
            case "oracle": {
                sourceJdbcMeta = new OracleSourceJdbcMeta(dbConfig);
                break;
            }
            case "lightdb": {
                sourceJdbcMeta = new LightdbSourceJdbcMeta(dbConfig);
                break;
            }
            case "mysql": {
                sourceJdbcMeta = new MysqlSourceJdbcMeta(dbConfig);
                break;
            }
            case "golden-mysql": {
                sourceJdbcMeta = new GoldenMysqlSourceJdbcMeta(dbConfig);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b{}", (Object)dataBaseType);
            }
        }
        return sourceJdbcMeta;
    }
}

