/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.factory;

import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.core.target.goldenmysql.GoldenMysqlTargetImporter;
import com.hundsun.lightdb.core.target.lightdb.LightdbTargetImporter;
import com.hundsun.lightdb.core.target.mysql.MysqlTargetImporter;
import com.hundsun.lightdb.core.target.oceanbase.OceanBaseTargetImporter;
import com.hundsun.lightdb.core.target.oracle.OracleTargetImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetImporterFacorty {
    private static final Logger log = LoggerFactory.getLogger(TargetImporterFacorty.class);

    public static TargetImporter getTargetImporter(String dataBaseType, TargetJdbcMeta targetJdbcMeta, SourceJdbcMeta sourceJdbcMeta) {
        OracleTargetImporter targetImporter = null;
        switch (dataBaseType) {
            case "oracle": {
                targetImporter = new OracleTargetImporter(targetJdbcMeta, sourceJdbcMeta);
                break;
            }
            case "lightdb": 
            case "lightdb-a": {
                targetImporter = new LightdbTargetImporter(targetJdbcMeta, sourceJdbcMeta);
                break;
            }
            case "ocean_base_mysql": 
            case "ocean_base_oracle": {
                targetImporter = new OceanBaseTargetImporter(targetJdbcMeta, sourceJdbcMeta);
                break;
            }
            case "mysql": {
                targetImporter = new MysqlTargetImporter(targetJdbcMeta, sourceJdbcMeta);
                break;
            }
            case "golden-mysql": {
                targetImporter = new GoldenMysqlTargetImporter(targetJdbcMeta, sourceJdbcMeta);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b{}", (Object)dataBaseType);
            }
        }
        return targetImporter;
    }
}

