/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.factory;

import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.core.target.goldenmysql.GoldenMysqlTargetJdbcMeta;
import com.hundsun.lightdb.core.target.lightdb.LightdbTargetJdbcMeta;
import com.hundsun.lightdb.core.target.mysql.MysqlTargetJdbcMeta;
import com.hundsun.lightdb.core.target.oceanbase.OceanBaseTargetJdbcMeta;
import com.hundsun.lightdb.core.target.oracle.OracleTargetJdbcMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetJdbcMetaFactory {
    private static final Logger log = LoggerFactory.getLogger(TargetJdbcMetaFactory.class);

    public static TargetJdbcMeta getTargetJdbcMeta(String dataBaseType, EtlConfig.DbConfig dbConfig) {
        OracleTargetJdbcMeta targetJdbcMeta = null;
        switch (dataBaseType) {
            case "oracle": {
                targetJdbcMeta = new OracleTargetJdbcMeta(dbConfig);
                break;
            }
            case "lightdb": {
                targetJdbcMeta = new LightdbTargetJdbcMeta(dbConfig);
                break;
            }
            case "ocean_base_mysql": 
            case "ocean_base_oracle": {
                targetJdbcMeta = new OceanBaseTargetJdbcMeta(dbConfig);
                break;
            }
            case "mysql": {
                targetJdbcMeta = new MysqlTargetJdbcMeta(dbConfig);
                break;
            }
            case "golden-mysql": {
                targetJdbcMeta = new GoldenMysqlTargetJdbcMeta(dbConfig);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b{}", (Object)dataBaseType);
            }
        }
        return targetJdbcMeta;
    }
}

