/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.hundsun.lightdb.motion.dao.DataBaseInfoEntityMapper;
import com.hundsun.lightdb.motion.entity.DataBaseInfoEntity;
import com.hundsun.lightdb.motion.enums.DataBaseUrlEnum;
import com.hundsun.lightdb.motion.enums.DeleteStatusEnum;
import com.hundsun.lightdb.motion.enums.NoticeEnum;
import com.hundsun.lightdb.motion.service.DatabaseInfoService;
import com.hundsun.lightdb.motion.service.DictionaryService;
import com.hundsun.lightdb.motion.service.TaskMainService;
import com.hundsun.lightdb.motion.vo.request.DatabaseInfoQueryReqVo;
import com.hundsun.lightdb.motion.vo.response.DatabaseInfoRespVo;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.BeanCopyUtil;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.JdbcUtils;
import com.hundsun.lightdb.utils.idworker.IdUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class DatabaseInfoServiceImpl
implements DatabaseInfoService {
    @Autowired
    private DataBaseInfoEntityMapper databaseInfoEntityMapper;
    @Autowired
    private TaskMainService taskMainService;
    @Autowired
    private DictionaryService dictionaryService;

    public DataBaseInfoEntity get(String databaseId) {
        return (DataBaseInfoEntity)this.databaseInfoEntityMapper.selectByPrimaryKey(databaseId);
    }

    public String post(DataBaseInfoEntity dataBaseInfoEntity) {
        this.getDataBaseConnection(dataBaseInfoEntity);
        dataBaseInfoEntity.setDatabaseUrl(dataBaseInfoEntity.getDatabaseUrl());
        dataBaseInfoEntity.setDatabaseId(IdUtil.nextId());
        dataBaseInfoEntity.setIsDeleted(DeleteStatusEnum.UNDELETED.getStatus());
        this.databaseInfoEntityMapper.insertSelective((Object)dataBaseInfoEntity);
        return dataBaseInfoEntity.getDatabaseId();
    }

    public Integer put(DataBaseInfoEntity dataBaseInfoEntity) {
        this.getDataBaseConnection(dataBaseInfoEntity);
        return this.databaseInfoEntityMapper.updateByPrimaryKeySelective((Object)dataBaseInfoEntity);
    }

    public Integer delete(String databaseId) {
        DataBaseInfoEntity dataBaseInfoEntity = new DataBaseInfoEntity();
        dataBaseInfoEntity.setDatabaseId(databaseId);
        dataBaseInfoEntity.setIsDeleted(DeleteStatusEnum.DELETED.getStatus());
        return this.databaseInfoEntityMapper.updateByPrimaryKeySelective((Object)dataBaseInfoEntity);
    }

    public PageInfo<DatabaseInfoRespVo> getList(DatabaseInfoQueryReqVo databaseInfoQueryReqVo) {
        PageHelper.startPage((int)databaseInfoQueryReqVo.getCurrentPageNum(), (int)databaseInfoQueryReqVo.getPageSize());
        DataBaseInfoEntity dataBaseInfoEntity = (DataBaseInfoEntity)BeanCopyUtil.copy((Object)databaseInfoQueryReqVo, DataBaseInfoEntity.class);
        List databaseInfoEntity = this.databaseInfoEntityMapper.selectList(dataBaseInfoEntity);
        PageInfo pageInfo = new PageInfo(databaseInfoEntity);
        List databaseInfoRespVos = BeanCopyUtil.copyList((List)databaseInfoEntity, DatabaseInfoRespVo.class);
        pageInfo.setList(databaseInfoRespVos);
        pageInfo.setPageNum(databaseInfoQueryReqVo.getCurrentPageNum());
        pageInfo.setPageSize(databaseInfoQueryReqVo.getPageSize());
        return pageInfo;
    }

    public void getDataBaseConnection(DataBaseInfoEntity dataBaseInfoEntity) {
        if (!CommonUtils.isValidIp((String)dataBaseInfoEntity.getDatabaseHost())) {
            NoticeEnum.IP_VALIDATION_FAILED.throwUp();
        }
        if (!CommonUtils.isValidPort((String)dataBaseInfoEntity.getDatabasePort())) {
            NoticeEnum.PORT_VALIDATION_FAILED.throwUp();
        }
        String url = this.getFormatedDataBaseUrl(dataBaseInfoEntity);
        String decodePassword = AesDecryptUtils.getDecryptPassword((String)dataBaseInfoEntity.getUserPassword());
        dataBaseInfoEntity.setDatabaseUrl(url);
        if (!JdbcUtils.checkDataBaseConnection((String)url, (String)dataBaseInfoEntity.getUserName(), (String)decodePassword)) {
            NoticeEnum.DATABASE_CAN_NOT_CONNECT.throwUp();
        }
    }

    public Boolean getConnectionConfig(String connectName) {
        List baseInfoEntityList = this.databaseInfoEntityMapper.selectByConnectName(connectName);
        return !CollectionUtils.isEmpty((Collection)baseInfoEntityList);
    }

    private String getFormatedDataBaseUrl(DataBaseInfoEntity dataBaseInfoEntity) {
        String url = DataBaseUrlEnum.getFormateUrl((String)dataBaseInfoEntity.getDatabaseType());
        if (null == url) {
            NoticeEnum.DATABASE_TYPE_UNSUPPORT.throwUp();
        }
        return String.format(url, dataBaseInfoEntity.getDatabaseHost(), dataBaseInfoEntity.getDatabasePort(), dataBaseInfoEntity.getDatabaseName());
    }
}

