/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.MotionParameters;
import com.hundsun.lightdb.motion.MotionTask;
import com.hundsun.lightdb.motion.dao.TaskMainEntityMapper;
import com.hundsun.lightdb.motion.entity.DataBaseInfoEntity;
import com.hundsun.lightdb.motion.entity.SysConfigEntity;
import com.hundsun.lightdb.motion.entity.TaskConfigEntity;
import com.hundsun.lightdb.motion.entity.TaskExectueSnapshotEntity;
import com.hundsun.lightdb.motion.entity.TaskMainEntity;
import com.hundsun.lightdb.motion.entity.TaskRecordEntity;
import com.hundsun.lightdb.motion.enums.DataBaseUrlEnum;
import com.hundsun.lightdb.motion.enums.DeleteStatusEnum;
import com.hundsun.lightdb.motion.enums.NoticeEnum;
import com.hundsun.lightdb.motion.enums.SysConfigShowEnum;
import com.hundsun.lightdb.motion.enums.TaskMainScheduleEnum;
import com.hundsun.lightdb.motion.enums.TaskMainStatusEnum;
import com.hundsun.lightdb.motion.quartzscheduler.DynamicQuartzScheduler;
import com.hundsun.lightdb.motion.service.DatabaseInfoService;
import com.hundsun.lightdb.motion.service.SysConfigService;
import com.hundsun.lightdb.motion.service.TaskConfigService;
import com.hundsun.lightdb.motion.service.TaskExectueSnapshotService;
import com.hundsun.lightdb.motion.service.TaskMainService;
import com.hundsun.lightdb.motion.service.TaskRecordService;
import com.hundsun.lightdb.motion.vo.request.TaskMainAddReqVo;
import com.hundsun.lightdb.motion.vo.request.TaskMainQueryReqVo;
import com.hundsun.lightdb.motion.vo.request.TaskMainUpdateReqVo;
import com.hundsun.lightdb.motion.vo.response.DatabaseInfoRespVo;
import com.hundsun.lightdb.motion.vo.response.TaskMainDetailRespVo;
import com.hundsun.lightdb.motion.vo.response.TaskMainRespVo;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.BeanCopyUtil;
import com.hundsun.lightdb.utils.idworker.IdUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class TaskMainServiceImpl
implements TaskMainService {
    private static final Logger log = LoggerFactory.getLogger(TaskMainServiceImpl.class);
    private static String SCHEDULE_KEY = "scheduledTime";
    private static String SOURCE_DATABASE_KEY = "sourceDatabase";
    private static String TARGET_DATABASE_KEY = "targetDatabase";
    private static String SCHEMAS = "{schemas}";
    @Autowired
    private TaskMainEntityMapper taskMainEntityMapper;
    @Autowired
    private TaskConfigService taskConfigService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private DatabaseInfoService databaseInfoService;
    @Autowired
    private TaskExectueSnapshotService taskExectueSnapshotService;
    @Autowired
    private TaskRecordService taskRecordService;
    @Autowired
    private DynamicQuartzScheduler dynamicQuartzScheduler;
    private static WorkerGroup workerGroup = new WorkerGroup(10);

    public String postTask(TaskMainAddReqVo taskMainAddReqVo) {
        String taskMainId = IdUtil.nextId();
        this.postTaskConfig(taskMainId, taskMainAddReqVo.getTaskConfig(), taskMainAddReqVo.getSourceDatabaseId(), taskMainAddReqVo.getTargetDatabaseId());
        TaskMainEntity taskMainEntity = new TaskMainEntity();
        taskMainEntity.setTaskMainId(taskMainId);
        taskMainEntity.setTaskMainName(taskMainAddReqVo.getTaskMainName());
        taskMainEntity.setSourceDatabaseId(taskMainAddReqVo.getSourceDatabaseId());
        taskMainEntity.setTargetDatabaseId(taskMainAddReqVo.getTargetDatabaseId());
        taskMainEntity.setStatus(TaskMainStatusEnum.READY.getStatus());
        taskMainEntity.setIsDeleted(DeleteStatusEnum.UNDELETED.getStatus());
        TaskMainScheduleEnum taskMainScheduleEnum = this.getScheduleFlag(taskMainAddReqVo);
        taskMainEntity.setIsSchedule(taskMainScheduleEnum.getType());
        taskMainEntity.setCreateTime(new Date());
        this.taskMainEntityMapper.insertSelective((Object)taskMainEntity);
        this.restDynamicQuartzScheduler();
        if (taskMainAddReqVo.getIsStartTak().booleanValue()) {
            this.postStartTask(taskMainId);
        }
        return taskMainId;
    }

    private void checkCronExpression(String expression) {
        try {
            CronExpression cronExpression = new CronExpression(expression);
        }
        catch (ParseException ex) {
            NoticeEnum.TASK_CRONEXPRESSION_ERROR.throwUp();
        }
    }

    private void restDynamicQuartzScheduler() {
        this.dynamicQuartzScheduler.restDynamicQuartzScheduler();
    }

    private TaskMainScheduleEnum getScheduleFlag(TaskMainAddReqVo taskMainAddReqVo) {
        Map map = taskMainAddReqVo.getTaskConfig();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{(CharSequence)map.get(SCHEDULE_KEY)})) {
            return TaskMainScheduleEnum.NOT_SCHEDULE;
        }
        this.checkCronExpression((String)map.get(SCHEDULE_KEY));
        return TaskMainScheduleEnum.SCHEDULE;
    }

    public Integer putTask(TaskMainUpdateReqVo taskMainUpdateReqVo) {
        this.checkTaskMainEditable(taskMainUpdateReqVo.getTaskMainId());
        this.taskConfigService.deleteByTaskMainId(taskMainUpdateReqVo.getTaskMainId());
        this.postTaskConfig(taskMainUpdateReqVo.getTaskMainId(), taskMainUpdateReqVo.getTaskConfig(), taskMainUpdateReqVo.getSourceDatabaseId(), taskMainUpdateReqVo.getTargetDatabaseId());
        TaskMainEntity taskMainEntity = new TaskMainEntity();
        taskMainEntity.setTaskMainId(taskMainUpdateReqVo.getTaskMainId());
        taskMainEntity.setTaskMainName(taskMainUpdateReqVo.getTaskMainName());
        taskMainEntity.setSourceDatabaseId(taskMainUpdateReqVo.getSourceDatabaseId());
        taskMainEntity.setTargetDatabaseId(taskMainUpdateReqVo.getTargetDatabaseId());
        TaskMainScheduleEnum taskMainScheduleEnum = this.getScheduleFlag((TaskMainAddReqVo)taskMainUpdateReqVo);
        taskMainEntity.setIsSchedule(taskMainScheduleEnum.getType());
        this.taskMainEntityMapper.updateByPrimaryKeySelective((Object)taskMainEntity);
        this.restDynamicQuartzScheduler();
        if (taskMainUpdateReqVo.getIsStartTak().booleanValue()) {
            this.postStartTask(taskMainUpdateReqVo.getTaskMainId());
        }
        return 1;
    }

    private void postTaskConfig(String taskMainId, Map<String, String> map, String sourceDataBaseId, String targetDataBaseId) {
        DataBaseInfoEntity source = (DataBaseInfoEntity)this.databaseInfoService.get(sourceDataBaseId);
        DataBaseInfoEntity target = (DataBaseInfoEntity)this.databaseInfoService.get(targetDataBaseId);
        Map<String, String> unShowConfigmap = this.getUnShowConfig();
        unShowConfigmap.put(SOURCE_DATABASE_KEY, source.getDatabaseType().toLowerCase());
        unShowConfigmap.put(TARGET_DATABASE_KEY, target.getDatabaseType().toLowerCase());
        unShowConfigmap = unShowConfigmap.entrySet().stream().filter(e -> !map.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        unShowConfigmap.putAll(map);
        unShowConfigmap.entrySet().forEach(entry -> {
            TaskConfigEntity taskConfigEntity = new TaskConfigEntity();
            taskConfigEntity.setTaskConfigId(IdUtil.nextId());
            taskConfigEntity.setTaskConfigKey((String)entry.getKey());
            taskConfigEntity.setTaskConfigValue((String)entry.getValue());
            taskConfigEntity.setIsDeleted(DeleteStatusEnum.UNDELETED.getStatus());
            taskConfigEntity.setTaskMainId(taskMainId);
            taskConfigEntity.setCreateTime(new Date());
            this.taskConfigService.post((Object)taskConfigEntity);
        });
    }

    public Integer delete(String taskMainId) {
        this.checkTaskMainEditable(taskMainId);
        this.taskConfigService.deleteByTaskMainId(taskMainId);
        return this.taskMainEntityMapper.deleteById(taskMainId);
    }

    public PageInfo<TaskMainRespVo> getList(TaskMainQueryReqVo taskMainQueryReqVo) {
        PageHelper.startPage((int)taskMainQueryReqVo.getCurrentPageNum(), (int)taskMainQueryReqVo.getPageSize());
        TaskMainEntity taskMainEntity = (TaskMainEntity)BeanCopyUtil.copy((Object)taskMainQueryReqVo, TaskMainEntity.class);
        List taskMainEntities = this.taskMainEntityMapper.selectList(taskMainEntity);
        PageInfo pageInfo = new PageInfo(taskMainEntities);
        List databaseInfoRespVos = BeanCopyUtil.copyList((List)taskMainEntities, TaskMainRespVo.class);
        pageInfo.setList(databaseInfoRespVos);
        pageInfo.setPageNum(taskMainQueryReqVo.getCurrentPageNum());
        pageInfo.setPageSize(taskMainQueryReqVo.getPageSize());
        return pageInfo;
    }

    private void checkTaskMainEditable(String taskMainId) {
        TaskMainEntity taskMainEntity = (TaskMainEntity)this.taskMainEntityMapper.selectByPrimaryKey(taskMainId);
        if (TaskMainStatusEnum.RUNNING.getStatus().equals(taskMainEntity.getStatus())) {
            NoticeEnum.TASK_CAN_NOT_EDIT.throwUp();
        }
    }

    public TaskMainDetailRespVo getTaskDetail(String taskMainId) {
        TaskMainEntity taskMainEntity = (TaskMainEntity)this.taskMainEntityMapper.selectByPrimaryKey(taskMainId);
        TaskMainDetailRespVo taskMainDetailRespVo = (TaskMainDetailRespVo)BeanCopyUtil.copy((Object)taskMainEntity, TaskMainDetailRespVo.class);
        Map map = this.getTaskConfig(taskMainId);
        Map map2 = this.taskShowConfig(map);
        taskMainDetailRespVo.setTaskConfig(map2);
        DataBaseInfoEntity srouce = (DataBaseInfoEntity)this.databaseInfoService.get(taskMainEntity.getSourceDatabaseId());
        DatabaseInfoRespVo databaseInfoRespVo = (DatabaseInfoRespVo)BeanCopyUtil.copy((Object)srouce, DatabaseInfoRespVo.class);
        taskMainDetailRespVo.setSourceDataBase(databaseInfoRespVo);
        DataBaseInfoEntity target = (DataBaseInfoEntity)this.databaseInfoService.get(taskMainEntity.getTargetDatabaseId());
        databaseInfoRespVo = (DatabaseInfoRespVo)BeanCopyUtil.copy((Object)target, DatabaseInfoRespVo.class);
        taskMainDetailRespVo.setTargetDataBase(databaseInfoRespVo);
        return taskMainDetailRespVo;
    }

    private Map<String, String> taskShowConfig(Map<String, String> map) {
        Map unShowConfig = this.getUnShowConfig();
        return map.entrySet().stream().filter(e -> !unShowConfig.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> getTaskConfig(String taskMainId) {
        List taskConfigEntities = this.taskConfigService.getByTaskMainId(taskMainId);
        return taskConfigEntities.stream().collect(Collectors.toMap(TaskConfigEntity::getTaskConfigKey, v -> Optional.ofNullable(v.getTaskConfigValue()).orElse("")));
    }

    private Map<String, String> getUnShowConfig() {
        SysConfigEntity sysConfigEntity = new SysConfigEntity();
        sysConfigEntity.setIsShow(SysConfigShowEnum.UNSHOW.getStatus());
        List sysConfigEntities = this.sysConfigService.getList(sysConfigEntity);
        return sysConfigEntities.stream().collect(Collectors.toMap(SysConfigEntity::getSysConfigKey, v -> Optional.ofNullable(v.getSysConfigValue()).orElse("")));
    }

    public Integer postStartTask(String taskMainId) {
        TaskMainEntity taskMainEntity = (TaskMainEntity)this.taskMainEntityMapper.selectByPrimaryKey(taskMainId);
        this.checkTaskMainEditable(taskMainId);
        DataBaseInfoEntity sourceDataBase = (DataBaseInfoEntity)this.databaseInfoService.get(taskMainEntity.getSourceDatabaseId());
        DataBaseInfoEntity targetDataBase = (DataBaseInfoEntity)this.databaseInfoService.get(taskMainEntity.getTargetDatabaseId());
        this.databaseInfoService.getDataBaseConnection(sourceDataBase);
        this.databaseInfoService.getDataBaseConnection(targetDataBase);
        Map configMap = this.getTaskConfig(taskMainId);
        EtlConfig.GlobalConfig globalConfig = this.initGlobalConfig(configMap);
        EtlConfig.DbConfig source = this.initDbconfig(sourceDataBase);
        EtlConfig.DbConfig target = this.initDbconfig(targetDataBase);
        if (DataBaseUrlEnum.LIGHTDB.getDataBaseType().equals(targetDataBase.getDatabaseType().toUpperCase())) {
            target.setUrl(targetDataBase.getDatabaseUrl() + DataBaseUrlEnum.LIGHTDB.getSuffix().replace(SCHEMAS, globalConfig.getTransferSchemas()));
        }
        this.changeTaskStatus(taskMainEntity, TaskMainStatusEnum.RUNNING);
        String taskExectueSnapshotId = this.postTaskExectueSnapshot(taskMainId, sourceDataBase, targetDataBase, globalConfig);
        MotionParameters motionParameters = new MotionParameters();
        motionParameters.taskExectueSnapshotId = taskExectueSnapshotId;
        motionParameters.taskMainId = taskMainId;
        MotionTask motionTask = new MotionTask(globalConfig, source, target, motionParameters);
        workerGroup.addTask(() -> {
            this.taskRecordService.deleteByTaskMainId(taskMainId);
            motionTask.run();
            this.taskFinish(taskMainEntity);
        });
        return 1;
    }

    private void taskFinish(TaskMainEntity taskMainEntity) {
        TaskRecordEntity taskRecordEntity = this.taskRecordService.getFailRecordByTaskMainId(taskMainEntity.getTaskMainId());
        if (taskRecordEntity == null) {
            taskMainEntity.setStatus(TaskMainStatusEnum.SUCCESS.getStatus());
        } else {
            taskMainEntity.setStatus(TaskMainStatusEnum.FAIL.getStatus());
        }
        this.taskMainEntityMapper.updateByPrimaryKeySelective((Object)taskMainEntity);
    }

    private String postTaskExectueSnapshot(String taskMainId, DataBaseInfoEntity sourceDataBase, DataBaseInfoEntity targetDataBase, EtlConfig.GlobalConfig globalConfig) {
        TaskExectueSnapshotEntity taskExectueSnapshotEntity = new TaskExectueSnapshotEntity();
        String taskExectueSnapshotId = IdUtil.nextId();
        taskExectueSnapshotEntity.setTaskExectueSnapshotId(taskExectueSnapshotId);
        taskExectueSnapshotEntity.setTaskMainId(taskMainId);
        taskExectueSnapshotEntity.setExecuteTime(new Date());
        StringBuilder sb = new StringBuilder("SourceDataBase:");
        sb.append(sourceDataBase.toString());
        sb.append("TargetDataBase:");
        sb.append(targetDataBase.toString());
        sb.append("Config:");
        sb.append(globalConfig.toString());
        taskExectueSnapshotEntity.setTaskConfigContent(sb.toString());
        taskExectueSnapshotEntity.setIsDeleted(DeleteStatusEnum.UNDELETED.getStatus());
        this.taskExectueSnapshotService.post(taskExectueSnapshotEntity);
        return taskExectueSnapshotId;
    }

    private void changeTaskStatus(TaskMainEntity taskMainEntity, TaskMainStatusEnum taskMainStatusEnum) {
        taskMainEntity.setStatus(taskMainStatusEnum.getStatus());
        this.taskMainEntityMapper.updateByPrimaryKeySelective((Object)taskMainEntity);
    }

    private EtlConfig.GlobalConfig initGlobalConfig(Map<String, String> configMap) {
        EtlConfig.GlobalConfig globalConfig = new EtlConfig.GlobalConfig();
        globalConfig.setRunModel("1");
        for (Map.Entry<String, String> m : configMap.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            switch (key) {
                case "targetDatabase": {
                    globalConfig.setTargetDatabase(value);
                    break;
                }
                case "showSql": {
                    globalConfig.setShowSql(Boolean.parseBoolean(value));
                    break;
                }
                case "fastFail": {
                    globalConfig.setFastFail(Boolean.parseBoolean(value));
                    break;
                }
                case "removeDoubleQuote": {
                    globalConfig.setRemoveDoubleQuote(Boolean.parseBoolean(value));
                    break;
                }
                case "batchCount": {
                    globalConfig.setBatchCount(Integer.parseInt(value));
                    break;
                }
                case "enableFunctions": {
                    globalConfig.setEnableFunctions(value);
                    break;
                }
                case "customException": {
                    globalConfig.setCustomException(value);
                    break;
                }
                case "includeTableRegexp": {
                    globalConfig.setIncludeTableRegexp(value);
                    break;
                }
                case "excludeTableRegexp": {
                    globalConfig.setExcludeTableRegexp(value);
                    break;
                }
                case "keywords": {
                    globalConfig.setKeywords(value);
                    break;
                }
                case "syncCustomTableData": {
                    globalConfig.setSyncCustomTableData(value);
                    break;
                }
                case "syncTableDataOpenTruncate": {
                    globalConfig.setSyncTableDataOpenTruncate(Boolean.parseBoolean(value));
                    break;
                }
                case "transferSchemas": {
                    globalConfig.setTransferSchemas(value);
                    break;
                }
                case "transferOnlyProcedures": {
                    globalConfig.setTransferOnlyProcedures(value);
                    break;
                }
                case "onlyTransferTempTables": {
                    globalConfig.setOnlyTransferTempTables(Boolean.parseBoolean(value));
                    break;
                }
                case "sqluldr2CmdPrefix": {
                    globalConfig.setSqluldr2CmdPrefix(value);
                    break;
                }
                case "sourceDatabase": {
                    globalConfig.setSourceDatabase(value);
                    break;
                }
                case "concurrentThreadCount": {
                    globalConfig.setConcurrentThreadCount(Integer.parseInt(value));
                    break;
                }
                case "plpgSql": {
                    globalConfig.setPlpgSql(Boolean.parseBoolean(value));
                    break;
                }
                case "setOnCommitPreserveRows": {
                    globalConfig.setOnCommitPreserveRows(Boolean.parseBoolean(value));
                    break;
                }
                case "compileOracleProcedure": {
                    globalConfig.setCompileOracleProcedure(Boolean.parseBoolean(value));
                    break;
                }
            }
        }
        return globalConfig;
    }

    private EtlConfig.DbConfig initDbconfig(DataBaseInfoEntity dataBaseInfoEntity) {
        EtlConfig.DbConfig config = new EtlConfig.DbConfig();
        config.setUrl(dataBaseInfoEntity.getDatabaseUrl());
        config.setHost(dataBaseInfoEntity.getDatabaseHost());
        config.setPort(dataBaseInfoEntity.getDatabasePort());
        config.setDatabaseName(dataBaseInfoEntity.getDatabaseName());
        config.setUsername(dataBaseInfoEntity.getUserName());
        config.setPassword(AesDecryptUtils.getDecryptPassword((String)dataBaseInfoEntity.getUserPassword()));
        return config;
    }

    public Boolean getUsedDatabase(String databaseId) {
        TaskMainEntity taskMainEntity = this.taskMainEntityMapper.selectUsedDatabase(databaseId);
        if (taskMainEntity != null) {
            return true;
        }
        return false;
    }
}

