/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeanCopyUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanCopyUtil.class);

    public static <T> T copy(Object source, Class<T> targetClass, BeanCopier beanCopier) {
        T t;
        if (!BeanCopyUtil.validSource((Object)source)) {
            return null;
        }
        if (null == source) {
            if (log.isInfoEnabled()) {
                log.info("BeanCopyUtil$copy source is null");
            }
            return null;
        }
        try {
            t = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        beanCopier.copy(source, t, null);
        return t;
    }

    public static <T> T copy(Object source, Class<T> targetClass, BeanCopier beanCopier, Converter converter) {
        T t;
        if (!BeanCopyUtil.validSource((Object)source)) {
            return null;
        }
        if (null == source) {
            if (log.isInfoEnabled()) {
                log.info("BeanCopyUtil$copy source is null");
            }
            return null;
        }
        try {
            t = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        beanCopier.copy(source, t, converter);
        return t;
    }

    private static boolean validSource(Object source) {
        if (null == source) {
            if (log.isInfoEnabled()) {
                log.info("BeanCopyUtil$copy source is null");
            }
            return false;
        }
        return true;
    }

    public static <T> T copy(Object source, Class<T> targetClass) {
        T t;
        if (!BeanCopyUtil.validSource((Object)source)) {
            return null;
        }
        try {
            t = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        BeanCopier.create(source.getClass(), targetClass, (boolean)false).copy(source, t, null);
        return t;
    }

    public static <T> T copy(Object source, Class<T> targetClass, Converter converter) {
        T t;
        if (!BeanCopyUtil.validSource((Object)source)) {
            return null;
        }
        try {
            t = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        BeanCopier.create(source.getClass(), targetClass, (boolean)true).copy(source, t, converter);
        return t;
    }

    public static void copy(Object source, Object target, BeanCopier beanCopier) {
        beanCopier.copy(source, target, null);
    }

    public static void copy(Object source, Object target, BeanCopier beanCopier, Converter converter) {
        beanCopier.copy(source, target, converter);
    }

    public static void copy(Object source, Object target) {
        BeanCopier.create(source.getClass(), target.getClass(), (boolean)false).copy(source, target, null);
    }

    public static void copy(Object source, Object target, Converter converter) {
        BeanCopier.create(source.getClass(), target.getClass(), (boolean)true).copy(source, target, converter);
    }

    public static <T> List<T> copyList(List<?> sourceList, Class<T> targetClass, BeanCopier beanCopier, Converter converter) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
        for (Object o : sourceList) {
            try {
                resultList.add(BeanCopyUtil.copy(o, targetClass, (BeanCopier)beanCopier, (Converter)converter));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    public static <T> List<T> copyList(List<?> sourceList, Class<T> targetClass, BeanCopier beanCopier) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
        for (Object o : sourceList) {
            try {
                resultList.add(BeanCopyUtil.copy(o, targetClass, (BeanCopier)beanCopier));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    public static <T> List<T> copyList(List<?> sourceList, Class<T> targetClass) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
        for (Object o : sourceList) {
            try {
                resultList.add(BeanCopyUtil.copy(o, targetClass));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    public static <T> List<T> copyList(List<?> sourceList, Class<T> targetClass, Converter converter) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(sourceList.size());
        for (Object o : sourceList) {
            try {
                resultList.add(BeanCopyUtil.copy(o, targetClass, (Converter)converter));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }
}

