/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.utils;

import com.hundsun.lightdb.CustomClassLoader;
import com.hundsun.lightdb.core.EtlConfig;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.motion.enums.DataBaseTypeEnum;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.utils.AesDecryptUtils;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.StrategyUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION", "DM_SYSTEM_OUT", "DM_SYSTEM_ERR"})
public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final Pattern URL_PATTERN = Pattern.compile("jdbc:(?<type>[a-z]+)://(?<host>[a-zA-Z0-9-//.]+):(?<port>[0-9]+)/(?<database>[a-zA-Z0-9_]+)?");
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String DATABASE = "database";
    public static String EXTRACT_CREATE_TABLE_NAME_PATTERN = "CREATE TABLE \".+\".\"(.+)\"";
    public static String DECLARE_LOWER = "declare";
    public static String DECLARE_UPPER = "DECLARE";
    public static String BEGIN_LOWER = "begin";
    public static String BEGIN_UPPER = "BEGIN";
    private static final String IP_PATTERN = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private static final String PORT_PATTERN = "^(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$";
    private static final String FOREIGN_KEY_PATTERN = "(?i)^\\bCONSTRAINT\\b.*\\bFOREIGN\\b\\s+\\bKEY\\b";
    private static final String KEY_PATTERN = "(?i)^\\bKEY\\b";
    private static final String PRIMARY_KEY_PATTERN = "(?i)^\\bPRIMARY\\b\\s+\\bKEY\\b";
    private static final String UNIQUE_KEY_PATTERN = "(?i)^\\bUNIQUE\\b\\s+\\bKEY\\b";
    private static final Pattern PATTERN_FK = Pattern.compile("(?i)^\\bCONSTRAINT\\b.*\\bFOREIGN\\b\\s+\\bKEY\\b");
    private static final Pattern PATTERN_KEY = Pattern.compile("(?i)^\\bKEY\\b");
    private static final Pattern PATTERN_PK = Pattern.compile("(?i)^\\bPRIMARY\\b\\s+\\bKEY\\b");
    private static final Pattern PATTERN_UK = Pattern.compile("(?i)^\\bUNIQUE\\b\\s+\\bKEY\\b");
    public static String[] reservedKeyword = new String[]{" user ", " current_date "};
    public static char SEMICOLON_MARK = (char)59;
    public static final String COMP_FILE_SRC_POSTFIX = "_source";
    public static final String COMP_FILE_TGT_POSTFIX = "_target";
    public static final String WORK_DIR = "user.dir";
    public static final String SQL_DATA_COMPARE = "sqldatacompare";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String TRANSFER_TABLE_DATA_RESULT_FILENAME = "result.info";
    public static final String TABLE_DATA_COMPARE_RESULT_FILENAME = "table_data_compare.info";
    private static final Map<String, Driver> DRIVER_CACHE = new ConcurrentHashMap();

    public static String preClean(String sql) {
        return sql.replaceAll("EDITIONABLE", "").replaceAll("NONEDITIONABLE", "");
    }

    public static String languageJava(String sql) {
        String regex = "(?i)as\\s*LANGUAGE\\s*JAVA\\s*NAME";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher((CharSequence)sql);
        if (matcher.find()) {
            String returnsRegex = "(?i)\\bRETURN\\b";
            sql = ((String)sql).replaceAll(regex, "AS");
            int count = 0;
            int secondReturnIndex = -1;
            Pattern pattern1 = Pattern.compile(returnsRegex);
            Matcher matcher1 = pattern1.matcher((CharSequence)sql);
            while (matcher1.find()) {
                if (++count != 2) continue;
                secondReturnIndex = matcher1.start();
                break;
            }
            if (secondReturnIndex > 0) {
                String firstSql = ((String)sql).substring(0, secondReturnIndex).replaceAll("(?i)\\bRETURN\\b", "RETURNS");
                String secondSql = ((String)sql).substring(secondReturnIndex, ((String)sql).length());
                int index = secondSql.indexOf(39);
                sql = firstSql + secondSql.substring(index, secondSql.length());
            } else {
                sql = ((String)sql).replaceAll("(?i)\\bRETURN\\b", "RETURNS");
            }
            sql = ((String)sql).trim();
            sql = ((String)sql).charAt(((String)sql).length() - 1) == SEMICOLON_MARK ? ((String)sql).substring(0, ((String)sql).length() - 1) + " LANGUAGE JAVA" : (String)sql + " LANGUAGE JAVA";
            return sql;
        }
        return sql;
    }

    public static String removeSchema(String source) {
        int replaceLength = source.indexOf(46);
        if (replaceLength <= 0) {
            return source;
        }
        String first = source.substring(0, replaceLength);
        String second = source.substring(replaceLength + 1, source.length());
        return first.replaceAll(String.format("(?i)\\b%s\\b", MotionEtlGlobalCtx.getInstance().currentSchema()), "") + second;
    }

    public static String removeQuoteSchemaPackage(String source) {
        int packBody = source.indexOf("CREATE", 6);
        if (packBody <= 0) {
            return CommonUtils.removeSchema((String)StrategyUtils.removeQuoteForDDL((String)source, (String)"PACKAGE", (String)"(IS|AS)"));
        }
        String packStmt = CommonUtils.removeSchema((String)source.substring(0, packBody));
        String bodyStmt = CommonUtils.removeSchema((String)source.substring(packBody, source.length()));
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().isRemoveDoubleQuote()) {
            packStmt = StrategyUtils.removeQuoteForDDL((String)packStmt, (String)"PACKAGE", (String)"(IS|AS)");
            bodyStmt = StrategyUtils.removeQuoteForDDL((String)bodyStmt, (String)"PACKAGE", (String)"(IS|AS)");
        }
        return packStmt + bodyStmt;
    }

    public static String removeQuoteType(String source) {
        int typeBody = source.indexOf("CREATE", 6);
        if (typeBody <= 0) {
            return CommonUtils.removeSchema((String)StrategyUtils.removeQuoteForDDL((String)source, (String)"TYPE", (String)"(IS|AS)"));
        }
        String typeStmt = source.substring(0, typeBody);
        String bodyStmt = source.substring(typeBody, source.length());
        if (MotionEtlGlobalCtx.getInstance().getGlobalConfig().isRemoveDoubleQuote()) {
            typeStmt = StrategyUtils.removeQuoteForDDL((String)typeStmt, (String)"TYPE", (String)"(IS|AS)");
            bodyStmt = StrategyUtils.removeQuoteForDDL((String)bodyStmt, (String)"TYPE", (String)"(IS|AS)");
        }
        return typeStmt + bodyStmt;
    }

    public static boolean isValidIp(String ip) {
        return ip.matches("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    }

    public static boolean isValidPort(String port) {
        return port.matches("^(6553[0-5]|655[0-2]\\d|65[0-4]\\d{2}|6[0-4]\\d{3}|[1-5]\\d{4}|[1-9]\\d{0,3}|0)$");
    }

    public static String trimLeadTailDoubleQuote(String name) {
        name = StringUtils.trimLeadingCharacter((String)name, (char)'\"');
        name = StringUtils.trimTrailingCharacter((String)name, (char)'\"');
        return name;
    }

    public static String trimLeadTailDoubleQuote(String name, boolean lowerCase) {
        String trimLeadTailDoubleQuote = CommonUtils.trimLeadTailDoubleQuote((String)name);
        return lowerCase ? trimLeadTailDoubleQuote.toLowerCase() : trimLeadTailDoubleQuote;
    }

    public static boolean isRegexpLikeExtract(String sql, String extractStrRegexp, String regexp) {
        String targetName;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)regexp) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)extractStrRegexp)) {
            return true;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sql)) {
            return false;
        }
        Pattern regex = Pattern.compile(extractStrRegexp, 2);
        Matcher matcher = regex.matcher(sql);
        if (matcher.find() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(targetName = matcher.group(1)))) {
            return targetName.matches(regexp);
        }
        return true;
    }

    public static void getRelyTableName(Map<String, List<String>> tableNameMap, List<String> tableNames) {
        if (Objects.isNull(tableNameMap) || tableNameMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : tableNameMap.entrySet()) {
            CommonUtils.backtrack(tableNameMap, tableNames, (String)entry.getKey());
        }
    }

    private static void backtrack(Map<String, List<String>> map, List<String> path, String currentValue) {
        if (path.contains(currentValue)) {
            return;
        }
        if (map.containsKey(currentValue)) {
            List<String> keys = map.get(currentValue);
            for (String key : keys) {
                CommonUtils.backtrack(map, path, (String)key);
            }
            path.add(currentValue);
        } else {
            path.add(currentValue);
        }
    }

    public static void writeListDataToFile(List<String> dataList, String resourcePath) {
        try {
            File file = new File(resourcePath);
            if (file.isFile() && file.exists()) {
                file.delete();
            }
            log.info("create foreign key file path is {}", (Object)resourcePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (String data : dataList) {
                writer.write(data);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fkFileName(EtlConfig.DbConfig dbConfig) {
        String url = dbConfig.getUrl();
        String schema = MotionEtlGlobalCtx.getInstance().currentSchema();
        return System.getProperty("user.dir") + System.getProperty("file.separator") + "logs" + System.getProperty("file.separator") + "lightdb-etl" + System.getProperty("file.separator") + "create_foreign_key_" + url.substring(url.indexOf(64) + 1).replaceAll("/|\\.|:", "_") + "_" + schema + ".sql";
    }

    public static List<String> read(String filePath, String splitStr) {
        File file = new File(filePath);
        if (!file.exists()) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            br.close();
        }
        catch (Exception e2) {
            log.error("\u62a5\u9519: ", (Throwable)e2);
        }
        return Arrays.stream(sb.toString().split(splitStr)).filter(org.apache.commons.lang3.StringUtils::isNotBlank).map(e -> e.replaceAll(splitStr, "").replace("\"", "").trim()).collect(Collectors.toList());
    }

    public static List<KeyValuePair> fkSqlConvert(List<String> fkSqlStrList) {
        if (CollectionUtils.isEmpty(fkSqlStrList)) {
            return Collections.emptyList();
        }
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        for (String sql : fkSqlStrList) {
            String[] s = sql.split(" ");
            if (s.length <= 3) continue;
            KeyValuePair keyValuePair = new KeyValuePair(s[2], sql);
            result.add(keyValuePair);
        }
        return result;
    }

    public static String removeQuote(String source) {
        int replaceLength = source.indexOf(46) + 50;
        int subLength = replaceLength > source.length() ? source.length() - 4 : replaceLength;
        String first = source.substring(0, subLength);
        String second = source.substring(subLength);
        int ch = 34;
        if (first.indexOf(ch) != -1) {
            return first.replaceAll("\"", "") + second;
        }
        return source;
    }

    public static String[] transformTriggerDdl(String source, String currentSchema) {
        String[] result = new String[2];
        String splitLanguage = "LANGUAGE plpgsql;";
        if ((source = CommonUtils.removeQuote((String)source)).indexOf(splitLanguage) >= 0) {
            result[0] = source.split(splitLanguage)[0].replaceAll(";;", ";") + splitLanguage;
            result[1] = source.split(splitLanguage)[1];
        } else {
            String functionContent;
            String keyWord = BEGIN_LOWER;
            if (source.indexOf(DECLARE_LOWER) >= 0) {
                keyWord = DECLARE_LOWER;
            } else if (source.indexOf(DECLARE_UPPER) >= 0) {
                keyWord = DECLARE_UPPER;
            } else if (source.indexOf(BEGIN_LOWER) >= 0) {
                keyWord = BEGIN_LOWER;
            } else if (source.indexOf(BEGIN_UPPER) >= 0) {
                keyWord = BEGIN_UPPER;
            }
            String[] sqlSplited = source.split(keyWord);
            String trigger = sqlSplited[0];
            String triggerName = trigger.split("\\.")[1].split(" ")[0];
            String functionName = triggerName + "_imp()";
            String[] funs = (keyWord + sqlSplited[1]).split("\n");
            StringBuffer functionSql = new StringBuffer();
            functionSql.append("create or replace function ").append(functionName).append(" RETURNS TRIGGER AS $$\n");
            for (int i = 0; i < funs.length; ++i) {
                if (funs[i].contains("end " + triggerName) || funs[i].contains("ALTER TRIGGER")) continue;
                functionSql.append(funs[i] + "\n");
            }
            functionSql.append(" $$ LANGUAGE plpgsql;");
            result[0] = functionContent = functionSql.toString().replace(triggerName.toLowerCase() + ";", ";").replace(triggerName.toUpperCase() + ";", ";");
            Object triggerSql = trigger + String.format(" EXECUTE PROCEDURE %s;", functionName);
            result[1] = triggerSql = ((String)triggerSql).replaceAll(currentSchema.toLowerCase() + ".", "").replaceAll(currentSchema.toUpperCase() + ".", "");
        }
        return result;
    }

    private static List<Triple<String, String, String>> getDictionary(ObjectTypeEnum typeEnum) {
        ArrayList<Triple<String, String, String>> list = new ArrayList<Triple<String, String, String>>();
        list.add(Triple.of((Object)"EDITIONABLE", (Object)"", (Object)""));
        list.add(Triple.of((Object)"AUTHID", (Object)"CURRENT_USER", (Object)""));
        list.add(Triple.of((Object)"AUTHID", (Object)"DEFINER", (Object)""));
        switch (2.$SwitchMap$com$hundsun$lightdb$core$ObjectTypeEnum[typeEnum.ordinal()]) {
            case 1: {
                list.add((Triple<String, String, String>)Triple.of((Object)"end loop v_foo;", (Object)"", (Object)"end loop;"));
                break;
            }
            case 2: {
                list.add((Triple<String, String, String>)Triple.of((Object)" force ", (Object)"", (Object)" "));
                list.add((Triple<String, String, String>)Triple.of((Object)" binary_integer", (Object)";", (Object)" integer"));
                list.add((Triple<String, String, String>)Triple.of((Object)"static", (Object)"", (Object)" member "));
                list.add((Triple<String, String, String>)Triple.of((Object)"or", (Object)"replace", (Object)""));
                break;
            }
            case 3: {
                list.add((Triple<String, String, String>)Triple.of((Object)"INSERTING", (Object)"", (Object)" TG_OP='INSERT' "));
                list.add((Triple<String, String, String>)Triple.of((Object)"UPDATING", (Object)";", (Object)" TG_OP='UPDATE' "));
                list.add((Triple<String, String, String>)Triple.of((Object)"DELETING", (Object)"", (Object)" TG_OP='DELETE' "));
                list.add((Triple<String, String, String>)Triple.of((Object)":new", (Object)"", (Object)"new"));
                list.add((Triple<String, String, String>)Triple.of((Object)":old", (Object)"", (Object)"old"));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                list.add((Triple<String, String, String>)Triple.of((Object)"CONSTRAINT FOREIGN KEY", (Object)"", (Object)" FOREIGN KEY "));
            }
        }
        return list;
    }

    private static List<Triple<String, String, String>> getRemoveSpaceDictionary() {
        ArrayList<Triple<String, String, String>> list = new ArrayList<Triple<String, String, String>>();
        list.add(Triple.of((Object)"REF", (Object)"CURSOR", (Object)"REFCURSOR"));
        return list;
    }

    public static String replaceSpaceWithExpression(String source) {
        List list = CommonUtils.getRemoveSpaceDictionary();
        for (Triple triple : list) {
            source = CommonUtils.regexSpaceReplace((String)source, (String)((String)triple.getLeft()), (String)((String)triple.getMiddle()), (String)((String)triple.getRight()));
        }
        return source;
    }

    public static String mysqlRemoveKey(String source) {
        String[] lines = source.split("\\n");
        StringBuffer result = new StringBuffer();
        for (String line : lines) {
            String lineTrim = line.trim();
            if (PATTERN_FK.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            if (PATTERN_KEY.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            if (PATTERN_PK.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            if (PATTERN_UK.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            result.append(line);
        }
        return result.toString();
    }

    public static String mysqlRemoveKeyExceptPK(String source) {
        String[] lines = source.split("\\n");
        StringBuffer result = new StringBuffer();
        for (String line : lines) {
            String lineTrim = line.trim();
            if (PATTERN_FK.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            if (PATTERN_KEY.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            if (PATTERN_UK.matcher(lineTrim).find()) {
                if (line.charAt(line.length() - 1) == ',' || result.charAt(result.length() - 1) != ',') continue;
                result.delete(result.length() - 1, result.length());
                continue;
            }
            result.append(line);
        }
        return result.toString();
    }

    public static String regexInsert(String source, String regex, String insert) {
        StringBuffer result = new StringBuffer(source.trim());
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(result);
        if (matcher.find()) {
            int index = matcher.end();
            result.insert(index, insert);
            return result.toString();
        }
        return source;
    }

    public static String removeForeignKey(String source) {
        String foreign = "CONSTRAINT ";
        String references = "REFERENCES";
        Matcher matcher = CommonUtils.getMatcher((String)source, (String)foreign, (String)references);
        while (matcher.find()) {
            ArrayList<Triple> list = new ArrayList<Triple>();
            list.add(Triple.of((Object)matcher.group(), (Object)"),", (Object)" "));
            list.add(Triple.of((Object)matcher.group(), (Object)")", (Object)" "));
            source = CommonUtils.replaceWithExpression((String)source, list);
        }
        source = CommonUtils.regexSpaceReplace((String)source, (String)",", (String)"\\)", (String)")");
        return source;
    }

    public static String getIndexSql(String sql, Map<String, Set<String>> targetIndexFromTable) {
        String uniqueIndex = "CREATE UNIQUE INDEX";
        if (sql.contains(uniqueIndex)) {
            try {
                String tableName = CommonUtils.getTableNameFromSql((String)sql);
                if (targetIndexFromTable.containsKey(tableName)) {
                    Set indexNameFromSql = CommonUtils.getIndexFromSql((String)sql);
                    Set<String> targetIndexSet = targetIndexFromTable.get(tableName);
                    sql = CommonUtils.getNewIndexSql((String)sql, (Set)indexNameFromSql, targetIndexSet);
                }
            }
            catch (Exception ex) {
                log.error("CommonUtils.getIndexSql error:{}", (Object)ex.getMessage());
            }
        }
        return sql;
    }

    public static String getIndexSql2(String sql, Map<String, Set<String>> targetIndexFromTable) {
        String uniqueIndex = "UNIQUE";
        String primaryKey = "PRIMARY";
        if (sql.contains(uniqueIndex) || sql.contains(primaryKey)) {
            try {
                String tableName = CommonUtils.getTableNameFromSql2((String)sql);
                if (targetIndexFromTable.containsKey(tableName)) {
                    Set indexNameFromSql = CommonUtils.getIndexFromSql((String)sql);
                    Set<String> targetIndexSet = targetIndexFromTable.get(tableName);
                    sql = CommonUtils.getNewIndexSql((String)sql, (Set)indexNameFromSql, targetIndexSet);
                }
            }
            catch (Exception ex) {
                log.error("CommonUtils.getIndexSql error:{}", (Object)ex.getMessage());
            }
        }
        return sql;
    }

    public static String getTableNameFromSql(String source) {
        Pattern pattern = Pattern.compile("CREATE\\s+UNIQUE\\s+INDEX\\s+\\S+\\s+ON\\s+([A-Za-z0-9_]+\\.[A-Za-z0-9_]+)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            String split;
            String tableName = matcher.group(1);
            if (tableName.contains(split = ".")) {
                tableName = tableName.split("\\.")[1];
                return tableName;
            }
            throw new RuntimeException("\u901a\u8fc7\u7d22\u5f15\u540d\u79f0\u83b7\u53d6\u8868\u540d\u5931\u8d25");
        }
        throw new RuntimeException("\u901a\u8fc7\u7d22\u5f15\u540d\u79f0\u83b7\u53d6\u8868\u540d\u5931\u8d25");
    }

    public static String getTableNameFromSql2(String source) {
        String patternString = "([^.]+)\\.(.+)";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            String sql = source.substring(matcher.start(2), source.length());
            Pattern pattern2 = Pattern.compile("[ \\n\\t]");
            Matcher matcher2 = pattern2.matcher(sql);
            if (matcher2.find()) {
                int index = matcher2.start();
                String tableName = sql.substring(0, index);
                return tableName.replaceAll("\"", "");
            }
            throw new RuntimeException("\u901a\u8fc7\u7d22\u5f15\u540d\u79f0\u83b7\u53d6\u8868\u540d\u5931\u8d25\uff0c\u56e0\u4e3a\u8f93\u5165\u5b57\u7b26\u4e32\u4e0d\u7b26\u5408\u9884\u671f\u7684\u683c\u5f0f");
        }
        throw new RuntimeException("\u901a\u8fc7\u7d22\u5f15\u540d\u79f0\u83b7\u53d6\u8868\u540d\u5931\u8d25\uff0c\u56e0\u4e3a\u8f93\u5165\u5b57\u7b26\u4e32\u4e0d\u7b26\u5408\u9884\u671f\u7684\u683c\u5f0f");
    }

    public static String getExcludeAlterTriggerSql(String source) {
        String toRemove = "ALTER TRIGGER";
        int index = source.indexOf(toRemove);
        if (index != -1) {
            String modifiedSql = source.substring(0, index);
            return modifiedSql;
        }
        return source;
    }

    public static Set<String> getIndexFromSql(String source) {
        HashSet<String> indexSet = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            String[] indexNames;
            String indexName = matcher.group(1);
            for (String s : indexNames = indexName.split(",")) {
                indexSet.add(s.replaceAll("\\s", ""));
            }
        }
        return indexSet;
    }

    public static String getOneIndexFromSql(String source) {
        Pattern pattern = Pattern.compile("(?i)INDEX\\s+([^\\s]+)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        Pattern pattern2 = Pattern.compile("(?i)CONSTRAINT\\s+([^\\s]+)");
        Matcher matcher2 = pattern2.matcher(source);
        if (matcher2.find()) {
            return matcher2.group(1);
        }
        return null;
    }

    public static String getPackageBodyFromSql(String source) {
        Pattern pattern = Pattern.compile("(?i)\\bPACKAGE\\s+BODY\\s+([A-Z0-9_]+)\\b\\s+(?:as|is)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getTriggerBodyFromSql(String source) {
        Pattern pattern = Pattern.compile("(?i)\\bTRIGGER\\s+BODY\\s+([A-Z0-9_]+)\\b\\s+(?:as|is)");
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String getNewIndexSql(String sql, Set<String> souSet, Set<String> tarSet) {
        StringBuffer newIndexNames;
        String indexNames;
        HashSet<String> lessIndex = new HashSet<String>();
        for (String s : tarSet) {
            if (souSet.contains(s)) continue;
            lessIndex.add(s);
        }
        Pattern pattern = Pattern.compile("\\((.*?)\\)");
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            indexNames = matcher.group(1);
            newIndexNames = new StringBuffer();
            newIndexNames = newIndexNames.append(indexNames);
            for (String s : lessIndex) {
                if (souSet.contains(s)) continue;
                newIndexNames = newIndexNames.append(", ").append(s);
            }
        } else {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u8054\u5408\u7d22\u5f15");
        }
        String middle = String.format("\\(%s\\)", indexNames);
        String right = String.format("(%s)", newIndexNames);
        sql = sql.replaceAll(middle, right);
        return sql;
    }

    private static Set<String> getErrorCloumnName(Set<String> source) {
        HashSet<String> cloumnNameList = new HashSet<String>(100);
        Pattern pattern = Pattern.compile(".*[^a-zA-Z0-9 ].*");
        source.forEach(s -> {
            String temp = s.replaceAll("_", "");
            Matcher matcher = pattern.matcher(temp);
            if (matcher.find()) {
                cloumnNameList.add((String)s);
            }
        });
        return cloumnNameList;
    }

    public static String replaceWithExpression(String source, ObjectTypeEnum typeEnum) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)source)) {
            return source;
        }
        List list = CommonUtils.getDictionary((ObjectTypeEnum)typeEnum);
        for (Triple triple : list) {
            source = CommonUtils.regexReplace((String)source, (String)((String)triple.getLeft()), (String)((String)triple.getMiddle()), (String)((String)triple.getRight()));
        }
        return source;
    }

    private static String replaceWithExpression(String source, List<Triple<String, String, String>> list) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)source) || list.size() == 0) {
            return source;
        }
        for (Triple<String, String, String> triple : list) {
            source = CommonUtils.regexReplace((String)source, (String)((String)triple.getLeft()), (String)((String)triple.getMiddle()), (String)((String)triple.getRight()));
        }
        return source;
    }

    private static String regexReplace(String source, String firstKeyWord, String lastKeyWord, String replacement) {
        Matcher matcher = CommonUtils.getMatcher((String)source, (String)firstKeyWord, (String)lastKeyWord);
        return matcher.replaceAll(replacement);
    }

    private static Matcher getMatcher(String source, String firstKeyWord, String lastKeyWord) {
        Pattern pattern = Pattern.compile("(?i)(" + Pattern.quote(firstKeyWord) + ".*?" + Pattern.quote(lastKeyWord) + ")");
        Matcher matcher = pattern.matcher(source);
        return matcher;
    }

    private static String regexSpaceReplace(String source, String firstKeyWord, String lastKeyWord, String replacement) {
        Pattern pattern = Pattern.compile(firstKeyWord + "\\s+" + lastKeyWord, 2);
        Matcher matcher = pattern.matcher(source);
        return matcher.replaceAll(replacement);
    }

    public static Triple<String, String, String> getDataBaseInfo(String url) {
        Triple triple = Triple.of((Object)"", (Object)"", (Object)"");
        Matcher dateMatcher = URL_PATTERN.matcher(url);
        if (dateMatcher.find()) {
            return Triple.of((Object)dateMatcher.group("host"), (Object)dateMatcher.group("port"), (Object)dateMatcher.group("database"));
        }
        return triple;
    }

    public static void quickSort(int[] arr) {
        CommonUtils.quickSort((int[])arr, (int)0, (int)(arr.length - 1));
    }

    private static void quickSort(int[] arr, int left, int right) {
        if (left < right) {
            int pivotIndex = CommonUtils.partition((int[])arr, (int)left, (int)right);
            CommonUtils.quickSort((int[])arr, (int)left, (int)(pivotIndex - 1));
            CommonUtils.quickSort((int[])arr, (int)(pivotIndex + 1), (int)right);
        }
    }

    private static int partition(int[] arr, int left, int right) {
        int pivot = arr[right];
        int i = left;
        for (int j = left; j < right; ++j) {
            if (arr[j] > pivot) continue;
            CommonUtils.swap((int[])arr, (int)i, (int)j);
            ++i;
        }
        CommonUtils.swap((int[])arr, (int)i, (int)right);
        return i;
    }

    private static void swap(int[] arr, int i, int j) {
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
    }

    public static int knapsack(int[] values, int[] weights, int capacity) {
        int n = values.length;
        int[][] dp = new int[n + 1][capacity + 1];
        for (int i = 1; i <= n; ++i) {
            for (int w = 1; w <= capacity; ++w) {
                dp[i][w] = weights[i - 1] <= w ? Math.max(dp[i - 1][w], values[i - 1] + dp[i - 1][w - weights[i - 1]]) : dp[i - 1][w];
            }
        }
        return dp[n][capacity];
    }

    public static synchronized boolean createNewFile(String fileName) {
        String formatFilePath = String.format(fileName + "%s", FilenameUtils.getName((String)""));
        File file = new File(formatFilePath);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u65b0\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
        }
        return true;
    }

    public static String getLogPath() {
        StringBuffer resultPath = new StringBuffer();
        String eltLogPath = System.getenv("ETL_LOG_PATH");
        resultPath.append("./logs/lightdb-etl/");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)eltLogPath)) {
            resultPath.append(eltLogPath);
        }
        return resultPath.toString();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "WMI_WRONG_MAP_ITERATOR"})
    public static synchronized boolean writeDataResult(String message, String fileName) {
        String formatFilePath = String.format(fileName + "%s", FilenameUtils.getName((String)""));
        File file = new File(formatFilePath);
        if (!file.exists()) {
            return false;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "utf-8");){
            writer.write(message);
            writer.flush();
        }
        catch (IOException e) {
            EtlGlobalCtx.INSTANCE.handleException(String.format("\u5199\u5165\u8fc1\u79fb\u7ed3\u679c\u62a5\u9519\uff1a\u5199\u5165\u6d88\u606f %s", message), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean writeTransferTableDataResult(String message) {
        StringBuffer resultPath = new StringBuffer();
        resultPath.append(String.format("%s/%s", CommonUtils.getLogPath(), "result.info"));
        boolean result = CommonUtils.writeDataResult((String)message, (String)resultPath.toString());
        return result;
    }

    public static boolean writeTableDataCompareResult(String message) {
        StringBuffer resultPath = new StringBuffer();
        resultPath.append(String.format("%s/%s", CommonUtils.getLogPath(), "table_data_compare.info"));
        boolean result = CommonUtils.writeDataResult((String)message, (String)resultPath.toString());
        return result;
    }

    public static boolean compareString(String str1, String str2) {
        if (CommonUtils.isNumeric((String)str1) && CommonUtils.isNumeric((String)str2)) {
            int num2;
            int num1 = Integer.parseInt(str1);
            return num1 <= (num2 = Integer.parseInt(str2));
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String compareSqlFilePath(String suffix) {
        String workDir = System.getProperty("user.dir");
        return String.format(String.join((CharSequence)File.separator, workDir, "sqldatacompare", "%s"), suffix);
    }

    public static boolean isPgFamilyDB(String dbName) {
        return dbName.equalsIgnoreCase(DataBaseTypeEnum.LIGHTDB_MYSQL.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.LIGHTDB_ORACLE.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.LIGHTDB_POSTGRESQL.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.OPENGAUSS.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.POSTGRESQL.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.GAUSSDB500ORACLE.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.GAUSSDB505ORACLE.getName());
    }

    public static boolean isMysqlFamilyDB(String dbName) {
        return dbName.equalsIgnoreCase(DataBaseTypeEnum.MYSQL.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.MYSQL80.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.GOLDENMYSQL.getName()) || dbName.equalsIgnoreCase(DataBaseTypeEnum.OCEAN_BASE_MYSQL.getName());
    }

    public static Path getConfigPath() {
        String userDir = System.getProperty("user.dir");
        Path configPath = Paths.get(userDir, new String[0]).resolve("config").toAbsolutePath();
        log.info("config path: {}", (Object)configPath);
        return configPath;
    }

    public static String getTargetJdbcJar(String configDir, String jarRegex) {
        String[] configFiles;
        String targetJdbcJar = "";
        for (String path : configFiles = new File(configDir).list()) {
            if (!path.matches(jarRegex)) continue;
            targetJdbcJar = path;
            break;
        }
        return targetJdbcJar;
    }

    public static void delCompareTmpFile() {
        String logPath = CommonUtils.getLogPath();
        Path dir = Paths.get(logPath, new String[0]);
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            try {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                log.error("Error walking file tree: ", (Throwable)e);
            }
        } else {
            log.error("Directory {} does not exist or is not a directory.", (Object)logPath);
        }
    }

    public static boolean isStringType(int type) {
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntType(int type) {
        switch (type) {
            case -6: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBitType(int type) {
        switch (type) {
            case -7: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLongType(int type) {
        switch (type) {
            case -5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateType(int type) {
        switch (type) {
            case 91: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimestampType(int type, String typeName) {
        switch (type) {
            case 93: 
            case 2014: {
                return true;
            }
        }
        switch (typeName.toUpperCase()) {
            case "TIMESTAMP WITH LOCAL TIME ZONE": 
            case "TIMESTAMP WITH TIME ZONE": {
                return true;
            }
        }
        return false;
    }

    public static boolean isBytesType(int type) {
        switch (type) {
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBlobType(int type) {
        switch (type) {
            case 2004: {
                return true;
            }
            case -4: {
                return true;
            }
            case -3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNClobType(String typeName) {
        switch (typeName.toUpperCase()) {
            case "NCLOB": {
                return true;
            }
        }
        return false;
    }

    public static boolean isClobType(int type) {
        switch (type) {
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBooleanType(int type, String typeName) {
        switch (type) {
            case 16: {
                return true;
            }
        }
        switch (typeName.toUpperCase()) {
            case "BOOL": 
            case "BOOLEAN": {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimalType(int type) {
        switch (type) {
            case 3: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeType(int type) {
        switch (type) {
            case 92: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloatType(int type) {
        switch (type) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDoubleType(int type) {
        switch (type) {
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRowidType(int type) {
        switch (type) {
            case -8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntervalymType(String typeName) {
        switch (typeName.toUpperCase()) {
            case "INTERVALYM": {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntervaldsType(String typeName) {
        switch (typeName.toUpperCase()) {
            case "INTERVALDS": {
                return true;
            }
        }
        return false;
    }

    public static String constructKey(String driverClassName, String regex) {
        return driverClassName + regex;
    }

    public static synchronized Connection getConnectionByDbConfig(EtlConfig.DbConfig dbConfig, String driverClassName, String regex, Class clazz) throws Exception {
        Properties info = new Properties();
        String encryptKey = System.getProperty("EncryptKey");
        info.put("user", dbConfig.getUsername());
        boolean pwdEncrypted = MotionEtlGlobalCtx.getInstance().getGlobalConfig().isPwdEncrypted();
        String decPwd = dbConfig.getPassword();
        if (pwdEncrypted) {
            decPwd = AesDecryptUtils.decryptStringWithInputKey((String)dbConfig.getPassword(), (String)encryptKey);
        }
        info.put("password", decPwd);
        if ("com.oceanbase.jdbc.Driver".equals(driverClassName)) {
            return DriverManager.getConnection(dbConfig.getUrl(), info);
        }
        Connection newConnection = null;
        Path configPath = CommonUtils.getConfigPath();
        String configDir = configPath.toString();
        String targetJdbcJar = CommonUtils.getTargetJdbcJar((String)configDir, (String)regex);
        String targetJdbcJarPath = configPath.resolve(targetJdbcJar).toString();
        URL[] jarFileUrls = new URL[]{new URL("file:///" + targetJdbcJarPath)};
        CustomClassLoader customClassLoader = new CustomClassLoader(jarFileUrls, clazz.getClassLoader(), new String[]{"java.", "javax.", "jdk."});
        Driver driver = null;
        String driverKey = CommonUtils.constructKey((String)driverClassName, (String)regex);
        if (!DRIVER_CACHE.containsKey(driverKey)) {
            driver = (Driver)customClassLoader.loadClass(driverClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DRIVER_CACHE.putIfAbsent(driverKey, driver);
        } else {
            driver = (Driver)DRIVER_CACHE.get(driverKey);
        }
        newConnection = driver.connect(dbConfig.getUrl(), info);
        return newConnection;
    }

    public static boolean oracle2Dm() {
        return MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.DM.name()) && MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase().equalsIgnoreCase(DbType.ORACLE.name());
    }

    public static boolean oracle2OceanBaseOracle() {
        return MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.OCEAN_BASE_ORACLE.name()) && MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase().equalsIgnoreCase(DbType.ORACLE.name());
    }

    public static boolean oracle2GaussdbOracle505() {
        return MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase().equalsIgnoreCase(DbType.GAUSSDB_ORACLE.name()) && MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase().equalsIgnoreCase(DbType.ORACLE.name());
    }

    public static boolean isOracleLongType(String typeName) {
        String longName = "LONG";
        return MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase().equalsIgnoreCase(DbType.ORACLE.name()) && typeName.equalsIgnoreCase(longName);
    }

    public static String removeTrailingSemicolon(String sql) {
        if (sql == null || sql.isEmpty()) {
            return sql;
        }
        if ((sql = sql.trim()).endsWith(";")) {
            return sql.substring(0, sql.length() - 1);
        }
        return sql;
    }
}

