/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.utils;

import com.google.common.collect.Sets;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.source.SourceFetcher;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.TargetImporter;
import com.hundsun.lightdb.core.transformer.EtlTransformer;
import com.hundsun.lightdb.motion.entity.RemailIndexEntity;
import com.hundsun.lightdb.motion.entity.ResultInfoModel;
import com.hundsun.lightdb.motion.entity.TableResultEntity;
import com.hundsun.lightdb.motion.enums.CompareTypeEnum;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.CompareTypeUtil;
import com.hundsun.lightdb.utils.DiffCompareData;
import com.hundsun.lightdb.utils.JdbcUtils;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CompareTypeUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareTypeUtil.class);
    private static final String PRT_FILTER = "_1_prt_";
    private static final String SYS_IL_FILTER = "sys_il";
    private static final String PKEY_FILTER = "_pkey";
    private static final String PRO_INVALID_COUNT = "proceduresInvalidCount";
    public static final String COMMA = ",";
    private static List<String> notSortedType = new ArrayList();
    public static final String DATA_LOG = "dataLog";
    public static final String TABLE_COUNT = "tableCount";
    public static final HashMap<String, Html> COMPARE_RESULT_HTML = new HashMap(16);

    static void removeMap() {
        CommonType.sourceRemailIndexEntity = null;
        CommonType.targetRemailIndexEntity = null;
        CommonType.result = null;
        CommonType.successResult = null;
        CommonType.failedResult = null;
    }

    public static void compareTypeCount(Map<String, HashMap<String, String>> source, Map<String, HashMap<String, String>> target) {
        try {
            HashMap<String, String> proceduresInvalidCount = source.get("proceduresInvalidCount");
            String currentSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            String currentTargetSchema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
            TableResultEntity tableResultEntity = new TableResultEntity();
            tableResultEntity.setSourceTableCount(source.get(CompareTypeEnum.TABLE.getCompareType()).size());
            tableResultEntity.setTargetTableCount(target.get(CompareTypeEnum.TABLE.getCompareType()).size());
            CommonType.TableMap.put(currentSchema, tableResultEntity);
            HashMap currentHtml = CommonType.resultHtml.computeIfAbsent(currentSchema, k -> new HashMap(10));
            for (Map.Entry<String, HashMap<String, String>> entry : source.entrySet()) {
                String prt;
                String sourceValue;
                Object sourceKey;
                ResultInfoModel resultInfoModel = new ResultInfoModel();
                String typeName = entry.getKey();
                if ("proceduresInvalidCount".equals(typeName)) {
                    if (CollectionUtils.isEmpty((Map)entry.getValue())) continue;
                    if (log.isWarnEnabled()) {
                        log.warn("\t\u4ee5\u4e0b\u5b58\u50a8\u8fc7\u7a0b\u65e0\u6cd5\u8fc1\u79fb\uff0c\u56e0\u4e3a\u5b83\u4eec\u5728\u6e90\u5e93\u662f\u5931\u6548\u72b6\u6001\uff1a");
                    }
                    for (Map.Entry<String, String> en : proceduresInvalidCount.entrySet()) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn(MotionEtlGlobalCtx.getInstance().currentSchema() + "." + en.getKey() + "; \n");
                    }
                    continue;
                }
                Html html = currentHtml.computeIfAbsent(typeName, k -> new Html());
                HashMap<String, String> sourceInfo = entry.getValue();
                HashMap<String, String> targetInfo = target.get(typeName);
                if (targetInfo == null) {
                    log.warn("\u5ffd\u7565\u6307\u5b9a\u7c7b\u578b\u5bf9\u8c61\u7684\u6bd4\u8f83 {}", (Object)typeName);
                    continue;
                }
                if (CollectionUtils.isEmpty(sourceInfo) && CollectionUtils.isEmpty(targetInfo)) {
                    html.success.put(String.format("schema\uff1a%s", currentSchema), "\u65e0\u6570\u636e");
                    resultInfoModel.getSuccessInfo().add("\t " + currentSchema + "\u65e0\u6570\u636e,\u5bf9\u6bd4\u4e00\u81f4\n");
                    if (!CommonType.sourceTargetNoData.containsKey(typeName)) {
                        CommonType.sourceTargetNoData.put(typeName, true);
                    }
                } else {
                    CommonType.sourceTargetNoData.put(typeName, false);
                }
                if (typeName.equals(CompareTypeEnum.PACKAGE.getCompareType()) || typeName.equals(CompareTypeEnum.PACKAGE_BODY.getCompareType())) {
                    if (CollectionUtils.isEmpty(sourceInfo)) {
                        resultInfoModel.getSuccessInfo().add("\t " + currentSchema + "\u65e0\u6570\u636e,\u5bf9\u6bd4\u4e00\u81f4\n");
                        html.success.put(String.format("\u5305%s", currentSchema), "\u65e0\u6570\u636e");
                        if (!CommonType.sourceTargetNoData.containsKey(typeName)) {
                            CommonType.sourceTargetNoData.put(typeName, true);
                        }
                    } else if (CollectionUtils.isEmpty(targetInfo)) {
                        CommonType.sourceTargetNoData.put(typeName, false);
                        for (Map.Entry<String, String> entry2 : sourceInfo.entrySet()) {
                            sourceKey = entry2.getKey();
                            sourceValue = entry2.getValue().toLowerCase();
                            html.failed.put(String.format("%s.%s", currentSchema, sourceKey), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                            resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93\uff1a\u5b58\u5728%s,\u76ee\u6807\u5e93:\u4e0d\u5b58\u5728%s \n", currentSchema + "." + (String)sourceKey, currentSchema + "." + (String)sourceKey));
                        }
                    } else {
                        CommonType.sourceTargetNoData.put(typeName, false);
                        CompareTypeUtil.compareResult2(sourceInfo, targetInfo, (ResultInfoModel)resultInfoModel, (Html)html);
                    }
                } else if (CollectionUtils.isEmpty(sourceInfo)) {
                    for (Map.Entry<String, String> entry3 : targetInfo.entrySet()) {
                        String targetKey = entry3.getKey();
                        String targetValue = entry3.getValue().toLowerCase();
                        if (CompareTypeEnum.INDEX.getCompareType().equals(typeName)) {
                            if (targetValue.contains("_pkey") || targetValue.contains("_1_prt_")) continue;
                            resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93\u4e0d\u5b58\u5728\u7d22\u5f15%s,\u76ee\u6807\u5e93:\u5b58\u5728\u7d22\u5f15%s \n", targetValue, targetValue));
                            continue;
                        }
                        prt = targetKey.toLowerCase();
                        if (prt.contains("_1_prt_")) continue;
                        String functionTrigger = "$trigger";
                        if (CompareTypeEnum.FUNCTION.getCompareType().equals(typeName) && targetValue.equalsIgnoreCase(functionTrigger)) continue;
                        resultInfoModel.getFailedInfo().add(String.format("\t\u6e90\u5e93:\u4e0d\u5b58\u5728%s,\u76ee\u6807\u5e93\uff1a\u5b58\u5728%s\n", currentSchema + "." + targetKey, currentSchema + "." + targetKey));
                    }
                } else if (CollectionUtils.isEmpty(targetInfo)) {
                    for (Map.Entry<String, String> entry4 : sourceInfo.entrySet()) {
                        sourceKey = entry4.getKey();
                        sourceValue = entry4.getValue().toLowerCase();
                        if (CompareTypeEnum.INDEX.getCompareType().equals(typeName)) {
                            sourceKey = "(" + ((String)sourceKey).replaceAll("\\|", ",") + ")";
                            prt = sourceValue.toLowerCase();
                            if (prt.contains("sys_il")) continue;
                            for (String item : sourceValue.split(",")) {
                                html.failed.put(String.format("%s.%s.%s", currentSchema, sourceKey, item), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                            }
                            resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93\uff1a\u5b58\u5728\u7d22\u5f15%s,\u76ee\u6807\u5e93:\u4e0d\u5b58\u5728\u7d22\u5f15%s \n", currentSchema + "." + (String)sourceKey + "." + sourceValue, currentTargetSchema + "." + (String)sourceKey + "." + sourceValue));
                            continue;
                        }
                        html.failed.put(String.format("%s.%s", currentSchema, sourceKey), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                        resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93\uff1a\u5b58\u5728%s,\u76ee\u6807\u5e93:\u4e0d\u5b58\u5728%s \n", currentSchema + "." + (String)sourceKey, currentSchema + "." + (String)sourceKey));
                    }
                } else if (!CompareTypeEnum.INDEX.getCompareType().equals(typeName)) {
                    CompareTypeUtil.compareResult(sourceInfo, targetInfo, (ResultInfoModel)resultInfoModel, (Html)html, (String)typeName);
                } else {
                    CompareTypeUtil.compareIndexResult(sourceInfo, targetInfo, (ResultInfoModel)resultInfoModel, (Html)html);
                }
                CompareTypeUtil.remainIndexCompare((ResultInfoModel)resultInfoModel, (String)typeName, (Html)html);
                CompareTypeUtil.typeNameContainKey((ResultInfoModel)resultInfoModel, (String)typeName);
                CompareTypeUtil.printInfo((String)typeName, (ResultInfoModel)resultInfoModel);
            }
            if (MotionEtlGlobalCtx.getInstance().currentSchemaIndex() >= MotionEtlGlobalCtx.getInstance().getSchemas().size()) {
                StringBuffer resultAppend = new StringBuffer();
                resultAppend.append("\u6570\u91cf\u5bf9\u6bd4\u5f00\u59cb\n");
                for (Map.Entry entry : CommonType.result.entrySet()) {
                    if ("dataLog".equals(entry.getKey())) continue;
                    resultAppend.append("\n" + CompareTypeEnum.getCompareName((String)((String)entry.getKey())) + "\u5bf9\u6bd4\u5f00\u59cb\n");
                    resultAppend.append((StringBuffer)entry.getValue());
                    if (!((Boolean)CommonType.sourceTargetNoData.get(entry.getKey())).booleanValue()) {
                        resultAppend.append(String.format("%s\u5bf9\u6bd4\u6210\u529f\u6570\u636e %d \u6761,\u5bf9\u6bd4\u5931\u8d25\u6570\u636e %d \u6761\n", CompareTypeEnum.getCompareName((String)((String)entry.getKey())), CommonType.successResult.get(entry.getKey()), CommonType.failedResult.get(entry.getKey())));
                        continue;
                    }
                    resultAppend.append(String.format("%s\u5bf9\u6bd4\u6210\u529f: \u6e90\u5e93\u65e0\u6570\u636e,\u76ee\u6807\u5e93\u65e0\u6570\u636e\n", CompareTypeEnum.getCompareName((String)((String)entry.getKey()))));
                }
                CompareTypeUtil.producehtml2();
                StringBuffer stringBuffer = (StringBuffer)CommonType.result.get("dataLog");
                if (Objects.isNull(stringBuffer)) {
                    CompareTypeUtil.produceHtml((boolean)false, (String)"");
                } else {
                    CompareTypeUtil.produceHtml((boolean)true, (String)stringBuffer.toString());
                }
                if (log.isInfoEnabled()) {
                    log.info(resultAppend.toString());
                }
                CompareTypeUtil.removeMap();
            }
        }
        catch (Exception e) {
            log.error("\u6bd4\u5bf9\u7c7b\u578b\u6570\u91cf\u65f6\u62a5\u9519\uff1a", (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "WMI_WRONG_MAP_ITERATOR"})
    private static void producehtml2() {
        StringBuffer head = new StringBuffer();
        StringBuffer summaryAll = new StringBuffer();
        StringBuffer summaryFirst = new StringBuffer();
        StringBuffer summarySecond = new StringBuffer();
        StringBuffer directory = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer module = new StringBuffer();
        StringBuffer directorySummary = new StringBuffer();
        HashMap<String, TypeSummary> typeSummary = new HashMap<String, TypeSummary>(10);
        String bg = "bgcolor=\"#FF0000\"";
        head.append("<!DOCTYPE html>  \n<html>  \n<head>   \n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">  \n<title>lightdb\u4e0eoracle\u5bf9\u8c61\u5bf9\u6bd4\u62a5\u544a</title>  \n<style>  \n  .container {  \n    display: flex;  \n    height: 100vh; /* \u4f7f\u7528\u89c6\u53e3\u9ad8\u5ea6 */  \n  }  \n  \n    .sidebar ul {  \n    width: 200px;\n    list-style-type: none;  \n\tbackground-color: #f4f4f4;\n\tpadding: 20px;\n    \n    margin: 0;  \n    display: flex; /* \u9ed8\u8ba4\u4f7f\u7528flex\u5e03\u5c40\u6a2a\u5411\u663e\u793a */  \n    flex-direction: column; /* \u521d\u59cb\u4e3a\u5782\u76f4\uff0c\u901a\u8fc7\u5a92\u4f53\u67e5\u8be2\u6539\u4e3a\u6a2a\u5411 */  \n\toverflow-y: auto; /* \u5982\u679c\u9700\u8981\uff0c\u53ef\u4ee5\u7eb5\u5411\u6eda\u52a8 */\n  }  \n  \n  .sidebar li {  \n    margin: 5px 0; /* \u5782\u76f4\u95f4\u8ddd */  \n    /* \u6a2a\u5411\u95f4\u8ddd\u5c06\u5728\u5a92\u4f53\u67e5\u8be2\u4e2d\u901a\u8fc7margin-right\u6dfb\u52a0 */  \n  } \n  \n \n  \n  .main-content {  \n    flex-grow: 1;  \n    overflow-x: auto; /* \u5141\u8bb8\u6a2a\u5411\u6eda\u52a8 */  \n    padding: 20px;  \n  }  \n  \n  /* \u8868\u683c\u6837\u5f0f */  \n  .scrollable-table {  \n    width: 100%;  \n    min-width: 800px; /* \u8868\u683c\u7684\u6700\u5c0f\u5bbd\u5ea6\uff0c\u786e\u4fdd\u6709\u8db3\u591f\u7684\u5185\u5bb9\u89e6\u53d1\u6eda\u52a8\u6761 */  \n    overflow-x: auto; /* \u6dfb\u52a0\u6c34\u5e73\u6eda\u52a8\u6761\u4ee5\u5904\u7406\u8d85\u51fa\u5bbd\u5ea6\u7684\u8868\u683c */  \n  }  \n  \n   /* \u9690\u85cf\u951a\u70b9 */  \n        .anchor {  \n            display: block;  \n            position: relative;  \n            top: -50px; /* \u6839\u636e\u9700\u8981\u8c03\u6574\uff0c\u4ee5\u786e\u4fdd\u8df3\u8f6c\u5230\u884c\u7684\u53ef\u89c1\u90e8\u5206 */  \n            visibility: hidden;  \n        }    table {  \n    width: 100%;  \n    border-collapse: collapse;  \n    table-layout: fixed; /* \u786e\u4fdd\u5217\u5bbd\u6309\u6307\u5b9a\u5bbd\u5ea6\u5206\u914d */  \n  }  \n  \n  th, td {  \n    border: 1px solid black;  \n    padding: 8px;  \n    text-align: left;  \n    word-wrap: break-word; /* \u5141\u8bb8\u6587\u672c\u6362\u884c */  \n    white-space: normal;  \n    max-width: 200px; /* \u53ef\u9009\uff0c\u6839\u636e\u9700\u8981\u8bbe\u7f6e\u6700\u5927\u5bbd\u5ea6 */  \n  }  \n</style>  \n</head> \n");
        body.append("<body>\n<div class=\"container\"> ");
        directory.append("<div class=\"sidebar\">  \n    <h2>\u76ee\u5f55</h2>  \n    <ul>\n");
        directory.append(String.format("\t<li><a href=\"#summaryResult\">\u6240\u6709\u7ed3\u679c\u6c47\u603b</a></li>\n", new Object[0]));
        summaryAll.append(String.format("<div class=\"main-div\" id=\"summaryResult\">\n<h1>\u6c47\u603b\u7ed3\u679c</h1>\n", new Object[0]));
        for (Map.Entry entry : CommonType.resultHtml.entrySet()) {
            String schema = (String)entry.getKey();
            directorySummary.append(String.format("\t<li><a href=\"#%s\">%s \u8be6\u7ec6\u5bf9\u6bd4\u7ed3\u679c</a></li>\n", schema, schema));
            directory.append(String.format("\t<li><a href=\"#%s\">%s \u5bf9\u6bd4\u6c47\u603b\u7ed3\u679c</a></li>\n", schema + "summary", schema));
            module.append(String.format("<div class=\"main-div\" id=\"%s\">\n<h1>%s\u8be6\u7ec6\u5bf9\u6bd4\u7ed3\u679c</h1>\n", schema, schema, schema));
            summarySecond.append(String.format("\t<div class=\"scrollable-table\" id=\"%s\"> ", schema + "summary"));
            summarySecond.append(String.format("<h2>%s\u5bf9\u6bd4\u7ed3\u679c\u6c47\u603b</h2>\n", schema));
            summarySecond.append("<table><thead><tr><th>\u5bf9\u8c61\u540d</th><th>\u5bf9\u6bd4\u7ed3\u679c</th></tr></thead><tbody>\n");
            for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                StringBuffer subModule = new StringBuffer();
                String typeName = CompareTypeEnum.getCompareName((String)((String)entry2.getKey()));
                TypeSummary ts = typeSummary.computeIfAbsent((String)entry2.getKey(), k -> new TypeSummary());
                boolean firstTypenameError = true;
                ts.success += ((Html)entry2.getValue()).success.size();
                ts.failed += ((Html)entry2.getValue()).failed.size();
                if (((Html)entry2.getValue()).failed.size() > 0) {
                    summarySecond.append(String.format("<tr><td %s><a href=\"#%s\">%s</a></td><td>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</td></tr>\n", bg, schema + "_" + (String)entry2.getKey(), typeName, ((Html)entry2.getValue()).success.size(), ((Html)entry2.getValue()).failed.size()));
                } else {
                    summarySecond.append(String.format("<tr><td>%s</td><td>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</td></tr>\n", typeName, ((Html)entry2.getValue()).success.size(), ((Html)entry2.getValue()).failed.size()));
                }
                subModule.append("\t<div class=\"scrollable-table\">  \n");
                subModule.append(String.format("\t<h2>%s\u5bf9\u6bd4\u7ed3\u679c</h2>\n", typeName));
                subModule.append(String.format("<p>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</p>\n", ((Html)entry2.getValue()).success.size(), ((Html)entry2.getValue()).failed.size()));
                subModule.append(String.format("<table><thead><tr><th>\u5bf9\u8c61\u540d</th><th>\u662f\u5426\u4e00\u81f4</th><th>\u539f\u56e0</th></tr></thead><tbody>\n", new Object[0]));
                for (Map.Entry entry3 : ((Html)entry2.getValue()).failed.entrySet()) {
                    Object objectName = (String)entry3.getKey();
                    if (CompareTypeEnum.PACKAGE_BODY.getCompareType().equals(entry2.getKey())) {
                        objectName = (String)entry3.getKey() + "_body";
                    }
                    String message = MotionEtlGlobalCtx.getInstance().getEtlMessageValue((String)objectName);
                    if (firstTypenameError) {
                        subModule.append(String.format("<tr id=\"%s\" ><td %s>%s</td><td>\u4e0d\u4e00\u81f4</td><td>%s</td></tr>\n", schema + "_" + (String)entry2.getKey(), bg, entry3.getKey(), StringUtils.isNotBlank((CharSequence)message) ? message : entry3.getValue()));
                        firstTypenameError = false;
                        continue;
                    }
                    subModule.append(String.format("<tr><td %s>%s</td><td>\u4e0d\u4e00\u81f4</td><td>%s</td></tr>\n", bg, entry3.getKey(), StringUtils.isNotBlank((CharSequence)message) ? message : entry3.getValue()));
                }
                for (Map.Entry entry3 : ((Html)entry2.getValue()).success.entrySet()) {
                    subModule.append(String.format("<tr><td>%s</td><td>\u4e00\u81f4</td><td>%s</td></tr>\n", entry3.getKey(), entry3.getValue()));
                }
                subModule.append("\n</tbody></table></div>\n");
                module.append(subModule);
            }
            summarySecond.append("</tbody></table></div>\n");
            module.append("</div>\n");
        }
        directory.append(directorySummary);
        directory.append("</ul>  \n</div>\n");
        summaryFirst.append(String.format("<h2>\u6574\u4f53\u6c47\u603b\u7ed3\u679c</h2>\n", new Object[0]));
        summaryFirst.append(String.format("\t<div class=\"scrollable-table\"> \n<table><thead><tr><th>\u5bf9\u8c61\u540d</th><th>\u5bf9\u6bd4\u7ed3\u679c</th></tr></thead><tbody>\n", new Object[0]));
        for (Map.Entry entry : typeSummary.entrySet()) {
            summaryFirst.append(String.format("<tr><td>%s</td><td>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</td></tr>\n", CompareTypeEnum.getCompareName((String)((String)entry.getKey())), ((TypeSummary)entry.getValue()).success, ((TypeSummary)entry.getValue()).failed));
        }
        summaryFirst.append("</tbody></table></div>\n");
        summaryAll.append(summaryFirst);
        summaryAll.append(summarySecond);
        summaryAll.append("</div>\n");
        body.append(directory);
        body.append("\n<div class=\"main-content\">\n");
        body.append(summaryAll);
        body.append(module);
        body.append("</div> \n</div> \n");
        String foot = "\n</body>\n\n</html>\n";
        Date currentTime = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String fileName = dateFormat.format(currentTime);
        String htmlName = "typeCompare_" + fileName + ".html";
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlName), "GBK");){
            writer.write(head.toString());
            writer.write(body.toString());
            writer.write(foot);
            writer.close();
        }
        catch (IOException e) {
            log.error("\u6253\u5f00\u6587\u4ef6\u6d41\u62a5\u9519: ", (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "WMI_WRONG_MAP_ITERATOR"})
    private static void produceHtml(boolean hasData, String stringHtml) {
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<html><head><title>\u8868\u6570\u636e\u5bf9\u6bd4</title><meta charset=\"GBK\"></head><body>");
        htmlBuilder.append("<style>  html, body {\n      height: 100%;\n      margin: 0;\n      display: flex;\n      justify-content: center;\n    }\n\n    table {\n      border-collapse: collapse;\n      height: 80vh; /* Adjust the height as needed */\n      overflow: auto;\n    }\n\n    tr {\n      height: 42px;\n    }\n\n    td, th {\n      border: 1px solid black;\n      padding: 8px;\n    }</style>");
        htmlBuilder.append("<table>");
        if (hasData) {
            String[] htmlStr = stringHtml.split("\\n");
            ArrayList<String> successStr = new ArrayList<String>();
            ArrayList<String> failStr = new ArrayList<String>();
            Set set = CommonType.TableMap.keySet();
            for (String str : htmlStr) {
                String result;
                String stringbody;
                if (str.contains("\u5bf9\u6bd4\u4e00\u81f4")) {
                    for (String str1 : set) {
                        stringbody = "%s.";
                        result = String.format(stringbody, str1);
                        if (!str.contains(result)) continue;
                        int success = ((TableResultEntity)CommonType.TableMap.get(str1)).getSuccess();
                        ((TableResultEntity)CommonType.TableMap.get(str1)).setSuccess(++success);
                    }
                    successStr.add(str);
                    continue;
                }
                for (String str1 : set) {
                    stringbody = "%s.";
                    result = String.format(stringbody, str1);
                    if (!str.contains(result)) continue;
                    int fail = ((TableResultEntity)CommonType.TableMap.get(str1)).getFail();
                    ((TableResultEntity)CommonType.TableMap.get(str1)).setFail(++fail);
                }
                failStr.add(str);
            }
            String rowTemplate = "<tr><td>%s</td></tr>";
            htmlBuilder.append("<tr><th colspan=\"2\"><h1>\u6570\u636e\u5bf9\u6bd4\u6c47\u603b\uff1a</h1></th></tr>");
            for (Map.Entry entry : CommonType.TableMap.entrySet()) {
                String result = "\u6e90\u5e93schema:%s,\u603b\u8868\u6570\u91cf:%s,\u76ee\u6807\u5e93schema:%s,\u603b\u8868\u6570\u91cf:%s,\u5bf9\u6bd4\u4e00\u81f4\u8868\u6570\u91cf:%s,\u5bf9\u6bd4\u4e0d\u4e00\u81f4\u8868\u6570\u91cf:%s";
                String key = (String)entry.getKey();
                TableResultEntity value = (TableResultEntity)entry.getValue();
                result = String.format(result, key, value.getSourceTableCount(), key, value.getTargetTableCount(), value.getSuccess(), value.getFail());
                htmlBuilder.append(String.format(rowTemplate, result));
            }
            htmlBuilder.append("<tr><th colspan=\"2\"><h1>\u6570\u636e\u5bf9\u6bd4\u4e0d\u4e00\u81f4\uff1a</h1></th></tr>");
            for (String str : failStr) {
                htmlBuilder.append(String.format(rowTemplate, str));
            }
            htmlBuilder.append("<tr><th colspan=\"2\"><h1>\u6570\u636e\u5bf9\u6bd4\u4e00\u81f4\uff1a</h1></th></tr>");
            for (String str : successStr) {
                htmlBuilder.append(String.format(rowTemplate, str));
            }
        } else {
            htmlBuilder.append("\u6e90\u5e93\u76ee\u6807\u5e93schema\u65e0\u8868\u6570\u636e");
        }
        htmlBuilder.append("</table>");
        htmlBuilder.append("</body></html>");
        String html = htmlBuilder.toString();
        Date currentTime = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String fileName = dateFormat.format(currentTime);
        String htmlName = "dataCompare_" + fileName + ".html";
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlName), "GBK");){
            writer.write(html);
        }
        catch (IOException e) {
            log.error("\u6253\u5f00\u6587\u4ef6\u6d41\u62a5\u9519: ", (Throwable)e);
        }
    }

    public static void writeHtml(String content, String fileNamePrefix) {
        block12: {
            if (content == null || content.trim().isEmpty()) {
                throw new IllegalArgumentException("HTML\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
            String timestamp = now.format(formatter);
            String fileName = String.format("%s_%s.html", fileNamePrefix, timestamp);
            String userDir = System.getProperty("user.dir");
            Path baseDir = Paths.get(userDir, new String[0]).toAbsolutePath().normalize();
            Path targetFile = baseDir.resolve(fileName).normalize();
            if (!targetFile.startsWith(baseDir)) {
                throw new SecurityException("\u975e\u6cd5\u6587\u4ef6\u8def\u5f84: " + targetFile);
            }
            try {
                Files.createDirectories(baseDir, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(targetFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                    writer.write(content);
                }
                if (log.isInfoEnabled()) {
                    log.info("HTML\u6587\u4ef6\u5df2\u751f\u6210: {}", (Object)fileName);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block12;
                log.error("\u5199\u5165HTML\u6587\u4ef6\u5931\u8d25: {}", (Object)fileName, (Object)e);
            }
        }
    }

    private static void typeNameContainKey(ResultInfoModel resultInfoModel, String typeName) {
        if (CommonType.result.containsKey(typeName)) {
            StringBuffer temp = (StringBuffer)CommonType.result.get(typeName);
            StringBuilder successInfoStr = new StringBuilder();
            resultInfoModel.getSuccessInfo().forEach(s -> {
                if (!Objects.isNull(s)) {
                    successInfoStr.append((String)s);
                }
            });
            temp.append((CharSequence)successInfoStr);
            StringBuilder failedInfoStr = new StringBuilder();
            resultInfoModel.getFailedInfo().forEach(s -> {
                if (!Objects.isNull(s)) {
                    failedInfoStr.append((String)s);
                }
            });
            temp.append((CharSequence)failedInfoStr);
            CommonType.result.put(typeName, temp);
            if ("tableCount".equals(typeName)) {
                StringBuffer temp2 = (StringBuffer)CommonType.result.get("dataLog");
                StringBuilder successInfoStr2 = new StringBuilder();
                StringBuilder failedInfoStr2 = new StringBuilder();
                resultInfoModel.getFailedInfo().forEach(s -> {
                    if (!Objects.isNull(s)) {
                        failedInfoStr2.append((String)s);
                    }
                });
                temp2.append((CharSequence)failedInfoStr2);
                resultInfoModel.getSuccessInfo().forEach(s -> {
                    if (!Objects.isNull(s)) {
                        successInfoStr2.append((String)s);
                    }
                });
                temp2.append((CharSequence)successInfoStr2);
                CommonType.result.put("dataLog", temp2);
            }
        } else {
            StringBuffer temp = new StringBuffer();
            StringBuilder successInfoStr = new StringBuilder();
            resultInfoModel.getSuccessInfo().forEach(s -> {
                if (!Objects.isNull(s)) {
                    successInfoStr.append((String)s);
                }
            });
            temp.append((CharSequence)successInfoStr);
            StringBuilder failedInfoStr = new StringBuilder();
            resultInfoModel.getFailedInfo().forEach(s -> {
                if (!Objects.isNull(s)) {
                    failedInfoStr.append((String)s);
                }
            });
            temp.append((CharSequence)failedInfoStr);
            CommonType.result.put(typeName, temp);
            if ("tableCount".equals(typeName)) {
                StringBuffer temp2 = new StringBuffer();
                StringBuilder successInfoStr2 = new StringBuilder();
                StringBuilder failedInfoStr2 = new StringBuilder();
                resultInfoModel.getFailedInfo().forEach(s -> {
                    if (!Objects.isNull(s)) {
                        failedInfoStr2.append((String)s);
                    }
                });
                temp2.append((CharSequence)failedInfoStr2);
                resultInfoModel.getSuccessInfo().forEach(s -> {
                    if (!Objects.isNull(s)) {
                        successInfoStr2.append((String)s);
                    }
                });
                temp2.append((CharSequence)successInfoStr2);
                CommonType.result.put("dataLog", temp2);
            }
        }
    }

    private static void printInfo(String typeName, ResultInfoModel resultInfoModel) {
        int length;
        String msg = "\u65e0\u6570\u636e";
        if (resultInfoModel.getSuccessInfo().size() == 1 && ((String)resultInfoModel.getSuccessInfo().get(0)).contains(msg)) {
            return;
        }
        if (CommonType.successResult.containsKey(typeName)) {
            length = resultInfoModel.getSuccessInfo().size();
            int successLength = (Integer)CommonType.successResult.get(typeName) + length;
            CommonType.successResult.put(typeName, successLength);
        } else {
            length = resultInfoModel.getSuccessInfo().size();
            CommonType.successResult.put(typeName, length);
        }
        if (CommonType.failedResult.containsKey(typeName)) {
            length = resultInfoModel.getFailedInfo().size();
            int failedLength = (Integer)CommonType.failedResult.get(typeName) + length;
            CommonType.failedResult.put(typeName, failedLength);
        } else {
            length = resultInfoModel.getFailedInfo().size();
            CommonType.failedResult.put(typeName, length);
        }
    }

    private static void compareResult(Map<String, String> sourceInfo, Map<String, String> targetInfo, ResultInfoModel resultInfoModel, Html html, String typeName) {
        String key;
        Iterator<Map.Entry<String, String>> sourceIterator = sourceInfo.entrySet().iterator();
        while (sourceIterator.hasNext()) {
            String targetValue;
            Map.Entry<String, String> sourceIndexMap = sourceIterator.next();
            if (!targetInfo.containsKey(sourceIndexMap.getKey())) {
                html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey()), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                resultInfoModel.getFailedInfo().add(String.format("\t\t \u6e90\u5e93:\u5b58\u5728%s,\u76ee\u6807\u5e93\uff1a\u4e0d\u5b58\u5728%s\n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceIndexMap.getKey(), MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceIndexMap.getKey()));
                sourceIterator.remove();
                continue;
            }
            String sourceValue = sourceIndexMap.getValue();
            if (!sourceValue.equals(targetValue = targetInfo.get(sourceIndexMap.getKey()))) {
                resultInfoModel.getFailedInfo().add(String.format("\t\t \u6570\u91cf\u4e0d\u540c\uff0c\u6e90\u5e93: %s.%s \u8868\u6709 %s \u6761\u6570\u636e,\u76ee\u6807\u5e93: %s.%s \u8868\u6709 %s \u6761\u6570\u636e\n", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey(), sourceIndexMap.getValue(), MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey(), targetInfo.get(sourceIndexMap.getKey())));
                html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey()), String.format("\u6e90\u5e93\u6709%s\u6761\u6570\u636e,\u76ee\u6807\u5e93\u6709%s\u6761\u6570\u636e", sourceIndexMap.getValue(), targetInfo.get(sourceIndexMap.getKey())));
            } else {
                html.success.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey()), "");
                resultInfoModel.getSuccessInfo().add("\t" + MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceIndexMap.getKey() + "\u5bf9\u6bd4\u4e00\u81f4\n");
            }
            sourceIterator.remove();
            targetInfo.remove(sourceIndexMap.getKey());
        }
        if (!CollectionUtils.isEmpty(sourceInfo)) {
            for (Map.Entry<String, String> entry : sourceInfo.entrySet()) {
                key = entry.getKey();
                html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), key), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                resultInfoModel.getFailedInfo().add(String.format("\t\t \u6e90\u5e93:\u5b58\u5728%s,\u76ee\u6807\u5e93\uff1a\u4e0d\u5b58\u5728%s\n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key, MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key));
            }
        }
        if (!CollectionUtils.isEmpty(targetInfo)) {
            for (Map.Entry<String, String> entry : targetInfo.entrySet()) {
                key = entry.getKey();
                String functionTrigger = "$trigger";
                try {
                    if (CompareTypeEnum.FUNCTION.getCompareType().equals(typeName) && functionTrigger.equalsIgnoreCase(key.substring(key.length() - 8, key.length()))) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn(String.format("\t\t\u51fd\u6570:%s\u662f\u89e6\u53d1\u5668%s\u7684\u6267\u884c\u51fd\u6570 \n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key, key.substring(key.length() - 8, key.length())));
                        continue;
                    }
                    if (key.contains("_1_prt_")) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn(String.format("\t\t pg\u589e\u52a0\u7684\u5206\u533a\u8868:%s \n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key));
                        continue;
                    }
                    resultInfoModel.getFailedInfo().add(String.format("\t\t \u6e90\u5e93:\u4e0d\u5b58\u5728%s,\u76ee\u6807\u5e93\uff1a\u5b58\u5728%s\n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key, MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key));
                }
                catch (Exception e) {
                    log.error(entry.getKey() + "," + entry.getValue(), (Throwable)e);
                }
            }
        }
    }

    private static void compareResult2(Map<String, String> sourceInfo, Map<String, String> targetInfo, ResultInfoModel resultInfoModel, Html html) {
        Iterator<Map.Entry<String, String>> sourceIterator = sourceInfo.entrySet().iterator();
        while (sourceIterator.hasNext()) {
            Map.Entry<String, String> sourceIndexMap = sourceIterator.next();
            if (!targetInfo.containsKey(sourceIndexMap.getKey())) {
                html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey()), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                resultInfoModel.getFailedInfo().add(String.format("\t\t \u6e90\u5e93:\u5b58\u5728%s,\u76ee\u6807\u5e93\uff1a\u4e0d\u5b58\u5728%s\n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceIndexMap.getKey(), MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceIndexMap.getKey()));
                sourceIterator.remove();
                continue;
            }
            String sourceValue = sourceIndexMap.getValue();
            String targetValue = targetInfo.get(sourceIndexMap.getKey());
            html.success.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceIndexMap.getKey()), "");
            resultInfoModel.getSuccessInfo().add("\t" + MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceIndexMap.getKey() + "\u5bf9\u6bd4\u4e00\u81f4\n");
            sourceIterator.remove();
            targetInfo.remove(sourceIndexMap.getKey());
        }
        if (!CollectionUtils.isEmpty(sourceInfo)) {
            for (Map.Entry<String, String> entry : sourceInfo.entrySet()) {
                String key = entry.getKey();
                html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), key), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                resultInfoModel.getFailedInfo().add(String.format("\t\t \u6e90\u5e93:\u5b58\u5728%s,\u76ee\u6807\u5e93\uff1a\u4e0d\u5b58\u5728%s\n", MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key, MotionEtlGlobalCtx.getInstance().currentSchema() + "." + key));
            }
        }
    }

    public static ResultInfoModel compareIndexResult(Map<String, String> sourceInfo, Map<String, String> targetInfo, ResultInfoModel resultInfoModel, Html html) {
        RemailIndexEntity remailIndexEntity;
        for (Map.Entry<String, String> sourceNameInfo : sourceInfo.entrySet()) {
            if (!targetInfo.containsKey(sourceNameInfo.getKey())) {
                HashSet<String> sou = new HashSet<String>(Arrays.asList(sourceNameInfo.getValue().split(",")));
                remailIndexEntity = new RemailIndexEntity();
                remailIndexEntity.setSchema(MotionEtlGlobalCtx.getInstance().currentSchema());
                remailIndexEntity.setIndexName(sou);
                for (String item : sou) {
                    if (item.contains("sys_il")) continue;
                    html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), item), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                }
                CommonType.sourceRemailIndexEntity.put(sourceNameInfo.getKey(), remailIndexEntity);
                continue;
            }
            String sourceValue = sourceNameInfo.getValue();
            String targetValue = targetInfo.get(sourceNameInfo.getKey());
            HashSet<String> sou = new HashSet<String>(Arrays.asList(sourceValue.split(",")));
            HashSet<String> tar = new HashSet<String>(Arrays.asList(targetValue.split(",")));
            Set equalsEle = sou.stream().filter(tar::contains).collect(Collectors.toSet());
            sou.removeAll(equalsEle);
            tar.removeAll(equalsEle);
            Iterator<String> souIt = sou.iterator();
            while (souIt.hasNext()) {
                Set<String> stringSet;
                RemailIndexEntity remailIndexEntity2;
                String souName = souIt.next();
                String sys = souName.toLowerCase();
                if (sys.contains("sys_il")) {
                    souIt.remove();
                    continue;
                }
                html.failed.put(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema(), sys), "\u76ee\u6807\u5e93\u4e0d\u5b58\u5728");
                if (CommonType.sourceRemailIndexEntity.containsKey(sourceNameInfo.getKey())) {
                    remailIndexEntity2 = (RemailIndexEntity)CommonType.sourceRemailIndexEntity.get(sourceNameInfo.getKey());
                    stringSet = remailIndexEntity2.getIndexName();
                    stringSet.add(souName);
                    continue;
                }
                remailIndexEntity2 = new RemailIndexEntity();
                stringSet = new HashSet();
                stringSet.add(souName);
                remailIndexEntity2.setSchema(MotionEtlGlobalCtx.getInstance().currentSchema());
                remailIndexEntity2.setIndexName(stringSet);
                CommonType.sourceRemailIndexEntity.put(sourceNameInfo.getKey(), remailIndexEntity2);
            }
            Iterator<String> tarIt = tar.iterator();
            while (tarIt.hasNext()) {
                Set<String> stringSet;
                RemailIndexEntity remailIndexEntity3;
                String tarName = tarIt.next();
                String pkey = tarName.toLowerCase();
                if (pkey.contains("_pkey")) {
                    tarIt.remove();
                    continue;
                }
                if (CommonType.targetRemailIndexEntity.containsKey(sourceNameInfo.getKey())) {
                    remailIndexEntity3 = (RemailIndexEntity)CommonType.targetRemailIndexEntity.get(sourceNameInfo.getKey());
                    stringSet = remailIndexEntity3.getIndexName();
                    stringSet.add(tarName);
                    continue;
                }
                remailIndexEntity3 = new RemailIndexEntity();
                stringSet = new HashSet();
                stringSet.add(tarName);
                remailIndexEntity3.setSchema(MotionEtlGlobalCtx.getInstance().currentSchema());
                remailIndexEntity3.setIndexName(stringSet);
                CommonType.targetRemailIndexEntity.put(sourceNameInfo.getKey(), remailIndexEntity3);
            }
            if (CollectionUtils.isEmpty(sou) && CollectionUtils.isEmpty(tar)) {
                html.success.put(String.format("\u8868%s.%s\u7684\u6240\u6709\u7d22\u5f15", MotionEtlGlobalCtx.getInstance().currentSchema(), sourceNameInfo.getKey()), "");
                resultInfoModel.getSuccessInfo().add("\t" + MotionEtlGlobalCtx.getInstance().currentSchema() + "." + sourceNameInfo.getKey() + "\u8868,\u7d22\u5f15\u5bf9\u6bd4\u4e00\u81f4\n");
            }
            targetInfo.remove(sourceNameInfo.getKey());
        }
        for (Map.Entry<String, String> targetEntry : targetInfo.entrySet()) {
            remailIndexEntity = new RemailIndexEntity();
            HashSet<String> tarSet = new HashSet<String>(Arrays.asList(targetEntry.getValue().split(",")));
            remailIndexEntity.setSchema(MotionEtlGlobalCtx.getInstance().currentSchema());
            remailIndexEntity.setIndexName(tarSet);
            for (String item : tarSet) {
                if (!item.contains("_pkey") && !item.contains("_1_prt_")) continue;
            }
            CommonType.targetRemailIndexEntity.put(targetEntry.getKey(), remailIndexEntity);
        }
        return resultInfoModel;
    }

    private static void remainIndexCompare(ResultInfoModel resultInfoModel, String typeName, Html html) {
        if (MotionEtlGlobalCtx.getInstance().currentSchemaIndex() >= MotionEtlGlobalCtx.getInstance().getSchemas().size() && CompareTypeEnum.INDEX.getCompareType().equals(typeName)) {
            Iterator sourceIteratorTmp = CommonType.sourceRemailIndexEntity.entrySet().iterator();
            while (sourceIteratorTmp.hasNext()) {
                Map.Entry sourceIndexMap = sourceIteratorTmp.next();
                if (!CommonType.targetRemailIndexEntity.containsKey(sourceIndexMap.getKey())) continue;
                RemailIndexEntity sourceEntity = (RemailIndexEntity)sourceIndexMap.getValue();
                RemailIndexEntity targetEntity = (RemailIndexEntity)CommonType.targetRemailIndexEntity.get(sourceIndexMap.getKey());
                Set equalsEle = Sets.intersection((Set)sourceEntity.getIndexName(), (Set)targetEntity.getIndexName()).stream().collect(Collectors.toSet());
                sourceEntity.getIndexName().removeAll(equalsEle);
                targetEntity.getIndexName().removeAll(equalsEle);
                for (String souName : sourceEntity.getIndexName()) {
                    String sys = souName.toLowerCase();
                    if (sys.contains("sys_il")) continue;
                    resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93:\u5b58\u5728:%s.%s.%s\u7d22\u5f15, \u76ee\u6807\u5e93\uff1a\u4e0d\u5b58\u5728%s.%s.%s\u7d22\u5f15\n", sourceEntity.getSchema(), sourceIndexMap.getKey(), souName, sourceEntity.getSchema(), sourceIndexMap.getKey(), souName));
                }
                for (Object tarName : targetEntity.getIndexName()) {
                    String pkey = ((String)tarName).toLowerCase();
                    if (pkey.contains("_pkey") || pkey.contains("_1_prt_")) continue;
                    resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93:\u4e0d\u5b58\u5728:%s.%s.%s\u7d22\u5f15, \u76ee\u6807\u5e93\uff1a\u5b58\u5728%s.%s.%s\u7d22\u5f15\n", targetEntity.getSchema(), sourceIndexMap.getKey(), tarName, targetEntity.getSchema(), sourceIndexMap.getKey(), tarName));
                }
                if (CollectionUtils.isEmpty((Collection)sourceEntity.getIndexName()) && CollectionUtils.isEmpty((Collection)targetEntity.getIndexName())) {
                    resultInfoModel.getSuccessInfo().add("\t" + MotionEtlGlobalCtx.getInstance().currentSchema() + "." + (String)sourceIndexMap.getKey() + "\u8868,\u7d22\u5f15\u5bf9\u6bd4\u4e00\u81f4\n");
                }
                sourceIteratorTmp.remove();
                CommonType.targetRemailIndexEntity.remove(sourceIndexMap.getKey());
            }
            for (Map.Entry stringEntry : CommonType.sourceRemailIndexEntity.entrySet()) {
                String tableName = (String)stringEntry.getKey();
                RemailIndexEntity remailIndexEntity = (RemailIndexEntity)stringEntry.getValue();
                Set indexSets = ((RemailIndexEntity)stringEntry.getValue()).getIndexName();
                for (String indexSet : indexSets) {
                    String prt = indexSet.toLowerCase();
                    if (prt.contains("sys_il")) continue;
                    resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93:\u5b58\u5728:%s.%s.%s\u7d22\u5f15, \u76ee\u6807\u5e93\uff1a\u4e0d\u5b58\u5728%s.%s.%s\u7d22\u5f15\n", remailIndexEntity.getSchema(), tableName, indexSet, remailIndexEntity.getSchema(), tableName, indexSet));
                }
            }
            for (Map.Entry stringEntry : CommonType.targetRemailIndexEntity.entrySet()) {
                String tableName = (String)stringEntry.getKey();
                if (tableName.contains("_1_prt_")) continue;
                RemailIndexEntity remailIndexEntity = (RemailIndexEntity)stringEntry.getValue();
                Set indexSets = ((RemailIndexEntity)stringEntry.getValue()).getIndexName();
                for (String indexSet : indexSets) {
                    if (indexSet.contains("_pkey")) continue;
                    resultInfoModel.getFailedInfo().add(String.format("\t\t\u6e90\u5e93:\u4e0d\u5b58\u5728:%s.%s.%s\u7d22\u5f15, \u76ee\u6807\u5e93\uff1a\u5b58\u5728%s.%s.%s\u7d22\u5f15\n", remailIndexEntity.getSchema(), tableName, indexSet, remailIndexEntity.getSchema(), tableName, indexSet));
                }
            }
        }
    }

    public static void compareColumnInfo(HashMap<String, HashMap<String, String>> source, HashMap<String, HashMap<String, String>> target, EtlTransformer transformer) {
        try {
            if (log.isInfoEnabled()) {
                log.info("\u8868\u7ed3\u6784\u5bf9\u6bd4\u5f00\u59cb");
            }
            StringBuffer strTrue = new StringBuffer();
            StringBuffer strFalse = new StringBuffer();
            Set commonKey = source.keySet().stream().filter(target.keySet()::contains).collect(Collectors.toSet());
            HashSet<String> diffrentKey = new HashSet<String>(source.keySet());
            diffrentKey.addAll(target.keySet());
            diffrentKey.removeAll(commonKey);
            String sourceDatabase = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase();
            String targetDatabase = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase();
            String sourceSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            String targetSchema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
            for (String tableName : diffrentKey) {
                if (!source.containsKey(tableName)) {
                    strFalse.append(sourceSchema + "." + tableName + "\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t [%s]\uff1a[%s.%s] \u4e0d\u5b58\u5728\n", sourceDatabase, sourceSchema, tableName));
                    strFalse.append("\n");
                    continue;
                }
                if (target.containsKey(tableName)) continue;
                strFalse.append(sourceSchema + "." + tableName + "\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                strFalse.append(String.format("\t [%s]\uff1a[%s.%s] \u4e0d\u5b58\u5728\n", targetDatabase, targetSchema, tableName));
                strFalse.append("\n");
            }
            for (String tableName : commonKey) {
                HashMap<String, String> sourceColumn = source.get(tableName);
                HashMap<String, String> targetColumn = target.get(tableName);
                HashSet<String> allColumn = new HashSet<String>(sourceColumn.keySet());
                allColumn.addAll(targetColumn.keySet());
                StringBuffer tmpStr = new StringBuffer();
                for (String columnName : allColumn) {
                    if (!sourceColumn.containsKey(columnName)) {
                        tmpStr.append(String.format("\t [%s]\uff1a[%s]\u5217\u4e0d\u5b58\u5728\n", sourceDatabase, columnName));
                        continue;
                    }
                    if (!targetColumn.containsKey(columnName)) {
                        tmpStr.append(String.format("\t [%s]\uff1a[%s]\u5217\u4e0d\u5b58\u5728\n", targetDatabase, columnName));
                        continue;
                    }
                    String[] sourceInfo = sourceColumn.get(columnName).split(",");
                    String[] targetInfo = targetColumn.get(columnName).split(",");
                    targetInfo[0] = targetInfo[0].toLowerCase();
                    String result = transformer.compareColumn(columnName, sourceInfo, targetInfo);
                    if ("SUCCESS".equals(result)) continue;
                    tmpStr.append(result);
                }
                if (StringUtils.isBlank((CharSequence)tmpStr.toString())) {
                    strTrue.append(sourceSchema + "." + tableName + "\u5bf9\u6bd4\u4e00\u81f4\u3002");
                    continue;
                }
                strFalse.append(sourceSchema + "." + tableName + "\u5bf9\u6bd4\u4e0d\u4e00\u81f4\n");
                strFalse.append(tmpStr);
                strFalse.append("\n");
            }
            if (StringUtils.isBlank((CharSequence)strTrue) && StringUtils.isBlank((CharSequence)strFalse)) {
                log.info("\u662f\u7a7a\u8868\u5bf9\u6bd4\u4e00\u81f4");
            } else {
                log.info(strTrue.toString());
                log.info(strFalse.toString());
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static void compareTableData(HashMap<String, TableInfo> source, HashMap<String, TableInfo> target, SourceFetcher sourceFetcher, TargetImporter targetImporter, EtlTransformer transformer) {
        try {
            String failMessage;
            if (log.isInfoEnabled()) {
                log.info("\u8868\u6570\u636e\u503c\u5bf9\u6bd4\u5f00\u59cb");
            }
            Set commonKey = source.keySet().stream().filter(target.keySet()::contains).collect(Collectors.toSet());
            HashSet<String> diffrentKey = new HashSet<String>(source.keySet());
            diffrentKey.addAll(target.keySet());
            diffrentKey.removeAll(commonKey);
            StringBuffer strTrue = new StringBuffer();
            StringBuffer strFalse = new StringBuffer();
            String sourceDatabase = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase();
            String targetDatabase = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase();
            String sourceSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            String targetSchema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
            Html currentHtml = COMPARE_RESULT_HTML.computeIfAbsent(sourceSchema, k -> new Html());
            ConcurrentHashMap compareResultList = new ConcurrentHashMap();
            WorkerGroup workerGroup = MotionEtlGlobalCtx.getInstance().getWorkerGroup();
            String logPath = CommonUtils.getLogPath();
            for (String string : commonKey) {
                String failMessage2;
                Set targetColumLowerCase;
                TableInfo sourceTable = source.get(string);
                TableInfo targetTable = target.get(string);
                if (sourceTable.getColumnNames().size() != targetTable.getColumnNames().size()) {
                    failMessage = String.format("\u8868\u5217\u4e0d\u4e00\u81f4\uff0c\u3010%s:%s\u3011\uff0c\u3010%s:%s\u3011", sourceDatabase, sourceTable.getColumnNames().toString(), targetDatabase, targetTable.getColumnNames().toString());
                    currentHtml.failed.put(sourceSchema + "." + string, failMessage);
                    strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t %s\n", failMessage));
                    strFalse.append("\n");
                    continue;
                }
                Set sourceColumLowerCase = sourceTable.getColumnNames().stream().map(String::toLowerCase).collect(Collectors.toSet());
                if (!sourceColumLowerCase.equals(targetColumLowerCase = targetTable.getColumnNames().stream().map(String::toLowerCase).collect(Collectors.toSet()))) {
                    String failMessage3 = String.format("\u8868\u5217\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u6620\u5c04\u6bd4\u5bf9\u3010%s:%s\u3011\uff0c\u3010%s:%s\u3011", sourceDatabase, sourceTable.getColumnNames().toString(), targetDatabase, targetTable.getColumnNames().toString());
                    currentHtml.failed.put(sourceSchema + "." + string, failMessage3);
                    strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t %s\n", failMessage3));
                    strFalse.append("\n");
                    continue;
                }
                long sourceCount = CompareTypeUtil.getTableCount((Connection)sourceFetcher.sourceJdbcMeta().openConnection(), (String)String.format("%s.%s", sourceTable.getSchema(), sourceTable.getTableName()));
                long targetCount = CompareTypeUtil.getTableCount((Connection)targetImporter.targetJdbcMeta().openConnection(), (String)String.format("%s.%s", targetTable.getSchema(), targetTable.getTableName()));
                if (sourceCount == -1L) {
                    String failMessage22 = String.format("[%s]\uff1a[%s.%s] \u8868\u884c\u6570\u67e5\u8be2\u5931\u8d25", sourceDatabase, sourceSchema, string);
                    currentHtml.failed.put(sourceSchema + "." + string, failMessage22);
                    strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t %s\n", failMessage22));
                    strFalse.append("\n");
                    strFalse.append("\n");
                    continue;
                }
                if (targetCount == -1L) {
                    failMessage2 = String.format("[%s]\uff1a[%s.%s] \u8868\u884c\u6570\u67e5\u8be2\u5931\u8d25", targetDatabase, targetSchema, string);
                    currentHtml.failed.put(sourceSchema + "." + string, failMessage2);
                    strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t %s\n", failMessage2));
                    strFalse.append("\n");
                    continue;
                }
                if (sourceCount != targetCount) {
                    failMessage2 = String.format("\u8868\u884c\u6570\u5bf9\u6bd4\u4e0d\u4e00\u81f4\uff0c\u3010%s:%s\u3011\uff0c\u3010%s:%s\u3011", sourceDatabase, sourceCount, targetDatabase, targetCount);
                    currentHtml.failed.put(sourceSchema + "." + string, failMessage2);
                    strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t %s\n", failMessage2));
                    continue;
                }
                if (sourceCount == 0L) {
                    currentHtml.success.put(sourceSchema + "." + string, "\u8868\u65e0\u6570\u636e\uff0c\u5bf9\u6bd4\u4e00\u81f4");
                    strTrue.append(sourceSchema).append(".").append(string).append("\u8868\u65e0\u6570\u636e\uff0c\u5bf9\u6bd4\u4e00\u81f4:\n");
                    continue;
                }
                HashMap execute = CompareTypeUtil.getExecuteSql((TableInfo)sourceTable, (TableInfo)targetTable, (SourceJdbcMeta)sourceFetcher.sourceJdbcMeta());
                sourceTable.setCompareSql((String)execute.get("sources"));
                targetTable.setCompareSql((String)execute.get("target"));
                DiffCompareData diffCompareData = new DiffCompareData();
                diffCompareData.setGroup(workerGroup);
                diffCompareData.setSourceTable(sourceTable);
                diffCompareData.setTargetTable(targetTable);
                diffCompareData.setSourceJdbcMeta(sourceFetcher.sourceJdbcMeta());
                diffCompareData.setTargetJdbcMeta(targetImporter.targetJdbcMeta());
                diffCompareData.setCompareResultList(compareResultList);
                diffCompareData.setSourceFilePath(String.format("%s%s%s_%s", logPath, File.separator, string, "source"));
                diffCompareData.setTargetFilePath(String.format("%s%s%s_%s", logPath, File.separator, string, "target"));
                diffCompareData.setBatchSize(MotionEtlGlobalCtx.getInstance().batchCount());
                diffCompareData.doCompare();
            }
            workerGroup.waitCompletion();
            for (Map.Entry entry : compareResultList.entrySet()) {
                String tableName = (String)entry.getKey();
                Boolean compareResult = (Boolean)entry.getValue();
                if (compareResult.booleanValue()) {
                    currentHtml.success.put(sourceSchema + "." + tableName, "\u6570\u636e\u4e00\u81f4");
                    strTrue.append(sourceSchema).append(".").append(tableName).append("\u5bf9\u6bd4\u4e00\u81f4\u3002");
                    continue;
                }
                failMessage = String.format("[%s]\uff1a[%s.%s] \u6570\u636e\u503c\u5bf9\u6bd4\u4e0d\u4e00\u81f4", sourceDatabase, sourceSchema, tableName);
                currentHtml.failed.put(sourceSchema + "." + tableName, failMessage);
                strFalse.append(sourceSchema).append(".").append(tableName).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                strFalse.append(String.format("\t %s\n", failMessage));
            }
            for (String string : diffrentKey) {
                if (!source.containsKey(string)) {
                    String failMessage4 = String.format("[%s]\uff1a[%s.%s] \u4e0d\u5b58\u5728", sourceDatabase, sourceSchema, string);
                    currentHtml.failed.put(sourceSchema + "." + string, failMessage4);
                    strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                    strFalse.append(String.format("\t %s\n", failMessage4));
                    continue;
                }
                if (target.containsKey(string)) continue;
                String failMessage3 = String.format("[%s]\uff1a[%s.%s] \u4e0d\u5b58\u5728", targetDatabase, targetSchema, string);
                currentHtml.failed.put(sourceSchema + "." + string, failMessage3);
                strFalse.append(sourceSchema).append(".").append(string).append("\u5bf9\u6bd4\u4e0d\u4e00\u81f4:\n");
                strFalse.append(String.format("\t %s\n", failMessage3));
            }
            if (StringUtils.isBlank((CharSequence)strTrue) && StringUtils.isBlank((CharSequence)strFalse)) {
                log.info("\u662f\u7a7a\u8868\u5bf9\u6bd4\u4e00\u81f4");
            } else {
                log.info(strTrue.toString());
                log.info(strFalse.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)strFalse)) {
                CommonUtils.writeTableDataCompareResult((String)"FAIL");
            } else {
                CommonUtils.writeTableDataCompareResult((String)"SUCCESS");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static HashMap<String, String> getExecuteSql(TableInfo sourceTable, TableInfo targetTable, SourceJdbcMeta source) {
        HashMap<String, String> result = new HashMap<String, String>(8);
        String sourceDBType = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase();
        boolean isSourceMysqlFamilyDB = CommonUtils.isMysqlFamilyDB((String)sourceDBType);
        String blankStrTransformTo = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getBlankStrTransformTo();
        StringBuilder sourceSelect = new StringBuilder();
        StringBuilder targetSelect = new StringBuilder();
        int maxOrderByCount = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getMaxOrderByCount();
        Map<String, String> sourceColumnMap = sourceTable.getColumnNames().stream().collect(Collectors.toMap(String::toLowerCase, item -> item));
        Map<String, String> targetColumnMap = targetTable.getColumnNames().stream().collect(Collectors.toMap(String::toLowerCase, item -> item));
        Set commonColumn = sourceColumnMap.keySet().stream().filter(targetColumnMap.keySet()::contains).collect(Collectors.toSet());
        HashSet sourceTableColSet = new HashSet();
        sourceTableColSet.addAll(sourceTable.getUniqueIndexCols());
        HashSet targetTableColSet = new HashSet();
        targetTableColSet.addAll(targetTable.getUniqueIndexCols());
        if (isSourceMysqlFamilyDB && sourceTable.getNotNullCols().size() == 0) {
            Set notNullColsSet = source.getNotNullColumns(sourceTable.getTableName());
            sourceTable.setNotNullCols(notNullColsSet);
        }
        Map<String, String> sourceUniqueMap = sourceTableColSet.stream().collect(Collectors.toMap(String::toLowerCase, item -> item));
        Map<String, String> targetUniqueMap = targetTableColSet.stream().collect(Collectors.toMap(String::toLowerCase, item -> item));
        Set commonUnique = sourceUniqueMap.keySet().stream().filter(targetUniqueMap.keySet()::contains).collect(Collectors.toSet());
        Set customizeOrderByColumn = EtlGlobalCtx.getOrderByColumn((String)sourceTable.getTableName().toLowerCase());
        sourceSelect.append("SELECT ");
        targetSelect.append("SELECT ");
        for (String column : commonColumn) {
            if (isSourceMysqlFamilyDB) {
                boolean appendFlag = true;
                if (EtlGlobalCtx.dataTransformColumn((String)sourceTable.getTableName(), (String)column)) {
                    String srcVal = EtlGlobalCtx.getColumnDataTransform((String)sourceTable.getTableName(), (String)column).getSrcColData();
                    String destVal = EtlGlobalCtx.getColumnDataTransform((String)sourceTable.getTableName(), (String)column).getDestColData();
                    int columnIndex = sourceTable.getColumnNames().indexOf(column);
                    if (0 < columnIndex && columnIndex < sourceTable.getColumnTypes().size()) {
                        String columnType = (String)sourceTable.getColumnTypes().get(columnIndex);
                        sourceSelect.append(String.format("cast(case when %s=%s then %s else %s end as %s) %s", column, srcVal, destVal, column, columnType, column) + ",");
                        appendFlag = false;
                    }
                }
                if (sourceTable.getNotNullCols().contains(column) && blankStrTransformTo != null) {
                    sourceSelect.append(String.format("case when %s='' then '%s' else %s end %s", column, blankStrTransformTo, column, column) + ",");
                    appendFlag = false;
                }
                if (appendFlag) {
                    sourceSelect.append(sourceColumnMap.get(column) + ",");
                }
            } else {
                sourceSelect.append(sourceColumnMap.get(column) + ",");
            }
            targetSelect.append(targetColumnMap.get(column) + ",");
        }
        if (StringUtils.isBlank((CharSequence)sourceTable.getSchema())) {
            sourceSelect.replace(sourceSelect.length() - 1, sourceSelect.length(), " FROM " + sourceTable.getTableName());
        } else {
            sourceSelect.replace(sourceSelect.length() - 1, sourceSelect.length(), String.format(" FROM %s.%s ", sourceTable.getSchema(), sourceTable.getTableName()));
        }
        if (StringUtils.isBlank((CharSequence)targetTable.getSchema())) {
            targetSelect.replace(targetSelect.length() - 1, targetSelect.length(), " FROM " + targetTable.getTableName());
        } else {
            targetSelect.replace(targetSelect.length() - 1, targetSelect.length(), String.format(" FROM %s.%s ", targetTable.getSchema(), targetTable.getTableName()));
        }
        if (customizeOrderByColumn != null && !customizeOrderByColumn.isEmpty()) {
            sourceSelect.append(" order by ");
            targetSelect.append(" order by ");
            for (String columnOrder : customizeOrderByColumn) {
                sourceSelect.append(columnOrder + ",");
                targetSelect.append(columnOrder + ",");
            }
            sourceSelect.delete(sourceSelect.length() - 1, sourceSelect.length());
            targetSelect.delete(targetSelect.length() - 1, targetSelect.length());
        } else if (commonUnique == null || commonUnique.isEmpty()) {
            List sourceOrderBy = CompareTypeUtil.getOrderByColumn((TableInfo)sourceTable);
            List targetOrderBy = CompareTypeUtil.getOrderByColumn((TableInfo)targetTable);
            Map<String, String> sourceOrderByMap = sourceOrderBy.stream().collect(Collectors.toMap(String::toLowerCase, item -> item));
            Map<String, String> targetOrderByMap = targetOrderBy.stream().collect(Collectors.toMap(String::toLowerCase, item -> item));
            Set commonOrderBy = sourceOrderByMap.keySet().stream().filter(targetOrderByMap.keySet()::contains).collect(Collectors.toSet());
            if (commonOrderBy.isEmpty()) {
                log.info("\u65e0\u76f8\u540corder by\u5217");
            } else {
                sourceSelect.append(" order by ");
                targetSelect.append(" order by ");
                Iterator iterator = commonOrderBy.iterator();
                for (int count = 0; iterator.hasNext() && count <= maxOrderByCount; ++count) {
                    String columnOrder = (String)iterator.next();
                    sourceSelect.append(sourceOrderByMap.get(columnOrder) + ",");
                    targetSelect.append(targetOrderByMap.get(columnOrder) + ",");
                }
                sourceSelect.delete(sourceSelect.length() - 1, sourceSelect.length());
                targetSelect.delete(targetSelect.length() - 1, targetSelect.length());
            }
        } else {
            sourceSelect.append(" order by ");
            targetSelect.append(" order by ");
            Iterator iterator = commonUnique.iterator();
            for (int count = 0; iterator.hasNext() && count <= maxOrderByCount; ++count) {
                String column = (String)iterator.next();
                sourceSelect.append(sourceUniqueMap.get(column) + ",");
                targetSelect.append(targetUniqueMap.get(column) + ",");
            }
            sourceSelect.delete(sourceSelect.length() - 1, sourceSelect.length());
            targetSelect.delete(targetSelect.length() - 1, targetSelect.length());
        }
        String targetSelectAfterTrans = targetSelect.toString();
        if (!CommonUtils.isMysqlFamilyDB((String)MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase())) {
            targetSelectAfterTrans = targetSelect.toString().replaceAll("`", "\"");
        }
        result.put("sources", sourceSelect.toString());
        result.put("target", targetSelectAfterTrans);
        return result;
    }

    public static long getQueryCount(Connection connection, String sql) {
        String countSql = String.format("SELECT COUNT(*) FROM (%s) ", sql);
        return (Long)JdbcUtils.doQuery((Connection)connection, (String)countSql, resultSet -> {
            long queryCount = -1L;
            try {
                while (resultSet.next()) {
                    queryCount = resultSet.getLong(1);
                }
                return queryCount;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(countSql, (Throwable)e);
                return queryCount;
            }
        });
    }

    private static long getTableCount(Connection connection, String tableName) {
        String countSql = String.format("select count(*) from %s", tableName);
        return (Long)JdbcUtils.doQuery((Connection)connection, (String)countSql, resultSet -> {
            long tableCount = -1L;
            try {
                while (resultSet.next()) {
                    tableCount = resultSet.getLong(1);
                }
                return tableCount;
            }
            catch (SQLException e) {
                EtlGlobalCtx.INSTANCE.handleException(countSql, (Throwable)e);
                return tableCount;
            }
        });
    }

    private static List<String> getOrderByColumn(TableInfo tableInfo) {
        List columnNames = tableInfo.getColumnNames();
        List columnType = tableInfo.getColumnTypes();
        ArrayList<String> orderByColumn = new ArrayList<String>();
        for (int i = 0; i < columnType.size(); ++i) {
            if (notSortedType.contains(((String)columnType.get(i)).toLowerCase())) continue;
            orderByColumn.add((String)columnNames.get(i));
        }
        return orderByColumn;
    }

    private static String getTableDataCompareHtmlHead() {
        StringBuffer head = new StringBuffer();
        head.append("<!DOCTYPE html>  \n<html>  \n<head>   \n<meta  charset=\"utf-8\">  \n<title>\u8868\u6570\u636e\u6bd4\u5bf9\u62a5\u544a</title>  \n<style>  \n  .container {  \n    display: flex;  \n    height: 100vh; /* \u4f7f\u7528\u89c6\u53e3\u9ad8\u5ea6 */  \n  }  \n  \n    .sidebar ul {  \n    width: 200px;\n    list-style-type: none;  \n\tbackground-color: #f4f4f4;\n\tpadding: 20px;\n    \n    margin: 0;  \n    display: flex; /* \u9ed8\u8ba4\u4f7f\u7528flex\u5e03\u5c40\u6a2a\u5411\u663e\u793a */  \n    flex-direction: column; /* \u521d\u59cb\u4e3a\u5782\u76f4\uff0c\u901a\u8fc7\u5a92\u4f53\u67e5\u8be2\u6539\u4e3a\u6a2a\u5411 */  \n\toverflow-y: auto; /* \u5982\u679c\u9700\u8981\uff0c\u53ef\u4ee5\u7eb5\u5411\u6eda\u52a8 */\n  }  \n  \n  .sidebar li {  \n    margin: 5px 0; /* \u5782\u76f4\u95f4\u8ddd */  \n    /* \u6a2a\u5411\u95f4\u8ddd\u5c06\u5728\u5a92\u4f53\u67e5\u8be2\u4e2d\u901a\u8fc7margin-right\u6dfb\u52a0 */  \n  } \n  \n \n  \n  .main-content {  \n    flex-grow: 1;  \n    overflow-x: auto; /* \u5141\u8bb8\u6a2a\u5411\u6eda\u52a8 */  \n    padding: 20px;  \n  }  \n  \n  /* \u8868\u683c\u6837\u5f0f */  \n  .scrollable-table {  \n    width: 100%;  \n    min-width: 800px; /* \u8868\u683c\u7684\u6700\u5c0f\u5bbd\u5ea6\uff0c\u786e\u4fdd\u6709\u8db3\u591f\u7684\u5185\u5bb9\u89e6\u53d1\u6eda\u52a8\u6761 */  \n    overflow-x: auto; /* \u6dfb\u52a0\u6c34\u5e73\u6eda\u52a8\u6761\u4ee5\u5904\u7406\u8d85\u51fa\u5bbd\u5ea6\u7684\u8868\u683c */  \n  }  \n  \n   /* \u9690\u85cf\u951a\u70b9 */  \n        .anchor {  \n            display: block;  \n            position: relative;  \n            top: -50px; /* \u6839\u636e\u9700\u8981\u8c03\u6574\uff0c\u4ee5\u786e\u4fdd\u8df3\u8f6c\u5230\u884c\u7684\u53ef\u89c1\u90e8\u5206 */  \n            visibility: hidden;  \n        }    table {  \n    width: 100%;  \n    border-collapse: collapse;  \n    table-layout: fixed; /* \u786e\u4fdd\u5217\u5bbd\u6309\u6307\u5b9a\u5bbd\u5ea6\u5206\u914d */  \n  }  \n  \n  th, td {  \n    border: 1px solid black;  \n    padding: 8px;  \n    text-align: left;  \n    word-wrap: break-word; /* \u5141\u8bb8\u6587\u672c\u6362\u884c */  \n    white-space: normal;  \n    max-width: 200px; /* \u53ef\u9009\uff0c\u6839\u636e\u9700\u8981\u8bbe\u7f6e\u6700\u5927\u5bbd\u5ea6 */  \n  }  \n</style>  \n</head> \n");
        return head.toString();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "WMI_WRONG_MAP_ITERATOR"})
    public static void produceTableDataCompareHtml() {
        StringBuffer head = new StringBuffer();
        StringBuffer summaryAll = new StringBuffer();
        StringBuffer summaryFirst = new StringBuffer();
        StringBuffer summarySecond = new StringBuffer();
        StringBuffer directory = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer module = new StringBuffer();
        StringBuffer directorySummary = new StringBuffer();
        HashMap<String, TypeSummary> typeSummary = new HashMap<String, TypeSummary>(10);
        String bg = "bgcolor=\"#FF0000\"";
        head.append(CompareTypeUtil.getTableDataCompareHtmlHead());
        body.append("<body>\n<div class=\"container\"> ");
        directory.append("<div class=\"sidebar\">  \n    <h2>\u76ee\u5f55</h2>  \n    <ul>\n");
        directory.append(String.format("\t<li><a href=\"#summaryResult\">\u6240\u6709\u7ed3\u679c\u6c47\u603b</a></li>\n", new Object[0]));
        summaryAll.append(String.format("<div class=\"main-div\" id=\"summaryResult\">\n<h1>\u6c47\u603b\u7ed3\u679c</h1>\n", new Object[0]));
        for (Map.Entry entry : COMPARE_RESULT_HTML.entrySet()) {
            String schema = (String)entry.getKey();
            directorySummary.append(String.format("\t<li><a href=\"#%s\">%s \u8be6\u7ec6\u5bf9\u6bd4\u7ed3\u679c</a></li>\n", schema, schema));
            directory.append(String.format("\t<li><a href=\"#%s\">%s \u5bf9\u6bd4\u6c47\u603b\u7ed3\u679c</a></li>\n", schema + "summary", schema));
            module.append(String.format("<div class=\"main-div\" id=\"%s\">\n<h1>%s\u8be6\u7ec6\u5bf9\u6bd4\u7ed3\u679c</h1>\n", schema, schema, schema));
            summarySecond.append(String.format("\t<div class=\"scrollable-table\" id=\"%s\"> ", schema + "summary"));
            summarySecond.append(String.format("<h2>%s\u5bf9\u6bd4\u7ed3\u679c\u6c47\u603b</h2>\n", schema));
            summarySecond.append("<table><thead><tr><th>\u5bf9\u8c61\u540d</th><th>\u5bf9\u6bd4\u7ed3\u679c</th></tr></thead><tbody>\n");
            StringBuffer subModule = new StringBuffer();
            String typeName = CompareTypeEnum.TABLE_DATA.getCompareName();
            TypeSummary ts = typeSummary.computeIfAbsent(typeName, k -> new TypeSummary());
            boolean firstTypenameError = true;
            ts.success += ((Html)entry.getValue()).success.size();
            ts.failed += ((Html)entry.getValue()).failed.size();
            if (((Html)entry.getValue()).failed.size() > 0) {
                summarySecond.append(String.format("<tr><td %s><a href=\"#%s\">%s</a></td><td>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</td></tr>\n", bg, schema + "_" + (String)entry.getKey(), typeName, ((Html)entry.getValue()).success.size(), ((Html)entry.getValue()).failed.size()));
            } else {
                summarySecond.append(String.format("<tr><td>%s</td><td>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</td></tr>\n", typeName, ((Html)entry.getValue()).success.size(), ((Html)entry.getValue()).failed.size()));
            }
            subModule.append("\t<div class=\"scrollable-table\">  \n");
            subModule.append(String.format("\t<h2>%s\u5bf9\u6bd4\u7ed3\u679c</h2>\n", typeName));
            subModule.append(String.format("<p>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</p>\n", ((Html)entry.getValue()).success.size(), ((Html)entry.getValue()).failed.size()));
            subModule.append(String.format("<table><thead><tr><th>\u5bf9\u8c61\u540d</th><th>\u662f\u5426\u4e00\u81f4</th><th>\u539f\u56e0</th></tr></thead><tbody>\n", new Object[0]));
            for (Map.Entry entry3 : ((Html)entry.getValue()).failed.entrySet()) {
                Object objectName = (String)entry3.getKey();
                if (CompareTypeEnum.PACKAGE_BODY.getCompareType().equals(entry.getKey())) {
                    objectName = (String)entry3.getKey() + "_body";
                }
                String message = MotionEtlGlobalCtx.getInstance().getEtlMessageValue((String)objectName);
                if (firstTypenameError) {
                    subModule.append(String.format("<tr id=\"%s\" ><td %s>%s</td><td>\u4e0d\u4e00\u81f4</td><td>%s</td></tr>\n", schema + "_" + (String)entry.getKey(), bg, entry3.getKey(), StringUtils.isNotBlank((CharSequence)message) ? message : entry3.getValue()));
                    firstTypenameError = false;
                    continue;
                }
                subModule.append(String.format("<tr><td %s>%s</td><td>\u4e0d\u4e00\u81f4</td><td>%s</td></tr>\n", bg, entry3.getKey(), StringUtils.isNotBlank((CharSequence)message) ? message : entry3.getValue()));
            }
            for (Map.Entry entry3 : ((Html)entry.getValue()).success.entrySet()) {
                subModule.append(String.format("<tr><td>%s</td><td>\u4e00\u81f4</td><td>%s</td></tr>\n", entry3.getKey(), entry3.getValue()));
            }
            subModule.append("\n</tbody></table></div>\n");
            module.append(subModule);
            summarySecond.append("</tbody></table></div>\n");
            module.append("</div>\n");
        }
        directory.append(directorySummary);
        directory.append("</ul>  \n</div>\n");
        summaryFirst.append(String.format("<h2>\u6574\u4f53\u6c47\u603b\u7ed3\u679c</h2>\n", new Object[0]));
        summaryFirst.append(String.format("\t<div class=\"scrollable-table\"> \n<table><thead><tr><th>\u5bf9\u8c61\u540d</th><th>\u5bf9\u6bd4\u7ed3\u679c</th></tr></thead><tbody>\n", new Object[0]));
        for (Map.Entry entry : typeSummary.entrySet()) {
            summaryFirst.append(String.format("<tr><td>%s</td><td>\u5bf9\u6bd4\u6210\u529f%s,\u5bf9\u6bd4\u5931\u8d25%s</td></tr>\n", entry.getKey(), ((TypeSummary)entry.getValue()).success, ((TypeSummary)entry.getValue()).failed));
        }
        summaryFirst.append("</tbody></table></div>\n");
        summaryAll.append(summaryFirst);
        summaryAll.append(summarySecond);
        summaryAll.append("</div>\n");
        body.append(directory);
        body.append("\n<div class=\"main-content\">\n");
        body.append(summaryAll);
        body.append(module);
        body.append("</div> \n</div> \n");
        String foot = "\n</body>\n\n</html>\n";
        Date currentTime = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String timeStr = dateFormat.format(currentTime);
        String htmlName = "table_data_compare_" + timeStr + ".html";
        StringBuffer htmlFilePath = new StringBuffer();
        String eltLogPath = System.getenv("ETL_LOG_PATH");
        if (StringUtils.isNotBlank((CharSequence)eltLogPath)) {
            htmlFilePath.append(String.format("%s/%s", CommonUtils.getLogPath(), htmlName));
        } else {
            htmlFilePath.append(htmlName);
        }
        CommonUtils.createNewFile((String)htmlFilePath.toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFilePath.toString()), "UTF-8");){
            writer.write(head.toString());
            writer.write(body.toString());
            writer.write(foot);
        }
        catch (IOException e) {
            EtlGlobalCtx.INSTANCE.handleException("\u5199\u5165\u8868\u6570\u636e\u6bd4\u5bf9\u7ed3\u679chtml\u9875\u9762\u5931\u8d25", (Throwable)e);
        }
    }

    static {
        notSortedType.add("xmltype");
        notSortedType.add("blob");
        notSortedType.add("nclob");
        notSortedType.add("clob");
        notSortedType.add("long raw");
        notSortedType.add("json");
        notSortedType.add("longblob");
    }
}

