/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.utils;

import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.WorkerGroup;
import com.hundsun.lightdb.comparison.strategy.CompareRule;
import com.hundsun.lightdb.comparison.strategy.CompareRuleManager;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.source.SourceJdbcMeta;
import com.hundsun.lightdb.core.target.TargetJdbcMeta;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.DbTypeSerializeUtil;
import com.hundsun.lightdb.utils.CommonUtils;
import com.hundsun.lightdb.utils.DiffCompareData;
import com.hundsun.lightdb.utils.JdbcUtils;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION", "DM_SYSTEM_OUT", "DM_SYSTEM_ERR", "SQL_INJECTION_JDBC"})
public class DiffCompareData {
    private static final Logger log = LoggerFactory.getLogger(DiffCompareData.class);
    volatile boolean compareResult = true;
    TableInfo sourceTable;
    int batchSize;
    TableInfo targetTable;
    SourceJdbcMeta sourceJdbcMeta;
    TargetJdbcMeta targetJdbcMeta;
    WorkerGroup group;
    ConcurrentHashMap<String, Boolean> compareResultList;
    int numberOfParties = 2;
    String sourceFilePath;
    String targetFilePath;

    public void doCompare() {
        try {
            CommonUtils.createNewFile((String)this.sourceFilePath);
            CommonUtils.createNewFile((String)this.targetFilePath);
            String sourceSql = this.sourceTable.getCompareSql();
            String targetSql = this.targetTable.getCompareSql();
            if (log.isDebugEnabled()) {
                log.debug("\u6e90\u6570\u636e\u5e93\u7684\u6bd4\u8f83SQL: {},\u76ee\u6807\u6570\u636e\u5e93\u7684\u6bd4\u8f83SQL:{}", (Object)sourceSql, (Object)targetSql);
            }
            String sourceDBType = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getSourceDatabase();
            String targetDBType = MotionEtlGlobalCtx.getInstance().getGlobalConfig().getTargetDatabase();
            CyclicBarrier barrier = new CyclicBarrier(this.numberOfParties, (Runnable)new BarrierAction(this));
            this.group.addTask(() -> this.processData(this.sourceJdbcMeta.openConnection(), barrier, sourceSql, this.sourceTable, this.sourceFilePath, sourceDBType));
            this.group.addTask(() -> this.processData(this.targetJdbcMeta.openConnection(), barrier, targetSql, this.targetTable, this.targetFilePath, targetDBType));
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException(String.format("%s\u5bf9\u6bd4\u5931\u8d25\uff0c\u83b7\u53d6\u552f\u4e00\u5b57\u6bb5\u5931\u8d25", this.sourceTable.getTableName()), (Throwable)e);
            this.compareResult = false;
            this.compareResultList.put(this.sourceTable.getTableName(), this.compareResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processData(Connection connection, CyclicBarrier barrier, String querySelect, TableInfo tableInfo, String filePath, String dataBaseType) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.info("\u8bfb\u53d6\u8868\u6570\u636e [{}]", (Object)querySelect);
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(querySelect, 1003, 1007);
            preparedStatement.setFetchSize(this.batchSize);
            boolean executeResult = false;
            executeResult = preparedStatement.execute();
            if (executeResult) {
                resultSet = preparedStatement.getResultSet();
            }
            ArrayList resultList = new ArrayList();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            int rowCount = 0;
            while (true) {
                ArrayList<Object> rowList;
                if (resultSet.next() && this.compareResult) {
                    rowList = new ArrayList<Object>(columnCount);
                } else {
                    if (rowCount % this.batchSize != 0 && this.compareResult) {
                        if (!this.writeData(resultList, filePath)) {
                            this.compareResultList.put(tableInfo.getTableName(), false);
                            JdbcUtils.close((AutoCloseable)preparedStatement);
                            JdbcUtils.close((AutoCloseable)resultSet);
                            this.compareResultList.put(tableInfo.getTableName(), this.compareResult);
                            return;
                        }
                        barrier.await();
                    }
                    JdbcUtils.close((AutoCloseable)preparedStatement);
                    JdbcUtils.close((AutoCloseable)resultSet);
                    this.compareResultList.put(tableInfo.getTableName(), this.compareResult);
                    return;
                }
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnName(i).toLowerCase();
                    String tableName = metaData.getTableName(i).toLowerCase();
                    int columnType = DbTypeSerializeUtil.getColumnType((ResultSetMetaData)metaData, (int)i);
                    DbType dbType = DbType.of((String)dataBaseType);
                    Object object = DbTypeSerializeUtil.getResultSetValueBySqlTypeName(null, (String)querySelect, (ResultSet)resultSet, (ResultSetMetaData)metaData, (int)i, (DbType)dbType);
                    if (log.isDebugEnabled()) {
                        log.debug("\u8868\u540d\uff1a{}\uff0c\u5217\u540d\uff1a{}\uff0c\u503c\uff1a{}\uff0c\u7c7b\u578b\uff1a{}", new Object[]{tableName, columnName, object, object == null ? "null" : object.getClass().getName()});
                    }
                    CompareRule.SourceValue input = new CompareRule.SourceValue(tableName, columnName, columnType, object);
                    CompareRuleManager.INSTANCE.applyCompareRules(input);
                    if (log.isDebugEnabled()) {
                        log.debug("\u591a\u53d1\u6bd4\u5bf9\u8f6c\u6362\u540e\u503c\uff1a{}, \u7c7b\u578b\uff1a{}", input.getOutputValue(), (Object)(input.getOutputValue() == null ? "null" : input.getOutputValue().getClass().getName()));
                    }
                    rowList.add(input.getOutputValue());
                }
                resultList.add(rowList);
                if (++rowCount % this.batchSize != 0 || !this.compareResult) continue;
                if (!this.writeData(resultList, filePath)) {
                    this.compareResultList.put(tableInfo.getTableName(), false);
                    JdbcUtils.close((AutoCloseable)preparedStatement);
                    JdbcUtils.close((AutoCloseable)resultSet);
                    this.compareResultList.put(tableInfo.getTableName(), this.compareResult);
                    return;
                }
                resultList = new ArrayList();
                barrier.await();
            }
        }
        catch (Throwable e) {
            try {
                log.error("{}\u6267\u884c\u5931\u8d25\uff0c\u62a5\u9519{}", (Object)tableInfo.getTableName(), (Object)e);
                EtlGlobalCtx.INSTANCE.handleException("\u6bd4\u5bf9\u6570\u636esql\uff1a " + querySelect, e);
                this.compareResult = false;
                try {
                    barrier.await(1L, TimeUnit.MICROSECONDS);
                }
                catch (Exception var) {
                    log.error("\u8bbe\u7f6e\u8d85\u65f6\u5931\u8d25" + var);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.close(preparedStatement);
                JdbcUtils.close(resultSet);
                this.compareResultList.put(tableInfo.getTableName(), this.compareResult);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            this.compareResultList.put(tableInfo.getTableName(), this.compareResult);
            return;
        }
    }

    private boolean writeData(List<List<Object>> tableData, String filePath) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));){
            for (List<Object> row : tableData) {
                writer.write(row.toString());
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            EtlGlobalCtx.INSTANCE.handleException("", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isCompareResult() {
        return this.compareResult;
    }

    public TableInfo getSourceTable() {
        return this.sourceTable;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public TableInfo getTargetTable() {
        return this.targetTable;
    }

    public SourceJdbcMeta getSourceJdbcMeta() {
        return this.sourceJdbcMeta;
    }

    public TargetJdbcMeta getTargetJdbcMeta() {
        return this.targetJdbcMeta;
    }

    public WorkerGroup getGroup() {
        return this.group;
    }

    public ConcurrentHashMap<String, Boolean> getCompareResultList() {
        return this.compareResultList;
    }

    public int getNumberOfParties() {
        return this.numberOfParties;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public void setCompareResult(boolean compareResult) {
        this.compareResult = compareResult;
    }

    public void setSourceTable(TableInfo sourceTable) {
        this.sourceTable = sourceTable;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setTargetTable(TableInfo targetTable) {
        this.targetTable = targetTable;
    }

    public void setSourceJdbcMeta(SourceJdbcMeta sourceJdbcMeta) {
        this.sourceJdbcMeta = sourceJdbcMeta;
    }

    public void setTargetJdbcMeta(TargetJdbcMeta targetJdbcMeta) {
        this.targetJdbcMeta = targetJdbcMeta;
    }

    public void setGroup(WorkerGroup group) {
        this.group = group;
    }

    public void setCompareResultList(ConcurrentHashMap<String, Boolean> compareResultList) {
        this.compareResultList = compareResultList;
    }

    public void setNumberOfParties(int numberOfParties) {
        this.numberOfParties = numberOfParties;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiffCompareData)) {
            return false;
        }
        DiffCompareData other = (DiffCompareData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCompareResult() != other.isCompareResult()) {
            return false;
        }
        TableInfo this$sourceTable = this.getSourceTable();
        TableInfo other$sourceTable = other.getSourceTable();
        if (this$sourceTable == null ? other$sourceTable != null : !this$sourceTable.equals(other$sourceTable)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        TableInfo this$targetTable = this.getTargetTable();
        TableInfo other$targetTable = other.getTargetTable();
        if (this$targetTable == null ? other$targetTable != null : !this$targetTable.equals(other$targetTable)) {
            return false;
        }
        SourceJdbcMeta this$sourceJdbcMeta = this.getSourceJdbcMeta();
        SourceJdbcMeta other$sourceJdbcMeta = other.getSourceJdbcMeta();
        if (this$sourceJdbcMeta == null ? other$sourceJdbcMeta != null : !this$sourceJdbcMeta.equals(other$sourceJdbcMeta)) {
            return false;
        }
        TargetJdbcMeta this$targetJdbcMeta = this.getTargetJdbcMeta();
        TargetJdbcMeta other$targetJdbcMeta = other.getTargetJdbcMeta();
        if (this$targetJdbcMeta == null ? other$targetJdbcMeta != null : !this$targetJdbcMeta.equals(other$targetJdbcMeta)) {
            return false;
        }
        WorkerGroup this$group = this.getGroup();
        WorkerGroup other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        ConcurrentHashMap this$compareResultList = this.getCompareResultList();
        ConcurrentHashMap other$compareResultList = other.getCompareResultList();
        if (this$compareResultList == null ? other$compareResultList != null : !((Object)this$compareResultList).equals(other$compareResultList)) {
            return false;
        }
        if (this.getNumberOfParties() != other.getNumberOfParties()) {
            return false;
        }
        String this$sourceFilePath = this.getSourceFilePath();
        String other$sourceFilePath = other.getSourceFilePath();
        if (this$sourceFilePath == null ? other$sourceFilePath != null : !this$sourceFilePath.equals(other$sourceFilePath)) {
            return false;
        }
        String this$targetFilePath = this.getTargetFilePath();
        String other$targetFilePath = other.getTargetFilePath();
        return !(this$targetFilePath == null ? other$targetFilePath != null : !this$targetFilePath.equals(other$targetFilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiffCompareData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCompareResult() ? 79 : 97);
        TableInfo $sourceTable = this.getSourceTable();
        result = result * 59 + ($sourceTable == null ? 43 : $sourceTable.hashCode());
        result = result * 59 + this.getBatchSize();
        TableInfo $targetTable = this.getTargetTable();
        result = result * 59 + ($targetTable == null ? 43 : $targetTable.hashCode());
        SourceJdbcMeta $sourceJdbcMeta = this.getSourceJdbcMeta();
        result = result * 59 + ($sourceJdbcMeta == null ? 43 : $sourceJdbcMeta.hashCode());
        TargetJdbcMeta $targetJdbcMeta = this.getTargetJdbcMeta();
        result = result * 59 + ($targetJdbcMeta == null ? 43 : $targetJdbcMeta.hashCode());
        WorkerGroup $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        ConcurrentHashMap $compareResultList = this.getCompareResultList();
        result = result * 59 + ($compareResultList == null ? 43 : ((Object)$compareResultList).hashCode());
        result = result * 59 + this.getNumberOfParties();
        String $sourceFilePath = this.getSourceFilePath();
        result = result * 59 + ($sourceFilePath == null ? 43 : $sourceFilePath.hashCode());
        String $targetFilePath = this.getTargetFilePath();
        result = result * 59 + ($targetFilePath == null ? 43 : $targetFilePath.hashCode());
        return result;
    }

    public String toString() {
        return "DiffCompareData(compareResult=" + this.isCompareResult() + ", sourceTable=" + this.getSourceTable() + ", batchSize=" + this.getBatchSize() + ", targetTable=" + this.getTargetTable() + ", sourceJdbcMeta=" + this.getSourceJdbcMeta() + ", targetJdbcMeta=" + this.getTargetJdbcMeta() + ", group=" + this.getGroup() + ", compareResultList=" + this.getCompareResultList() + ", numberOfParties=" + this.getNumberOfParties() + ", sourceFilePath=" + this.getSourceFilePath() + ", targetFilePath=" + this.getTargetFilePath() + ")";
    }

    static {
        CompareRuleManager.INSTANCE.loadCompareRulesInDir();
    }
}

