/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.utils;

import com.hundsun.lightdb.SqlLogger;
import com.hundsun.lightdb.TableInfo;
import com.hundsun.lightdb.core.EtlGlobalCtx;
import com.hundsun.lightdb.core.KeyValuePair;
import com.hundsun.lightdb.core.MotionEtlGlobalCtx;
import com.hundsun.lightdb.core.ObjectTypeEnum;
import com.hundsun.lightdb.core.RowValue;
import com.hundsun.lightdb.core.UniqueKey;
import com.hundsun.lightdb.motion.enums.MysqlTypeEnum;
import com.hundsun.lightdb.motion.enums.TaskResultEnum;
import com.hundsun.lightdb.utils.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "COMMAND_INJECTION", "DM_SYSTEM_OUT", "DM_SYSTEM_ERR", "SQL_INJECTION_JDBC"})
public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    static Pattern pattern = Pattern.compile("Distribution key column \"(.*)\"");

    public static <T> T doQuery(Connection connection, String sql, Function<ResultSet, T> resultSetConsumer) {
        T t;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            SqlLogger.printSql((String)"\u53ea\u67e5\u8be2", (String)sql);
            statement = connection.createStatement();
            statement.setFetchSize(MotionEtlGlobalCtx.getInstance().batchCount());
            resultSet = statement.executeQuery(sql);
            t = resultSetConsumer.apply(resultSet);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close((AutoCloseable)statement);
                throw throwable;
            }
        }
        JdbcUtils.close((AutoCloseable)resultSet);
        JdbcUtils.close((AutoCloseable)statement);
        return t;
    }

    public static <T> T doQuery(Connection connection, String sql, int fetchSize, Function<ResultSet, T> resultSetConsumer) {
        T t;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            SqlLogger.printSql((String)"\u53ea\u67e5\u8be2", (String)sql);
            statement = connection.createStatement();
            statement.setFetchSize(fetchSize);
            resultSet = statement.executeQuery(sql);
            t = resultSetConsumer.apply(resultSet);
        }
        catch (SQLException e) {
            try {
                if (log.isErrorEnabled()) {
                    log.error("doQuery sql:{} error:{}", (Object)sql, (Object)e);
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(resultSet);
                JdbcUtils.close((AutoCloseable)statement);
                throw throwable;
            }
        }
        JdbcUtils.close((AutoCloseable)resultSet);
        JdbcUtils.close((AutoCloseable)statement);
        return t;
    }

    public static void close(AutoCloseable autoCloseable) {
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (Exception e) {
            EtlGlobalCtx.INSTANCE.handleException("\u5173\u95ed\u8d44\u6e90\u5931\u8d25", (Throwable)e);
        }
    }

    public static boolean distributedColumnNotInIndex(String error) {
        return error.contains("UNIQUE index must contain all columns in the table's distribution key");
    }

    public static String extractDistributedColumn(String error) {
        Matcher matcher = pattern.matcher(error);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("not found distribution key");
    }

    public static String appendDistributedColumn(String indexSql, String distributedColumn) {
        return indexSql.replaceFirst("\\)", String.format(",%s)", distributedColumn));
    }

    public static void executeSql(Connection connection, String sql) {
        JdbcUtils.executeSql((Connection)connection, (String)"default", (String)"default", (String)sql);
    }

    public static List<KeyValuePair> fetchDdl(Connection connection, String sql) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<KeyValuePair> ddls = new ArrayList<KeyValuePair>(1000);
            String sourceSchema = MotionEtlGlobalCtx.getInstance().currentSchema();
            String targetShcema = MotionEtlGlobalCtx.getInstance().currentTargetSchema();
            while (resultSet.next()) {
                String group = resultSet.getString(1);
                String ddlSql = resultSet.getString(2);
                if (StringUtils.isNotBlank((CharSequence)sourceSchema) && StringUtils.isNotBlank((CharSequence)targetShcema) && !sourceSchema.equals(targetShcema)) {
                    ddlSql = ddlSql.replaceAll(String.format("(?i)\"%s\"\\.", sourceSchema), String.format("\"%s\"\\.", targetShcema));
                    ddlSql = ddlSql.replaceAll(String.format("(?i)%s\\.", sourceSchema), String.format("%s\\.", targetShcema));
                }
                ddls.add(new KeyValuePair(group, ddlSql));
            }
            return ddls;
        }
        catch (SQLException e) {
            EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static List<KeyValuePair> fetchMysqlDdl(Connection connection, String sqlRelation, MysqlTypeEnum mysqlDdlEnum) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(sqlRelation);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<KeyValuePair> ddls = new ArrayList<KeyValuePair>(1000);
            while (resultSet.next()) {
                String group = resultSet.getString(1);
                String getddlSql = resultSet.getString(2);
                String ddlSql = JdbcUtils.getMysqlDdl((Connection)connection, (String)getddlSql, (int)mysqlDdlEnum.getTypeIndex());
                ddls.add(new KeyValuePair(group, ddlSql));
            }
            return ddls;
        }
        catch (SQLException e) {
            EtlGlobalCtx.INSTANCE.handleException(sqlRelation, (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMysqlDdl(Connection connection, String sqlDdl, int indexDdl) {
        String string;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement(sqlDdl);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            String string2 = resultSet.getString(indexDdl);
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return string2;
        }
        try {
            string = "";
        }
        catch (SQLException e) {
            String string3;
            try {
                EtlGlobalCtx.INSTANCE.handleException(sqlDdl, (Throwable)e);
                string3 = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.close((AutoCloseable)preparedStatement);
                JdbcUtils.close(resultSet);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return string3;
        }
        JdbcUtils.close((AutoCloseable)preparedStatement);
        JdbcUtils.close((AutoCloseable)resultSet);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, HashMap<String, String>> fetchColumnInfo(Connection connection, String sql) {
        HashMap<String, HashMap<String, String>> hashMap;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.info("\u8bfb\u53d6\u6e90\u5e93\u5217\u4fe1\u606f [{}]", (Object)sql);
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, HashMap<String, String>> columnInfos = new HashMap<String, HashMap<String, String>>(100);
            while (resultSet.next()) {
                String tableName = MotionEtlGlobalCtx.getInstance().ignoreCase(resultSet.getString(1));
                String columnName = MotionEtlGlobalCtx.getInstance().ignoreCase(resultSet.getString(2)).trim();
                StringBuilder sb = new StringBuilder();
                String str = "null,";
                int a = 3;
                int b = 7;
                for (int i = a; i <= b; ++i) {
                    if (StringUtils.isBlank((CharSequence)resultSet.getString(i))) {
                        sb.append(str);
                        continue;
                    }
                    sb.append(resultSet.getString(i)).append(",");
                }
                sb.delete(sb.length() - 1, sb.length());
                HashMap columnInfo = columnInfos.computeIfAbsent(tableName, k -> new HashMap());
                columnInfo.put(columnName, sb.toString());
            }
            hashMap = columnInfos;
        }
        catch (SQLException e) {
            HashMap<String, HashMap<String, String>> hashMap2;
            try {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
                hashMap2 = new HashMap<String, HashMap<String, String>>(16);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(preparedStatement);
                JdbcUtils.close(resultSet);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return hashMap2;
        }
        JdbcUtils.close((AutoCloseable)preparedStatement);
        JdbcUtils.close((AutoCloseable)resultSet);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RowValue> fetchData(Connection connection, TableInfo tableInfo, String sql) {
        ArrayList<RowValue> rowValues = null;
        Statement s1 = null;
        ResultSet r1 = null;
        try {
            s1 = connection.createStatement();
            r1 = s1.executeQuery(sql);
            ResultSetMetaData metaData = r1.getMetaData();
            int columnCount = metaData.getColumnCount();
            rowValues = new ArrayList<RowValue>();
            while (r1.next()) {
                UniqueKey primaryKey = new UniqueKey();
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    Object columnValue = r1.getObject(i);
                    if (columnValue instanceof PGobject) {
                        columnValue = ((PGobject)columnValue).getValue();
                    }
                    if (tableInfo.getColumnNames().contains(metaData.getColumnName(i).toLowerCase())) {
                        primaryKey.addColumnValue(columnValue);
                        primaryKey.addColumnName(metaData.getColumnName(i).toLowerCase());
                    }
                    row.add(columnValue);
                }
                rowValues.add(new RowValue(primaryKey, row));
            }
        }
        catch (SQLException e) {
            try {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(r1);
                JdbcUtils.close((AutoCloseable)s1);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)r1);
            JdbcUtils.close((AutoCloseable)s1);
        }
        JdbcUtils.close((AutoCloseable)r1);
        JdbcUtils.close((AutoCloseable)s1);
        return rowValues;
    }

    public static KeyValuePair executeSql(Connection connection, String objectType, String group, String sql) {
        try {
            if (log.isInfoEnabled()) {
                log.info("\u6267\u884cSQL {}", (Object)sql);
            }
            Statement statement = connection.createStatement();
            statement.execute(sql);
            statement.close();
            return new KeyValuePair(TaskResultEnum.TASK_SUCCESS.getStatus(), "");
        }
        catch (SQLException e) {
            MotionEtlGlobalCtx.getInstance().putEtlMessage(String.format("%s.%s", MotionEtlGlobalCtx.getInstance().currentSchema().toLowerCase(), group.toLowerCase()), e.getMessage());
            if (JdbcUtils.distributedColumnNotInIndex((String)e.getMessage())) {
                JdbcUtils.executeSql((Connection)connection, (String)JdbcUtils.appendDistributedColumn((String)sql, (String)JdbcUtils.extractDistributedColumn((String)e.getMessage())));
                return new KeyValuePair(TaskResultEnum.TASK_SUCCESS.getStatus(), "");
            }
            if (objectType.equals(ObjectTypeEnum.PRIMARY_KEY.getName())) {
                EtlGlobalCtx.INSTANCE.handlePrimaryKeyException(sql, (Throwable)e);
            } else {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
            }
            return new KeyValuePair(TaskResultEnum.TASK_FAIL.getStatus(), e.getMessage());
        }
    }

    public static boolean checkDataBaseConnection(String url, String userName, String password) {
        boolean flag;
        block2: {
            flag = false;
            try {
                Connection connection = DriverManager.getConnection(url, userName, password);
                connection.close();
                flag = true;
            }
            catch (SQLException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error("\u6570\u636e\u5e93\u914d\u7f6e\u9519\u8bef url\uff1a{} userName:{} ", (Object)url, (Object)userName);
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSaveMessage(Connection connection, String sql) {
        int rowCount = 0;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            int batchSize = MotionEtlGlobalCtx.getInstance().batchCount();
            for (Map.Entry entry : MotionEtlGlobalCtx.getInstance().getEtlMessage().entrySet()) {
                preparedStatement.setString(1, (String)entry.getKey());
                preparedStatement.setString(2, (String)entry.getValue());
                preparedStatement.addBatch();
                if (++rowCount % batchSize != 0) continue;
                preparedStatement.executeBatch();
            }
            if (rowCount % batchSize != 0) {
                preparedStatement.executeBatch();
            }
        }
        catch (SQLException e) {
            EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
        }
        finally {
            JdbcUtils.close((AutoCloseable)preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> queryCountSql(Connection connection, String countSql) {
        HashMap<String, String> hashMap;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.info("\u7edf\u8ba1\u5bf9\u8c61\u6d88\u606f [{}]", (Object)countSql);
            preparedStatement = connection.prepareStatement(countSql);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, String> info = new HashMap<String, String>(100);
            while (resultSet.next()) {
                info.put(MotionEtlGlobalCtx.getInstance().ignoreCase(resultSet.getString(1)), resultSet.getString(2));
            }
            hashMap = info;
        }
        catch (Exception e) {
            HashMap<String, String> hashMap2;
            try {
                EtlGlobalCtx.INSTANCE.handleException((Throwable)e);
                hashMap2 = new HashMap<String, String>(8);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(preparedStatement);
                JdbcUtils.close(resultSet);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return hashMap2;
        }
        JdbcUtils.close((AutoCloseable)preparedStatement);
        JdbcUtils.close((AutoCloseable)resultSet);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, TableInfo> fetchTableColumnInfo(Connection connection, String sql) {
        HashMap<String, TableInfo> hashMap;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.info("\u8bfb\u53d6\u5217\u3001\u7ea6\u675f\u4fe1\u606f [{}]", (Object)sql);
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            HashMap<String, TableInfo> tableColumnInfo = new HashMap<String, TableInfo>(100);
            while (resultSet.next()) {
                String schema = resultSet.getString(1);
                String tableName = MotionEtlGlobalCtx.getInstance().ignoreCase(resultSet.getString(2));
                TableInfo tableInfo = tableColumnInfo.computeIfAbsent(tableName, k -> new TableInfo());
                tableInfo.setSchema(schema);
                tableInfo.setTableName(tableName);
                tableInfo.addColumn(resultSet.getString(3), resultSet.getString(4));
                String uniqueIndexType = resultSet.getString(5);
                if (!"1".equals(uniqueIndexType)) continue;
                tableInfo.addUniqueIndexCols(resultSet.getString(3));
            }
            hashMap = tableColumnInfo;
        }
        catch (SQLException e) {
            HashMap<String, TableInfo> hashMap2;
            try {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
                hashMap2 = new HashMap<String, TableInfo>(16);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(preparedStatement);
                JdbcUtils.close(resultSet);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return hashMap2;
        }
        JdbcUtils.close((AutoCloseable)preparedStatement);
        JdbcUtils.close((AutoCloseable)resultSet);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Object>> fetchTableData(Connection connection, String sql) {
        ArrayList<List<Object>> arrayList;
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.info("\u8bfb\u53d6\u5217\u3001\u7ea6\u675f\u4fe1\u606f [{}]", (Object)sql);
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (resultSet.next()) {
                ArrayList<Object> rowList = new ArrayList<Object>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    rowList.add(resultSet.getObject(i));
                }
                resultList.add(rowList);
            }
            arrayList = resultList;
        }
        catch (SQLException e) {
            ArrayList<List<Object>> arrayList2;
            try {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
                arrayList2 = resultList;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(preparedStatement);
                JdbcUtils.close(resultSet);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return arrayList2;
        }
        JdbcUtils.close((AutoCloseable)preparedStatement);
        JdbcUtils.close((AutoCloseable)resultSet);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> queryNotNullColumnsSql(Connection connection, String sql) {
        HashSet<String> hashSet;
        HashSet<String> set = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            log.debug("\u8bfb\u53d6\u5217\u3001\u7ea6\u675f\u4fe1\u606f [{}]", (Object)sql);
            preparedStatement = connection.prepareStatement(sql);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                set.add(resultSet.getString(1));
            }
            hashSet = set;
        }
        catch (SQLException e) {
            HashSet<String> hashSet2;
            try {
                EtlGlobalCtx.INSTANCE.handleException(sql, (Throwable)e);
                hashSet2 = set;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(preparedStatement);
                JdbcUtils.close(resultSet);
                throw throwable;
            }
            JdbcUtils.close((AutoCloseable)preparedStatement);
            JdbcUtils.close((AutoCloseable)resultSet);
            return hashSet2;
        }
        JdbcUtils.close((AutoCloseable)preparedStatement);
        JdbcUtils.close((AutoCloseable)resultSet);
        return hashSet;
    }
}

