/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.utils;

import com.hundsun.lightdb.core.KeyValuePair;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class StrategyUtils {
    private static final Logger log = LoggerFactory.getLogger(StrategyUtils.class);

    public static int getCreateViewTypeCode(KeyValuePair ddlSQL) {
        String sql = ddlSQL.getValue();
        String regex = "(?s)(?i)(/\\*\\*.*?\\*|/\\*\\*.*?\\*/)";
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(sql);
        boolean bool = matcher.find();
        if (bool) {
            return 3;
        }
        if (sql.toUpperCase().contains("UNION") || sql.toUpperCase().contains("UNION ALL")) {
            return 1;
        }
        return 1;
    }

    public static int getCreateProcedureTypeCode(KeyValuePair ddlSQL) {
        String sql = ddlSQL.getValue();
        String regex = "(?s)(?i)(/\\*\\*.*?\\*|/\\*\\*.*?\\*/)";
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(sql);
        boolean bool = matcher.find();
        if (bool) {
            return 3;
        }
        return 1;
    }

    public static String quoteWithMultiLetter(String braceStr) {
        if (braceStr == null || braceStr.equalsIgnoreCase("")) {
            return "";
        }
        if (".*".equals(braceStr)) {
            return ".*";
        }
        Pattern pattern = Pattern.compile("\\|");
        Matcher matcher = pattern.matcher(braceStr);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("\u5b57\u7b26\u4e32\u4e2d\u7684 \"|\" \u5c0f\u4e8e\u7b49\u4e8e0\u4e2a");
            }
            return Pattern.quote(braceStr);
        }
        char firstChar = braceStr.charAt(0);
        char lastChar = braceStr.charAt(braceStr.length() - 1);
        String noBraceSQl = braceStr.substring(1, braceStr.length() - 1);
        if (log.isInfoEnabled()) {
            log.info("noBraceSQl is:{}", (Object)noBraceSQl);
        }
        String[] quotes = noBraceSQl.split("\\|");
        StringBuffer buf = new StringBuffer();
        for (String val : quotes) {
            buf.append(Pattern.quote(val) + "|");
        }
        buf.substring(0, buf.length() - 1);
        return firstChar + buf.toString().trim() + lastChar;
    }

    public static String getSplitDLLObjectByUnion(String sql, String ddlType) {
        ArrayList<Object> parts = new ArrayList<Object>();
        StringBuffer sb = new StringBuffer();
        String[] segments = sql.toUpperCase().split("UNION");
        if (segments.length <= 1) {
            return StrategyUtils.removeQuoteForDDLObject((String)sql, (String)ddlType, (String)".*", (String)"(IS|AS)");
        }
        for (int i = 0; i < segments.length; ++i) {
            String string = segments[i];
            if (i > 0 && !string.isEmpty()) {
                String string2 = StrategyUtils.removeQuoteForDDLObject((String)string, (String)"Select", (String)"*", (String)"From");
                parts.add(" UNION " + string2);
                continue;
            }
            String string3 = StrategyUtils.removeQuoteForDDLObject((String)string, (String)ddlType, (String)"(IS|AS)", (String)"SELECT");
            parts.add(string3);
        }
        if (parts.size() > 0 && sql.toUpperCase().startsWith("UNION")) {
            parts.set(0, "UNION" + (String)parts.get(0));
        }
        for (String string : parts) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String removeQuoteForDDLObject(String source, String firstKeyWord, String middleKeyWord, String lastKeyWord) {
        String pattern = "(?s)(?i)(" + Pattern.quote(firstKeyWord) + ".*?" + StrategyUtils.quoteWithMultiLetter((String)middleKeyWord) + ".*?" + StrategyUtils.quoteWithMultiLetter((String)lastKeyWord) + ")";
        if (log.isDebugEnabled()) {
            log.debug("==============================================================");
        }
        if (log.isDebugEnabled()) {
            log.debug("=====removeQuoteForDDLObject pattern is:{}==========", (Object)pattern);
        }
        if (log.isDebugEnabled()) {
            log.debug("***************************************************************");
        }
        Pattern regexPattern = Pattern.compile(pattern);
        Matcher matcher = regexPattern.matcher(source);
        int posBeign = 0;
        int posEnd = 0;
        if (!matcher.find()) {
            return source;
        }
        posBeign = matcher.start();
        posEnd = matcher.end();
        String begin = source.substring(0, posBeign);
        String middle = source.substring(posBeign, posEnd);
        int ch = 34;
        if (middle.indexOf(ch) != -1) {
            middle = middle.replaceAll("\"", "");
        }
        String end = source.substring(posEnd);
        return begin + middle + end;
    }

    public static List<Triple<String, String, String>> getDictionary(String ddlType) {
        ArrayList<Triple<String, String, String>> list = new ArrayList<Triple<String, String, String>>();
        list.add(Triple.of((Object)"IN ", (Object)"OUT", (Object)"INOUT"));
        list.add(Triple.of((Object)" OUT ", (Object)"", (Object)" INOUT "));
        switch (ddlType) {
            case "PROCEDURE": {
                list.add((Triple<String, String, String>)Triple.of((Object)"> ", (Object)"=", (Object)">="));
                list.add((Triple<String, String, String>)Triple.of((Object)"< ", (Object)"=", (Object)"<="));
                break;
            }
            case "FUNCTION": {
                list.add((Triple<String, String, String>)Triple.of((Object)"CONSTRAINT FOREIGN KEY", (Object)"", (Object)" FOREIGN KEY "));
                break;
            }
        }
        return list;
    }

    public static String regexReplace(String source, String firstKeyWord, String lastKeyWord, String replacement) {
        Matcher matcher = StrategyUtils.getMatcher((String)source, (String)firstKeyWord, (String)lastKeyWord);
        return matcher.replaceAll(replacement);
    }

    private static Matcher getMatcher(String source, String firstKeyWord, String lastKeyWord) {
        Pattern pattern = Pattern.compile("(?i)(" + Pattern.quote(firstKeyWord) + ".*?" + Pattern.quote(lastKeyWord) + ")");
        Matcher matcher = pattern.matcher(source);
        return matcher;
    }

    public static String removeQuoteForDDL(String source, String firstKeyWord, String lastKeyWord) {
        String pattern = String.format("(?si)%s.*?\\b%s\\b", firstKeyWord, lastKeyWord);
        if (log.isDebugEnabled()) {
            log.debug("==============================================================");
        }
        if (log.isDebugEnabled()) {
            log.debug("=====removeQuoteForDDLObject pattern is:{}==========", (Object)pattern);
        }
        if (log.isDebugEnabled()) {
            log.debug("***************************************************************");
        }
        Pattern regexPattern = Pattern.compile(pattern);
        Matcher matcher = regexPattern.matcher(source);
        int posBeign = 0;
        int posEnd = 0;
        if (!matcher.find()) {
            return source.replaceAll("\"", "");
        }
        posBeign = matcher.start();
        posEnd = matcher.end();
        String begin = source.substring(0, posBeign);
        String middle = source.substring(posBeign, posEnd);
        int ch = 34;
        if (middle.indexOf(ch) != -1) {
            middle = middle.replaceAll("\"", "");
        }
        String end = source.substring(posEnd);
        return begin + middle + end;
    }
}

