/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.jdbc.clientlogic;

import com.huawei.opengauss.jdbc.jdbc.clientlogic.ClientLogicImpl;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.LimitOffsetMetaData;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.SortColumnMetaData;
import com.huawei.opengauss.jdbc.jdbc.clientlogic.TargetColumnMetaData;

public class SortingAndAggregationMetaData {
    private boolean postSortingRequired;
    private TargetColumnMetaData[] targetList;
    private SortColumnMetaData[] orderByList;
    private SortColumnMetaData[] groupByList;
    private LimitOffsetMetaData limitOffset;
    private boolean distinct;

    public boolean fetchDataFromLibPq(ClientLogicImpl impl) {
        this.postSortingRequired = impl.getSortingAndAggregationPostRequired();
        if (this.postSortingRequired) {
            int targetListLength = impl.getSortingAndAggregationTargetLength();
            if (targetListLength == 0) {
                this.postSortingRequired = false;
                return false;
            }
            this.targetList = new TargetColumnMetaData[targetListLength];
            for (int index = 0; index < targetListLength; ++index) {
                this.targetList[index] = impl.getSortingAndAggregationTargetAtIndex(index);
                if (this.targetList[index] != null) continue;
                this.postSortingRequired = false;
                return false;
            }
            int orderByListLength = impl.getSortingAndAggregationOrderByLength();
            this.orderByList = new SortColumnMetaData[orderByListLength];
            for (int index = 0; index < orderByListLength; ++index) {
                this.orderByList[index] = impl.getSortingAndAggregationOrderByAtIndex(index);
                if (this.orderByList[index] != null) continue;
                this.postSortingRequired = false;
                return false;
            }
            int groupByListLength = impl.getSortingAndAggregationGroupByLength();
            this.groupByList = new SortColumnMetaData[groupByListLength];
            for (int index = 0; index < groupByListLength; ++index) {
                this.groupByList[index] = impl.getSortingAndAggregationGroupByAtIndex(index);
                if (this.groupByList[index] != null) continue;
                this.postSortingRequired = false;
                return false;
            }
            this.limitOffset = impl.getSortingAndAggregationLimitOffset();
            if (this.limitOffset == null) {
                this.postSortingRequired = false;
                return false;
            }
            this.distinct = impl.getSortingAndAggregationDistinct();
        }
        return true;
    }

    public void cleanDataFromLibPq(ClientLogicImpl impl) {
        impl.resetSortingAndAggregation();
    }

    public boolean isPostProcessingRequired() {
        return this.postSortingRequired;
    }

    protected SortColumnMetaData[] getOrderByList() {
        return this.orderByList;
    }

    protected SortColumnMetaData[] getGroupByList() {
        return this.groupByList;
    }

    protected TargetColumnMetaData[] getTargetList() {
        return this.targetList;
    }

    protected LimitOffsetMetaData getLimitOffset() {
        return this.limitOffset;
    }

    protected boolean getDistinct() {
        return this.distinct;
    }
}

