/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.util;

import com.huawei.opengauss.jdbc.core.Parser;
import com.huawei.opengauss.jdbc.core.QueryExecutor;
import com.huawei.opengauss.jdbc.core.SetupQueryRunner;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.GT;
import com.huawei.opengauss.jdbc.util.PSQLException;
import com.huawei.opengauss.jdbc.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class HintNodeName {
    private static Log LOGGER = Logger.getLogger(HintNodeName.class.getName());
    private static long lastUpdated = System.currentTimeMillis();
    private static final long MIN_UPDATAED = 10000L;
    private static List<String> allNode = new ArrayList<String>();
    private static char[] specialChar = new char[]{'+', '-', '*', '/', ' ', '\n', '\r', '\t'};
    private static char[] jumpChar = new char[]{')', '/', '\'', '\"', '(', '-'};

    public static String addNodeName(String query, String nodeName, QueryExecutor queryExecutor) throws SQLException {
        if (nodeName == null || nodeName.isEmpty()) {
            return query;
        }
        HintNodeName.containsSqlInjection(nodeName, queryExecutor);
        char[] tempSql = query.toCharArray();
        boolean isSelect = false;
        boolean isSelectStatement = false;
        int parenthesesClose = 0;
        for (int i = 0; i < tempSql.length; ++i) {
            if (tempSql[i] == '/' && i + 2 < tempSql.length && tempSql[i + 1] == '*') {
                if (isSelect) {
                    return HintNodeName.addHint(i, nodeName, tempSql, query);
                }
                i = Parser.parseBlockComment(tempSql, i);
                continue;
            }
            if (tempSql[i] == '-' && i + 1 < tempSql.length && tempSql[i + 1] == '-') {
                i = Parser.parseLineComment(tempSql, i);
                continue;
            }
            if (Parser.isSpecialCharacters(tempSql[i])) continue;
            if (tempSql[i] == '(') {
                if (!isSelectStatement) continue;
                if (isSelect) {
                    return HintNodeName.addHint(i, nodeName, tempSql, query);
                }
                ++parenthesesClose;
                continue;
            }
            if (tempSql[i] == ')') {
                --parenthesesClose;
                continue;
            }
            if (tempSql[i] == '\"') {
                i = Parser.parseDoubleQuotes(tempSql, i);
                continue;
            }
            if (tempSql[i] == '\'') {
                i = Parser.parseSingleQuotes(tempSql, i, true);
                continue;
            }
            if (!(tempSql[i] != 's' && tempSql[i] != 'S' || i + 5 >= tempSql.length || isSelect)) {
                if (parenthesesClose != 0 || !"select".equalsIgnoreCase(String.valueOf(tempSql[i]) + tempSql[i + 1] + tempSql[i + 2] + tempSql[i + 3] + tempSql[i + 4] + tempSql[i + 5])) continue;
                isSelect = HintNodeName.isSpecialCharacters(i + 6, tempSql);
                if (isSelect) {
                    isSelectStatement = true;
                }
                i += 5;
                continue;
            }
            if (!(tempSql[i] != 'w' && tempSql[i] != 'W' || i + 3 >= tempSql.length || isSelectStatement)) {
                if (!"with".equalsIgnoreCase(String.valueOf(tempSql[i]) + tempSql[i + 1] + tempSql[i + 2] + tempSql[i + 3])) continue;
                isSelectStatement = HintNodeName.isSpecialCharacters(i + 4, tempSql);
                i += 3;
                continue;
            }
            if (isSelect) {
                return HintNodeName.addHint(i, nodeName, tempSql, query);
            }
            if (!isSelectStatement) {
                return query;
            }
            i = HintNodeName.crossThisString(i, tempSql);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Add a single slice query statement to the SQL statement:" + String.valueOf(tempSql));
        }
        return query;
    }

    private static String addHint(int offSet, String nodeName, char[] sqlChars, String query) {
        String newSql;
        int tempOffSet = offSet;
        if (sqlChars[tempOffSet] == '/' && tempOffSet + 2 < sqlChars.length && sqlChars[tempOffSet + 1] == '*' && sqlChars[tempOffSet + 2] == '+') {
            tempOffSet = Parser.parseBlockComment(sqlChars, tempOffSet) - 1;
            newSql = query.substring(0, tempOffSet) + " set(node_name " + nodeName + ") " + query.substring(tempOffSet);
        } else {
            newSql = query.substring(0, tempOffSet) + "/*+ set(node_name " + nodeName + ") */ " + query.substring(tempOffSet);
        }
        return newSql;
    }

    public static void containsSqlInjection(String nodeName, QueryExecutor queryExecutor) throws SQLException {
        if (nodeName.contains(";") || nodeName.contains("/*") || nodeName.contains("*/")) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.warn("Illegal node name:" + nodeName);
            }
            throw new PSQLException(GT.tr("Illegal node name:" + nodeName + ".", new Object[0]), PSQLState.DATA_ERROR);
        }
        HintNodeName.nodeNameCheck(nodeName, queryExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateAllNode(QueryExecutor queryExecutor) throws SQLException {
        String query = "select node_name from pgxc_node where node_type='D' and nodeis_active='t'";
        List<byte[][]> results = SetupQueryRunner.runForList(queryExecutor, query, true);
        List<String> list = allNode;
        synchronized (list) {
            try {
                long nowTime = System.currentTimeMillis();
                if (allNode.size() != 0 && nowTime - lastUpdated < 10000L) {
                    return;
                }
                allNode.clear();
                for (byte[][] result : results) {
                    allNode.add(queryExecutor.getEncoding().decode(result[0]));
                }
                lastUpdated = nowTime;
            }
            catch (IOException e) {
                allNode.clear();
                throw new SQLException("Fail to check pgxc_node." + e.getMessage());
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Currently available DN nodes:" + allNode);
        }
    }

    private static boolean isSpecialCharacters(int offSet, char[] tempSql) {
        if (offSet >= tempSql.length) {
            return true;
        }
        char tempChar = tempSql[offSet];
        for (char specialChar : HintNodeName.specialChar) {
            if (specialChar != tempChar) continue;
            return true;
        }
        return false;
    }

    private static boolean jumpCharacters(char specialChar) {
        for (char jump : jumpChar) {
            if (jump != specialChar) continue;
            return true;
        }
        return false;
    }

    private static int crossThisString(int offSet, char[] tempSql) {
        for (int i = offSet + 1; i < tempSql.length; ++i) {
            if (Parser.isSpecialCharacters(tempSql[i])) {
                return i - 1;
            }
            if (!HintNodeName.jumpCharacters(tempSql[i])) continue;
            return i - 1;
        }
        return tempSql.length - 1;
    }

    private static void nodeNameCheck(String nodeName, QueryExecutor queryExecutor) throws SQLException {
        if (!allNode.contains(nodeName)) {
            HintNodeName.updateAllNode(queryExecutor);
            if (!allNode.contains(nodeName)) {
                throw new PSQLException(GT.tr("Node name " + nodeName + " does not exist.", new Object[0]), PSQLState.DATA_ERROR);
            }
        }
    }
}

