/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.core;

import com.huawei.opengauss.jdbc.PGProperty;
import com.huawei.opengauss.jdbc.core.PGStream;
import com.huawei.opengauss.jdbc.core.QueryExecutor;
import com.huawei.opengauss.jdbc.core.v3.ConnectionFactoryImpl;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.GT;
import com.huawei.opengauss.jdbc.util.HostSpec;
import com.huawei.opengauss.jdbc.util.PSQLException;
import com.huawei.opengauss.jdbc.util.PSQLState;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    private static Log LOGGER = Logger.getLogger(ConnectionFactory.class.getName());
    private static final String PROTOCOL_VERSION_1_STR = "1";
    private static final String PROTOCOL_VERSION_3_STR = "3";

    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || protoName.isEmpty() || PROTOCOL_VERSION_1_STR.equals(protoName) || PROTOCOL_VERSION_3_STR.equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info)) != null) {
            return queryExecutor;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4) throws SQLException;

    protected void closeStream(PGStream newStream) {
        block3: {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Catch IOException on close:", e);
                }
            }
        }
    }
}

