/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.core.v3;

import com.huawei.opengauss.jdbc.core.CachedQuery;
import com.huawei.opengauss.jdbc.core.NativeQuery;
import com.huawei.opengauss.jdbc.core.ParameterList;
import com.huawei.opengauss.jdbc.core.v3.SimpleQuery;
import com.huawei.opengauss.jdbc.core.v3.TypeTransferModeRegistry;

public class BatchedQuery
extends SimpleQuery {
    private String sql;
    private final int valuesBraceOpenPosition;
    private final int valuesBraceClosePosition;
    private final int batchSize;
    private BatchedQuery[] blocks;
    private CachedQuery originalPrepareQuery;

    public BatchedQuery(NativeQuery query, TypeTransferModeRegistry transferModeRegistry, int valuesBraceOpenPosition, int valuesBraceClosePosition, boolean sanitiserDisabled) {
        super(query, transferModeRegistry, sanitiserDisabled);
        this.valuesBraceOpenPosition = valuesBraceOpenPosition;
        this.valuesBraceClosePosition = valuesBraceClosePosition;
        this.batchSize = 1;
    }

    private BatchedQuery(BatchedQuery src, int batchSize) {
        super(src);
        this.valuesBraceOpenPosition = src.valuesBraceOpenPosition;
        this.valuesBraceClosePosition = src.valuesBraceClosePosition;
        this.batchSize = batchSize;
    }

    public BatchedQuery deriveForMultiBatch(int valueBlock) {
        BatchedQuery bq;
        if (this.getBatchSize() != 1) {
            throw new IllegalStateException("Only the original decorator can be derived.");
        }
        if (valueBlock == 1) {
            return this;
        }
        int index = Integer.numberOfTrailingZeros(valueBlock) - 1;
        if (valueBlock > 128 || valueBlock != 1 << index + 1) {
            throw new IllegalArgumentException("Expected value block should be a power of 2 smaller or equal to 128. Actual block is " + valueBlock);
        }
        if (this.blocks == null) {
            this.blocks = new BatchedQuery[7];
        }
        if ((bq = this.blocks[index]) == null) {
            this.blocks[index] = bq = new BatchedQuery(this, valueBlock);
        }
        return bq;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getNativeSql() {
        if (this.sql != null) {
            return this.sql;
        }
        this.sql = this.buildNativeSql(null);
        return this.sql;
    }

    public CachedQuery getOriginalPrepareQuery() {
        return this.originalPrepareQuery;
    }

    public void setOriginalPrepareQuery(CachedQuery originalPrepareQuery) {
        this.originalPrepareQuery = originalPrepareQuery;
    }

    private String buildNativeSql(ParameterList params) {
        int pos;
        String buildSql = null;
        String nativeSql = super.getNativeSql();
        int batch = this.getBatchSize();
        if (batch < 2) {
            buildSql = nativeSql;
            return buildSql;
        }
        if (nativeSql == null) {
            buildSql = "";
            return buildSql;
        }
        int valuesBlockCharCount = 0;
        int[] bindPositions = this.getNativeQuery().bindPositions;
        int[] chunkStart = new int[1 + bindPositions.length];
        int[] chunkEnd = new int[1 + bindPositions.length];
        chunkStart[0] = this.valuesBraceOpenPosition;
        if (bindPositions.length == 0) {
            valuesBlockCharCount = this.valuesBraceClosePosition - this.valuesBraceOpenPosition + 1;
            chunkEnd[0] = this.valuesBraceClosePosition + 1;
        } else {
            chunkEnd[0] = bindPositions[0];
            valuesBlockCharCount += chunkEnd[0] - chunkStart[0];
            for (int i = 0; i < bindPositions.length; ++i) {
                int startIndex;
                int endIndex;
                int n = endIndex = i < bindPositions.length - 1 ? bindPositions[i + 1] : this.valuesBraceClosePosition + 1;
                for (startIndex = bindPositions[i] + 2; startIndex < endIndex && Character.isDigit(nativeSql.charAt(startIndex)); ++startIndex) {
                }
                chunkStart[i + 1] = startIndex;
                chunkEnd[i + 1] = endIndex;
                valuesBlockCharCount += chunkEnd[i + 1] - chunkStart[i + 1];
            }
        }
        int length = nativeSql.length();
        length += NativeQuery.calculateBindLength(bindPositions.length * batch);
        length -= NativeQuery.calculateBindLength(bindPositions.length);
        StringBuilder s = new StringBuilder(length += (valuesBlockCharCount + 1) * (batch - 1));
        if (bindPositions.length > 0 && params == null) {
            s.append(nativeSql, 0, this.valuesBraceClosePosition + 1);
            pos = bindPositions.length + 1;
        } else {
            pos = 1;
            ++batch;
            s.append(nativeSql, 0, this.valuesBraceOpenPosition);
        }
        for (int i = 2; i <= batch; ++i) {
            if (i > 2 || pos != 1) {
                s.append(',');
            }
            s.append(nativeSql, chunkStart[0], chunkEnd[0]);
            for (int j = 1; j < chunkStart.length; ++j) {
                if (params == null) {
                    NativeQuery.appendBindName(s, pos++);
                } else {
                    s.append(params.toString(pos++, true));
                }
                s.append(nativeSql, chunkStart[j], chunkEnd[j]);
            }
        }
        s.append(nativeSql, this.valuesBraceClosePosition + 1, nativeSql.length());
        buildSql = s.toString();
        assert (params != null || s.length() == length) : "Predicted length != actual: " + length + " !=" + s.length();
        return buildSql;
    }

    @Override
    public String toString(ParameterList params) {
        if (this.getBatchSize() < 2) {
            return super.toString(params);
        }
        return this.buildNativeSql(params);
    }
}

