/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.hostchooser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DomainResolveInfo {
    private String domainName;
    private List<String> hostIps = new ArrayList<String>();
    private long updateInterval;
    private long lastUpdated;

    public DomainResolveInfo(String domainName, long updateInterval) {
        this.domainName = domainName;
        this.updateInterval = updateInterval;
        this.lastUpdated = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (o instanceof DomainResolveInfo) {
            DomainResolveInfo objInfo = (DomainResolveInfo)o;
            return Objects.equals(this.domainName, objInfo.domainName);
        }
        return false;
    }

    public int hashCode() {
        return this.domainName.hashCode();
    }

    public String toString() {
        return this.domainName + " " + this.hostIps;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public List<String> getHostIps() {
        return this.hostIps;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setHostIps(List<String> hostIps) {
        this.hostIps = hostIps;
        this.lastUpdated = System.currentTimeMillis();
    }

    public void refreshLastUpdated() {
        this.lastUpdated = System.currentTimeMillis();
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }
}

