/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.hostchooser;

import com.huawei.opengauss.jdbc.PGProperty;
import com.huawei.opengauss.jdbc.hostchooser.DomainResolveInfo;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.PSQLException;
import com.huawei.opengauss.jdbc.util.PSQLState;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalDomainResolveTracker {
    private static Log LOGGER = Logger.getLogger("GlobalDomainResolveTracker");
    private static ConcurrentHashMap<String, DomainResolveInfo> domainResolveMap = new ConcurrentHashMap();

    public static boolean checkDomainIp(String domain, String ip) {
        DomainResolveInfo resolveInfo = domainResolveMap.get(domain);
        return resolveInfo != null && resolveInfo.getHostIps() != null && resolveInfo.getHostIps().contains(ip);
    }

    protected static List<String> resolveDomain(String domainName) throws SQLException {
        InetAddress[] addrs;
        try {
            addrs = InetAddress.getAllByName(domainName);
        }
        catch (UnknownHostException e) {
            throw new PSQLException("[GlobalDomainResolveTracker]failed to parse domain name '" + domainName + "'", PSQLState.IO_ERROR, (Throwable)e);
        }
        ArrayList<String> ips = new ArrayList<String>();
        for (InetAddress addr : addrs) {
            if (ips.contains(addr.getHostAddress())) continue;
            ips.add(addr.getHostAddress());
        }
        Collections.sort(ips);
        return ips;
    }

    public static DomainResolveInfo refreshOrCreateResolveInfo(String domainName, long updateInterval) throws SQLException {
        DomainResolveInfo resolveInfo = domainResolveMap.get(domainName);
        if (resolveInfo == null) {
            resolveInfo = new DomainResolveInfo(domainName, updateInterval);
            GlobalDomainResolveTracker.refreshResolveInfo(resolveInfo);
            DomainResolveInfo preValue = domainResolveMap.putIfAbsent(domainName, resolveInfo);
            return preValue == null ? resolveInfo : preValue;
        }
        if (resolveInfo.getLastUpdated() + resolveInfo.getLastUpdated() <= System.currentTimeMillis()) {
            GlobalDomainResolveTracker.refreshResolveInfo(resolveInfo);
            return resolveInfo;
        }
        return resolveInfo;
    }

    public static void refreshResolveInfo(DomainResolveInfo resolveInfo) throws SQLException {
        if (resolveInfo == null) {
            return;
        }
        List<String> ips = GlobalDomainResolveTracker.resolveDomain(resolveInfo.getDomainName());
        if (!ips.equals(resolveInfo.getHostIps())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[GlobalDomainResolveTracker] domain resolve result updated for " + resolveInfo.getDomainName() + " from " + resolveInfo.getHostIps() + " to " + ips);
                resolveInfo.setHostIps(ips);
            }
        } else {
            resolveInfo.refreshLastUpdated();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[GlobalDomainResolveTracker] do not need to update domain resolve result for " + resolveInfo.getDomainName() + " with hostIps " + resolveInfo.getHostIps());
            }
        }
    }

    public static Set<DomainResolveInfo> getExpiredDomains() {
        HashSet<DomainResolveInfo> domainResolveInfos = new HashSet<DomainResolveInfo>();
        long currentTimeMillis = System.currentTimeMillis();
        for (DomainResolveInfo value : domainResolveMap.values()) {
            if (value.getLastUpdated() + 1000L * value.getUpdateInterval() > currentTimeMillis) continue;
            domainResolveInfos.add(value);
        }
        return domainResolveInfos;
    }

    public static boolean isValidPriorityAndPrimaryDomains(Properties props) {
        int lengthPgPortUrl;
        int priorityDomains;
        int primaryDomains;
        try {
            primaryDomains = PGProperty.PRIMARY_DOMAINS.getInt(props);
            priorityDomains = PGProperty.PRIORITY_DOMAINS.getInt(props);
            String pgPrortUrl = PGProperty.PG_PORT_URL.get(props);
            lengthPgPortUrl = pgPrortUrl == null ? 0 : pgPrortUrl.split(",").length;
        }
        catch (PSQLException e) {
            LOGGER.warn("When configuring primary domains, \"primaryDomains\" should be number.");
            return false;
        }
        if (primaryDomains < 0) {
            LOGGER.warn("When configuring primary domains, The number of primary domains should not be less than 0.");
            return false;
        }
        if (priorityDomains < 0) {
            LOGGER.warn("When configuring priority domains, The number of priority domains should not be less than 0.");
            return false;
        }
        if (primaryDomains >= lengthPgPortUrl) {
            LOGGER.warn("When configuring primary domains, The number of primary domains should be less than  the number of nodes on the URL.");
            return false;
        }
        if (priorityDomains >= lengthPgPortUrl) {
            LOGGER.warn("When configuring priority domains, The number of priority domains should be less than  the number of nodes on the URL.");
            return false;
        }
        if ((priorityDomains >= primaryDomains || priorityDomains + primaryDomains >= lengthPgPortUrl) && primaryDomains > 0) {
            LOGGER.warn("When configuring priority domains, The number of priority domains should be less than the number of clusters nodes.");
            return false;
        }
        return true;
    }

    public static boolean isVaildPrimaryDomains(Properties props) {
        try {
            return PGProperty.PRIMARY_DOMAINS.getInt(props) != 0;
        }
        catch (PSQLException e) {
            LOGGER.warn("When configuring primary domains, \"primaryDomains\" should be number.");
            return false;
        }
    }
}

