/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.opengauss.jdbc.util;

import com.huawei.opengauss.jdbc.core.EncodingPredictor;
import com.huawei.opengauss.jdbc.log.Log;
import com.huawei.opengauss.jdbc.log.Logger;
import com.huawei.opengauss.jdbc.util.GT;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ServerErrorMessage
implements Serializable {
    private static Log LOGGER = Logger.getLogger(ServerErrorMessage.class.getName());
    private static final Character SEVERITY = Character.valueOf('S');
    private static final Character MESSAGE = Character.valueOf('M');
    private static final Character DETAIL = Character.valueOf('D');
    private static final Character HINT = Character.valueOf('H');
    private static final Character POSITION = Character.valueOf('P');
    private static final Character WHERE = Character.valueOf('W');
    private static final Character FILE = Character.valueOf('F');
    private static final Character LINE = Character.valueOf('L');
    private static final Character ROUTINE = Character.valueOf('R');
    private static final Character SQLSTATE = Character.valueOf('C');
    private static final Character ERRORCODE = Character.valueOf('c');
    private static final Character INTERNAL_POSITION = Character.valueOf('p');
    private static final Character INTERNAL_QUERY = Character.valueOf('q');
    private static final Character SOCKET_ADDRESS = Character.valueOf('a');
    private final Map<Character, String> m_mesgParts = new HashMap<Character, String>();

    public ServerErrorMessage(EncodingPredictor.DecodeResult serverError, String socketAddress) {
        this(serverError.result, socketAddress);
        if (serverError.encoding != null) {
            this.m_mesgParts.put(MESSAGE, this.m_mesgParts.get(MESSAGE) + GT.tr(" (pgjdbc: autodetected server-encoding to be {0}, if the message is not readable, please check database logs and/or host, port, dbname, user, password, pg_hba.conf)", serverError.encoding));
        }
    }

    public ServerErrorMessage(String p_serverError) {
        char[] l_chars = p_serverError.toCharArray();
        int l_length = l_chars.length;
        for (int l_pos = 0; l_pos < l_length; ++l_pos) {
            char l_mesgType = l_chars[l_pos];
            if (l_mesgType == '\u0000') continue;
            int l_startString = ++l_pos;
            while (l_pos < l_length && l_chars[l_pos] != '\u0000') {
                ++l_pos;
            }
            String l_mesgPart = new String(l_chars, l_startString, l_pos - l_startString);
            this.m_mesgParts.put(Character.valueOf(l_mesgType), l_mesgPart);
        }
    }

    public ServerErrorMessage(String p_serverError, String socketAddress) {
        this(p_serverError);
        this.m_mesgParts.put(SOCKET_ADDRESS, socketAddress);
    }

    public String getSQLState() {
        return this.m_mesgParts.get(SQLSTATE);
    }

    public String getERRORCODE() {
        return this.m_mesgParts.get(ERRORCODE);
    }

    public String getMessage() {
        return this.m_mesgParts.get(MESSAGE);
    }

    public String getSeverity() {
        return this.m_mesgParts.get(SEVERITY);
    }

    public String getDetail() {
        return this.m_mesgParts.get(DETAIL);
    }

    public String getHint() {
        return this.m_mesgParts.get(HINT);
    }

    public int getPosition() {
        return this.getIntegerPart(POSITION);
    }

    public String getWhere() {
        return this.m_mesgParts.get(WHERE);
    }

    public String getFile() {
        return this.m_mesgParts.get(FILE);
    }

    public int getLine() {
        return this.getIntegerPart(LINE);
    }

    public String getRoutine() {
        return this.m_mesgParts.get(ROUTINE);
    }

    public String getInternalQuery() {
        return this.m_mesgParts.get(INTERNAL_QUERY);
    }

    public int getInternalPosition() {
        return this.getIntegerPart(INTERNAL_POSITION);
    }

    private int getIntegerPart(Character c) {
        String s = this.m_mesgParts.get(c);
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public String toString() {
        StringBuilder l_totalMessage = new StringBuilder();
        String l_message = this.m_mesgParts.get(SOCKET_ADDRESS);
        if (l_message != null) {
            l_totalMessage.append("[" + l_message + "] ");
        }
        if ((l_message = this.m_mesgParts.get(SEVERITY)) != null) {
            l_totalMessage.append(l_message).append(": ");
        }
        if ((l_message = this.m_mesgParts.get(MESSAGE)) != null) {
            l_totalMessage.append(l_message);
        }
        if ((l_message = this.m_mesgParts.get(DETAIL)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Detail: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(HINT)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Hint: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(POSITION)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Position: {0}", l_message));
        }
        if ((l_message = this.m_mesgParts.get(WHERE)) != null) {
            l_totalMessage.append("\n  ").append(GT.tr("Where: {0}", l_message));
        }
        if (LOGGER.isTraceEnabled()) {
            String l_internalPosition;
            String l_internalQuery = this.m_mesgParts.get(INTERNAL_QUERY);
            if (l_internalQuery != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Internal Query: {0}", l_internalQuery));
            }
            if ((l_internalPosition = this.m_mesgParts.get(INTERNAL_POSITION)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Internal Position: {0}", l_internalPosition));
            }
            String l_file = this.m_mesgParts.get(FILE);
            String l_line = this.m_mesgParts.get(LINE);
            String l_routine = this.m_mesgParts.get(ROUTINE);
            if (l_file != null || l_line != null || l_routine != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Location: File: {0}, Routine: {1}, Line: {2}", l_file, l_routine, l_line));
            }
            if ((l_message = this.m_mesgParts.get(SQLSTATE)) != null) {
                l_totalMessage.append("\n  ").append(GT.tr("Server SQLState: {0}", l_message));
            }
        }
        return l_totalMessage.toString();
    }
}

