/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.controller;

import com.github.pagehelper.PageInfo;
import com.hundsun.lightdb.motion.base.Result;
import com.hundsun.lightdb.motion.entity.DataBaseInfoEntity;
import com.hundsun.lightdb.motion.enums.NoticeEnum;
import com.hundsun.lightdb.motion.service.DatabaseInfoService;
import com.hundsun.lightdb.motion.vo.request.DatabaseInfoAddReqVo;
import com.hundsun.lightdb.motion.vo.request.DatabaseInfoQueryReqVo;
import com.hundsun.lightdb.motion.vo.request.DatabaseInfoUpdateReqVo;
import com.hundsun.lightdb.motion.vo.response.DatabaseInfoAddRespVo;
import com.hundsun.lightdb.motion.vo.response.DatabaseInfoRespVo;
import com.hundsun.lightdb.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/databaseinfo"})
@Api(tags={"\u6570\u636e\u5e93"})
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class DatabaseInfoController {
    @Autowired
    private DatabaseInfoService databaseInfoService;

    @RequestMapping(value={"/selectbyid"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5e93\u4fe1\u606f")
    public Result<DatabaseInfoRespVo> selectById(String databaseId) {
        DataBaseInfoEntity databaseInfoEntity = (DataBaseInfoEntity)this.databaseInfoService.get(databaseId);
        DatabaseInfoRespVo databaseInfoRespVo = (DatabaseInfoRespVo)BeanCopyUtil.copy((Object)databaseInfoEntity, DatabaseInfoRespVo.class);
        return Result.success((Object)databaseInfoRespVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93\u4fe1\u606f")
    public Result delete(String databaseId) {
        int result = this.databaseInfoService.delete(databaseId);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u4fe1\u606f")
    public Result<DatabaseInfoAddRespVo> add(@RequestBody @Valid DatabaseInfoAddReqVo databaseInfoAddReqVo) {
        String connectionName = databaseInfoAddReqVo.getConnectName();
        if (this.databaseInfoService.getConnectionConfig(connectionName).booleanValue()) {
            return Result.fail((String)"\u5df2\u7ecf\u5b58\u5728\u8fde\u63a5\u540d,\u8bf7\u66f4\u6539\u8fde\u63a5\u540d\u4fe1\u606f");
        }
        DataBaseInfoEntity dataBaseInfoEntity = (DataBaseInfoEntity)BeanCopyUtil.copy((Object)databaseInfoAddReqVo, DataBaseInfoEntity.class);
        String result = this.databaseInfoService.post((Object)dataBaseInfoEntity);
        DatabaseInfoAddRespVo databaseInfoAddRespVo = new DatabaseInfoAddRespVo();
        databaseInfoAddRespVo.setDatabaseId(result);
        return Result.successWithDataAndMessage((Object)databaseInfoAddRespVo, (String)NoticeEnum.HANDLER_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/checkdatabaseconnection"}, method={RequestMethod.POST})
    @ApiOperation(value="\u68c0\u6d4b\u6570\u636e\u5e93\u662f\u5426\u53ef\u8fde\u63a5")
    public Result checkDataBaseConnection(@RequestBody @Valid DatabaseInfoAddReqVo databaseInfoAddReqVo) {
        DataBaseInfoEntity dataBaseInfoEntity = (DataBaseInfoEntity)BeanCopyUtil.copy((Object)databaseInfoAddReqVo, DataBaseInfoEntity.class);
        this.databaseInfoService.getDataBaseConnection(dataBaseInfoEntity);
        return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u5e93\u4fe1\u606f")
    public Result update(@RequestBody DatabaseInfoUpdateReqVo databaseInfoUpdateReqVo) {
        DataBaseInfoEntity dataBaseInfoEntity = (DataBaseInfoEntity)BeanCopyUtil.copy((Object)databaseInfoUpdateReqVo, DataBaseInfoEntity.class);
        int result = this.databaseInfoService.put((Object)dataBaseInfoEntity);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }

    @RequestMapping(value={"/selectlist"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5e93\u4fe1\u606f\u5217\u8868")
    public Result<PageInfo<DatabaseInfoRespVo>> getDatabaseInfoById(@RequestBody DatabaseInfoQueryReqVo databaseInfoQueryReqVo) {
        PageInfo pageInfo = this.databaseInfoService.getList(databaseInfoQueryReqVo);
        return Result.success((Object)pageInfo);
    }
}

