/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.controller;

import com.github.pagehelper.PageInfo;
import com.hundsun.lightdb.motion.base.Result;
import com.hundsun.lightdb.motion.entity.TaskRecordEntity;
import com.hundsun.lightdb.motion.enums.NoticeEnum;
import com.hundsun.lightdb.motion.service.TaskRecordService;
import com.hundsun.lightdb.motion.vo.request.TaskRecordQueryReqVo;
import com.hundsun.lightdb.motion.vo.response.TaskRecordRespVo;
import com.hundsun.lightdb.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taskrecord"})
@Api(tags={"\u4efb\u52a1\u6267\u884c\u8bb0\u5f55"})
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class TaskRecordController {
    @Autowired
    private TaskRecordService taskRecordService;

    @RequestMapping(value={"/selectbyid"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u8bb0\u5f55")
    public Result<TaskRecordRespVo> selectById(String taskRecordId) {
        TaskRecordEntity taskRecordEntity = (TaskRecordEntity)this.taskRecordService.get(taskRecordId);
        TaskRecordRespVo taskRecordRespVo = (TaskRecordRespVo)BeanCopyUtil.copy((Object)taskRecordEntity, TaskRecordRespVo.class);
        return Result.success((Object)taskRecordRespVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u6267\u884c\u8bb0\u5f55")
    public Result delete(String taskRecordId) {
        int result = this.taskRecordService.delete(taskRecordId);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }

    @RequestMapping(value={"/deletebytaskmainid"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u5220\u9664\u4efb\u52a1\u6267\u884c\u8bb0\u5f55")
    public Result deleteByTaskMainId(String tasMainId) {
        int result = this.taskRecordService.deleteByTaskMainId(tasMainId);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }

    @RequestMapping(value={"/selectlist"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u6267\u884c\u8bb0\u5f55\u5217\u8868")
    public Result<PageInfo<TaskRecordRespVo>> selectList(@RequestBody TaskRecordQueryReqVo taskRecordQueryReqVo) {
        PageInfo pageInfo = this.taskRecordService.getList(taskRecordQueryReqVo);
        return Result.success((Object)pageInfo);
    }
}

