/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.handler;

import com.hundsun.lightdb.motion.base.Result;
import com.hundsun.lightdb.motion.enums.NoticeEnum;
import com.hundsun.lightdb.motion.exception.MotionException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class MotionExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MotionExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public Object motionExceptionHandler(Exception ex) {
        List allErrors;
        if (log.isErrorEnabled()) {
            log.error(ex.getMessage());
        }
        if (ex instanceof MethodArgumentNotValidException && (allErrors = ((MethodArgumentNotValidException)ex).getBindingResult().getAllErrors()).size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            allErrors.forEach(error -> stringBuilder.append(error.getDefaultMessage()).append(","));
            return Result.fail((String)stringBuilder.toString());
        }
        if (ex instanceof MotionException) {
            return ((MotionException)ex).getResult();
        }
        return Result.fail((int)NoticeEnum.EXCEPTION_OCCUR.getCode(), (String)NoticeEnum.EXCEPTION_OCCUR.getMessage());
    }
}

