/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.service.impl;

import com.hundsun.lightdb.motion.dao.TaskConfigEntityMapper;
import com.hundsun.lightdb.motion.entity.TaskConfigEntity;
import com.hundsun.lightdb.motion.enums.DeleteStatusEnum;
import com.hundsun.lightdb.motion.service.TaskConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class TaskConfigServiceImpl
implements TaskConfigService {
    @Autowired
    private TaskConfigEntityMapper taskConfigEntityMapper;

    public String post(TaskConfigEntity taskConfigEntity) {
        this.taskConfigEntityMapper.insertSelective((Object)taskConfigEntity);
        return taskConfigEntity.getTaskConfigId();
    }

    public Integer put(TaskConfigEntity taskConfigEntity) {
        return this.taskConfigEntityMapper.updateByPrimaryKeySelective((Object)taskConfigEntity);
    }

    public Integer delete(String taskConfigId) {
        TaskConfigEntity taskConfigEntity = new TaskConfigEntity();
        taskConfigEntity.setTaskConfigId(taskConfigId);
        taskConfigEntity.setIsDeleted(DeleteStatusEnum.DELETED.getStatus());
        return this.taskConfigEntityMapper.updateByPrimaryKeySelective((Object)taskConfigEntity);
    }

    public Integer deleteByTaskMainId(String taskMainId) {
        return this.taskConfigEntityMapper.deleteByTaskMainId(taskMainId);
    }

    public List<TaskConfigEntity> getByTaskMainId(String taskMainId) {
        return this.taskConfigEntityMapper.selectByTaskMainId(taskMainId);
    }

    public List<TaskConfigEntity> getSchedule() {
        return this.taskConfigEntityMapper.selectSchedule();
    }
}

