/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.core;

import com.tencentcloud.tdsql.pg.core.BaseQueryKey;
import com.tencentcloud.tdsql.pg.core.CachedQuery;
import com.tencentcloud.tdsql.pg.core.CallableQueryKey;
import com.tencentcloud.tdsql.pg.core.JdbcCallParseInfo;
import com.tencentcloud.tdsql.pg.core.NativeQuery;
import com.tencentcloud.tdsql.pg.core.Parser;
import com.tencentcloud.tdsql.pg.core.Query;
import com.tencentcloud.tdsql.pg.core.QueryExecutor;
import com.tencentcloud.tdsql.pg.core.QueryWithReturningColumnsKey;
import com.tencentcloud.tdsql.pg.jdbc.PreferQueryMode;
import com.tencentcloud.tdsql.pg.util.LruCache;
import com.tencentcloud.tdsql.pg.util.internal.Nullness;
import java.sql.SQLException;
import java.util.List;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean outParamBeforeFunc;
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + key;
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        if (key instanceof String || Nullness.castNonNull(queryKey).escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), this.queryExecutor.getEscapeSyntaxCallMode());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParamBeforeFunc = callInfo.isOutParamBeforeFunc();
        } else {
            isFunction = false;
            outParamBeforeFunc = false;
        }
        boolean isParameterized = key instanceof String || Nullness.castNonNull(queryKey).isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), this.queryExecutor.getQuoteReturningIdentifiers(), returningColumns);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction, outParamBeforeFunc);
    }
}

