/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.core;

import com.tencentcloud.tdsql.pg.PGProperty;
import com.tencentcloud.tdsql.pg.ssl.LibPQFactory;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.ObjectFactory;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketFactoryFactory {
    public static SocketFactory getSocketFactory(Properties info) throws PSQLException {
        String socketFactoryClassName = PGProperty.SOCKET_FACTORY.get(info);
        if (socketFactoryClassName == null) {
            return SocketFactory.getDefault();
        }
        try {
            return ObjectFactory.instantiate(SocketFactory.class, socketFactoryClassName, info, true, PGProperty.SOCKET_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SocketFactory class provided {0} could not be instantiated.", socketFactoryClassName), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory(Properties info) throws PSQLException {
        String classname = PGProperty.SSL_FACTORY.get(info);
        if (classname == null || "com.tencentcloud.tdsql.pg.ssl.jdbc4.LibPQFactory".equals(classname) || "com.tencentcloud.tdsql.pg.ssl.LibPQFactory".equals(classname)) {
            return new LibPQFactory(info);
        }
        try {
            return ObjectFactory.instantiate(SSLSocketFactory.class, classname, info, true, PGProperty.SSL_FACTORY_ARG.get(info));
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
    }
}

