/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.geometric;

import com.tencentcloud.tdsql.pg.geometric.PGpoint;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.PGobject;
import com.tencentcloud.tdsql.pg.util.PGtokenizer;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGpath
extends PGobject
implements Serializable,
Cloneable {
    public boolean open;
    public PGpoint @Nullable [] points;

    public PGpath(PGpoint @Nullable [] points, boolean open) {
        this();
        this.points = points;
        this.open = open;
    }

    public PGpath() {
        this.type = "path";
    }

    public PGpath(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    @Override
    public void setValue(@Nullable String s) throws SQLException {
        if (s == null) {
            this.points = null;
            return;
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            this.open = true;
            s = PGtokenizer.removeBox(s);
        } else if (s.startsWith("(") && s.endsWith(")")) {
            this.open = false;
            s = PGtokenizer.removePara(s);
        } else {
            throw new PSQLException(GT.tr("Cannot tell if path is open or closed: {0}.", s), PSQLState.DATA_TYPE_MISMATCH);
        }
        PGtokenizer t = new PGtokenizer(s, ',');
        int npoints = t.getSize();
        PGpoint[] points = new PGpoint[npoints];
        this.points = points;
        for (int p = 0; p < npoints; ++p) {
            points[p] = new PGpoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PGpath) {
            PGpath p = (PGpath)obj;
            PGpoint[] points = this.points;
            PGpoint[] pPoints = p.points;
            if (points == null) {
                return pPoints == null;
            }
            if (pPoints == null) {
                return false;
            }
            if (p.open != this.open) {
                return false;
            }
            if (pPoints.length != points.length) {
                return false;
            }
            for (int i = 0; i < points.length; ++i) {
                if (points[i].equals(pPoints[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        PGpoint[] points = this.points;
        if (points == null) {
            return 0;
        }
        int hash = this.open ? 1231 : 1237;
        for (int i = 0; i < points.length && i < 5; ++i) {
            hash = hash * 31 + points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGpath newPGpath = (PGpath)super.clone();
        if (newPGpath.points != null) {
            PGpoint[] newPoints = (PGpoint[])newPGpath.points.clone();
            newPGpath.points = newPoints;
            for (int i = 0; i < newPGpath.points.length; ++i) {
                newPoints[i] = (PGpoint)newPGpath.points[i].clone();
            }
        }
        return newPGpath;
    }

    @Override
    public @Nullable String getValue() {
        PGpoint[] points = this.points;
        if (points == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(this.open ? "[" : "(");
        for (int p = 0; p < points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(points[p].toString());
        }
        b.append(this.open ? "]" : ")");
        return b.toString();
    }

    public boolean isOpen() {
        return this.open && this.points != null;
    }

    public boolean isClosed() {
        return !this.open && this.points != null;
    }

    public void closePath() {
        this.open = false;
    }

    public void openPath() {
        this.open = true;
    }
}

