/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.util;

import com.tencentcloud.tdsql.pg.util.ByteArray_;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class PGClobByteArray
extends OutputStream {
    protected ByteArray_ arr;

    public PGClobByteArray() {
        this(32);
    }

    public PGClobByteArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.arr = new ByteArray_(size);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.arr.buf.length;
        int minGrowth = minCapacity - oldCapacity;
        if (minGrowth > 0) {
            this.arr.buf = Arrays.copyOf(this.arr.buf, minCapacity + 8192);
        }
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(this.arr.count + 1);
        this.arr.buf[this.arr.offset] = (byte)b;
        if (this.arr.count == this.arr.offset) {
            ++this.arr.count;
        }
        ++this.arr.offset;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.arr.count + len);
        System.arraycopy(b, off, this.arr.buf, this.arr.offset, len);
        if (this.arr.offset + len > this.arr.count) {
            this.arr.count = this.arr.offset + len;
        }
        this.arr.offset += len;
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    public synchronized void reset() {
        this.arr.count = 0;
        this.arr.offset = 0;
    }

    public synchronized byte[] toByteArray() {
        return Arrays.copyOf(this.arr.buf, this.arr.count);
    }

    public synchronized int size() {
        return this.arr.count;
    }

    public synchronized String toString() {
        return new String(this.arr.buf, 0, this.arr.count);
    }

    public synchronized int setStreamPosition(int new_pos) {
        int old_pos = this.arr.offset;
        if (new_pos >= Integer.MAX_VALUE) {
            throw new RuntimeException("to large offset set for a stream");
        }
        if (new_pos > this.arr.count || new_pos < 0) {
            throw new RuntimeException("offset reach end of the stream");
        }
        this.arr.offset = new_pos;
        return old_pos;
    }

    public synchronized int getStreamPosition() {
        return this.arr.offset;
    }

    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.arr.buf, 0, this.arr.count, charsetName);
    }

    public synchronized String toString(Charset charset) {
        return new String(this.arr.buf, 0, this.arr.count, charset);
    }

    public synchronized void truncate(int len) {
        if (len < 0 || len > this.arr.count) {
            return;
        }
        this.arr.count = len;
        if (this.arr.offset > this.arr.count) {
            this.arr.offset = this.arr.count;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

