/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.util;

import com.tencentcloud.tdsql.pg.core.BaseConnection;
import com.tencentcloud.tdsql.pg.largeobject.PGBlobOutputStream;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGOrclBlob
implements Blob {
    private BaseConnection conn;
    private @Nullable byte[] buf;
    private int count;

    public PGOrclBlob(BaseConnection conn, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.conn = conn;
        this.count = bytes.length;
        this.buf = new byte[this.count];
        System.arraycopy(bytes, 0, this.buf, 0, this.count);
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkFreed();
        return this.count;
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, length);
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid length.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length == 0) {
            return new byte[0];
        }
        if (pos > (long)this.count) {
            return null;
        }
        return Arrays.copyOfRange(this.buf, (int)pos - 1, (int)Math.min((long)this.count, (long)length + pos - 1L));
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        ByteArrayInputStream stream = new ByteArrayInputStream(this.buf);
        return stream;
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        this.checkFreed();
        if (pattern == null) {
            return -1L;
        }
        this.assertPosition(start, pattern.length);
        if (pattern.length == 0 || start > (long)this.count || start + (long)pattern.length - 1L > (long)this.count) {
            return -1L;
        }
        int patternIdx = 0;
        long result = -1L;
        int tmpPosition = 1;
        for (int position = (int)(start - 1L); position < this.count; ++position) {
            if (this.buf[position] == pattern[patternIdx]) {
                if (patternIdx == 0) {
                    tmpPosition = position;
                }
                if (++patternIdx != pattern.length) continue;
                result = tmpPosition + 1;
                break;
            }
            patternIdx = 0;
        }
        return result;
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        this.checkFreed();
        if (pattern == null) {
            return -1L;
        }
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkFreed();
        if (bytes == null) {
            return 0;
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, 0L);
        if (pos - 1L > this.length()) {
            throw new PSQLException(GT.tr("Invalid position: pos - 1 is greater than the number of bytes in the Blob.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (bytes == null || len <= 0) {
            return 0;
        }
        if (offset < 0) {
            throw new PSQLException(GT.tr("Invalid offset.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if ((long)offset + (long)len > (long)bytes.length) {
            throw new PSQLException(GT.tr("Invalid offset or len: offset + len is greater than the number of bytes in the byte array.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + (long)len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
        int copyLen = Math.min(this.count - (int)pos + 1, len);
        System.arraycopy(bytes, offset, this.buf, (int)(pos - 1L), copyLen);
        if (copyLen == len) {
            return copyLen;
        }
        this.write(bytes, offset += copyLen, len -= copyLen);
        return len + copyLen;
    }

    @Override
    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, 0L);
        if (pos - 1L > this.length()) {
            throw new PSQLException(GT.tr("Invalid position: pos - 1 is greater than the number of bytes in the Blob.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return new PGBlobOutputStream(this, pos);
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        this.checkFreed();
        if (len < 0L) {
            throw new PSQLException(GT.tr("Invalid length: cannot truncate LOB to a negative length.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len > this.length()) {
            throw new PSQLException(GT.tr("Invalid length: the specified truncation length is greater than the number of bytes in the Blob.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.count = (int)len;
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
        }
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, length);
        if (pos > this.length()) {
            throw new PSQLException(GT.tr("Invalid position.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (length < 0L) {
            throw new PSQLException(GT.tr("Invalid length.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + length - 1L > this.length()) {
            throw new PSQLException(GT.tr("Invalid position or length: pos + length - 1 is greater than the number of bytes in the Blob", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(this.buf, (int)(pos - 1L), (int)length);
        return stream;
    }

    private void assertPosition(long pos, long len) throws SQLException {
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    private void checkFreed() throws SQLException {
        if (this.buf == null) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    private void ensureCapacity(long oldCount, long length) {
        long newCount = oldCount + length;
        if (newCount - Integer.MAX_VALUE > 0L) {
            throw new OutOfMemoryError();
        }
        if (newCount - (long)this.buf.length > 0L) {
            this.grow(newCount);
        }
    }

    private void grow(long minCapacity) {
        long oldCapacity = this.buf.length;
        long newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0L) {
            newCapacity = minCapacity;
        }
        if (newCapacity - Integer.MAX_VALUE > 0L) {
            newCapacity = Integer.MAX_VALUE;
        }
        this.buf = Arrays.copyOf(this.buf, (int)newCapacity);
    }

    private void write(byte[] b, int offset, int len) {
        if (offset < 0 || offset > b.length || len < 0 || (long)offset + (long)len - (long)b.length > 0L) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count, len);
        System.arraycopy(b, offset, this.buf, this.count, len);
        this.count += len;
    }
}

