/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.util;

import com.tencentcloud.tdsql.pg.core.BaseConnection;
import com.tencentcloud.tdsql.pg.largeobject.ClobOutputStreamWriter;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.PGClobByteArray;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;

public class PGOrclStringClob
implements Serializable,
Cloneable,
Clob {
    private static final long serialVersionUID = 5219967406711421236L;
    private PGClobByteArray clobBytea;
    private BaseConnection conn;

    protected void checkFreed() throws SQLException {
        if (this.clobBytea == null) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    private void assertPosition(long pos, long len) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    public synchronized String getClobString() throws SQLException {
        this.checkFreed();
        Charset connectionCharset = Charset.forName(this.conn.getEncoding().name());
        String clobString = new String(this.clobBytea.toByteArray(), connectionCharset);
        return clobString;
    }

    public PGOrclStringClob(BaseConnection conn, String val) throws SQLException {
        this.conn = conn;
        this.clobBytea = new PGClobByteArray();
        try {
            this.clobBytea.write(val.getBytes());
        }
        catch (IOException e) {
            throw new SQLException("failed write bytes when creating clob object");
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkFreed();
        return this.getClobString().length();
    }

    @Override
    public synchronized String getSubString(long pos, int length) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, length);
        if (length == 0) {
            return null;
        }
        if (length < 0) {
            throw new SQLException("a negative length");
        }
        String clobStr = this.getClobString();
        int cloblen = clobStr.length();
        int newlength = length + (int)pos - 1;
        return this.getClobString().substring((int)pos - 1, newlength > cloblen ? cloblen : newlength);
    }

    @Override
    public synchronized long position(String searchstr, long start) throws SQLException {
        String clobStr = this.getClobString();
        this.checkFreed();
        this.assertPosition(start, 0L);
        if (start > (long)clobStr.length()) {
            return -1L;
        }
        int curpos = clobStr.substring((int)start - 1).indexOf(searchstr);
        if (curpos == -1) {
            return -1L;
        }
        return curpos + 1;
    }

    @Override
    public synchronized long position(Clob subclob, long start) throws SQLException {
        PGOrclStringClob oclob = (PGOrclStringClob)subclob;
        this.checkFreed();
        this.assertPosition(start, 0L);
        return this.position(oclob.getClobString(), start);
    }

    private synchronized int getByteIndex(String clobstr, long pos) throws SQLException {
        this.assertPosition(pos, 0L);
        if (pos == 1L) {
            return 0;
        }
        if (pos >= (long)clobstr.length()) {
            return clobstr.getBytes().length;
        }
        return clobstr.substring(0, (int)pos - 1).getBytes().length;
    }

    @Override
    public synchronized int setString(long pos, String str) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, 0L);
        if (str == null) {
            return 0;
        }
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, 0L);
        String clobString = this.getClobString();
        if (pos > (long)(clobString.length() + 1)) {
            throw new SQLException("reach end of clob object");
        }
        int actpos = this.getByteIndex(clobString, pos);
        byte[] bytes = str.getBytes();
        this.clobBytea.setStreamPosition(actpos);
        this.clobBytea.write(bytes, offset, bytes.length);
        return len;
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkFreed();
        return new StringReader(this.getClobString());
    }

    @Override
    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, length);
        if (pos < 1L) {
            throw new SQLException("offset of stream is less than 1");
        }
        String clobstr = this.getClobString();
        if (pos > (long)clobstr.length() || pos + length - 1L > (long)clobstr.length()) {
            throw new SQLException("reach end of clob");
        }
        return new StringReader(clobstr.substring((int)pos - 1, (int)pos - 1 + (int)length));
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkFreed();
        return new ByteArrayInputStream(this.getClobString().getBytes());
    }

    @Override
    public synchronized OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkFreed();
        this.assertPosition(pos, 0L);
        if (pos > (long)(this.getClobString().length() + 1)) {
            throw new SQLException("reach end of clob object");
        }
        String clobstr = this.getClobString();
        int bytepos = this.getByteIndex(clobstr, pos);
        this.clobBytea.setStreamPosition(bytepos);
        return this.clobBytea;
    }

    @Override
    public synchronized Writer setCharacterStream(long pos) throws SQLException {
        return new ClobOutputStreamWriter(this.setAsciiStream(pos));
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        if (this.clobBytea == null) {
            return;
        }
        String clobStr = this.getClobString();
        if (len > (long)(clobStr.length() + 1) || len <= 0L) {
            this.clobBytea.reset();
            return;
        }
        int actpos = this.getByteIndex(clobStr, len + 1L);
        this.clobBytea.truncate(actpos);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.clobBytea = null;
    }

    public synchronized int getClobPosition() throws SQLException {
        this.checkFreed();
        return this.clobBytea.getStreamPosition();
    }
}

