/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.xa;

import com.tencentcloud.tdsql.pg.core.BaseConnection;
import com.tencentcloud.tdsql.pg.ds.common.BaseDataSource;
import com.tencentcloud.tdsql.pg.xa.PGXAConnection;
import com.tencentcloud.tdsql.pg.xa.PGXADataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGXADataSource
extends BaseDataSource
implements XADataSource {
    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public XAConnection getXAConnection(@Nullable String user, @Nullable String password) throws SQLException {
        Connection con = super.getConnection(user, password);
        return new PGXAConnection((BaseConnection)con);
    }

    @Override
    public String getDescription() {
        return "XA-enabled DataSource from TDSQL-PG JDBC Driver 1.1.4";
    }

    @Override
    protected Reference createReference() {
        return new Reference(this.getClass().getName(), PGXADataSourceFactory.class.getName(), null);
    }
}

