/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc;

import com.goldendb.jdbc.BalanceStrategy;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedConnectionProxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestResponseTimeBalanceStrategy
implements BalanceStrategy {
    @Override
    public void destroy() {
    }

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
    }

    @Override
    public ConnectionImpl pickConnection(LoadBalancedConnectionProxy proxy, List<String> configuredHosts, Map<String, ConnectionImpl> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        ConnectionImpl conn;
        ArrayList<String> whiteList = new ArrayList<String>(configuredHosts.size());
        whiteList.addAll(configuredHosts);
        Map<String, Long> blackList = proxy.getGlobalBlacklist();
        whiteList.removeAll(blackList.keySet());
        SQLException ex = null;
        int attempts = 0;
        while (true) {
            String bestHost;
            if (attempts >= numRetries) {
                if (ex != null) {
                    throw ex;
                }
                return null;
            }
            long minResponseTime = Long.MAX_VALUE;
            int bestHostIndex = 0;
            if (blackList.size() == configuredHosts.size()) {
                blackList = proxy.getGlobalBlacklist();
            }
            for (int i = 0; i < responseTimes.length; ++i) {
                long candidateResponseTime = responseTimes[i];
                if (candidateResponseTime >= minResponseTime || blackList.containsKey(whiteList.get(i))) continue;
                if (candidateResponseTime == 0L) {
                    bestHostIndex = i;
                    break;
                }
                bestHostIndex = i;
                minResponseTime = candidateResponseTime;
            }
            if ((conn = liveConnections.get(bestHost = (String)whiteList.get(bestHostIndex))) != null) break;
            try {
                conn = proxy.createConnectionForHost(bestHost);
            }
            catch (SQLException var18) {
                ex = var18;
                if (!proxy.shouldExceptionTriggerConnectionSwitch(var18)) {
                    throw var18;
                }
                proxy.addToGlobalBlacklist(bestHost);
                blackList.put(bestHost, null);
                if (blackList.size() != configuredHosts.size()) continue;
                ++attempts;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException var17) {
                    // empty catch block
                }
                blackList = proxy.getGlobalBlacklist();
                continue;
            }
            break;
        }
        return conn;
    }
}

