/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.authentication;

import com.goldendb.jdbc.AuthenticationPlugin;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.internal.core.io.Buffer;
import com.goldendb.jdbc.internal.core.io.Security;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoldendbNativePasswordPlugin
implements AuthenticationPlugin {
    private Connection connection;
    private String password = null;

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
        this.connection = conn;
    }

    @Override
    public void destroy() {
        this.password = null;
    }

    @Override
    public String getProtocolPluginName() {
        return "mysql_native_password";
    }

    @Override
    public boolean requiresConfidentiality() {
        return false;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public void setAuthenticationParameters(String user, String password) {
        this.password = password;
    }

    @Override
    public boolean nextAuthenticationStep(Buffer fromServer, List<Buffer> toServer) throws SQLException {
        try {
            toServer.clear();
            Buffer bresp = null;
            String pwd = this.password;
            bresp = fromServer != null && pwd != null && pwd.length() != 0 ? new Buffer(Security.scramble411(pwd, fromServer.readString(), this.connection.getPasswordCharacterEncoding())) : new Buffer(new byte[0]);
            toServer.add(bresp);
            return true;
        }
        catch (NoSuchAlgorithmException var5) {
            throw SQLError.createSQLException(Messages.getString("MysqlIO.91") + Messages.getString("MysqlIO.92"), "S1000", (ExceptionInterceptor)null);
        }
        catch (UnsupportedEncodingException var6) {
            throw SQLError.createSQLException(Messages.getString("GoldendbNativePasswordPlugin.1", new Object[]{this.connection.getPasswordCharacterEncoding()}), "S1000", (ExceptionInterceptor)null);
        }
    }

    @Override
    public void reset() {
    }
}

