/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.io;

import com.goldendb.jdbc.AbandonedConnectionCleanupThread;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.ConnectionPropertiesImpl;
import com.goldendb.jdbc.ConnectionPropertiesTransform;
import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.HostInfo;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.NetworkResources;
import com.goldendb.jdbc.internal.core.loadbalance.FailoverConnectionProxy;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedConnectionProxy;
import com.goldendb.jdbc.internal.core.loadbalance.ReplicationConnectionProxy;
import com.goldendb.jdbc.internal.custom.BlackListManager;
import com.goldendb.jdbc.internal.custom.ConfigStmtRuleManager;
import com.goldendb.jdbc.internal.custom.ConnectionManager;
import com.goldendb.jdbc.internal.custom.GroupInfo;
import com.goldendb.jdbc.internal.custom.LoadBalanceExceptionChecker;
import com.goldendb.jdbc.internal.log.GoldendbLog;
import com.goldendb.jdbc.internal.log.LogFactory;
import com.goldendb.jdbc.internal.log.StandardLogger;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.internal.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.net.URLDecoder;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonRegisteringDriver
implements Driver {
    private static final String ALLOWED_QUOTES = "\"'";
    private static final String REPLICATION_URL_PREFIX = "jdbc:goldendb:replication://";
    private static final String URL_PREFIX = "jdbc:goldendb://";
    private static final String MXJ_URL_PREFIX = "jdbc:goldendb:mxj://";
    public static final String LOADBALANCE_URL_PREFIX = "jdbc:goldendb:loadbalance://";
    private static final String MYSQL_REPLICATION_URL_PREFIX = "jdbc:mysql:replication://";
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    private static final String MYSQL_MXJ_URL_PREFIX = "jdbc:mysql:mxj://";
    public static final String MYSQL_LOADBALANCE_URL_PREFIX = "jdbc:mysql:loadbalance://";
    public static final ConcurrentHashMap<ConnectionPhantomReference, ConnectionPhantomReference> connectionPhantomRefs = new ConcurrentHashMap();
    public static final ReferenceQueue<ConnectionImpl> refQueue = new ReferenceQueue();
    public static final String OS = NonRegisteringDriver.getOSName();
    public static final String PLATFORM = NonRegisteringDriver.getPlatform();
    public static final String LICENSE = " ";
    public static final String RUNTIME_VENDOR = System.getProperty("java.vendor");
    public static final String RUNTIME_VERSION = System.getProperty("java.version");
    public static final String VERSION = "gdb_mysql-connector-java-5.1.46.57";
    public static final String NAME = "GoldenDB Connector Java";
    List<String> hostSeeds = new ArrayList<String>();
    public static final String DBNAME_PROPERTY_KEY = "DBNAME";
    public static final boolean DEBUG = false;
    public static final int HOST_NAME_INDEX = 0;
    public static final String HOST_PROPERTY_KEY = "HOST";
    public static final String NUM_HOSTS_PROPERTY_KEY = "NUM_HOSTS";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    public static final int PORT_NUMBER_INDEX = 1;
    public static final String PORT_PROPERTY_KEY = "PORT";
    public static final String PROPERTIES_TRANSFORM_KEY = "propertiesTransform";
    public static final boolean TRACE = false;
    public static final String USE_CONFIG_PROPERTY_KEY = "useConfigs";
    public static final String USER_PROPERTY_KEY = "user";
    public static final String PROTOCOL_PROPERTY_KEY = "PROTOCOL";
    public static final String PATH_PROPERTY_KEY = "PATH";
    private volatile GoldendbLog log = null;
    private static final Object logLock = new Object();

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getPlatform() {
        return System.getProperty("os.arch");
    }

    static int getMajorVersionInternal() {
        return NonRegisteringDriver.safeIntParse("5");
    }

    static int getMinorVersionInternal() {
        return NonRegisteringDriver.safeIntParse("1");
    }

    public static String[] parseHostPortPair(String hostPortPair) throws SQLException {
        String[] splitValues = new String[2];
        if (StringUtils.startsWithIgnoreCaseAndWs(hostPortPair, "address=")) {
            splitValues[0] = hostPortPair.trim();
            splitValues[1] = null;
            return splitValues;
        }
        int portIndex = hostPortPair.indexOf(":");
        String hostname = null;
        if (portIndex != -1) {
            if (portIndex + 1 >= hostPortPair.length()) {
                throw SQLError.createSQLException(Messages.getString("NonRegisteringDriver.37"), "01S00", (ExceptionInterceptor)null);
            }
            String portAsString = hostPortPair.substring(portIndex + 1);
            splitValues[0] = hostname = hostPortPair.substring(0, portIndex);
            splitValues[1] = portAsString;
        } else {
            splitValues[0] = hostPortPair;
            splitValues[1] = null;
        }
        return splitValues;
    }

    private static int safeIntParse(String intAsString) {
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException var2) {
            return 0;
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw SQLError.createSQLException(Messages.getString("NonRegisteringDriver.1"), "08001", (ExceptionInterceptor)null);
        }
        return NonRegisteringDriver.parseURL(url, null) != null;
    }

    @Override
    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw SQLError.createSQLException(Messages.getString("NonRegisteringDriver.1"), "08001", (ExceptionInterceptor)null);
        }
        java.sql.Connection connection = null;
        Properties props = NonRegisteringDriver.parseURL(url, info);
        if (props == null) {
            return null;
        }
        boolean enableUseConfigStmtRule = false;
        int checkPeriod = 60;
        try {
            String useConfigStmtRule = props.getProperty("useConfigStmtRule", "false");
            enableUseConfigStmtRule = Boolean.parseBoolean(useConfigStmtRule);
            String checkConfigStmtRulePeriod = props.getProperty("checkConfigStmtRulePeriod", "60");
            checkPeriod = Integer.parseInt(checkConfigStmtRulePeriod);
            checkPeriod = Math.max(checkPeriod, 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        ConnectionManager.getInstance().setFullUrl(url);
        if (StringUtils.startsWithIgnoreCase(url, LOADBALANCE_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_LOADBALANCE_URL_PREFIX)) {
            connection = this.chargeLoadBalanceIsOpen(url, info) ? this.connectionLoadBalanceUrl(url, info) : this.connectLoadBalanced(url, info);
        } else if (StringUtils.startsWithIgnoreCase(url, REPLICATION_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_REPLICATION_URL_PREFIX)) {
            connection = this.connectReplicationConnection(url, info);
        } else if (!"1".equals(props.getProperty(NUM_HOSTS_PROPERTY_KEY))) {
            connection = this.connectFailover(url, info);
        } else {
            try {
                connection = ConnectionImpl.getInstance(this.host(props), this.port(props), props, this.database(props), url);
            }
            catch (SQLException var6) {
                throw var6;
            }
            catch (Exception var7) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("NonRegisteringDriver.17") + var7.toString() + Messages.getString("NonRegisteringDriver.18"), "08001", (ExceptionInterceptor)null);
                sqlEx.initCause(var7);
                throw sqlEx;
            }
        }
        if (enableUseConfigStmtRule) {
            ConfigStmtRuleManager.init(url, info, checkPeriod);
        }
        return connection;
    }

    private boolean chargeLoadBalanceIsOpen(String url, Properties info) {
        boolean result = true;
        String isConnectionLevel = "true";
        if (null != info) {
            isConnectionLevel = info.getProperty("isConnectionLevel", "true");
        }
        if (url.indexOf("isConnectionLevel=false") != -1 || isConnectionLevel.equals("false")) {
            result = false;
        }
        return result;
    }

    public List<String> filterBlackList(List<String> hosts, Properties props) throws SQLException {
        ArrayList<String> hostsClone = new ArrayList<String>(hosts.size());
        hostsClone.addAll(hosts);
        Iterator iterator = hostsClone.iterator();
        Map<String, HostInfo> blackList = BlackListManager.getInstance().getGlobalBlacklist();
        while (iterator.hasNext()) {
            String host = (String)iterator.next();
            HostInfo monitorhost = new HostInfo(host, props, "");
            String key = monitorhost.getBlackHostKey();
            if (!blackList.containsKey(key)) continue;
            iterator.remove();
        }
        return hostsClone;
    }

    public String getBlackListException(List<String> hosts, Properties props) throws SQLException {
        ArrayList<String> hostsClone = new ArrayList<String>(hosts.size());
        hostsClone.addAll(hosts);
        String exception = "";
        Iterator iterator = hostsClone.iterator();
        Map<String, HostInfo> blackList = BlackListManager.getInstance().getGlobalBlacklist();
        while (iterator.hasNext()) {
            HostInfo blackhost;
            String errMsg;
            String host = (String)iterator.next();
            HostInfo monitorhost = new HostInfo(host, props, "");
            String key = monitorhost.getBlackHostKey();
            if (!blackList.containsKey(key) || null == (errMsg = (blackhost = blackList.get(key)).getException()) || "".equals(errMsg)) continue;
            exception = errMsg;
        }
        return exception;
    }

    public java.sql.Connection connectionLoadBalanceUrl(String initUrl, Properties info) throws SQLException {
        String hostStuff = null;
        String parameterStuff = null;
        String dbName = null;
        String originalUrl = initUrl;
        int hostStartIndex = initUrl.indexOf("//");
        int hostEndIndex = initUrl.indexOf("?");
        Properties props = NonRegisteringDriver.parseURL(initUrl, info);
        if (hostStartIndex == -1) {
            return null;
        }
        String prefixUrl = initUrl.substring(0, hostStartIndex + 2);
        if (null == prefixUrl || 0 == prefixUrl.length()) {
            return null;
        }
        if (-1 == hostEndIndex) {
            parameterStuff = "";
            initUrl = initUrl.substring(hostStartIndex + 2);
        } else {
            parameterStuff = initUrl.substring(hostEndIndex);
            initUrl = initUrl.substring(hostStartIndex + 2, hostEndIndex);
        }
        int slashIndex = StringUtils.indexOfIgnoreCase(0, initUrl, "/", ALLOWED_QUOTES, ALLOWED_QUOTES, StringUtils.SEARCH_MODE__ALL);
        if (slashIndex == -1) {
            dbName = "";
            hostStuff = initUrl;
        } else {
            dbName = initUrl.substring(slashIndex);
            hostStuff = initUrl.substring(0, slashIndex);
        }
        int numGroups = Integer.parseInt(props.getProperty("proxygroups", "0"));
        String strategy = props.getProperty("loadBalanceStrategy", "random");
        List<GroupInfo> groupHostList = null;
        if (0 == numGroups) {
            if (null != hostStuff) {
                List<String> hosts = StringUtils.split(hostStuff, ",", ALLOWED_QUOTES, ALLOWED_QUOTES, true);
                ConnectionManager.getInstance().addAllHost(hosts);
                if (null != hosts && hosts.size() > 0) {
                    List<String> filterHosts = this.filterBlackList(hosts, info);
                    java.sql.Connection conn = this.getConnectionByLoadBalance(prefixUrl, filterHosts, info, parameterStuff, dbName, strategy);
                    if (null != conn) {
                        return conn;
                    }
                    String exception = this.getBlackListException(hosts, props);
                    throw SQLError.createSQLException(exception.toString() + "\n " + Messages.getString("NonRegisteringDriver.17") + " Can't connect to all loadbalcance monitorhostList:" + BlackListManager.getInstance().getMonitorHostPair() + "hosts.Blacklist:" + BlackListManager.getInstance().getBlackHostPair() + " hosts.List " + hosts + "." + Messages.getString("NonRegisteringDriver.18"), "08001", (ExceptionInterceptor)null);
                }
            }
            return null;
        }
        ArrayList<String> hostList = new ArrayList<String>();
        props.remove("roundRobinLoadBalance");
        int host_alive_threshold = Integer.parseInt(props.getProperty("minconnectionproxys", "0"));
        boolean masterConnection = Boolean.parseBoolean(props.getProperty("masterConnection", "false"));
        if (masterConnection) {
            ConnectionManager.getInstance().checkSameGroupInfo(props);
            String materIP = ConnectionManager.getInstance().getMsterIP(props, originalUrl);
            List<GroupInfo> hostAllList = ConnectionManager.getInstance().getHostList(props, materIP);
            for (GroupInfo groupinfo : hostAllList) {
                List<String> lbHosts = groupinfo.getHost();
                List<String> filterHosts = this.filterBlackList(lbHosts, info);
                java.sql.Connection conn = null;
                try {
                    conn = this.getConnectionByLoadBalance(prefixUrl, filterHosts, info, parameterStuff, dbName, strategy);
                    if (null == conn) continue;
                    return conn;
                }
                catch (SQLException var18) {
                }
                catch (Exception var19) {
                }
            }
        } else {
            ArrayList<String> errorHostList = new ArrayList<String>();
            for (int i = 0; i < numGroups; ++i) {
                groupHostList = this.getGroupHostList(numGroups, props);
                for (GroupInfo group : groupHostList) {
                    List<String> lbHosts = group.getHost();
                    lbHosts.removeAll(errorHostList);
                    List<String> filterHosts = this.filterBlackList(lbHosts, info);
                    hostList.addAll(filterHosts);
                    if (!(0 == host_alive_threshold ? hostList.size() > host_alive_threshold : hostList.size() >= host_alive_threshold)) continue;
                    break;
                }
                java.sql.Connection conn = null;
                try {
                    errorHostList.addAll(hostList);
                    conn = this.getConnectionByLoadBalance(prefixUrl, hostList, info, parameterStuff, dbName, strategy);
                    if (null == conn) continue;
                    return conn;
                }
                catch (SQLException var18) {
                    continue;
                }
                catch (Exception var19) {
                    // empty catch block
                }
            }
        }
        String exception = this.getBlackListException(hostList, props);
        throw SQLError.createSQLException(exception.toString() + "\n " + Messages.getString("NonRegisteringDriver.17") + " Can't connect to all loadbalcance monitorhostList:" + BlackListManager.getInstance().getMonitorHostPair() + "hosts.Blacklist:" + BlackListManager.getInstance().getBlackHostPair() + " group.HostList " + groupHostList + "." + Messages.getString("NonRegisteringDriver.18"), "08001", (ExceptionInterceptor)null);
    }

    private List<GroupInfo> getGroupHostList(int numGroups, Properties parsedProps) throws SQLException {
        ArrayList<GroupInfo> groupHostList = new ArrayList<GroupInfo>();
        for (int i = 1; i <= numGroups; ++i) {
            List<String> hosts;
            String hostStuff = null;
            String groupName = "proxygroup" + i;
            hostStuff = parsedProps.getProperty(groupName);
            if (null == hostStuff || null == (hosts = StringUtils.split(hostStuff, ",", ALLOWED_QUOTES, ALLOWED_QUOTES, true)) || hosts.size() <= 0) continue;
            GroupInfo group = new GroupInfo(i, groupName, hosts);
            groupHostList.add(group);
        }
        return groupHostList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.Connection getConnectionByLoadBalance(String prefixUrl, List<String> hosts, Properties info, String parameterStuff, String dbName, String strategy) throws SQLException {
        String resultUrl = null;
        String host = null;
        StringBuilder resultBuilder = new StringBuilder();
        String groupHostList = hosts.toString();
        Connection conn = null;
        Throwable exception = null;
        for (int i = 0; i < hosts.size(); ++i) {
            int tryTimes;
            host = this.getHostByStrategy(hosts, strategy);
            resultBuilder.append(prefixUrl).append(host).append(dbName).append(parameterStuff);
            resultUrl = resultBuilder.toString();
            Properties props = NonRegisteringDriver.parseURL(resultUrl, info);
            resultBuilder.setLength(0);
            String loadBalanceTryTimes = props.getProperty("loadBalanceTryTimes", "1");
            try {
                tryTimes = Integer.parseInt(loadBalanceTryTimes);
                if (tryTimes < 1) {
                    tryTimes = 1;
                }
            }
            catch (Exception e) {
                tryTimes = 1;
            }
            for (int k = 0; k < tryTimes; ++k) {
                try {
                    exception = null;
                    conn = ConnectionImpl.getInstance(this.host(props), this.port(props), props, this.database(props), resultUrl);
                }
                catch (SQLException var18) {
                    exception = var18;
                }
                catch (Exception var19) {
                    exception = var19;
                }
                if (null == conn) continue;
                LoadBalanceExceptionChecker exceptionChecker = null;
                String lbExceptionChecker = props.getProperty("loadBalanceExceptionChecker", "com.goldendb.jdbc.internal.custom.MyExceptionChecker");
                exceptionChecker = (LoadBalanceExceptionChecker)Util.loadExtensions(null, props, lbExceptionChecker, "InvalidLoadBalanceExceptionChecker", null).get(0);
                Statement stmt = null;
                try {
                    stmt = conn.createStatement();
                    stmt.execute("select 1");
                }
                catch (SQLException var20) {
                    exception = var20;
                    if (null != exceptionChecker && exceptionChecker.shouldExceptionTriggerFailover(var20)) {
                        continue;
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                ConnectionManager.getInstance().addConnection(host, conn);
                ConnectionManager.getInstance().increaseHostCount(host);
                ((ConnectionImpl)conn).setLoadBakanceExceptionChecker(exceptionChecker);
                return conn;
            }
            if (conn != null) continue;
            if (this.log == null) {
                Object k = logLock;
                synchronized (k) {
                    if (this.log == null) {
                        this.log = LogFactory.getLogger(props.getProperty("logger", StandardLogger.class.getName()), "MySQL", null);
                    }
                }
            }
            String logMsg = "[goldendb] loadbalance try fail, ConnectTo[" + this.host(props) + "," + this.port(props) + "," + this.database(props) + "]" + "||" + "tryTimes: " + tryTimes + " |";
            String errMsg = exception.getCause() == null ? exception.toString() : exception.getCause().toString();
            this.log.logInfo(logMsg + "|" + errMsg);
            hosts.remove(host);
            BlackListManager.getInstance().addMonitorHost(host, props, (Exception)exception);
            --i;
        }
        if (null == conn && null != exception) {
            String errMsg = exception.getMessage();
            Throwable cause = exception.getCause();
            if (null != cause) {
                errMsg = errMsg + "\n";
                errMsg = errMsg + cause.getMessage();
            }
            throw SQLError.createSQLException(errMsg + "\n " + Messages.getString("NonRegisteringDriver.17") + " Can't connect to all loadbalcance monitorhostList:" + BlackListManager.getInstance().getMonitorHostPair() + "hosts.Blacklist:" + BlackListManager.getInstance().getBlackHostPair() + " group.HostList " + groupHostList + "." + Messages.getString("NonRegisteringDriver.18"), "08001", (ExceptionInterceptor)null);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHostByStrategy(List<String> hosts, String strategy) {
        ConcurrentHashMap<String, Integer> concurrentHashMap = ConnectionManager.hostConnectionCountMap;
        synchronized (concurrentHashMap) {
            String host = this.getRandomHost(hosts);
            if ("minconnection".equals(strategy) && ConnectionManager.hostConnectionCountMap.containsKey(host)) {
                host = this.getBalanceHost(hosts);
            }
            return host;
        }
    }

    private void filterHost(String prefixUrl, List<String> hosts, String dbName, String parameterStuff, Properties props) {
        Iterator<String> iterator = hosts.iterator();
        while (iterator.hasNext()) {
            String host = iterator.next();
            StringBuilder resultBuilder = new StringBuilder();
            resultBuilder.append(prefixUrl).append(host).append(dbName).append(parameterStuff);
            try {
                java.sql.Connection conn = this.chargeConnection(host, resultBuilder.toString(), props, false);
                if (null != conn) {
                    conn.close();
                } else {
                    iterator.remove();
                }
            }
            catch (Exception var9) {
                var9.printStackTrace();
            }
            resultBuilder.setLength(0);
        }
    }

    private String getBalanceHost(List<String> hosts) {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(ConnectionManager.hostConnectionCountMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        });
        String result = "";
        for (int i = 0; i < list.size(); ++i) {
            result = (String)((Map.Entry)list.get(i)).getKey();
            if (!hosts.contains(result)) continue;
            return result;
        }
        return result;
    }

    private String getRandomHost(List<String> hosts) {
        int random = (int)Math.floor(Math.random() * (double)hosts.size());
        String hostStuff = hosts.get(random);
        return hostStuff;
    }

    private java.sql.Connection chargeConnection(String host, String reusltUrl, Properties props, Boolean flag) throws SQLException {
        Connection conn = null;
        try {
            conn = ConnectionImpl.getInstance(this.host(props), this.port(props), props, this.database(props), reusltUrl);
            if (null != conn && !conn.isClosed()) {
                if (flag.booleanValue()) {
                    ConnectionManager.getInstance().addConnection(host, conn);
                }
                return conn;
            }
            return conn;
        }
        catch (SQLException var7) {
            System.out.print("connection fail " + host + "\n");
            var7.printStackTrace();
            return conn;
        }
        catch (Exception var8) {
            System.out.print("connection fail " + host + "\n");
            var8.printStackTrace();
            return conn;
        }
    }

    protected static void trackConnection(java.sql.Connection newConn) {
        ConnectionPhantomReference phantomRef = new ConnectionPhantomReference((ConnectionImpl)newConn, refQueue);
        connectionPhantomRefs.put(phantomRef, phantomRef);
    }

    private java.sql.Connection connectLoadBalanced(String url, Properties info) throws SQLException {
        Properties parsedProps = NonRegisteringDriver.parseURL(url, info);
        if (parsedProps == null) {
            return null;
        }
        parsedProps.remove("roundRobinLoadBalance");
        int numHosts = Integer.parseInt(parsedProps.getProperty(NUM_HOSTS_PROPERTY_KEY));
        ArrayList<String> hostList = new ArrayList<String>();
        for (int i = 0; i < numHosts; ++i) {
            int index = i + 1;
            hostList.add(parsedProps.getProperty("HOST." + index) + ":" + parsedProps.getProperty("PORT." + index));
        }
        return LoadBalancedConnectionProxy.createProxyInstance(hostList, parsedProps);
    }

    private java.sql.Connection connectFailover(String url, Properties info) throws SQLException {
        Properties parsedProps = NonRegisteringDriver.parseURL(url, info);
        if (parsedProps == null) {
            return null;
        }
        parsedProps.remove("roundRobinLoadBalance");
        int numHosts = Integer.parseInt(parsedProps.getProperty(NUM_HOSTS_PROPERTY_KEY));
        ArrayList<String> hostList = new ArrayList<String>();
        for (int i = 0; i < numHosts; ++i) {
            int index = i + 1;
            hostList.add(parsedProps.getProperty("HOST." + index) + ":" + parsedProps.getProperty("PORT." + index));
        }
        return FailoverConnectionProxy.createProxyInstance(hostList, parsedProps);
    }

    protected java.sql.Connection connectReplicationConnection(String url, Properties info) throws SQLException {
        Properties parsedProps = NonRegisteringDriver.parseURL(url, info);
        if (parsedProps == null) {
            return null;
        }
        Properties masterProps = (Properties)parsedProps.clone();
        Properties slavesProps = (Properties)parsedProps.clone();
        slavesProps.setProperty("com.goldendb.jdbc.internal.core.loadbalance.ReplicationConnection.isSlave", "true");
        int numHosts = Integer.parseInt(parsedProps.getProperty(NUM_HOSTS_PROPERTY_KEY));
        if (numHosts < 2) {
            throw SQLError.createSQLException("Must specify at least one slave host to connect to for master/slave replication load-balancing functionality", "01S00", (ExceptionInterceptor)null);
        }
        ArrayList<String> slaveHostList = new ArrayList<String>();
        ArrayList<String> masterHostList = new ArrayList<String>();
        String firstHost = masterProps.getProperty("HOST.1") + ":" + masterProps.getProperty("PORT.1");
        boolean usesExplicitServerType = NonRegisteringDriver.isHostPropertiesList(firstHost);
        for (int i = 0; i < numHosts; ++i) {
            int index = i + 1;
            masterProps.remove("HOST." + index);
            masterProps.remove("PORT." + index);
            slavesProps.remove("HOST." + index);
            slavesProps.remove("PORT." + index);
            String host = parsedProps.getProperty("HOST." + index);
            String port = parsedProps.getProperty("PORT." + index);
            if (usesExplicitServerType) {
                if (this.isHostMaster(host)) {
                    masterHostList.add(host);
                    continue;
                }
                slaveHostList.add(host);
                continue;
            }
            if (i == 0) {
                masterHostList.add(host + ":" + port);
                continue;
            }
            slaveHostList.add(host + ":" + port);
        }
        slavesProps.remove(NUM_HOSTS_PROPERTY_KEY);
        masterProps.remove(NUM_HOSTS_PROPERTY_KEY);
        masterProps.remove(HOST_PROPERTY_KEY);
        masterProps.remove(PORT_PROPERTY_KEY);
        slavesProps.remove(HOST_PROPERTY_KEY);
        slavesProps.remove(PORT_PROPERTY_KEY);
        return ReplicationConnectionProxy.createProxyInstance(masterHostList, masterProps, slaveHostList, slavesProps);
    }

    private boolean isHostMaster(String host) {
        Properties hostSpecificProps;
        return NonRegisteringDriver.isHostPropertiesList(host) && (hostSpecificProps = NonRegisteringDriver.expandHostKeyValues(host)).containsKey("type") && "master".equalsIgnoreCase(hostSpecificProps.get("type").toString());
    }

    public String database(Properties props) {
        return props.getProperty(DBNAME_PROPERTY_KEY);
    }

    @Override
    public int getMajorVersion() {
        return NonRegisteringDriver.getMajorVersionInternal();
    }

    @Override
    public int getMinorVersion() {
        return NonRegisteringDriver.getMinorVersionInternal();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (url != null && (url.startsWith(URL_PREFIX) || url.startsWith(MYSQL_URL_PREFIX))) {
            info = NonRegisteringDriver.parseURL(url, info);
        }
        DriverPropertyInfo hostProp = new DriverPropertyInfo(HOST_PROPERTY_KEY, info.getProperty(HOST_PROPERTY_KEY));
        hostProp.required = true;
        hostProp.description = Messages.getString("NonRegisteringDriver.3");
        DriverPropertyInfo portProp = new DriverPropertyInfo(PORT_PROPERTY_KEY, info.getProperty(PORT_PROPERTY_KEY, "3306"));
        portProp.required = false;
        portProp.description = Messages.getString("NonRegisteringDriver.7");
        DriverPropertyInfo dbProp = new DriverPropertyInfo(DBNAME_PROPERTY_KEY, info.getProperty(DBNAME_PROPERTY_KEY));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo(USER_PROPERTY_KEY, info.getProperty(USER_PROPERTY_KEY));
        userProp.required = true;
        userProp.description = Messages.getString("NonRegisteringDriver.13");
        DriverPropertyInfo passwordProp = new DriverPropertyInfo(PASSWORD_PROPERTY_KEY, info.getProperty(PASSWORD_PROPERTY_KEY));
        passwordProp.required = true;
        passwordProp.description = Messages.getString("NonRegisteringDriver.16");
        DriverPropertyInfo[] dpi = ConnectionPropertiesImpl.exposeAsDriverPropertyInfo(info, 5);
        dpi[0] = hostProp;
        dpi[1] = portProp;
        dpi[2] = dbProp;
        dpi[3] = userProp;
        dpi[4] = passwordProp;
        return dpi;
    }

    public String host(Properties props) {
        return props.getProperty(HOST_PROPERTY_KEY, "localhost");
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static Properties parseURL(String url, Properties defaults) throws SQLException {
        String configNames;
        String hostStuff;
        int index;
        Properties urlProps;
        Properties properties = urlProps = defaults != null ? new Properties(defaults) : new Properties();
        if (url == null) {
            return null;
        }
        if (!(StringUtils.startsWithIgnoreCase(url, URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MXJ_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, LOADBALANCE_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, REPLICATION_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_MXJ_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_LOADBALANCE_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_REPLICATION_URL_PREFIX))) {
            return null;
        }
        int beginningOfSlashes = url.indexOf("//");
        if (StringUtils.startsWithIgnoreCase(url, MXJ_URL_PREFIX) || StringUtils.startsWithIgnoreCase(url, MYSQL_MXJ_URL_PREFIX)) {
            urlProps.setProperty("socketFactory", "com.goldendb.management.driverlaunched.ServerLauncherSocketFactory");
        }
        if ((index = url.indexOf("?")) != -1) {
            hostStuff = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(hostStuff, "&");
            while (queryParams.hasMoreTokens()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEquals = StringUtils.indexOfIgnoreCase(0, parameterValuePair, "=");
                configNames = null;
                String hostAndPort = null;
                if (indexOfEquals != -1) {
                    configNames = parameterValuePair.substring(0, indexOfEquals);
                    if (indexOfEquals + 1 < parameterValuePair.length()) {
                        hostAndPort = parameterValuePair.substring(indexOfEquals + 1);
                    }
                }
                if (hostAndPort == null || hostAndPort.length() <= 0 || configNames == null || configNames.length() <= 0) continue;
                try {
                    urlProps.setProperty(configNames, URLDecoder.decode(hostAndPort, "UTF-8"));
                }
                catch (UnsupportedEncodingException var21) {
                    urlProps.setProperty(configNames, URLDecoder.decode(hostAndPort));
                }
                catch (NoSuchMethodError var22) {
                    urlProps.setProperty(configNames, URLDecoder.decode(hostAndPort));
                }
            }
        }
        url = url.substring(beginningOfSlashes + 2);
        hostStuff = null;
        int slashIndex = StringUtils.indexOfIgnoreCase(0, url, "/", ALLOWED_QUOTES, ALLOWED_QUOTES, StringUtils.SEARCH_MODE__ALL);
        if (slashIndex != -1) {
            hostStuff = url.substring(0, slashIndex);
            if (slashIndex + 1 < url.length()) {
                urlProps.put(DBNAME_PROPERTY_KEY, url.substring(slashIndex + 1, url.length()));
            }
        } else {
            hostStuff = url;
        }
        int numHosts = 0;
        if (hostStuff != null && hostStuff.trim().length() > 0) {
            List<String> hosts = StringUtils.split(hostStuff, ",", ALLOWED_QUOTES, ALLOWED_QUOTES, true);
            for (String hostAndPort : hosts) {
                ++numHosts;
                String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostAndPort);
                if (hostPortPair[0] != null && hostPortPair[0].trim().length() > 0) {
                    urlProps.setProperty("HOST." + numHosts, hostPortPair[0]);
                } else {
                    urlProps.setProperty("HOST." + numHosts, "localhost");
                }
                if (hostPortPair[1] != null) {
                    urlProps.setProperty("PORT." + numHosts, hostPortPair[1]);
                    continue;
                }
                urlProps.setProperty("PORT." + numHosts, "3306");
            }
        } else {
            numHosts = 1;
            urlProps.setProperty("HOST.1", "localhost");
            urlProps.setProperty("PORT.1", "3306");
        }
        urlProps.setProperty(NUM_HOSTS_PROPERTY_KEY, String.valueOf(numHosts));
        urlProps.setProperty(HOST_PROPERTY_KEY, urlProps.getProperty("HOST.1"));
        urlProps.setProperty(PORT_PROPERTY_KEY, urlProps.getProperty("PORT.1"));
        String propertiesTransformClassName = urlProps.getProperty(PROPERTIES_TRANSFORM_KEY);
        if (propertiesTransformClassName != null) {
            try {
                ConnectionPropertiesTransform propTransformer = (ConnectionPropertiesTransform)Class.forName(propertiesTransformClassName).newInstance();
                urlProps = propTransformer.transformProperties(urlProps);
            }
            catch (InstantiationException var18) {
                throw SQLError.createSQLException("Unable to create properties transform instance '" + propertiesTransformClassName + "' due to underlying exception: " + var18.toString(), "01S00", (ExceptionInterceptor)null);
            }
            catch (IllegalAccessException var19) {
                throw SQLError.createSQLException("Unable to create properties transform instance '" + propertiesTransformClassName + "' due to underlying exception: " + var19.toString(), "01S00", (ExceptionInterceptor)null);
            }
            catch (ClassNotFoundException var20) {
                throw SQLError.createSQLException("Unable to create properties transform instance '" + propertiesTransformClassName + "' due to underlying exception: " + var20.toString(), "01S00", (ExceptionInterceptor)null);
            }
        }
        if (Util.isColdFusion() && urlProps.getProperty("autoConfigureForColdFusion", "true").equalsIgnoreCase("true")) {
            configNames = urlProps.getProperty(USE_CONFIG_PROPERTY_KEY);
            StringBuilder newConfigs = new StringBuilder();
            if (configNames != null) {
                newConfigs.append(configNames);
                newConfigs.append(",");
            }
            newConfigs.append("coldFusion");
            urlProps.setProperty(USE_CONFIG_PROPERTY_KEY, newConfigs.toString());
        }
        configNames = null;
        if (defaults != null) {
            configNames = defaults.getProperty(USE_CONFIG_PROPERTY_KEY);
        }
        if (configNames == null) {
            configNames = urlProps.getProperty(USE_CONFIG_PROPERTY_KEY);
        }
        if (configNames != null) {
            List<String> splitNames = StringUtils.split(configNames, ",", true);
            Properties configProps = new Properties();
            for (String configName : splitNames) {
                try {
                    InputStream configAsStream = NonRegisteringDriver.class.getResourceAsStream("configs/" + configName + ".properties");
                    if (configAsStream == null) {
                        throw SQLError.createSQLException("Can't find configuration template named '" + configName + "'", "01S00", (ExceptionInterceptor)null);
                    }
                    configProps.load(configAsStream);
                    configAsStream.close();
                }
                catch (IOException var17) {
                    SQLException sqlEx = SQLError.createSQLException("Unable to load configuration template '" + configName + "' due to underlying IOException: " + var17, "01S00", (ExceptionInterceptor)null);
                    sqlEx.initCause(var17);
                    throw sqlEx;
                }
            }
            Iterator<Object> propsIter = urlProps.keySet().iterator();
            while (propsIter.hasNext()) {
                String key = propsIter.next().toString();
                String property = urlProps.getProperty(key);
                configProps.setProperty(key, property);
            }
            urlProps = configProps;
        }
        if (defaults != null) {
            Iterator<Object> propsIter = defaults.keySet().iterator();
            while (propsIter.hasNext()) {
                String key = propsIter.next().toString();
                if (key.equals(NUM_HOSTS_PROPERTY_KEY)) continue;
                String property = defaults.getProperty(key);
                urlProps.setProperty(key, property);
            }
        }
        return urlProps;
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty(PORT_PROPERTY_KEY, "3306"));
    }

    public String property(String name, Properties props) {
        return props.getProperty(name);
    }

    public static Properties expandHostKeyValues(String host) {
        Properties hostProps = new Properties();
        if (NonRegisteringDriver.isHostPropertiesList(host)) {
            host = host.substring("address=".length() + 1);
            List<String> hostPropsList = StringUtils.split(host, ")", "'\"", "'\"", true);
            Iterator<String> iter = hostPropsList.iterator();
            while (true) {
                String value;
                if (!iter.hasNext()) {
                    return hostProps;
                }
                String propDef = iter.next();
                if (propDef.startsWith("(")) {
                    propDef = propDef.substring(1);
                }
                List<String> kvp = StringUtils.split(propDef, "=", "'\"", "'\"", true);
                String key = kvp.get(0);
                String string = value = kvp.size() > 1 ? kvp.get(1) : null;
                if (value != null && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
                    value = value.substring(1, value.length() - 1);
                }
                if (value == null) continue;
                if (!(HOST_PROPERTY_KEY.equalsIgnoreCase(key) || DBNAME_PROPERTY_KEY.equalsIgnoreCase(key) || PORT_PROPERTY_KEY.equalsIgnoreCase(key) || PROTOCOL_PROPERTY_KEY.equalsIgnoreCase(key) || PATH_PROPERTY_KEY.equalsIgnoreCase(key))) {
                    if (USER_PROPERTY_KEY.equalsIgnoreCase(key) || PASSWORD_PROPERTY_KEY.equalsIgnoreCase(key)) {
                        key = key.toLowerCase(Locale.ENGLISH);
                    }
                } else {
                    key = key.toUpperCase(Locale.ENGLISH);
                }
                hostProps.setProperty(key, value);
            }
        }
        return hostProps;
    }

    public static boolean isHostPropertiesList(String host) {
        return host != null && StringUtils.startsWithIgnoreCase(host, "address=");
    }

    static {
        try {
            Class.forName(AbandonedConnectionCleanupThread.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConnectionPhantomReference
    extends PhantomReference<ConnectionImpl> {
        private NetworkResources io;

        ConnectionPhantomReference(ConnectionImpl connectionImpl, ReferenceQueue<ConnectionImpl> q) {
            super(connectionImpl, q);
            try {
                this.io = connectionImpl.getIO().getNetworkResources();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            if (this.io != null) {
                try {
                    this.io.forceClose();
                }
                finally {
                    this.io = null;
                }
            }
        }
    }
}

