/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.loadbalance;

import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.NonRegisteringDriver;
import com.goldendb.jdbc.internal.core.loadbalance.MultiHostMySQLConnection;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiHostConnectionProxy
implements InvocationHandler {
    private static final String METHOD_GET_MULTI_HOST_SAFE_PROXY = "getMultiHostSafeProxy";
    private static final String METHOD_EQUALS = "equals";
    private static final String METHOD_HASH_CODE = "hashCode";
    private static final String METHOD_CLOSE = "close";
    private static final String METHOD_ABORT_INTERNAL = "abortInternal";
    private static final String METHOD_ABORT = "abort";
    private static final String METHOD_IS_CLOSED = "isClosed";
    private static final String METHOD_GET_AUTO_COMMIT = "getAutoCommit";
    private static final String METHOD_GET_CATALOG = "getCatalog";
    private static final String METHOD_GET_TRANSACTION_ISOLATION = "getTransactionIsolation";
    private static final String METHOD_GET_SESSION_MAX_ROWS = "getSessionMaxRows";
    public List<String> hostList;
    Properties localProps;
    public boolean autoReconnect = false;
    public MySQLConnection thisAsConnection = this.getNewWrapperForThisAsConnection();
    MySQLConnection proxyConnection = null;
    public MySQLConnection currentConnection = null;
    public boolean isClosed = false;
    public boolean closedExplicitly = false;
    public String closedReason = null;
    protected Throwable lastExceptionDealtWith = null;
    private static Constructor<?> JDBC_4_MS_CONNECTION_CTOR;

    public MultiHostConnectionProxy() throws SQLException {
    }

    public MultiHostConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        this();
        this.initializeHostsSpecs(hosts, props);
    }

    int initializeHostsSpecs(List<String> hosts, Properties props) {
        this.autoReconnect = "true".equalsIgnoreCase(props.getProperty("autoReconnect")) || "true".equalsIgnoreCase(props.getProperty("autoReconnectForPools"));
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        for (int i = 0; i < numHosts; ++i) {
            this.localProps.remove("HOST." + (i + 1));
            this.localProps.remove("PORT." + (i + 1));
        }
        this.localProps.remove("NUM_HOSTS");
        return numHosts;
    }

    MySQLConnection getNewWrapperForThisAsConnection() throws SQLException {
        return !Util.isJdbc4() && JDBC_4_MS_CONNECTION_CTOR == null ? new MultiHostMySQLConnection(this) : (MySQLConnection)Util.handleNewInstance(JDBC_4_MS_CONNECTION_CTOR, new Object[]{this}, null);
    }

    protected MySQLConnection getProxy() {
        return this.proxyConnection != null ? this.proxyConnection : this.thisAsConnection;
    }

    public final void setProxy(MySQLConnection proxyConn) {
        this.proxyConnection = proxyConn;
        this.propagateProxyDown(proxyConn);
    }

    protected void propagateProxyDown(MySQLConnection proxyConn) {
        this.currentConnection.setProxy(proxyConn);
    }

    public Object proxyIfReturnTypeIsJdbcInterface(Class<?> returnType, Object toProxy) {
        if (toProxy != null && Util.isJdbcInterface(returnType)) {
            Class<?> toProxyClass = toProxy.getClass();
            return Proxy.newProxyInstance(toProxyClass.getClassLoader(), Util.getImplementedInterfaces(toProxyClass), this.getNewJdbcInterfaceProxy(toProxy));
        }
        return toProxy;
    }

    InvocationHandler getNewJdbcInterfaceProxy(Object toProxy) {
        return new JdbcInterfaceProxy(toProxy);
    }

    public void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            if (this.lastExceptionDealtWith != t && this.shouldExceptionTriggerConnectionSwitch(t)) {
                this.invalidateCurrentConnection();
                this.pickNewConnection();
                this.lastExceptionDealtWith = t;
            }
            throw t;
        }
        throw e;
    }

    abstract boolean shouldExceptionTriggerConnectionSwitch(Throwable var1);

    abstract boolean isMasterConnection();

    public synchronized void invalidateCurrentConnection() throws SQLException {
        this.invalidateConnection(this.currentConnection);
    }

    synchronized void invalidateConnection(MySQLConnection conn) throws SQLException {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.realClose(true, !conn.getAutoCommit(), true, null);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    abstract void pickNewConnection() throws SQLException;

    public synchronized ConnectionImpl createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        String hostName = hostPortPair[0];
        String portNumber = hostPortPair[1];
        String dbName = connProps.getProperty("DBNAME");
        if (hostName == null) {
            throw new SQLException("Could not find a hostname to start a connection to");
        }
        if (portNumber == null) {
            portNumber = "3306";
        }
        connProps.setProperty("HOST", hostName);
        connProps.setProperty("PORT", portNumber);
        connProps.setProperty("HOST.1", hostName);
        connProps.setProperty("PORT.1", portNumber);
        connProps.setProperty("NUM_HOSTS", "1");
        connProps.setProperty("roundRobinLoadBalance", "false");
        ConnectionImpl conn = (ConnectionImpl)ConnectionImpl.getInstance(hostName, Integer.parseInt(portNumber), connProps, dbName, "jdbc:goldendb://" + hostName + ":" + portNumber + "/");
        conn.setProxy(this.getProxy());
        return conn;
    }

    public void syncSessionState(Connection source, Connection target) throws SQLException {
        if (source != null && target != null) {
            boolean prevUseLocalSessionState = source.getUseLocalSessionState();
            source.setUseLocalSessionState(true);
            boolean readOnly = source.isReadOnly();
            source.setUseLocalSessionState(prevUseLocalSessionState);
            this.syncSessionState(source, target, readOnly);
        }
    }

    void syncSessionState(Connection source, Connection target, boolean readOnly) throws SQLException {
        if (target != null) {
            target.setReadOnly(readOnly);
        }
        if (source != null && target != null) {
            boolean prevUseLocalSessionState = source.getUseLocalSessionState();
            source.setUseLocalSessionState(true);
            target.setAutoCommit(source.getAutoCommit());
            target.setCatalog(source.getCatalog());
            target.setTransactionIsolation(source.getTransactionIsolation());
            target.setSessionMaxRows(source.getSessionMaxRows());
            source.setUseLocalSessionState(prevUseLocalSessionState);
        }
    }

    public abstract void doClose() throws SQLException;

    public abstract void doAbortInternal() throws SQLException;

    public abstract void doAbort(Executor var1) throws SQLException;

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (METHOD_GET_MULTI_HOST_SAFE_PROXY.equals(methodName)) {
            return this.thisAsConnection;
        }
        if (METHOD_EQUALS.equals(methodName)) {
            return args[0].equals(this);
        }
        if (METHOD_HASH_CODE.equals(methodName)) {
            return this.hashCode();
        }
        if (METHOD_CLOSE.equals(methodName)) {
            this.doClose();
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            this.closedExplicitly = true;
            return null;
        }
        if (METHOD_ABORT_INTERNAL.equals(methodName)) {
            this.doAbortInternal();
            this.currentConnection.abortInternal();
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            return null;
        }
        if (METHOD_ABORT.equals(methodName) && args.length == 1) {
            this.doAbort((Executor)args[0]);
            this.isClosed = true;
            this.closedReason = "Connection explicitly closed.";
            return null;
        }
        if (METHOD_IS_CLOSED.equals(methodName)) {
            return this.isClosed;
        }
        try {
            return this.invokeMore(proxy, method, args);
        }
        catch (InvocationTargetException var12) {
            throw var12.getCause() != null ? var12.getCause() : var12;
        }
        catch (Exception var13) {
            Class<?>[] declaredException;
            Exception e = var13;
            Class<?>[] arr$ = declaredException = method.getExceptionTypes();
            int len$ = declaredException.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<?> declEx = arr$[i$];
                if (!declEx.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public abstract Object invokeMore(Object var1, Method var2, Object[] var3) throws Throwable;

    protected boolean allowedOnClosedConnection(Method method) {
        String methodName = method.getName();
        return methodName.equals(METHOD_GET_AUTO_COMMIT) || methodName.equals(METHOD_GET_CATALOG) || methodName.equals(METHOD_GET_TRANSACTION_ISOLATION) || methodName.equals(METHOD_GET_SESSION_MAX_ROWS);
    }

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_MS_CONNECTION_CTOR = Class.forName("com.goldendb.jdbc.internal.core.JDBC4MultiHostMySQLConnection").getConstructor(MultiHostConnectionProxy.class);
            }
            catch (SecurityException var1) {
                throw new RuntimeException(var1);
            }
            catch (NoSuchMethodException var2) {
                throw new RuntimeException(var2);
            }
            catch (ClassNotFoundException var3) {
                throw new RuntimeException(var3);
            }
        }
    }

    public class JdbcInterfaceProxy
    implements InvocationHandler {
        Object invokeOn = null;

        public JdbcInterfaceProxy(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (MultiHostConnectionProxy.METHOD_EQUALS.equals(method.getName())) {
                return args[0].equals(this);
            }
            MultiHostConnectionProxy multiHostConnectionProxy = MultiHostConnectionProxy.this;
            synchronized (multiHostConnectionProxy) {
                Object result = null;
                try {
                    result = method.invoke(this.invokeOn, args);
                    result = MultiHostConnectionProxy.this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
                }
                catch (InvocationTargetException var8) {
                    MultiHostConnectionProxy.this.dealWithInvocationException(var8);
                }
                return result;
            }
        }
    }
}

