/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.custom;

import com.goldendb.jdbc.AbandonedConnectionCleanupThread;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.NonRegisteringDriver;
import com.goldendb.jdbc.internal.custom.BlackListManager;
import com.goldendb.jdbc.internal.custom.GroupInfo;
import com.goldendb.jdbc.internal.log.GoldendbLog;
import com.goldendb.jdbc.internal.log.LogFactory;
import com.goldendb.jdbc.internal.log.StandardLogger;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.internal.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager {
    public static final ConcurrentHashMap<String, Integer> hostConnectionCountMap = new ConcurrentHashMap();
    private Map<String, java.sql.Connection> shadowLink = new ConcurrentHashMap<String, java.sql.Connection>();
    private Map<String, List<java.sql.Connection>> hostConnectionMap = new ConcurrentHashMap<String, List<java.sql.Connection>>();
    private Map<String, Properties> propMap = new HashMap<String, Properties>();
    private Properties props = null;
    private static ConnectionManager connManager = new ConnectionManager();
    private String fullUrl = new String("");
    private String MaterDN = new String("");
    private Set<String> hosts = new LinkedHashSet<String>();
    private Set<String> urlSet = new LinkedHashSet<String>();
    public static final ConnectionMonitorThread connMonitor = new ConnectionMonitorThread();
    public static final BlackListManager blacklistMonitor = new BlackListManager();
    public static final ConnectionMasterDNThread connMasterDN = new ConnectionMasterDNThread();

    public static ConnectionManager getInstance() {
        return connManager;
    }

    public Map<String, Properties> getPropMap() {
        return this.propMap;
    }

    public void setProps(Properties p) {
        if (null == this.props && null != p) {
            this.props = p;
        }
    }

    public Properties getProps() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFullUrl(String url) {
        String string = this.fullUrl;
        synchronized (string) {
            if (!StringUtils.isEmptyOrWhitespaceOnly(url)) {
                this.fullUrl = url;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaterDN(String masterdn) {
        String string = this.MaterDN;
        synchronized (string) {
            if (!StringUtils.isEmptyOrWhitespaceOnly(this.MaterDN)) {
                this.MaterDN = masterdn;
            }
        }
    }

    public void dupKillConn(java.sql.Connection sCon, int index) {
        final ConnectionImpl bConn = (ConnectionImpl)sCon;
        try {
            Thread killThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block34: {
                        Statement cancelStmt;
                        java.sql.Connection killCon;
                        block32: {
                            block31: {
                                killCon = null;
                                cancelStmt = null;
                                if (!(null != bConn & !bConn.isClosed())) break block31;
                                killCon = bConn.duplicate();
                                cancelStmt = killCon.createStatement();
                                cancelStmt.execute("KILL connection " + bConn.getId());
                            }
                            Object var5_3 = null;
                            if (cancelStmt == null) break block32;
                            try {
                                cancelStmt.close();
                            }
                            catch (SQLException var24) {
                                ConnectionManager.this.log(bConn, "dupKillConn SQLException " + var24.getMessage());
                            }
                        }
                        if (killCon != null) {
                            try {
                                killCon.close();
                            }
                            catch (SQLException var23) {
                                ConnectionManager.this.log(killCon, "dupKillConn SQLException " + var23.getMessage());
                            }
                        }
                        try {
                            if (null != bConn & !bConn.isClosed()) {
                                bConn.close();
                            }
                            break block34;
                        }
                        catch (Exception var22) {
                            ConnectionManager.this.log(bConn, "dupKillConn Exception " + var22.getMessage());
                        }
                        break block34;
                        {
                            catch (NullPointerException var25) {
                                ConnectionManager.this.log(bConn, "dupKillConn NullPointerException " + var25.getMessage());
                                Object var5_4 = null;
                                if (cancelStmt != null) {
                                    try {
                                        cancelStmt.close();
                                    }
                                    catch (SQLException var24) {
                                        ConnectionManager.this.log(bConn, "dupKillConn SQLException " + var24.getMessage());
                                    }
                                }
                                if (killCon != null) {
                                    try {
                                        killCon.close();
                                    }
                                    catch (SQLException var23) {
                                        ConnectionManager.this.log(killCon, "dupKillConn SQLException " + var23.getMessage());
                                    }
                                }
                                try {
                                    if (null != bConn & !bConn.isClosed()) {
                                        bConn.close();
                                    }
                                    break block34;
                                }
                                catch (Exception var22) {
                                    ConnectionManager.this.log(bConn, "dupKillConn Exception " + var22.getMessage());
                                }
                                break block34;
                            }
                            catch (SQLException var26) {
                                ConnectionManager.this.log(bConn, "dupKillConn SQLException " + var26.getMessage());
                                Object var5_5 = null;
                                if (cancelStmt != null) {
                                    try {
                                        cancelStmt.close();
                                    }
                                    catch (SQLException var24) {
                                        ConnectionManager.this.log(bConn, "dupKillConn SQLException " + var24.getMessage());
                                    }
                                }
                                if (killCon != null) {
                                    try {
                                        killCon.close();
                                    }
                                    catch (SQLException var23) {
                                        ConnectionManager.this.log(killCon, "dupKillConn SQLException " + var23.getMessage());
                                    }
                                }
                                try {
                                    if (null != bConn & !bConn.isClosed()) {
                                        bConn.close();
                                    }
                                    break block34;
                                }
                                catch (Exception var22) {
                                    ConnectionManager.this.log(bConn, "dupKillConn Exception " + var22.getMessage());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            if (cancelStmt != null) {
                                try {
                                    cancelStmt.close();
                                }
                                catch (SQLException var24) {
                                    ConnectionManager.this.log(bConn, "dupKillConn SQLException " + var24.getMessage());
                                }
                            }
                            if (killCon != null) {
                                try {
                                    killCon.close();
                                }
                                catch (SQLException var23) {
                                    ConnectionManager.this.log(killCon, "dupKillConn SQLException " + var23.getMessage());
                                }
                            }
                            try {
                                if (null != bConn & !bConn.isClosed()) {
                                    bConn.close();
                                }
                            }
                            catch (Exception var22) {
                                ConnectionManager.this.log(bConn, "dupKillConn Exception " + var22.getMessage());
                            }
                            throw throwable;
                        }
                    }
                }
            };
            killThread.start();
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(final String host, java.sql.Connection conn) {
        List<Object> sCons = null;
        Map<String, List<java.sql.Connection>> map = this.hostConnectionMap;
        synchronized (map) {
            if (this.hostConnectionMap.containsKey(host)) {
                List<Object> list = sCons = this.hostConnectionMap.get(host);
                synchronized (list) {
                    sCons.add(conn);
                }
            } else {
                sCons = new ArrayList<java.sql.Connection>();
                sCons.add(conn);
            }
            this.hostConnectionMap.put(host, sCons);
        }
        if (null == this.props) {
            this.props = ((ConnectionImpl)this.hostConnectionMap.get(host).get(0)).getProperties();
        }
        boolean shadowThreadFlag = Boolean.parseBoolean(this.props.getProperty("shadowThreadSwitch", "false"));
        Thread shadowThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int i = 0;
                java.sql.Connection newConn = null;
                while (i++ < 5) {
                    try {
                        Map map = ConnectionManager.this.shadowLink;
                        synchronized (map) {
                            if (!ConnectionManager.this.shadowLink.containsKey(host)) {
                                Properties prop = ((ConnectionImpl)((List)ConnectionManager.this.hostConnectionMap.get(host)).get(0)).getProperties();
                                ConnectionManager.getInstance().setProps(prop);
                                newConn = ConnectionManager.this.copyConn(host);
                                ConnectionManager.this.shadowLink.put(host, newConn);
                                break;
                            }
                        }
                    }
                    catch (Exception var17) {
                        ConnectionManager.this.log(newConn, "shadowThread SQLException " + var17.getMessage());
                    }
                }
                if (null != newConn) {
                    Statement stmt = null;
                    boolean flag = true;
                    int errorCountMax = Integer.parseInt(ConnectionManager.this.props.getProperty("errorCount", "1"));
                    if (errorCountMax == 0) {
                        errorCountMax = 1;
                    }
                    int counts = 0;
                    while (flag) {
                        try {
                            int intervalTime = 6000;
                            if (null != ConnectionManager.this.props) {
                                intervalTime = Integer.parseInt(ConnectionManager.this.props.getProperty("intervalTime", "0"));
                                intervalTime = intervalTime == 0 ? 3000 : intervalTime;
                            }
                            Thread.sleep(intervalTime);
                            if (null == newConn || newConn.isClosed()) continue;
                            stmt = newConn.createStatement();
                            stmt.execute("select 1");
                            stmt.close();
                            int k = ConnectionManager.this.getHostCount(host);
                            if (0 != k) continue;
                            break;
                        }
                        catch (Exception var15) {
                            if (++counts < errorCountMax) continue;
                            ConnectionManager.getInstance().dupKillConn(newConn, 0);
                            hostConnectionCountMap.remove(host);
                            ConnectionManager.this.log(newConn, "add ip [" + host + "] to blacklist");
                            List sCons = (List)ConnectionManager.this.hostConnectionMap.get(host);
                            ConnectionManager.this.shadowLink.remove(host);
                            int kx = 0;
                            List list = sCons;
                            synchronized (list) {
                                for (java.sql.Connection sCon : sCons) {
                                    ConnectionManager.getInstance().dupKillConn(sCon, kx);
                                    ++kx;
                                }
                            }
                            ConnectionManager.this.hostConnectionMap.remove(host);
                            flag = false;
                            counts = 0;
                        }
                    }
                }
            }
        };
        if (shadowThreadFlag) {
            shadowThread.start();
        }
    }

    private java.sql.Connection copyConn(String host) throws SQLException {
        Properties prop = this.props;
        if (null == this.props) {
            return null;
        }
        int connectTimeout = Integer.parseInt(prop.getProperty("connectTimeout", "10000"));
        int socketTimeout = Integer.parseInt(prop.getProperty("socketTimeout", "0"));
        connectTimeout = connectTimeout == 0 ? 5000 : connectTimeout;
        socketTimeout = socketTimeout == 0 ? 10000 : socketTimeout;
        String url = "jdbc:goldendb://" + host + "/?useSSL=false&connectTimeout=" + connectTimeout + "&socketTimeout=" + socketTimeout;
        int port = Integer.parseInt(prop.getProperty("PORT", "3306"));
        String db = prop.getProperty("DBNAME", "");
        Connection newConn = ConnectionImpl.getInstance(host, port, prop, db, url);
        return newConn;
    }

    public void addSingleUrl(String url) {
        this.urlSet.add(url);
    }

    public void addAllHost(List<String> l) {
        if (this.hosts.size() == 0) {
            for (String h : l) {
                this.hosts.add(h);
            }
        }
    }

    public Set<String> getAllHost() {
        return this.hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostCount(String host) {
        int count = 0;
        ConcurrentHashMap<String, Integer> concurrentHashMap = hostConnectionCountMap;
        synchronized (concurrentHashMap) {
            try {
                if (hostConnectionCountMap.containsKey(host)) {
                    count = hostConnectionCountMap.get(host);
                }
            }
            catch (Exception var6) {
                var6.printStackTrace();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostCount(String host, int count) {
        ConcurrentHashMap<String, Integer> concurrentHashMap = hostConnectionCountMap;
        synchronized (concurrentHashMap) {
            count = hostConnectionCountMap.put(host, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseHostCount(String host) {
        ConcurrentHashMap<String, Integer> concurrentHashMap = hostConnectionCountMap;
        synchronized (concurrentHashMap) {
            try {
                int count = 1;
                if (hostConnectionCountMap.containsKey(host)) {
                    count += hostConnectionCountMap.get(host).intValue();
                }
                hostConnectionCountMap.put(host, count);
            }
            catch (Exception var5) {
                var5.printStackTrace();
            }
        }
    }

    public void log(java.sql.Connection newConn, String message) {
        if (newConn instanceof MySQLConnection) {
            try {
                ((MySQLConnection)newConn).getLog().logError(message);
            }
            catch (SQLException var4) {
                var4.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getGlobalHostlist() {
        HashSet<String> monitorlistClone = null;
        Map<String, List<java.sql.Connection>> map = this.hostConnectionMap;
        synchronized (map) {
            monitorlistClone = new HashSet<String>(this.hostConnectionMap.keySet());
            return monitorlistClone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostLiveNum(String host) {
        int liveNum = 0;
        List<java.sql.Connection> sCons = null;
        Object object = this.hostConnectionMap;
        synchronized (object) {
            if (hostConnectionCountMap.containsKey(host)) {
                sCons = this.hostConnectionMap.get(host);
            }
        }
        if (null == sCons) {
            return liveNum;
        }
        object = sCons;
        synchronized (object) {
            try {
                Iterator<java.sql.Connection> iterator = sCons.iterator();
                while (iterator.hasNext()) {
                    java.sql.Connection sCon = iterator.next();
                    if (!sCon.isClosed()) continue;
                    iterator.remove();
                }
                liveNum = sCons.size();
            }
            catch (Exception var8) {
                var8.printStackTrace();
            }
            return liveNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killNoMasterConnection(HashSet<String> hosts, String masterIp, Boolean bPrintCount) {
        for (String host : hosts) {
            if (StringUtils.startsWithIgnoreCaseAndWs(host, masterIp)) continue;
            List<java.sql.Connection> sCons = null;
            Object object = this.hostConnectionMap;
            synchronized (object) {
                if (hostConnectionCountMap.containsKey(host)) {
                    sCons = this.hostConnectionMap.get(host);
                }
            }
            if (null == sCons || sCons.size() <= 0) continue;
            if (bPrintCount.booleanValue()) {
                System.out.println("kill no masterCN:" + host + " masterCN:" + masterIp);
            }
            object = sCons;
            synchronized (object) {
                try {
                    for (java.sql.Connection sCon : sCons) {
                        if (sCon.isClosed()) continue;
                        this.dupKillConn(sCon, 0);
                    }
                }
                catch (Exception var8) {
                    var8.printStackTrace();
                }
            }
        }
    }

    public String parseIp(String host) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            String address = inetAddress.getHostAddress();
            return address;
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public Boolean isMaterIp(Properties defaults, String hostPortPair, String materIP) throws SQLException {
        boolean bMaster = false;
        GoldendbLog log = null;
        String logger = defaults.getProperty("logger", StandardLogger.class.getName());
        log = LogFactory.getLogger(logger, "MySQL", null);
        Boolean bPrintCount = Boolean.parseBoolean(defaults.getProperty("printDebugLog", "false"));
        if (null == hostPortPair || null == materIP) {
            return bMaster;
        }
        String newurl = "jdbc:goldendb://" + hostPortPair + "/?logger=com.goldendb.jdbc.log.NullLogger";
        Properties props = NonRegisteringDriver.parseURL(newurl, null);
        if (null != props) {
            String hostIp = this.host(props);
            if (null == hostIp) {
                return bMaster;
            }
            String parseTmpIp = this.parseIp(hostIp);
            String parseMasterIp = this.parseIp(materIP);
            if (bPrintCount.booleanValue()) {
                log.logInfo("parseIP " + hostIp + "--->" + parseTmpIp);
            }
            if (null == parseTmpIp || null == parseMasterIp) {
                return bMaster;
            }
            bMaster = StringUtils.startsWithIgnoreCaseAndWs(parseTmpIp, parseMasterIp);
        }
        return bMaster;
    }

    int getMasterGroupIndex(Properties prop, int numGroups, String materIP) throws SQLException {
        int index = 0;
        for (int i = 1; i <= numGroups; ++i) {
            String hostStuff = null;
            String groupName = "proxygroup" + i;
            hostStuff = prop.getProperty(groupName);
            if (null == hostStuff) continue;
            boolean bMaster = false;
            List<String> hosts = StringUtils.split(hostStuff, ",", "\"'", "\"'", true);
            if (null == hosts || hosts.size() <= 0) continue;
            for (String tmpIP : hosts) {
                bMaster = this.isMaterIp(prop, tmpIP, materIP);
                if (!bMaster) continue;
                index = i;
                return index;
            }
        }
        return index;
    }

    public List<GroupInfo> getHostList(Properties prop, String materIP) throws SQLException {
        ArrayList<GroupInfo> groupHostList = new ArrayList<GroupInfo>();
        if (null == prop) {
            return groupHostList;
        }
        int index = 0;
        int numGroups = Integer.parseInt(prop.getProperty("proxygroups", "0"));
        if (numGroups > 0) {
            if (null != materIP && materIP.length() > 0) {
                List<String> hosts;
                index = this.getMasterGroupIndex(prop, numGroups, materIP);
                String superMaterGroupName = "proxygroup_super";
                String materGroupName = "proxygroup" + index;
                String msterHostStuff = prop.getProperty(materGroupName);
                ArrayList<String> superMaterHosts = new ArrayList<String>();
                ArrayList<String> materhosts = new ArrayList<String>();
                if (null != msterHostStuff && null != (hosts = StringUtils.split(msterHostStuff, ",", "\"'", "\"'", true)) && hosts.size() > 0) {
                    GroupInfo group;
                    for (String tmpIP : hosts) {
                        boolean bMaster = false;
                        bMaster = this.isMaterIp(prop, tmpIP, materIP);
                        if (bMaster) {
                            superMaterHosts.add(tmpIP);
                            continue;
                        }
                        materhosts.add(tmpIP);
                    }
                    if (superMaterHosts.size() > 0) {
                        group = new GroupInfo(0, superMaterGroupName, superMaterHosts);
                        groupHostList.add(group);
                    }
                    if (materhosts.size() > 0) {
                        group = new GroupInfo(index, materGroupName, materhosts);
                        groupHostList.add(group);
                    }
                }
            }
            for (int i = 1; i <= numGroups; ++i) {
                List<String> hosts;
                if (i == index) continue;
                String hostStuff = null;
                String groupName = "proxygroup" + i;
                hostStuff = prop.getProperty(groupName);
                if (null == hostStuff || null == (hosts = StringUtils.split(hostStuff, ",", "\"'", "\"'", true)) || hosts.size() <= 0) continue;
                GroupInfo group = new GroupInfo(i, groupName, hosts);
                groupHostList.add(group);
            }
        }
        return groupHostList;
    }

    public List<String> getGroupHost(Properties prop, int groupIndex) {
        ArrayList<String> hostList = null;
        try {
            int numGroups = Integer.parseInt(prop.getProperty("proxygroups", "0"));
            hostList = new ArrayList<String>();
            for (int i = 1; i <= numGroups; ++i) {
                List<String> hosts;
                if (i == groupIndex) continue;
                String hostStuff = null;
                String groupName = "proxygroup" + i;
                hostStuff = prop.getProperty(groupName);
                if (null == hostStuff || null == (hosts = StringUtils.split(hostStuff, ",", "\"'", "\"'", true)) || hosts.size() <= 0) continue;
                hostList.addAll(hosts);
            }
        }
        catch (Exception ex) {
            return null;
        }
        return hostList;
    }

    public void checkSameGroupInfo(Properties prop) throws SQLException {
        if (null == prop) {
            return;
        }
        int numGroups = Integer.parseInt(prop.getProperty("proxygroups", "0"));
        for (int i = 1; i <= numGroups; ++i) {
            String hostStuff = null;
            String groupName = "proxygroup" + i;
            hostStuff = prop.getProperty(groupName);
            if (null == hostStuff) continue;
            List<String> curHosts = StringUtils.split(hostStuff, ",", "\"'", "\"'", true);
            List<String> otherHosts = this.getGroupHost(prop, i);
            for (String curIP : curHosts) {
                int portIndex = curIP.indexOf(":");
                String hostname = null;
                if (portIndex == -1 || portIndex + 1 >= curIP.length()) continue;
                hostname = curIP.substring(0, portIndex);
                if (null == otherHosts || otherHosts.size() <= 0) continue;
                for (String tmpIP : otherHosts) {
                    if (!StringUtils.startsWithIgnoreCaseAndWs(tmpIP, hostname)) continue;
                    throw SQLError.createSQLException("proxygroup" + i + " " + hostStuff + " has same ip in other proxygroup", "08001", (ExceptionInterceptor)null);
                }
            }
        }
    }

    public void checkGroupInfo(Properties prop) throws SQLException {
        int numGroups = Integer.parseInt(prop.getProperty("proxygroups", "0"));
        for (int i = 1; i <= numGroups; ++i) {
            List<String> hosts;
            String hostStuff = null;
            String groupName = "proxygroup" + i;
            hostStuff = prop.getProperty(groupName);
            if (null == hostStuff || null == (hosts = StringUtils.split(hostStuff, ",", "\"'", "\"'", true)) || hosts.size() <= 1) continue;
            String hostPortPair = hosts.get(0);
            int portIndex = hostPortPair.indexOf(":");
            String hostname = null;
            if (portIndex == -1 || portIndex + 1 >= hostPortPair.length()) continue;
            hostname = hostPortPair.substring(0, portIndex);
            for (int j = 1; j < hosts.size(); ++j) {
                String hostPair = hosts.get(j);
                if (StringUtils.startsWithIgnoreCaseAndWs(hostPair, hostname)) continue;
                throw SQLError.createSQLException("proxygroup" + i + " " + hostStuff + " ip are different", "08001", (ExceptionInterceptor)null);
            }
        }
    }

    public String host(Properties props) {
        return props.getProperty("HOST", "localhost");
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty("PORT", "3306"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMsterIP(Properties prop, String url) {
        java.sql.Connection newConn = null;
        String masterIP = null;
        try {
            int connectTimeout = Integer.parseInt(prop.getProperty("connectTimeout", "10000"));
            int socketTimeout = Integer.parseInt(prop.getProperty("socketTimeout", "0"));
            connectTimeout = connectTimeout == 0 ? 5000 : connectTimeout;
            socketTimeout = socketTimeout == 0 ? 10000 : socketTimeout;
            int numGroups = Integer.parseInt(prop.getProperty("proxygroups", "0"));
            ArrayList<String> hostList = new ArrayList<String>();
            for (int i = 1; i <= numGroups; ++i) {
                List<String> hosts;
                String hostStuff = null;
                String groupName = "proxygroup" + i;
                hostStuff = prop.getProperty(groupName);
                if (null == hostStuff || null == (hosts = StringUtils.split(hostStuff, ",", "\"'", "\"'", true)) || hosts.size() <= 0) continue;
                hostList.addAll(hosts);
            }
            for (String hostPortPair : hostList) {
                Exception e22;
                Object var16_19;
                block19: {
                    String newurl = "jdbc:goldendb://" + hostPortPair + "/?useSSL=false&connectTimeout=" + connectTimeout + "&socketTimeout=" + socketTimeout + "&logger=com.goldendb.jdbc.log.NullLogger";
                    Properties props = NonRegisteringDriver.parseURL(newurl, null);
                    if (null != props) {
                        props.setProperty("user", prop.getProperty("user"));
                        props.setProperty("password", prop.getProperty("password"));
                        props.setProperty("logger", "com.goldendb.jdbc.log.NullLogger");
                        newConn = ConnectionImpl.getInstance(this.host(props), this.port(props), props, null, newurl);
                    }
                    if (null != newConn) {
                        Statement stmt = newConn.createStatement();
                        ResultSet rs = stmt.executeQuery("show variables like 'bind_address';");
                        while (rs.next()) {
                            masterIP = rs.getString(2);
                        }
                    }
                    if (null == masterIP) break block19;
                    var16_19 = null;
                    try {
                        if (null == newConn || newConn.isClosed()) return masterIP;
                        newConn.close();
                        return masterIP;
                    }
                    catch (Exception e22) {}
                    return masterIP;
                }
                var16_19 = null;
                try {
                    if (null == newConn || newConn.isClosed()) continue;
                    newConn.close();
                }
                catch (Exception e22) {}
                continue;
                {
                    catch (SQLException throwables) {
                        var16_19 = null;
                        try {
                            if (null == newConn || newConn.isClosed()) continue;
                            newConn.close();
                        }
                        catch (Exception e22) {}
                        continue;
                    }
                    catch (Exception ex) {
                        var16_19 = null;
                        try {
                            if (null == newConn || newConn.isClosed()) continue;
                            newConn.close();
                        }
                        catch (Exception e22) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var16_19 = null;
                    try {
                        if (null == newConn || newConn.isClosed()) throw throwable;
                        newConn.close();
                        throw throwable;
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                    throw throwable;
                    return masterIP;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return masterIP;
    }

    private static void checkMsterDN() throws SQLException {
        Properties prop = ConnectionManager.getInstance().props;
        String url = ConnectionManager.getInstance().fullUrl;
        if (null == prop || null == url) {
            return;
        }
        Boolean bPrintCount = Boolean.parseBoolean(prop.getProperty("printDebugLog", "false"));
        String masterip = ConnectionManager.getInstance().getMsterIP(prop, url);
        if (null != masterip && bPrintCount.booleanValue()) {
            System.out.println("masterCN:" + masterip);
        }
    }

    public static class ConnectionMasterDNThread
    implements Runnable {
        private static ExecutorService ConnectionMasterDNThreadExcecutorService;
        static Thread threadRef;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object var5_6;
                try {
                    block7: {
                        try {
                            Boolean masterConnection = false;
                            int intervalTime = 3000;
                            Properties props = ConnectionManager.getInstance().getProps();
                            if (null != props) {
                                intervalTime = Integer.parseInt(props.getProperty("intervalTime", "0"));
                                intervalTime = intervalTime == 0 ? 3000 : intervalTime;
                                masterConnection = Boolean.parseBoolean(props.getProperty("masterConnection", "false"));
                            }
                            Thread.sleep(intervalTime);
                            if (!masterConnection.booleanValue()) break block7;
                            ConnectionManager.checkMsterDN();
                        }
                        catch (InterruptedException e) {
                            threadRef = null;
                            var5_6 = null;
                            return;
                        }
                        catch (Exception exception) {
                            var5_6 = null;
                            continue;
                        }
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    throw throwable;
                }
            }
        }

        static {
            threadRef = null;
            ConnectionMasterDNThreadExcecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "Abandoned connection cleanup thread");
                    t.setDaemon(true);
                    t.setContextClassLoader(AbandonedConnectionCleanupThread.class.getClassLoader());
                    threadRef = t;
                    return threadRef;
                }
            });
            ConnectionMasterDNThreadExcecutorService.execute(new ConnectionMasterDNThread());
        }
    }

    public static class ConnectionMonitorThread
    implements Runnable {
        private static ExecutorService ConnectionMonitorThreadExcecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Abandoned connection cleanup thread");
                t.setDaemon(true);
                t.setContextClassLoader(AbandonedConnectionCleanupThread.class.getClassLoader());
                threadRef = t;
                return t;
            }
        });
        static Thread threadRef = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object var9_10;
                try {
                    try {
                        int intervalTime = 3000;
                        Boolean bPrintCount = false;
                        Properties props = ConnectionManager.getInstance().getProps();
                        if (null != props) {
                            intervalTime = Integer.parseInt(props.getProperty("intervalTime", "0"));
                            intervalTime = intervalTime == 0 ? 3000 : intervalTime;
                            bPrintCount = Boolean.parseBoolean(props.getProperty("printDebugLog", "false"));
                        }
                        Thread.sleep(intervalTime);
                        HashSet<String> monitorList = ConnectionManager.getInstance().getGlobalHostlist();
                        for (String host : monitorList) {
                            if (bPrintCount.booleanValue()) {
                                System.out.println(host + " Befor connection count:" + ConnectionManager.getInstance().getHostCount(host));
                            }
                            int count = ConnectionManager.getInstance().getHostLiveNum(host);
                            if (bPrintCount.booleanValue()) {
                                System.out.println(host + "  live connection:" + count);
                            }
                            ConnectionManager.getInstance().setHostCount(host, count);
                            if (!bPrintCount.booleanValue()) continue;
                            System.out.println(host + "  after connection count:" + ConnectionManager.getInstance().getHostCount(host));
                        }
                        var9_10 = null;
                    }
                    catch (InterruptedException var13) {
                        threadRef = null;
                        var9_10 = null;
                        return;
                    }
                    catch (Exception exception) {
                        var9_10 = null;
                    }
                }
                catch (Throwable throwable) {
                    var9_10 = null;
                    throw throwable;
                }
            }
        }

        static {
            ConnectionMonitorThreadExcecutorService.execute(new ConnectionMonitorThread());
        }
    }
}

