/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.jdbc2.optional;

import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.jdbc2.optional.ConnectionWrapper;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class GoldendbPooledConnection
implements PooledConnection {
    private static final Constructor<?> JDBC_4_POOLED_CONNECTION_WRAPPER_CTOR;
    public static final int CONNECTION_ERROR_EVENT = 1;
    public static final int CONNECTION_CLOSED_EVENT = 2;
    private Map<ConnectionEventListener, ConnectionEventListener> connectionEventListeners;
    private java.sql.Connection logicalHandle = null;
    private Connection physicalConn;
    private ExceptionInterceptor exceptionInterceptor;

    protected static GoldendbPooledConnection getInstance(Connection connection) throws SQLException {
        return !Util.isJdbc4() ? new GoldendbPooledConnection(connection) : (GoldendbPooledConnection)Util.handleNewInstance(JDBC_4_POOLED_CONNECTION_WRAPPER_CTOR, new Object[]{connection}, connection.getExceptionInterceptor());
    }

    public GoldendbPooledConnection(Connection connection) {
        this.physicalConn = connection;
        this.connectionEventListeners = new HashMap<ConnectionEventListener, ConnectionEventListener>();
        this.exceptionInterceptor = this.physicalConn.getExceptionInterceptor();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectioneventlistener) {
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.put(connectioneventlistener, connectioneventlistener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectioneventlistener) {
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.remove(connectioneventlistener);
        }
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        return this.getConnection(true, false);
    }

    protected synchronized java.sql.Connection getConnection(boolean resetServerState, boolean forXa) throws SQLException {
        if (this.physicalConn == null) {
            SQLException sqlException = SQLError.createSQLException("Physical Connection doesn't exist", this.exceptionInterceptor);
            this.callConnectionEventListeners(1, sqlException);
            throw sqlException;
        }
        try {
            if (this.logicalHandle != null) {
                ((ConnectionWrapper)this.logicalHandle).close(false);
            }
            if (resetServerState) {
                this.physicalConn.resetServerState();
            }
            this.logicalHandle = ConnectionWrapper.getInstance(this, this.physicalConn, forXa);
        }
        catch (SQLException var4) {
            this.callConnectionEventListeners(1, var4);
            throw var4;
        }
        return this.logicalHandle;
    }

    public synchronized void close() throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.close();
            this.physicalConn = null;
        }
        if (this.connectionEventListeners != null) {
            this.connectionEventListeners.clear();
            this.connectionEventListeners = null;
        }
    }

    protected synchronized void callConnectionEventListeners(int eventType, SQLException sqlException) {
        if (this.connectionEventListeners != null) {
            Iterator<Map.Entry<ConnectionEventListener, ConnectionEventListener>> iterator = this.connectionEventListeners.entrySet().iterator();
            ConnectionEvent connectionevent = new ConnectionEvent(this, sqlException);
            while (iterator.hasNext()) {
                ConnectionEventListener connectioneventlistener = iterator.next().getValue();
                if (eventType == 2) {
                    connectioneventlistener.connectionClosed(connectionevent);
                    continue;
                }
                if (eventType != 1) continue;
                connectioneventlistener.connectionErrorOccurred(connectionevent);
            }
        }
    }

    protected ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_POOLED_CONNECTION_WRAPPER_CTOR = Class.forName("com.goldendb.jdbc.internal.jdbc2.JDBC4GoldendbPooledConnection").getConstructor(Connection.class);
            }
            catch (SecurityException var1) {
                throw new RuntimeException(var1);
            }
            catch (NoSuchMethodException var2) {
                throw new RuntimeException(var2);
            }
            catch (ClassNotFoundException var3) {
                throw new RuntimeException(var3);
            }
        } else {
            JDBC_4_POOLED_CONNECTION_WRAPPER_CTOR = null;
        }
    }
}

