/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.SuppressFBWarnings;
import com.hundsun.lightdb.TableExportStat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "PATH_TRAVERSAL_IN", "SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL", "DMI_HARDCODED_EXEC_COMMAND", "COMMAND_INJECTION"})
public class OracleExport {
    private static final Logger log = LoggerFactory.getLogger(OracleExport.class);
    static final CopyOnWriteArrayList<TableExportStat> STATS = new CopyOnWriteArrayList();

    public static void printTime(long currentTimeMillis, String prefix) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedTime = dateFormat.format(new Date(currentTimeMillis));
        log.info(prefix + formattedTime);
    }

    public static native int addOne(int var0);

    public static void main(String[] args) throws IOException, InterruptedException {
        String finalDataDir;
        BufferedReader reader;
        File dir;
        boolean justTest;
        log.info("\u672c\u7a0b\u5e8f\u4e3a\u4e86\u786e\u4fdd\u6700\u5927\u5316\u6027\u80fd\uff0c\u5e94\u8fd0\u884c\u5728lightdb\u670d\u52a1\u7aef\u6240\u5728\u7684\u670d\u52a1\u5668, \u6240\u4ee5\u4e0d\u4f20\u9012ip");
        log.info(System.getProperty("java.library.path"));
        long currentTimeMillis = System.currentTimeMillis();
        OracleExport.printTime((long)currentTimeMillis, (String)"\u5f00\u59cb\u65f6\u95f4\uff1a");
        int threadCount = 4;
        String s = System.getProperty("threadCount");
        if (s != null) {
            threadCount = Integer.parseInt(s);
        }
        long keepAliveTime = 60L;
        TimeUnit unit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE);
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, keepAliveTime, unit, workQueue, threadFactory);
        String dataDir = System.getProperty("data.dir");
        String userInfo = System.getProperty("userInfo");
        boolean hasNull = System.getProperty("hasNull") != null;
        String sep = System.getProperty("sep");
        boolean bl = justTest = System.getProperty("limit100") != null;
        if (dataDir == null && userInfo == null) {
            log.info("usage: java -Ddata.dir=xxx -DuserInfo=username/password@ip:port/dbname -jar oracleexport.jar\ndata.dir \u6587\u4ef6\u5b58\u653e\u8def\u5f84\nuserInfo \u5230oracle\u7684\u8fde\u63a5\u4e32\nsep \u5b57\u6bb5\u5206\u9694\u7b26\uff0c\u9ed8\u8ba4i_mpig\nshardCount \u975e\u5206\u533a\u8868\u5206\u7247\u6570 \u9ed8\u8ba420\nthreadCount \u7ebf\u7a0b\u6570,\u9ed8\u8ba44\nhasNull \u53d6\u6a21\u5b57\u6bb5\u662f\u5426\u6709null\u503c\uff0c\u6700\u597d\u9009\u6ca1\u6709\u7684\uff0c\u540c\u65f6\u4e0d\u8981\u914d\u7f6e\u8be5\u9009\u9879\nlimit100 \u662f\u5426\u4ec5\u5bfc\u51fa100\u884c\uff08\u6d4b\u8bd5\u76ee\u7684\uff09\n\u6d89\u53ca\u7684\u914d\u7f6e\u6587\u4ef6\uff1anotPartTable.txt\uff0cpartTable.txt");
            System.exit(-1);
        }
        int notPartTableShardCount = 20;
        s = System.getProperty("shardCount");
        if (s != null) {
            notPartTableShardCount = Integer.parseInt(s);
        }
        if (sep == null) {
            sep = "i_mpig";
        }
        if (userInfo == null) {
            log.error("-DuserInfo\u5fc5\u987b\u4f20\u9012\uff0c\u683c\u5f0f\uff1ausername/password@ip:port/dbname");
            System.exit(-1);
        }
        if (dataDir == null) {
            dataDir = "/home/lightdb";
        }
        if (!(dir = new File(dataDir)).exists()) {
            dir.mkdirs();
        }
        AtomicIntegerArray totalFile = new AtomicIntegerArray(1);
        AtomicIntegerArray success = new AtomicIntegerArray(1);
        AtomicIntegerArray failed = new AtomicIntegerArray(1);
        try {
            String notPartTable;
            reader = new BufferedReader(new FileReader("notPartTable.txt"));
            while ((notPartTable = reader.readLine()) != null) {
                if ("".equals(notPartTable = notPartTable.trim()) || notPartTable.startsWith("#")) continue;
                finalDataDir = dataDir;
                int mod = (int)Math.ceil((double)Integer.parseInt(notPartTable.split(",")[2]) / 20480.0);
                String finalNotPartTable = notPartTable.split(",")[0];
                for (int n = 0; n < mod; ++n) {
                    String finalFileName = finalNotPartTable + "___" + n;
                    String modCond = "mod(" + notPartTable.split(",")[1] + "," + mod + ") = " + n;
                    if (mod == 1) {
                        modCond = "1=1";
                        finalFileName = finalNotPartTable;
                    }
                    String sqlFile = dataDir + "/" + finalFileName + ".sql";
                    OracleExport.createNewFileNoExists((String)sqlFile);
                    String sql = "select * from " + finalNotPartTable + " t where " + modCond;
                    if (justTest) {
                        sql = sql + " and rownum<=100 ";
                    }
                    try {
                        FileWriter writer = new FileWriter(sqlFile);
                        writer.write(sql);
                        writer.close();
                        log.info("\u751f\u6210sqluldr2 sql\u6587\u4ef6:" + sqlFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    totalFile.getAndAdd(0, 1);
                    String finalSep2 = sep;
                    String finalFileName1 = finalFileName;
                    int finalNotPartTableShardCount = notPartTableShardCount;
                    executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
                if (mod <= 1 || !hasNull) continue;
                String finalFileName = finalNotPartTable + "___null";
                String modCond = "mod(" + notPartTable.split(",")[1] + "," + mod + ") is null";
                String sqlFile = dataDir + "/stage/" + finalFileName + ".sql";
                OracleExport.createNewFileNoExists((String)sqlFile);
                String sql = "select * from " + finalNotPartTable + " t where " + modCond;
                if (justTest) {
                    sql = sql + " and rownum<=100 ";
                }
                try {
                    FileWriter writer = new FileWriter(sqlFile);
                    writer.write(sql);
                    writer.close();
                    log.info("\u751f\u6210sqluldr2 sql\u6587\u4ef6:" + sqlFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                totalFile.getAndAdd(0, 1);
                String finalSep1 = sep;
                executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("\u6240\u6709\u975e\u5206\u533a\u8868\u5bfc\u51fa\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u5171" + totalFile.get(0));
        try {
            String partTableLine;
            reader = new BufferedReader(new FileReader("partTable.txt"));
            while ((partTableLine = reader.readLine()) != null) {
                String[] partNames;
                if ("".equals(partTableLine = partTableLine.trim()) || partTableLine.startsWith("#")) continue;
                finalDataDir = dataDir;
                String field = partTableLine.split(",")[2];
                for (String partName : partNames = partTableLine.substring(partTableLine.indexOf(40) + 1, partTableLine.indexOf(41)).split("\\|")) {
                    String finalFileName = partTableLine.split(",")[0] + "___" + partName;
                    String finalPartTableLine = partTableLine.split(",")[0] + " partition(" + partName + ")";
                    String sqlFile = dataDir + "/stage/" + finalFileName + ".sql";
                    OracleExport.createNewFileNoExists((String)sqlFile);
                    String sql = "select * from " + finalPartTableLine + " t";
                    if (justTest) {
                        sql = sql + " where rownum<=100 ";
                    }
                    try {
                        FileWriter writer = new FileWriter(sqlFile);
                        writer.write(sql);
                        writer.close();
                        log.info("\u751f\u6210sqluldr2 sql\u6587\u4ef6:" + sqlFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    totalFile.getAndAdd(0, 1);
                    String finalSep = sep;
                    executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
            reader.close();
            log.info("\u6240\u6709\u5206\u533a\u8868\u548c\u975e\u5206\u533a\u8868\u4efb\u52a1\u5747\u5df2\u7ecf\u63d0\u4ea4\uff0c\u5171:" + totalFile.get(0));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            FileWriter writer = new FileWriter(dataDir + "/count");
            writer.write(String.valueOf(totalFile.get(0)));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
        log.info("\u6240\u6709\u5206\u533a\u8868\u548c\u975e\u5206\u533a\u8868\u90fd\u5df2\u5bfc\u51fa\u5b8c\u6210\uff0c\u5171:" + totalFile.get(0) + ",\u6210\u529f:" + success.get(0) + ",\u5931\u8d25:" + failed.get(0));
        OracleExport.generateReport();
        currentTimeMillis = System.currentTimeMillis();
        OracleExport.printTime((long)currentTimeMillis, (String)"\u7ed3\u675f\u65f6\u95f4\uff1a");
    }

    private static void changeAllSplitToDone(String dataDir, String prefix) {
        File[] files;
        File folder = new File(dataDir);
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (!file.getName().toLowerCase().startsWith(prefix)) continue;
                File fileName = new File(file.getAbsolutePath().replace(".exporting", ".done"));
                boolean bl = file.renameTo(fileName);
            }
        }
    }

    private static void generateReport() {
        String html = "<html>\n\n<head>\n\t<title>\u6570\u636e\u5bfc\u51fa\u6027\u80fd\u7edf\u8ba1</title>\n</head>\n<body>\n\t<h1>\u6570\u636e\u5bfc\u51fa\u6027\u80fd\u7edf\u8ba1</h1>\n\t<table border=\"1\" cellspacing=\"0\" cellpadding=\"10\"><thead><tr>   <th>\u8868\u540d</th><th>\u6587\u4ef6\u5927\u5c0f</th><th>\u884c\u6570</th><th>\u8017\u65f6(ms)</th></tr></thead><tbody>\n";
        String foot = "</tbody></table></body>\n\n</html>";
        String body = "";
        STATS.sort(new /* Unavailable Anonymous Inner Class!! */);
        for (TableExportStat stat : STATS) {
            try {
                body = body + "<tr><td>" + stat.tableName + "</td><td>" + stat.size + "</td><td>" + stat.rows + "</td><td>" + stat.exportElapsedMs + "</td></tr>\n";
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u62a5\u544a\u62a5\u9519:" + stat.toString());
                e.printStackTrace();
            }
        }
        try {
            FileWriter writer = new FileWriter("import_perf.html");
            writer.write(html);
            writer.write(body);
            writer.write(foot);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "WMI_WRONG_MAP_ITERATOR"})
    public static void createNewFileNoExists(String fullPath) {
        File file = new File(fullPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(String x0, String x1) {
        OracleExport.changeAllSplitToDone((String)x0, (String)x1);
    }
}

