/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.ShardNode;
import com.hundsun.lightdb.util.DateUtils;
import com.hundsun.lightdb.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DistributeShard {
    private static final String DOUBLE_SLASH = "//";
    private static final String MARK_QUESTION = "?";
    private static final String MARK_COLON = ":";
    private static final String MARK_MARK_DOT = ".";
    private static final String MARK_NEGATIVE = "-";
    private static final int INT32_MIN = Integer.MIN_VALUE;
    private static final int INT32_MAX = Integer.MAX_VALUE;
    private static final long UINT32_INT = 0x80000000L;
    private static final long UINT32_MAX = 0x100000000L;
    public static final ConcurrentHashMap<String, ConcurrentHashMap<String, List<ShardNode>>> partitionMap = new ConcurrentHashMap();
    public static boolean WORDS_BIGENDIAN = false;
    private static Connection connection;
    private static PreparedStatement preparedStatement;
    private static ResultSet resultSet;

    public static ShardNode getShard(String cnNodeURL, String user, String password, String logicTable, String shardValue) throws Exception {
        ConcurrentHashMap<String, List<ShardNode>> shardNodeMap;
        String urlKey = DistributeShard.subStringToLast(cnNodeURL, DOUBLE_SLASH, MARK_QUESTION);
        if (!partitionMap.containsKey(urlKey) || !partitionMap.get(urlKey).containsKey(logicTable)) {
            DistributeShard.refreshCache(cnNodeURL, user, password, logicTable);
        }
        if ((shardNodeMap = partitionMap.get(urlKey)) == null || shardNodeMap.isEmpty()) {
            throw new IllegalArgumentException(String.format("unexpected logicTable passed to getShard: The distributed table %s does not exist\uff01", logicTable));
        }
        List<ShardNode> shardNodeList = shardNodeMap.get(logicTable);
        if (shardNodeList == null || shardNodeList.isEmpty()) {
            throw new IllegalArgumentException(String.format("unexpected logicTable passed to getShard: The distributed table %s does not exist\uff01", logicTable));
        }
        long hash_uint32 = DistributeShard.getHash(shardValue, shardNodeList, urlKey);
        long hash = (int)hash_uint32;
        int size = shardNodeList.size();
        long index = (hash + 0x80000000L) / (0x100000000L / (long)size);
        boolean _var = DistributeShard.getShardNode(shardNodeList, size);
        if (_var) {
            return shardNodeList.get((int)index);
        }
        for (ShardNode shardNode : shardNodeList) {
            if (Math.max((long)shardNode.getShardMinValue().intValue(), hash) != Math.min(hash, (long)shardNode.getShardMaxValue().intValue())) continue;
            return shardNode;
        }
        throw new RuntimeException(String.format("Current shardValue:%s hash value:%s No sharding is found !", shardValue, hash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshCache(String cnNodeURL, String user, String password, String logicTable) throws Exception {
        Class<DistributeShard> clazz = DistributeShard.class;
        synchronized (DistributeShard.class) {
            String urlKey = DistributeShard.subStringToLast(cnNodeURL, DOUBLE_SLASH, MARK_QUESTION);
            if (logicTable == null || !partitionMap.containsKey(urlKey) || !partitionMap.get(urlKey).containsKey(logicTable)) {
                if (partitionMap.get(urlKey) != null) {
                    partitionMap.get(urlKey).clear();
                }
                connection = DriverManager.getConnection(cnNodeURL, user, password);
                DistributeShard.existsNode(connection, "select count(1) CT from pg_class where relname = 'pg_dist_node'");
                DistributeShard.existsNode(connection, "select count(1) CT from pg_dist_node");
                preparedStatement = connection.prepareStatement("SELECT shard.logicalrelid, shard.logicalrelid || '_' || shard.shardid AS shard_name, shard.shardminvalue, shard.shardmaxvalue, placement.nodename, placement.nodeport, col.TABLE_NAME, col.COLUMN_NAME, col.data_type, col.udt_name FROM pg_dist_shard shard LEFT JOIN pg_dist_shard_placement placement ON shard.shardid = placement.shardid LEFT JOIN ( SELECT A.TABLE_NAME, A.COLUMN_NAME, B.data_type, B.udt_name FROM ( SELECT logicalrelid :: TEXT TABLE_NAME, column_to_column_name ( logicalrelid, partkey ) COLUMN_NAME FROM pg_dist_partition ) A JOIN information_schema.COLUMNS B ON A.TABLE_NAME = B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ) col ON shard.logicalrelid = col.TABLE_NAME :: REGCLASS");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    final String logicTableName = resultSet.getString(1);
                    String shardTableName = resultSet.getString(2);
                    Integer shardMinValue = resultSet.getInt(3);
                    Integer shardMaxValue = resultSet.getInt(4);
                    String nodeName = resultSet.getString(5);
                    if (Objects.equals("127.0.0.1", nodeName)) {
                        nodeName = urlKey.split(MARK_COLON)[0];
                    }
                    Integer nodePort = resultSet.getInt(6);
                    String shardColumn = resultSet.getString(8);
                    String shardColumnType = resultSet.getString(9);
                    final ShardNode shardNode = new ShardNode(logicTableName, shardTableName, shardMinValue, shardMaxValue, nodeName, nodePort, shardColumn, shardColumnType);
                    ConcurrentHashMap<String, List<ShardNode>> shardMap = partitionMap.get(urlKey);
                    if (shardMap == null) {
                        shardMap = new ConcurrentHashMap<String, List<ShardNode>>(){
                            {
                                this.put(logicTableName, new ArrayList<ShardNode>(){
                                    {
                                        this.add(shardNode);
                                    }
                                });
                            }
                        };
                        partitionMap.put(urlKey, shardMap);
                        continue;
                    }
                    ArrayList<ShardNode> shardNodes = shardMap.get(logicTableName);
                    if (shardNodes == null) {
                        shardNodes = new ArrayList<ShardNode>(){
                            {
                                this.add(shardNode);
                            }
                        };
                        shardMap.put(logicTableName, shardNodes);
                        continue;
                    }
                    shardNodes.add(shardNode);
                }
                if (partitionMap.get(urlKey) != null) {
                    partitionMap.get(urlKey).forEach((k, v) -> v.sort(Comparator.comparing(ShardNode::getShardMinValue)));
                }
                DistributeShard.closeResource(resultSet);
                DistributeShard.closeResource(preparedStatement);
                DistributeShard.closeResource(connection);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static boolean getShardNode(List<ShardNode> shardNodeList, int size) {
        long hashTokenIncrement = 0x100000000L / (long)size;
        for (int shardIndex = 0; shardIndex < size; ++shardIndex) {
            long shardMinHashToken = Integer.MIN_VALUE + (long)shardIndex * hashTokenIncrement;
            long shardMaxHashToken = shardMinHashToken + (hashTokenIncrement - 1L);
            if (shardIndex == size - 1) {
                shardMaxHashToken = Integer.MAX_VALUE;
            }
            if ((long)shardNodeList.get(shardIndex).getShardMinValue().intValue() == shardMinHashToken && (long)shardNodeList.get(shardIndex).getShardMaxValue().intValue() == shardMaxHashToken) continue;
            return false;
        }
        return true;
    }

    private static void existsNode(Connection connection, String sql) throws SQLException {
        preparedStatement = connection.prepareStatement(sql);
        resultSet = preparedStatement.executeQuery();
        int count = 0;
        while (resultSet.next()) {
            count = resultSet.getInt(1);
        }
        if (count == 0) {
            throw new IllegalArgumentException("unexpected cnNodeURL passed to getShard: It's not a distributed database URL\uff01");
        }
    }

    private static long getHash(String shardValue, List<ShardNode> shardNodeList, String urlKey) {
        long hash;
        ShardNode shardNode = shardNodeList.get(0);
        switch (shardNode.getShardColumnType()) {
            case "numeric": {
                hash = DistributeShard.hash_numeric(shardValue);
                break;
            }
            case "character": {
                hash = DistributeShard.hash_character(shardValue);
                break;
            }
            case "smallint": {
                hash = DistributeShard.hash_smallint(shardValue);
                break;
            }
            case "integer": {
                hash = DistributeShard.hash_integer(shardValue);
                break;
            }
            case "bigint": {
                hash = DistributeShard.hash_bigint(shardValue);
                break;
            }
            case "text": {
                hash = DistributeShard.hash_text(shardValue);
                break;
            }
            case "character varying": {
                hash = DistributeShard.hash_character_varying(shardValue);
                break;
            }
            case "date": {
                hash = DistributeShard.hash_date(shardValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected shardColumnType passed to getShard: " + shardNode.getShardColumnType());
            }
        }
        return hash;
    }

    public static long hash_date(String shardValue) {
        LocalDate localDate = null;
        try {
            localDate = DateUtils.strToLocalDate(shardValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unexpected shard key value type that is yyyy-MM-dd");
        }
        int epochDay = DateUtils.getEpochDay(localDate, DateUtils.DATE_MILLENNIUM);
        return DistributeShard.hash_integer(String.valueOf(epochDay));
    }

    private static long hash_character_varying(String shardValue) {
        return DistributeShard.hash_bytes(shardValue.getBytes());
    }

    public static long hash_text(String shardValue) {
        return DistributeShard.hash_bytes(shardValue.getBytes());
    }

    private static long hash_bigint(String shardValue) {
        long val = Long.valueOf(shardValue);
        long lohalf = DistributeShard.getUnsignedInt(val);
        long hihalf = val >>> 32;
        return DistributeShard.hash_bytes_uint32(lohalf ^= val >= 0L ? hihalf : hihalf ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long hash_integer(String shardValue) {
        return DistributeShard.hash_bytes_uint32(DistributeShard.getUnsignedInt(Integer.parseInt(shardValue)));
    }

    private static long hash_smallint(String shardValue) {
        return DistributeShard.hash_bytes_uint32(DistributeShard.getUnsignedInt(Integer.parseInt(shardValue)));
    }

    private static long hash_character(String shardValue) {
        shardValue = shardValue.replaceAll("[\u3000 ]+$", "");
        return DistributeShard.hash_bytes(shardValue.getBytes());
    }

    public static long hash_numeric(String shardValue) {
        int indexPositive;
        try {
            BigDecimal bigDecimal = new BigDecimal(shardValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unexpected numeric data type");
        }
        String shardValueReal = shardValue;
        if (shardValue.startsWith(MARK_NEGATIVE)) {
            shardValueReal = shardValue.substring(1);
        }
        String integerPart = null;
        String decimalPart = null;
        short[] retVal = null;
        int weight = 0;
        if (shardValueReal.contains(MARK_MARK_DOT)) {
            integerPart = shardValueReal.substring(0, shardValueReal.indexOf(MARK_MARK_DOT));
            decimalPart = shardValueReal.substring(shardValueReal.indexOf(MARK_MARK_DOT) + 1);
        } else {
            integerPart = shardValueReal;
        }
        short[] shortsInteger = DistributeShard.getShortsInteger(integerPart);
        short[] shortsDecimal = DistributeShard.getShortsDecimal(decimalPart);
        int shortsIntegerLength = shortsInteger == null ? 0 : shortsInteger.length;
        int shortsDecimalLength = shortsDecimal == null ? 0 : shortsDecimal.length;
        weight = shortsIntegerLength - 1;
        short[] shortsAll = new short[shortsIntegerLength + shortsDecimalLength];
        System.arraycopy(shortsInteger, 0, shortsAll, 0, shortsIntegerLength);
        if (shortsDecimal != null) {
            System.arraycopy(shortsDecimal, 0, shortsAll, shortsIntegerLength, shortsDecimalLength);
        }
        int indexNegative = shortsAll.length - 1;
        for (indexPositive = 0; indexPositive < shortsAll.length && shortsAll[indexPositive] == 0; ++indexPositive) {
        }
        while (indexNegative >= 0 && shortsAll[indexNegative] == 0) {
            --indexNegative;
        }
        weight -= indexPositive;
        if (indexPositive == shortsAll.length) {
            return -1L;
        }
        retVal = new short[indexNegative - indexPositive + 1];
        System.arraycopy(shortsAll, indexPositive, retVal, 0, indexNegative - indexPositive + 1);
        byte[] ret = DistributeShard.shortToByte(retVal);
        long retValue = DistributeShard.hash_bytes(ret);
        return retValue ^ (long)weight;
    }

    public static byte[] shortToByte(short[] data) {
        byte[] byteValue = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byteValue[i * 2] = (byte)(data[i] & 0xFF);
            byteValue[i * 2 + 1] = (byte)((data[i] & 0xFF00) >> 8);
        }
        return byteValue;
    }

    private static short[] getShortsInteger(String content) {
        if (StringUtils.isBlank(content)) {
            return null;
        }
        int sizeOld = content.length();
        int size = sizeOld / 4 + (sizeOld % 4 > 0 ? 1 : 0);
        short[] retVal = new short[size];
        for (int i = size - 1; i >= 0; --i) {
            int index = sizeOld;
            String yyu = content;
            if (sizeOld > 4) {
                index = sizeOld - 4;
                yyu = content.substring(index);
                content = content.substring(0, index);
                sizeOld -= 4;
            }
            retVal[i] = Short.parseShort(yyu);
        }
        return retVal;
    }

    private static short[] getShortsDecimal(String content) {
        if (StringUtils.isBlank(content)) {
            return null;
        }
        int sizeOld = content.length();
        int size = sizeOld / 4 + (sizeOld % 4 > 0 ? 1 : 0);
        short[] retVal = new short[size];
        String contentVar = content;
        for (int i = 0; i < size; ++i) {
            String yyu = contentVar;
            if (sizeOld >= 4) {
                yyu = contentVar.substring(0, 4);
                contentVar = contentVar.substring(4);
                sizeOld -= 4;
            } else if (sizeOld > 0) {
                for (int ze = 4 - yyu.length(); ze > 0; --ze) {
                    yyu = yyu + "0";
                }
            }
            retVal[i] = Short.parseShort(yyu);
        }
        return retVal;
    }

    private static short[] getShortsNegative(String content) {
        int i;
        String positive = content.substring(0, content.indexOf(MARK_MARK_DOT));
        String negative = content.substring(content.indexOf(MARK_MARK_DOT) + 1);
        short[] ret = DistributeShard.getShortsInteger(positive);
        int sizeOld = negative.length();
        int size = sizeOld / 4 + (sizeOld % 4 > 0 ? 1 : 0);
        short[] retVal = new short[size += ret.length];
        for (i = 0; i < ret.length; ++i) {
            retVal[i] = ret[i];
        }
        for (i = ret.length; i < size; ++i) {
            String yyu = negative;
            if (sizeOld >= 4) {
                yyu = negative.substring(0, 4);
                negative = negative.substring(4);
                sizeOld -= 4;
            } else if (sizeOld > 0) {
                for (int ze = 4 - yyu.length(); ze > 0; --ze) {
                    yyu = yyu + "0";
                }
            }
            retVal[i] = Short.valueOf(yyu);
        }
        return retVal;
    }

    public static long hash_bytes_uint32(long k) {
        long c;
        long b = c = DistributeShard.getUnsignedInt(-1636608428L);
        long a = c;
        a = DistributeShard.getUnsignedInt(a + k);
        c = DistributeShard._final(a, b, c);
        return c;
    }

    private static long _final(long a, long b, long c) {
        c ^= b;
        c = DistributeShard.getUnsignedInt(c - DistributeShard.rot(b, 14L));
        a ^= c;
        a = DistributeShard.getUnsignedInt(a - DistributeShard.rot(c, 11L));
        b ^= a;
        b = DistributeShard.getUnsignedInt(b - DistributeShard.rot(a, 25L));
        c ^= b;
        c = DistributeShard.getUnsignedInt(c - DistributeShard.rot(b, 16L));
        a ^= c;
        a = DistributeShard.getUnsignedInt(a - DistributeShard.rot(c, 4L));
        b ^= a;
        b = DistributeShard.getUnsignedInt(b - DistributeShard.rot(a, 14L));
        c ^= b;
        c = DistributeShard.getUnsignedInt(c - DistributeShard.rot(b, 24L));
        return c;
    }

    private static long rot(long x, long k) {
        return DistributeShard.getUnsignedInt(x << (int)k | x >> (int)(32L - k));
    }

    public static long getUnsignedInt(long d) {
        return d & 0xFFFFFFFFL;
    }

    public static int getUnsignedByte(byte d) {
        return d & 0xFF;
    }

    public static long hash_bytes(byte[] ka) {
        long c;
        long len = DistributeShard.getUnsignedInt(ka.length);
        int[] k = new int[ka.length];
        for (int i = 0; i < ka.length; ++i) {
            k[i] = DistributeShard.getUnsignedByte(ka[i]);
        }
        long b = c = DistributeShard.getUnsignedInt(-1640531527L + len + 3923095L);
        long a = c;
        int t = 0;
        while (len >= 12L) {
            a = DistributeShard.getUnsignedInt(a + ((long)k[t] + DistributeShard.getUnsignedInt(k[t + 1] << 8) + DistributeShard.getUnsignedInt(k[t + 2] << 16) + DistributeShard.getUnsignedInt(k[t + 3] << 24)));
            b = DistributeShard.getUnsignedInt(b + ((long)k[t + 4] + DistributeShard.getUnsignedInt(k[t + 5] << 8) + DistributeShard.getUnsignedInt(k[t + 6] << 16) + DistributeShard.getUnsignedInt(k[t + 7] << 24)));
            c = DistributeShard.getUnsignedInt(c + ((long)k[t + 8] + DistributeShard.getUnsignedInt(k[t + 9] << 8) + DistributeShard.getUnsignedInt(k[t + 10] << 16) + DistributeShard.getUnsignedInt(k[t + 11] << 24)));
            a = DistributeShard.getUnsignedInt(a - c);
            a ^= DistributeShard.rot(c, 4L);
            c = DistributeShard.getUnsignedInt(c + b);
            b = DistributeShard.getUnsignedInt(b - a);
            b ^= DistributeShard.rot(a, 6L);
            a = DistributeShard.getUnsignedInt(a + c);
            c = DistributeShard.getUnsignedInt(c - b);
            c ^= DistributeShard.rot(b, 8L);
            b = DistributeShard.getUnsignedInt(b + a);
            a = DistributeShard.getUnsignedInt(a - c);
            a ^= DistributeShard.rot(c, 16L);
            c = DistributeShard.getUnsignedInt(c + b);
            b = DistributeShard.getUnsignedInt(b - a);
            b ^= DistributeShard.rot(a, 19L);
            a = DistributeShard.getUnsignedInt(a + c);
            c = DistributeShard.getUnsignedInt(c - b);
            c ^= DistributeShard.rot(b, 4L);
            b = DistributeShard.getUnsignedInt(b + a);
            t += 12;
            len -= 12L;
        }
        switch (Math.toIntExact(len)) {
            case 11: {
                c = DistributeShard.getUnsignedInt(c + DistributeShard.getUnsignedInt(k[t + 10] << 24));
            }
            case 10: {
                c = DistributeShard.getUnsignedInt(c + DistributeShard.getUnsignedInt(k[t + 9] << 16));
            }
            case 9: {
                c = DistributeShard.getUnsignedInt(c + DistributeShard.getUnsignedInt(k[t + 8] << 8));
            }
            case 8: {
                b = DistributeShard.getUnsignedInt(b + DistributeShard.getUnsignedInt(k[t + 7] << 24));
            }
            case 7: {
                b = DistributeShard.getUnsignedInt(b + DistributeShard.getUnsignedInt(k[t + 6] << 16));
            }
            case 6: {
                b = DistributeShard.getUnsignedInt(b + DistributeShard.getUnsignedInt(k[t + 5] << 8));
            }
            case 5: {
                b = DistributeShard.getUnsignedInt(b + (long)k[t + 4]);
            }
            case 4: {
                a = DistributeShard.getUnsignedInt(a + DistributeShard.getUnsignedInt(k[t + 3] << 24));
            }
            case 3: {
                a = DistributeShard.getUnsignedInt(a + DistributeShard.getUnsignedInt(k[t + 2] << 16));
            }
            case 2: {
                a = DistributeShard.getUnsignedInt(a + DistributeShard.getUnsignedInt(k[t + 1] << 8));
            }
            case 1: {
                a = DistributeShard.getUnsignedInt(a + (long)k[t + 0]);
            }
        }
        c = DistributeShard._final(a, b, c);
        return c;
    }

    private static void closeResource(AutoCloseable resource) throws Exception {
        if (resource != null) {
            resource.close();
        }
    }

    public static String subStringToLast(String src, String start, String to) {
        int indexTo;
        int indexFrom;
        int n = indexFrom = start == null ? 0 : src.indexOf(start);
        if (to == null) {
            indexTo = src.length();
        } else {
            int n2 = indexTo = src.indexOf(to) >= 0 ? src.lastIndexOf(to) : src.length();
        }
        if (indexFrom >= 0 && indexTo >= 0 && indexFrom <= indexTo) {
            if (null != start) {
                indexFrom += start.length();
            }
            return src.substring(indexFrom, indexTo);
        }
        return null;
    }
}

